/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.client.texture.CableBusTextures;
import appeng.core.settings.TickRates;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.cache.GridStorageCache;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.tile.networking.TileCableBus;
import appeng.util.IterationCounter;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import appeng.util.prioitylist.IPartitionList;
import appeng.util.prioitylist.PrecisePriorityList;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.PartFluidInterface;
import com.glodblock.github.common.tile.TileFluidInterface;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.MEMonitorIFluidHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.ModAndClassUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.tileentity.TileEntityFluidInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.IFluidHandler;

public class PartFluidStorageBus
extends PartUpgradeable
implements IGridTickable,
ICellContainer,
IMEMonitorHandlerReceiver<IAEFluidStack>,
IPriorityHost {
    private final BaseActionSource source;
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory((IAEAppEngInventory)this, 63);
    private int priority = 0;
    private boolean cached = false;
    private MEMonitorIFluidHandler monitor = null;
    private MEInventoryHandler<IAEFluidStack> handler = null;
    private int handlerHash = 0;
    private boolean wasActive = false;
    private byte resetCacheLogic = 0;
    private boolean readOncePass = false;

    public PartFluidStorageBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
        this.getConfigManager().registerSetting(Settings.STICKY_MODE, (Enum)YesNo.NO);
        this.source = new MachineSource((IActionHost)this);
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.updateStatus();
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged changedChannels) {
        this.updateStatus();
    }

    protected void updateStatus() {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                this.getHost().markForUpdate();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    protected int getUpgradeSlots() {
        return 5;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.resetCache(true);
        this.getHost().markForSave();
    }

    public void upgradesChanged() {
        super.upgradesChanged();
        this.resetCache(true);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.config.readFromNBT(data, "config");
        this.priority = data.func_74762_e("priority");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.config.writeToNBT(data, "config");
        data.func_74768_a("priority", this.priority);
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.config) {
            this.resetCache(true);
        }
    }

    protected void resetCache(boolean fullReset) {
        if (this.getHost() == null || this.getHost().getTile() == null || this.getHost().getTile().func_145831_w() == null || this.getHost().getTile().func_145831_w().field_72995_K) {
            return;
        }
        if (fullReset) {
            this.resetCacheLogic = (byte)2;
        } else if (this.resetCacheLogic < 2) {
            this.resetCacheLogic = 1;
        }
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void resetCache() {
        boolean fullReset = this.resetCacheLogic == 2;
        this.resetCacheLogic = 0;
        MEInventoryHandler<IAEFluidStack> in = this.getInternalHandler();
        IItemList before = AEApi.instance().storage().createFluidList();
        if (in != null) {
            before = in.getAvailableItems(before, IterationCounter.fetchNewId());
        }
        this.cached = false;
        if (fullReset) {
            this.handlerHash = 0;
        }
        MEInventoryHandler<IAEFluidStack> out = this.getInternalHandler();
        if (this.monitor != null) {
            this.monitor.onTick();
        }
        IItemList after = AEApi.instance().storage().createFluidList();
        if (in != out) {
            if (out != null) {
                after = out.getAvailableItems(after, IterationCounter.fetchNewId());
            }
            Platform.postListChanges((IItemList)before, (IItemList)after, (IMEMonitorHandlerReceiver)this, (BaseActionSource)this.source);
        }
    }

    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource source) {
        try {
            if (this.getProxy().isActive()) {
                AccessRestriction currentAccess;
                if (!this.readOncePass && !(currentAccess = (AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS)).hasPermission(AccessRestriction.READ)) {
                    return;
                }
                Iterable<IAEFluidStack> filteredChanges = this.filterChanges(change, this.readOncePass);
                this.readOncePass = false;
                if (filteredChanges == null) {
                    return;
                }
                this.getProxy().getStorage().postAlterationOfStoredItems(StorageChannel.FLUIDS, filteredChanges, this.source);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Nullable
    private Iterable<IAEFluidStack> filterChanges(Iterable<IAEFluidStack> change, boolean readOncePass) {
        if (readOncePass) {
            return change;
        }
        if (this.handler != null && this.handler.isExtractFilterActive() && !this.handler.getExtractPartitionList().isEmpty()) {
            ArrayList<IAEFluidStack> filteredChanges = new ArrayList<IAEFluidStack>();
            Predicate extractFilterCondition = this.handler.getExtractFilterCondition();
            for (IAEFluidStack changedFluid : change) {
                if (!extractFilterCondition.test(changedFluid)) continue;
                filteredChanges.add(changedFluid);
            }
            return filteredChanges.isEmpty() ? null : Collections.unmodifiableList(filteredChanges);
        }
        return change;
    }

    public void onListUpdate() {
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public void onNeighborChanged() {
        TileEntity tile = this.getTile();
        if (tile == null || this.getProxy() == null || !this.getProxy().isActive()) {
            return;
        }
        BlockPos neighbor = new BlockPos(tile).getOffSet(this.getSide());
        TileEntity te = neighbor.getTileEntity();
        if (te instanceof TileCableBus) {
            IPart iPart = ((TileCableBus)te).getPart(this.getSide().getOpposite());
            if (iPart == null || iPart instanceof PartFluidInterface) {
                this.resetCache(true);
                this.resetCache();
            }
            if (ModAndClassUtil.EC2 && (iPart == null || iPart instanceof extracells.part.PartFluidInterface)) {
                this.resetCache(true);
                this.resetCache();
            }
        } else if (te == null || te instanceof TileFluidInterface) {
            this.resetCache(true);
            this.resetCache();
        } else if (ModAndClassUtil.EC2) {
            if (te instanceof TileEntityFluidInterface) {
                this.resetCache(true);
                this.resetCache();
            }
        } else if (te instanceof IFluidHandler) {
            this.resetCache(true);
            this.resetCache();
        } else {
            this.resetCache(false);
        }
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (player.func_70093_af()) {
            return false;
        }
        if (Platform.isServer()) {
            InventoryHandler.openGui(player, this.getHost().getTile().func_145831_w(), new BlockPos(this.getHost().getTile()), Objects.requireNonNull(this.getSide()), GuiType.FLUID_STORAGE_BUS);
        }
        return true;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus.getMin(), TickRates.StorageBus.getMax(), this.monitor == null, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.resetCacheLogic != 0) {
            this.resetCache();
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return TickRateModulation.SLEEP;
    }

    public MEInventoryHandler<IAEFluidStack> getInternalHandler() {
        IExternalStorageHandler esh;
        if (this.cached) {
            return this.handler;
        }
        boolean wasSleeping = this.monitor == null;
        this.cached = true;
        TileEntity self = this.getHost().getTile();
        TileEntity target = new BlockPos(self).getOffSet(this.getSide()).getTileEntity();
        int newHandlerHash = Platform.generateTileHash((TileEntity)target);
        if (newHandlerHash != 0 && newHandlerHash == this.handlerHash) {
            return this.handler;
        }
        this.handlerHash = newHandlerHash;
        this.handler = null;
        this.monitor = null;
        this.readOncePass = true;
        if (target != null && (esh = AEApi.instance().registries().externalStorage().getHandler(target, this.getSide().getOpposite(), StorageChannel.FLUIDS, this.source)) != null) {
            IMEInventory inv = esh.getInventory(target, this.getSide().getOpposite(), StorageChannel.FLUIDS, this.source);
            if (inv instanceof MEMonitorIFluidHandler) {
                MEMonitorIFluidHandler h = (MEMonitorIFluidHandler)inv;
                h.setMode((StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER));
                h.setActionSource((BaseActionSource)new MachineSource((IActionHost)this));
                this.monitor = h;
            }
            if (inv != null) {
                this.handler = new MEInventoryHandler(inv, StorageChannel.FLUIDS);
                AccessRestriction currentAccess = (AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS);
                this.handler.setBaseAccess(currentAccess);
                this.handler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
                this.handler.setSticky(this.getInstalledUpgrades(Upgrades.STICKY) > 0);
                this.handler.setPriority(this.priority);
                this.handler.setIsExtractFilterActive(currentAccess == AccessRestriction.READ);
                if (inv instanceof IMEMonitor) {
                    ((IBaseMonitor)inv).addListener((IMEMonitorHandlerReceiver)this, this.handler);
                }
                IItemList priorityList = AEApi.instance().storage().createFluidList();
                int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
                for (int x = 0; x < this.config.func_70302_i_() && x < slotsToUse; ++x) {
                    IAEItemStack is = this.config.getAEStackInSlot(x);
                    if (is == null) continue;
                    priorityList.add((IAEStack)AEFluidStack.create((Object)ItemFluidPacket.getFluidStack(is)));
                }
                PrecisePriorityList partitionList = new PrecisePriorityList(priorityList);
                this.handler.setPartitionList((IPartitionList)partitionList);
                this.handler.setExtractPartitionList((IPartitionList)partitionList);
            }
        }
        if (wasSleeping != (this.monitor == null)) {
            try {
                ITickManager tm = this.getProxy().getTick();
                if (this.monitor == null) {
                    tm.sleepDevice(this.getProxy().getNode());
                } else {
                    tm.wakeDevice(this.getProxy().getNode());
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        try {
            ((GridStorageCache)this.getProxy().getGrid().getCache(IStorageGrid.class)).cellUpdate(null);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return this.handler;
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        MEInventoryHandler<IAEFluidStack> out;
        if (channel == StorageChannel.FLUIDS && (out = this.getInternalHandler()) != null) {
            return Collections.singletonList(out);
        }
        return Collections.emptyList();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.resetCache(true);
    }

    public void saveChanges(IMEInventory cellInventory) {
    }

    public AppEngInternalAEInventory getConfig() {
        return this.config;
    }

    public void setFluidInSlot(int id, IAEFluidStack fluid) {
        ItemStack tmp = ItemFluidPacket.newDisplayStack(fluid == null ? null : fluid.getFluidStack());
        this.config.func_70299_a(id, tmp);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageBack.getIcon(), FCPartsTexture.PartFluidStorageBus.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon());
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, (IBoxProvider)this, this.getRenderCache()));
        rh.setTexture(CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageBack.getIcon(), FCPartsTexture.PartFluidStorageBus.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon());
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageBack.getIcon(), FCPartsTexture.PartFluidStorageBus.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon());
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), FCPartsTexture.PartFluidStorageBus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }
}

