/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.net;

import bartworks.common.net.CircuitProgrammerPacket;
import bartworks.common.net.EICPacket;
import bartworks.common.net.MetaBlockPacket;
import bartworks.common.net.OreDictCachePacket;
import bartworks.common.net.RendererPacket;
import bartworks.common.net.ServerJoinedPacket;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.server.FMLServerHandler;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketNew;
import gregtech.api.net.IGT_NetworkHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@ChannelHandler.Sharable
public class BWNetwork
extends MessageToMessageCodec<FMLProxyPacket, GTPacketNew>
implements IGT_NetworkHandler {
    private final EnumMap<Side, FMLEmbeddedChannel> mChannel = NetworkRegistry.INSTANCE.newChannel("BartWorks", new ChannelHandler[]{this, new HandlerShared()});
    private final GTPacketNew[] mSubChannels = new GTPacketNew[]{new RendererPacket(), new CircuitProgrammerPacket(), new MetaBlockPacket(), new OreDictCachePacket(), new ServerJoinedPacket(), new EICPacket()};

    protected void encode(ChannelHandlerContext aContext, GTPacketNew aPacket, List<Object> aOutput) throws Exception {
        aOutput.add(new FMLProxyPacket(Unpooled.buffer().writeByte((int)aPacket.getPacketID()).writeBytes(aPacket.encode()).copy(), (String)aContext.channel().attr(NetworkRegistry.FML_CHANNEL).get()));
    }

    protected void decode(ChannelHandlerContext aContext, FMLProxyPacket aPacket, List<Object> aOutput) throws Exception {
        ByteArrayDataInput aData = ByteStreams.newDataInput((byte[])aPacket.payload().array());
        aOutput.add(this.mSubChannels[aData.readByte()].decode(aData));
    }

    @Override
    public void sendToPlayer(@Nonnull GTPacket aPacket, @Nonnull EntityPlayerMP aPlayer) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPlayer);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    public void sendToAllPlayersinWorld(@Nonnull GTPacket aPacket, World world) {
        for (String name : FMLServerHandler.instance().getServer().func_71213_z()) {
            this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)world.func_72924_a(name));
            this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
        }
    }

    @Override
    public void sendToAllAround(@Nonnull GTPacket aPacket, NetworkRegistry.TargetPoint aPosition) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPosition);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToAll(@Nonnull GTPacket aPacket) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToServer(@Nonnull GTPacket aPacket) {
        this.mChannel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.mChannel.get(Side.CLIENT).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendPacketToAllPlayersInRange(World aWorld, @Nonnull GTPacket aPacket, int aX, int aZ) {
        if (!aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.func_72938_d(aX, aZ);
                if (!tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) continue;
                this.sendToPlayer(aPacket, tPlayer);
            }
        }
    }

    @ChannelHandler.Sharable
    static final class HandlerShared
    extends SimpleChannelInboundHandler<GTPacketNew> {
        HandlerShared() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, GTPacketNew aPacket) throws Exception {
            EntityPlayer aPlayer = GTValues.GT.getThePlayer();
            aPacket.process((IBlockAccess)(aPlayer == null ? null : GTValues.GT.getThePlayer().field_70170_p));
        }
    }
}

