/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.net;

import bartworks.common.items.ItemCircuitProgrammer;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacketNew;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CircuitProgrammerPacket
extends GTPacketNew {
    private int dimID;
    private int playerID;
    private byte chipCfg;
    private boolean hasChip;

    public CircuitProgrammerPacket() {
        super(true);
    }

    public CircuitProgrammerPacket(int dimID, int playerID, boolean hasChip, byte chipCfg) {
        super(false);
        this.dimID = dimID;
        this.playerID = playerID;
        this.hasChip = hasChip;
        this.chipCfg = chipCfg;
    }

    @Override
    public byte getPacketID() {
        return 1;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.dimID).writeInt(this.playerID).writeByte(this.hasChip ? (int)this.chipCfg : -1);
    }

    @Override
    public GTPacketNew decode(ByteArrayDataInput byteArrayDataInput) {
        return new CircuitProgrammerPacket(byteArrayDataInput.readInt(), byteArrayDataInput.readInt(), byteArrayDataInput.readByte() > -1, byteArrayDataInput.readByte());
    }

    @Override
    public void process(IBlockAccess iBlockAccess) {
        Item item;
        ItemStack stack;
        WorldServer w = DimensionManager.getWorld((int)this.dimID);
        if (w != null && w.func_73045_a(this.playerID) instanceof EntityPlayer && (stack = ((EntityPlayer)w.func_73045_a(this.playerID)).func_70694_bm()) != null && stack.field_77994_a > 0 && (item = stack.func_77973_b()) instanceof ItemCircuitProgrammer) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74757_a("HasChip", this.hasChip);
            if (this.hasChip) {
                nbt.func_74774_a("ChipConfig", this.chipCfg);
            }
            stack.func_77982_d(nbt);
            ((EntityPlayer)w.func_73045_a((int)this.playerID)).field_71071_by.func_70299_a(((EntityPlayer)w.func_73045_a((int)this.playerID)).field_71071_by.field_70461_c, stack);
        }
    }
}

