/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.net;

import bartworks.MainMod;
import bartworks.system.material.TileEntityMetaGeneratedBlock;
import bartworks.util.MurmurHash3;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacketNew;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MetaBlockPacket
extends GTPacketNew {
    int x;
    short y;
    int z;
    short meta;

    public MetaBlockPacket(int x, int y, int z, int meta) {
        super(false);
        this.x = x;
        this.y = (short)y;
        this.z = z;
        this.meta = (short)meta;
    }

    public MetaBlockPacket() {
        super(true);
    }

    @Override
    public byte getPacketID() {
        return 2;
    }

    @Override
    public void encode(ByteBuf aOut) {
        int hash = MurmurHash3.murmurhash3_x86_32(ByteBuffer.allocate(12).putInt(this.x).putInt(this.z).putShort(this.y).putShort(this.meta).array(), 0, 12, 31);
        aOut.writeInt(this.x).writeInt(this.z).writeShort((int)this.y).writeShort((int)this.meta).writeInt(hash);
    }

    @Override
    public GTPacketNew decode(ByteArrayDataInput byteArrayDataInput) {
        this.x = byteArrayDataInput.readInt();
        this.z = byteArrayDataInput.readInt();
        this.y = byteArrayDataInput.readShort();
        this.meta = byteArrayDataInput.readShort();
        MetaBlockPacket todecode = new MetaBlockPacket(this.x, this.y, this.z, this.meta);
        if (byteArrayDataInput.readInt() != MurmurHash3.murmurhash3_x86_32(ByteBuffer.allocate(12).putInt(this.x).putInt(this.z).putShort(this.y).putShort(this.meta).array(), 0, 12, 31)) {
            MainMod.LOGGER.error("PACKET HASH DOES NOT MATCH!");
            return null;
        }
        return todecode;
    }

    @Override
    public void process(IBlockAccess iBlockAccess) {
        if (iBlockAccess != null) {
            TileEntity tTileEntity = iBlockAccess.func_147438_o(this.x, (int)this.y, this.z);
            if (tTileEntity instanceof TileEntityMetaGeneratedBlock) {
                ((TileEntityMetaGeneratedBlock)tTileEntity).mMetaData = this.meta;
            }
            if (iBlockAccess instanceof World && ((World)iBlockAccess).field_72995_K) {
                ((World)iBlockAccess).func_147471_g(this.x, (int)this.y, this.z);
            }
        }
    }
}

