/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.classic;

import bartworks.API.ITileAddsInformation;
import bartworks.API.ITileDropsContent;
import bartworks.API.ITileHasDifferentTextureSides;
import bartworks.API.modularUI.BWUITextures;
import bartworks.common.configs.Configuration;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.InvWrapper;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.util.GTUtility;
import gregtech.common.Pollution;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityHeatedWaterPump
extends TileEntity
implements ITileDropsContent,
IFluidHandler,
IFluidTank,
ITileWithModularUI,
ITileAddsInformation,
ITileHasDifferentTextureSides {
    public static final int FUELSLOT = 0;
    public static final Fluid WATER = FluidRegistry.WATER;
    public ItemStack fuelstack;
    public FluidStack outputstack = new FluidStack(FluidRegistry.WATER, 0);
    public int fuel;
    public byte tick;
    public int maxfuel;
    public ItemStack fakestack = new ItemStack(Blocks.field_150355_j);

    public void func_145841_b(NBTTagCompound compound) {
        NBTTagCompound subItemStack = new NBTTagCompound();
        if (this.fuelstack != null) {
            this.fuelstack.func_77955_b(subItemStack);
        }
        compound.func_74782_a("ItemStack", (NBTBase)subItemStack);
        NBTTagCompound subFluidStack = new NBTTagCompound();
        this.outputstack.writeToNBT(subFluidStack);
        compound.func_74782_a("FluidStack", (NBTBase)subFluidStack);
        compound.func_74768_a("fuel", this.fuel);
        compound.func_74768_a("maxfuel", this.maxfuel);
        compound.func_74774_a("tick", this.tick);
        super.func_145841_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.tick = compound.func_74771_c("tick");
        this.fuel = compound.func_74762_e("fuel");
        this.maxfuel = compound.func_74762_e("maxfuel");
        this.outputstack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("FluidStack"));
        if (!compound.func_74775_l("ItemStack").equals((Object)new NBTTagCompound())) {
            this.fuelstack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("ItemStack"));
        }
        super.func_145839_a(compound);
    }

    private boolean checkPreUpdate() {
        return (this.fuelstack == null || this.fuelstack.field_77994_a <= 0) && this.fuel <= 0;
    }

    private void fixUnderlflow() {
        if (this.fuel < 0) {
            this.fuel = 0;
        }
    }

    private void handleRefuel() {
        if (this.fuelstack != null && this.fuel == 0) {
            this.fuel = this.maxfuel = TileEntityFurnace.func_145952_a((ItemStack)this.fuelstack);
            --this.fuelstack.field_77994_a;
            if (this.fuelstack.field_77994_a <= 0) {
                this.fuelstack = this.fuelstack.func_77973_b().getContainerItem(this.fuelstack);
            }
        }
    }

    private void handleWaterGeneration() {
        if (this.fuel > 0) {
            this.tick = (byte)(this.tick + 1);
            --this.fuel;
            if (this.tick % 20 == 0) {
                if (this.outputstack.amount <= 8000 - Configuration.singleBlocks.mbWaterperSec) {
                    this.outputstack.amount += Configuration.singleBlocks.mbWaterperSec;
                }
                this.tick = 0;
            }
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pushWaterToAdjacentTiles();
        this.fakestack.func_151001_c(this.outputstack.amount + "L Water");
        if (this.checkPreUpdate()) {
            return;
        }
        this.fixUnderlflow();
        this.handleRefuel();
        this.handleWaterGeneration();
        this.causePollution();
    }

    private void pushWaterToAdjacentTiles() {
        Arrays.stream(ForgeDirection.values(), 0, 6).forEach(direction -> Optional.ofNullable(this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ)).ifPresent(te -> {
            IFluidTank tank;
            int drainage;
            if (te instanceof IFluidHandler) {
                int drainage2;
                IFluidHandler tank2 = (IFluidHandler)te;
                if (tank2.canFill(direction.getOpposite(), this.outputstack.getFluid()) && (drainage2 = tank2.fill(direction.getOpposite(), this.outputstack, false)) > 0) {
                    tank2.fill(direction.getOpposite(), this.outputstack, true);
                    this.drain(drainage2, true);
                }
            } else if (te instanceof IFluidTank && (drainage = (tank = (IFluidTank)te).fill(this.outputstack, false)) > 0) {
                tank.fill(this.outputstack, true);
                this.drain(drainage, true);
            }
        }));
    }

    private void causePollution() {
        Optional.ofNullable(this.field_145850_b).ifPresent(e -> {
            if (e.func_82737_E() % 20L == 0L) {
                Optional.ofNullable(e.func_72938_d(this.field_145851_c, this.field_145849_e)).ifPresent(c -> Pollution.addPollution(c, Configuration.pollution.pollutionHeatedWaterPumpSecond));
            }
        });
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return TileEntityFurnace.func_145952_a((ItemStack)p_102007_2_) > 0;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slotIn) {
        if (slotIn == 0) {
            return this.fuelstack;
        }
        return this.fakestack;
    }

    public ItemStack func_70298_a(int slot, int ammount) {
        if (slot != 0 || this.fuelstack == null || ammount > this.fuelstack.field_77994_a) {
            return null;
        }
        return this.fuelstack.func_77979_a(ammount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            this.fuelstack = stack;
        } else {
            this.fakestack = stack;
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 && index == 0;
    }

    public FluidStack getFluid() {
        return this.outputstack.amount > 0 ? this.outputstack : null;
    }

    public int getFluidAmount() {
        return this.outputstack.amount;
    }

    public int getCapacity() {
        return 8000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int actualdrain = maxDrain;
        if (actualdrain > this.outputstack.amount) {
            actualdrain = this.outputstack.amount;
        }
        FluidStack ret = new FluidStack(WATER, actualdrain);
        if (ret.amount == 0) {
            ret = null;
        }
        if (doDrain) {
            this.outputstack.amount -= actualdrain;
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.outputstack, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, actualdrain));
        }
        return ret;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == WATER && this.drain(resource.amount, false) != null) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == null || fluid == WATER;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"tooltip.tile.waterpump.0.name") + " " + GTUtility.formatNumbers(Configuration.singleBlocks.mbWaterperSec) + String.format(StatCollector.func_74838_a((String)"tooltip.tile.waterpump.1.name"), Configuration.pollution.pollutionHeatedWaterPumpSecond), StatCollector.func_74838_a((String)"tooltip.tile.waterpump.2.name")};
    }

    @Override
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        ITileHasDifferentTextureSides.texture[ForgeDirection.UP.ordinal()] = par1IconRegister.func_94245_a("bartworks:heatedWaterPumpTop");
        ITileHasDifferentTextureSides.texture[ForgeDirection.DOWN.ordinal()] = par1IconRegister.func_94245_a("bartworks:heatedWaterPumpDown");
        for (int i = 2; i < 7; ++i) {
            ITileHasDifferentTextureSides.texture[i] = par1IconRegister.func_94245_a("bartworks:heatedWaterPumpSide");
        }
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        ModularWindow.Builder builder = ModularWindow.builder((int)176, (int)166);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        builder.bindPlayerInventory(buildContext.getPlayer());
        InvWrapper invWrapper = new InvWrapper((IInventory)this);
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)invWrapper, 0).setFilter(stack -> TileEntityFurnace.func_145952_a((ItemStack)stack) > 0).setPos(55, 52))).widget(SlotWidget.phantom((IItemHandlerModifiable)invWrapper, (int)1).disableInteraction().setPos(85, 32))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.fuel / (float)this.maxfuel)).setTexture(BWUITextures.PROGRESSBAR_FUEL, 14).setDirection(ProgressBar.Direction.UP).setPos(56, 36).setSize(14, 14));
        return builder.build();
    }
}

