/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.API.modularUI.BWUITextures;
import bartworks.common.items.ItemStonageRotors;
import bartworks.common.loaders.ItemRegistry;
import bartworks.common.tileentities.classic.TileEntityRotorBlock;
import bartworks.util.BWTooltipReference;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IGetTitleColor;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEWindmill
extends MTEEnhancedMultiBlockBase<MTEWindmill>
implements ISurvivalConstructable,
IGetTitleColor {
    private static final IIcon[] iIcons = new IIcon[2];
    private static final IIconContainer[] iIconContainers = new IIconContainer[2];
    private static final ITexture[] iTextures = new ITexture[3];
    private TileEntityRotorBlock rotorBlock;
    private int mDoor = 0;
    private int mHardenedClay = 0;
    private int mMulti = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEWindmill> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"       ", "       ", "       ", "   p   ", "       ", "       ", "       "}, {"       ", "       ", "  ppp  ", "  p p  ", "  ppp  ", "       ", "       "}, {"       ", " ppppp ", " p   p ", " p   p ", " p   p ", " ppppp ", "       "}, {" ppppp ", "p     p", "p     p", "p     p", "p     p", "p     p", " ppppp "}, {" ppspp ", "p     p", "p     p", "p     p", "p     p", "p     p", " ppppp "}, {" ppppp ", "p     p", "p     p", "p     p", "p     p", "p     p", " ppppp "}, {"       ", " ppppp ", " p   p ", " p   p ", " p   p ", " ppppp ", "       "}, {"       ", "  ccc  ", " c   c ", " c   c ", " c   c ", "  ccc  ", "       "}, {"       ", "  ccc  ", " c   c ", " c   c ", " c   c ", "  ccc  ", "       "}, {"       ", "  ccc  ", " c   c ", " c   c ", " c   c ", "  ccc  ", "       "}, {"       ", "  ccc  ", " c   c ", " c   c ", " c   c ", "  ccc  ", "       "}, {" bb~bb ", "bbbbbbb", "bbbbbbb", "bbbbbbb", "bbbbbbb", "bbbbbbb", " bbbbb "}})).addElement('p', StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150344_f)).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> ++t.mHardenedClay, (IStructureElement)StructureUtility.ofBlock((Block)Blocks.field_150405_ch, (int)0)), StructureUtility.ofTileAdder(MTEWindmill::addDispenserToOutputSet, (Block)Blocks.field_150405_ch, (int)0), StructureUtility.onElementPass(t -> ++t.mDoor, (IStructureElement)new IStructureElementNoPlacement<MTEWindmill>(){
        private final IStructureElement<MTEWindmill> delegate = StructureUtility.ofBlock((Block)Blocks.field_150466_ao, (int)0);

        public boolean check(MTEWindmill gt_tileEntity_windmill, World world, int x, int y, int z) {
            return this.delegate.check((Object)gt_tileEntity_windmill, world, x, y, z);
        }

        public boolean spawnHint(MTEWindmill gt_tileEntity_windmill, World world, int x, int y, int z, ItemStack trigger) {
            return this.delegate.spawnHint((Object)gt_tileEntity_windmill, world, x, y, z, trigger);
        }
    })})).addElement('b', StructureUtility.ofBlock((Block)Blocks.field_150336_V, (int)0)).addElement('s', (IStructureElement)new IStructureElement<MTEWindmill>(){

        public boolean check(MTEWindmill t, World world, int x, int y, int z) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            return t.setRotorBlock(tileEntity);
        }

        public boolean spawnHint(MTEWindmill t, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)0);
            return true;
        }

        public boolean placeBlock(MTEWindmill gt_tileEntity_windmill, World world, int x, int y, int z, ItemStack trigger) {
            return false;
        }

        public IStructureElement.BlocksToPlace getBlocksToPlace(MTEWindmill gt_tileEntity_windmill, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.create((ItemStack)new ItemStack(ItemRegistry.ROTORBLOCK));
        }
    }).build();
    private final Set<TileEntityDispenser> tileEntityDispensers = new HashSet<TileEntityDispenser>();

    public MTEWindmill(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    private MTEWindmill(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEWindmill> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Windmill").addInfo("Controller block for the Windmill").addInfo("A primitive Grinder powered by Kinetic energy").addInfo("Speed and output will be affected by wind speed, recipe and rotor").addInfo("Please use the Primitive Rotor").addInfo("Macerates 16 items at a time").addInfo("The structure is too complex!").addInfo("Follow the StructureLib hologram projector to build the main structure.").addSeparator().beginStructureBlock(7, 12, 7, false).addController("Front bottom center").addCasingInfoMin("Hardened Clay block", 40, false).addOtherStructurePart("Dispenser", "Any Hardened Clay block").addOtherStructurePart("0-1 Wooden door", "Any Hardened Clay block").addStructureHint("Primitive Kinetic Shaftbox", 1).toolTipFinisher(BWTooltipReference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mMaxProgresstime > 0) {
            this.mProgresstime += this.rotorBlock.getGrindPower();
        }
        if (!this.rotorBlock.rotorSlot.isEmpty()) {
            this.setRotorDamage(this.rotorBlock, this.rotorBlock.getGrindPower());
        }
        return this.rotorBlock.getGrindPower() > 0;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    private float[] multiplierRecipe(ItemStack itemStack) {
        OrePrefixes prefix;
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151015_O) {
            return new float[]{1.13f, 1.5f};
        }
        Block block = Block.func_149634_a((Item)item);
        if (item == Items.field_151103_aS || block == Blocks.field_150426_aN || block == Blocks.field_150423_aK) {
            return new float[]{0.8f, 1.0f};
        }
        if (block == Blocks.field_150351_n || block == Blocks.field_150347_e || block == Blocks.field_150348_b || block == Blocks.field_150322_A || block == Blocks.field_150435_aG || block == Blocks.field_150405_ch || block == Blocks.field_150406_ce || block == Blocks.field_150325_L || block == Blocks.field_150424_aL || block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
            return new float[]{1.0f, 1.5f};
        }
        ItemData association = GTOreDictUnificator.getAssociation(itemStack);
        OrePrefixes orePrefixes = prefix = association == null ? null : association.mPrefix;
        if (prefix == null || association.mMaterial == null || association.mMaterial.mMaterial == null || association.mMaterial.mMaterial.getDust(1) == null) {
            return new float[]{1.0f, 1.0f};
        }
        if (OrePrefixes.ore == prefix || OrePrefixes.oreNetherrack == prefix || OrePrefixes.oreEndstone == prefix || OrePrefixes.oreBlackgranite == prefix || OrePrefixes.oreRedgranite == prefix || OrePrefixes.oreMarble == prefix || OrePrefixes.oreBasalt == prefix) {
            return new float[]{0.5f, 1.0f};
        }
        if (OrePrefixes.stone == prefix || OrePrefixes.stoneBricks == prefix || OrePrefixes.stoneChiseled == prefix || OrePrefixes.stoneCobble == prefix || OrePrefixes.stoneCracked == prefix || OrePrefixes.stoneMossy == prefix || OrePrefixes.stoneMossyBricks == prefix || OrePrefixes.stoneSmooth == prefix || OrePrefixes.cobblestone == prefix) {
            return new float[]{1.0f, 1.5f};
        }
        return new float[]{1.0f, 1.0f};
    }

    @Override
    public boolean checkRecipe(ItemStack itemStack) {
        GTRecipe tRecipe;
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return false;
        }
        if (this.mOutputItems == null) {
            this.mOutputItems = new ItemStack[2];
        }
        if ((tRecipe = RecipeMaps.maceratorRecipes.findRecipeQuery().items(itemStack).voltage(GTValues.V[1]).find()) == null) {
            return false;
        }
        if (tRecipe.getOutput(0) != null) {
            ItemStack tmp;
            int amount;
            for (int i = 0; i < this.mMulti; ++i) {
                if (tRecipe.isRecipeInputEqual(true, null, itemStack)) continue;
                this.mMulti = i;
                break;
            }
            this.updateSlots();
            this.mOutputItems[0] = tRecipe.getOutput(0);
            float[] mRecipe = this.multiplierRecipe(itemStack);
            float multiper = Math.min(mRecipe[1], Math.max(mRecipe[0], 2.0f * (float)Math.sqrt(1.0f / (float)(this.rotorBlock.getWindStrength() + 1)) * this.OutputMultiplier(this.rotorBlock) * (mRecipe[0] + mRecipe[1])));
            ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
            for (amount = (int)Math.floor(multiper * (float)(this.mOutputItems[0].field_77994_a * this.mMulti)); amount > this.mOutputItems[0].func_77976_d(); amount -= this.mOutputItems[0].func_77976_d()) {
                tmp = this.mOutputItems[0].func_77946_l();
                tmp.field_77994_a = this.mOutputItems[0].func_77976_d();
                splitStacks.add(tmp);
            }
            tmp = this.mOutputItems[0].func_77946_l();
            tmp.field_77994_a = amount;
            splitStacks.add(tmp);
            this.mOutputItems = splitStacks.toArray(new ItemStack[splitStacks.size()]);
        }
        this.mMaxProgresstime = tRecipe.mDuration * 2 * 100 * this.mMulti / this.getSpeed(this.rotorBlock);
        this.mMulti = 16;
        return true;
    }

    @Override
    public void stopMachine() {
        this.getBaseMetaTileEntity().disableWorking();
    }

    public boolean addDispenserToOutputSet(TileEntity aTileEntity) {
        if (aTileEntity instanceof TileEntityDispenser) {
            this.tileEntityDispensers.add((TileEntityDispenser)aTileEntity);
            return true;
        }
        return false;
    }

    public boolean setRotorBlock(TileEntity aTileEntity) {
        if (aTileEntity instanceof TileEntityRotorBlock) {
            this.rotorBlock = (TileEntityRotorBlock)aTileEntity;
            return true;
        }
        return false;
    }

    @Override
    public boolean addOutput(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        for (TileEntityDispenser tHatch : this.tileEntityDispensers) {
            for (int i = tHatch.func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.func_70301_a(i) != null && (!GTUtility.areStacksEqual(tHatch.func_70301_a(i), aStack) || aStack.field_77994_a + tHatch.func_70301_a((int)i).field_77994_a > 64)) continue;
                if (GTUtility.areStacksEqual(tHatch.func_70301_a(i), aStack)) {
                    ItemStack merge = tHatch.func_70301_a(i).func_77946_l();
                    merge.field_77994_a = aStack.field_77994_a + tHatch.func_70301_a((int)i).field_77994_a;
                    tHatch.func_70299_a(i, merge);
                } else {
                    tHatch.func_70299_a(i, aStack.func_77946_l());
                }
                if (GTUtility.areStacksEqual(tHatch.func_70301_a(i), aStack)) {
                    aStack = null;
                    return true;
                }
                tHatch.func_70299_a(i, null);
                aStack = null;
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        this.tileEntityDispensers.clear();
        this.mDoor = 0;
        this.mHardenedClay = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 11, 0) && !this.tileEntityDispensers.isEmpty() && this.mDoor <= 2 && this.mHardenedClay >= 40;
    }

    @Override
    public int getCurrentEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public void updateSlots() {
        if (this.mInventory[1] != null && this.mInventory[1].field_77994_a <= 0) {
            this.mInventory[1] = null;
        }
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEWindmill(this.mName);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Progress:", this.mProgresstime + " Grindings of " + this.mMaxProgresstime + " needed Grindings", "GrindPower:", this.rotorBlock.getGrindPower() + "KU/t"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        MTEWindmill.iIcons[0] = Blocks.field_150336_V.func_149691_a(0, 0);
        MTEWindmill.iIconContainers[0] = new IIconContainer(){

            @Override
            public IIcon getIcon() {
                return iIcons[0];
            }

            @Override
            public IIcon getOverlayIcon() {
                return null;
            }

            @Override
            public ResourceLocation getTextureFile() {
                return new ResourceLocation("brick");
            }
        };
        MTEWindmill.iIcons[1] = aBlockIconRegister.func_94245_a("bartworks:windmill_top");
        MTEWindmill.iIconContainers[1] = new IIconContainer(){

            @Override
            public IIcon getIcon() {
                return iIcons[1];
            }

            @Override
            public IIcon getOverlayIcon() {
                return null;
            }

            @Override
            public ResourceLocation getTextureFile() {
                return new ResourceLocation("bartworks:windmill_top");
            }
        };
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        Object[] ret = new ITexture[6];
        if (this.isClientSide()) {
            if (facing == side || side == ForgeDirection.DOWN) {
                MTEWindmill.iTextures[0] = TextureFactory.of(iIconContainers[0]);
                Arrays.fill(ret, iTextures[0]);
            } else if (side == ForgeDirection.UP) {
                MTEWindmill.iTextures[1] = TextureFactory.of(iIconContainers[1]);
                Arrays.fill(ret, iTextures[1]);
            } else {
                MTEWindmill.iTextures[2] = TextureFactory.of(Textures.BlockIcons.COVER_WOOD_PLATE);
                Arrays.fill(ret, iTextures[2]);
            }
        }
        return ret;
    }

    public boolean isClientSide() {
        if (this.getBaseMetaTileEntity().getWorld() != null) {
            return this.getBaseMetaTileEntity().getWorld().field_72995_K ? FMLCommonHandler.instance().getSide() == Side.CLIENT : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 3, 11, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 11, 0, elementBudget, env, false, true);
    }

    public float OutputMultiplier(TileEntityRotorBlock rotorBlock) {
        try {
            return ((ItemStonageRotors)rotorBlock.rotorSlot.get().func_77973_b()).getmRotor();
        }
        catch (Exception e) {
            return 1.0f;
        }
    }

    public int getSpeed(TileEntityRotorBlock rotorBlock) {
        try {
            return ((ItemStonageRotors)rotorBlock.rotorSlot.get().func_77973_b()).getSpeed();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public void setRotorDamage(TileEntityRotorBlock rotorBlock, int damage) {
        try {
            ((ItemStonageRotors)rotorBlock.rotorSlot.get().func_77973_b()).damageItemStack(rotorBlock.rotorSlot.get(), damage);
        }
        catch (Exception e) {
            rotorBlock.rotorSlot.damage(damage, false);
        }
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return new GUITextureSet().setMainBackground((UITexture)BWUITextures.BACKGROUND_BROWN).setItemSlot((UITexture)BWUITextures.SLOT_BROWN).setTitleTab(BWUITextures.TAB_TITLE_BROWN, BWUITextures.TAB_TITLE_DARK_BROWN, BWUITextures.TAB_TITLE_ANGULAR_BROWN);
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)BWUITextures.PICTURE_BW_LOGO_47X21).setSize(47, 21).setPos(123, 59));
    }

    @Override
    public int getTitleColor() {
        return (Integer)this.COLOR_TITLE_WHITE.get();
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).setPos(59, 35))).widget(new DrawableWidget(){
            private static final int DIVIDER = 125;

            public void onScreenUpdate() {
                super.onScreenUpdate();
                if (MTEWindmill.this.mMaxProgresstime > 0) {
                    if (System.currentTimeMillis() / 125L % 40L == 30L) {
                        this.setDrawable((IDrawable)BWUITextures.PICTURE_WINDMILL_ROTATING[3]);
                    } else if (System.currentTimeMillis() / 125L % 40L == 20L) {
                        this.setDrawable((IDrawable)BWUITextures.PICTURE_WINDMILL_ROTATING[2]);
                    } else if (System.currentTimeMillis() / 125L % 40L == 10L) {
                        this.setDrawable((IDrawable)BWUITextures.PICTURE_WINDMILL_ROTATING[1]);
                    } else if (System.currentTimeMillis() / 125L % 40L == 0L) {
                        this.setDrawable((IDrawable)BWUITextures.PICTURE_WINDMILL_ROTATING[0]);
                    }
                } else {
                    this.setDrawable((IDrawable)BWUITextures.PICTURE_WINDMILL_EMPTY);
                }
            }
        }.setDrawable((IDrawable)BWUITextures.PICTURE_WINDMILL_EMPTY).setPos(85, 27).setSize(32, 32))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mMaxProgresstime, val -> {
            this.mMaxProgresstime = val;
        }))).widget(new ItemDrawable(() -> this.mMachine && !this.getBaseMetaTileEntity().isActive() ? MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SOFTMALLET.ID, 1, null, null, null) : null).asWidget().setPos(66, 66))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)))).widget(new TextWidget(GTUtility.trans("138", "Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setMaxWidth(150).setEnabled(widget -> !this.mMachine).setPos(92, 22))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

