/*
 * Decompiled with CFR 0.152.
 */
package detrav.items.behaviours;

import bartworks.system.material.Werkstoff;
import com.sinthoras.visualprospecting.VisualProspecting_API;
import cpw.mods.fml.common.registry.LanguageRegistry;
import detrav.DetravScannerMod;
import detrav.items.DetravMetaGeneratedTool01;
import detrav.utils.BartWorksHelper;
import detrav.utils.GTppHelper;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.common.Pollution;
import gregtech.common.UndergroundOil;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.SplittableRandom;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;

public class BehaviourDetravToolProspector
extends BehaviourNone {
    static final int[] DISTANCEINTS = new int[]{0, 4, 25, 64};
    int distTextIndex;
    HashMap<String, Integer> ores;
    int badluck;
    protected final int mCosts;
    static final String CHAT_MSG_SEPARATOR = "--------------------";

    public BehaviourDetravToolProspector(int aCosts) {
        this.mCosts = aCosts;
    }

    @Override
    public boolean onItemUse(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        SplittableRandom aRandom = new SplittableRandom();
        int chance = Math.min((1 + aStack.func_77960_j()) * 8, 100);
        if (aWorld.field_72995_K) {
            return false;
        }
        if (aWorld.func_147439_a(aX, aY, aZ) == Blocks.field_150357_h) {
            if (!aWorld.field_72995_K && aRandom.nextInt(100) < chance) {
                FluidStack fStack = UndergroundOil.undergroundOil(aWorld.func_72938_d(aX, aZ), -1.0f);
                this.addChatMassageByValue(aPlayer, fStack.amount / 2, "a Fluid");
                if (!aPlayer.field_71075_bZ.field_75098_d) {
                    ((DetravMetaGeneratedTool01)aItem).doDamage(aStack, this.mCosts);
                }
                if (Mods.VisualProspecting.isModLoaded()) {
                    VisualProspecting_API.LogicalServer.sendProspectionResultsToClient((EntityPlayerMP)((EntityPlayerMP)aPlayer), new ArrayList(), (List)VisualProspecting_API.LogicalServer.prospectUndergroundFluidsWithingRadius((World)aWorld, (int)((int)aPlayer.field_70165_t), (int)((int)aPlayer.field_70161_v), (int)0));
                }
            }
            return true;
        }
        if (aWorld.func_147439_a(aX, aY, aZ).func_149688_o() == Material.field_151576_e || aWorld.func_147439_a(aX, aY, aZ).func_149688_o() == Material.field_151578_c || aWorld.func_147439_a(aX, aY, aZ) == GregTechAPI.sBlockOres1) {
            if (!aWorld.field_72995_K) {
                this.prospectChunks((DetravMetaGeneratedTool01)aItem, aStack, aPlayer, aWorld, aX, aY, aZ, aRandom, chance);
            }
            return true;
        }
        return false;
    }

    protected void prospectChunks(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, SplittableRandom aRandom, int chance) {
        int bX = aX;
        int bZ = aZ;
        this.badluck = 0;
        this.ores = new HashMap();
        int range = ((DetravMetaGeneratedTool01)aItem).getHarvestLevel(aStack, "") / 2 + aStack.func_77960_j() / 4;
        if (range % 2 == 0) {
            ++range;
        }
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + GTLanguageManager.sEnglishFile.get("LanguageFile", "gt.scanner.prospecting", "Prospecting at ").getString() + EnumChatFormatting.BLUE + "(" + bX + ", " + bZ + ")"));
        for (int x = -(range /= 2); x < range + 1; ++x) {
            aX = bX + x * 16;
            for (int z = -range; z < range + 1; ++z) {
                aZ = bZ + z * 16;
                int dist = x * x + z * z;
                this.distTextIndex = 0;
                while (this.distTextIndex < DISTANCEINTS.length && dist > DISTANCEINTS[this.distTextIndex]) {
                    ++this.distTextIndex;
                }
                if (DetravScannerMod.DEBUG_ENABLED) {
                    aPlayer.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "Chunk at " + aX + "|" + aZ + " to " + (aX + 16) + "|" + (aZ + 16) + StatCollector.func_74838_a((String)("detrav.scanner.distance.texts." + this.distTextIndex))));
                }
                this.processOreProspecting((DetravMetaGeneratedTool01)aItem, aStack, aPlayer, aWorld.func_72938_d(aX, aZ), aWorld.func_147438_o(aX, aY, aZ), GTOreDictUnificator.getAssociation(new ItemStack(aWorld.func_147439_a(aX, aY, aZ), 1, aWorld.func_72805_g(aX, aY, aZ))), aRandom, chance);
            }
        }
        ArrayList<ChatComponentText> oreMessages = new ArrayList<ChatComponentText>();
        for (String key : this.ores.keySet()) {
            int value = this.ores.get(key);
            this.appendChatMessageByValue(oreMessages, aPlayer, value, key);
        }
        List<String> sortOrder = Arrays.asList(StatCollector.func_74838_a((String)"detrav.scanner.distance.texts.4"), StatCollector.func_74838_a((String)"detrav.scanner.distance.texts.3"), StatCollector.func_74838_a((String)"detrav.scanner.distance.texts.2"), StatCollector.func_74838_a((String)"detrav.scanner.distance.texts.1"), StatCollector.func_74838_a((String)"detrav.scanner.distance.texts.0"));
        ArrayList<ChatComponentText> oreMessagesSorted = new ArrayList<ChatComponentText>();
        oreMessagesSorted.add(new ChatComponentText(CHAT_MSG_SEPARATOR));
        for (String oreFrequency : sortOrder) {
            for (ChatComponentText msg : oreMessages) {
                if (!msg.func_150265_g().contains(oreFrequency)) continue;
                oreMessagesSorted.add(msg);
            }
            if (((ChatComponentText)oreMessagesSorted.get(oreMessagesSorted.size() - 1)).func_150265_g().contains(CHAT_MSG_SEPARATOR)) continue;
            oreMessagesSorted.add(new ChatComponentText(CHAT_MSG_SEPARATOR));
        }
        if (this.badluck == 0) {
            oreMessages.add(new ChatComponentText(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"detrav.scanner.success")));
        } else {
            oreMessages.add(new ChatComponentText(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"detrav.scanner.fail").replace("%badluck", Integer.toString(this.badluck))));
        }
        for (ChatComponentText msg : oreMessagesSorted) {
            aPlayer.func_145747_a((IChatComponent)msg);
        }
        if (Mods.VisualProspecting.isModLoaded()) {
            VisualProspecting_API.LogicalServer.sendProspectionResultsToClient((EntityPlayerMP)((EntityPlayerMP)aPlayer), (List)VisualProspecting_API.LogicalServer.prospectOreVeinsWithinRadius((int)aWorld.field_73011_w.field_76574_g, (int)((int)aPlayer.field_70165_t), (int)((int)aPlayer.field_70161_v), (int)(range * 16)), new ArrayList());
        }
    }

    protected void prospectSingleChunk(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        this.ores = new HashMap();
        aPlayer.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"detrav.scanner.prospecting") + EnumChatFormatting.BLUE + "(" + aX + ", " + aZ + ")"));
        this.processOreProspecting((DetravMetaGeneratedTool01)aItem, aStack, aPlayer, aWorld.func_72938_d(aX, aZ), aWorld.func_147438_o(aX, aY, aZ), GTOreDictUnificator.getAssociation(new ItemStack(aWorld.func_147439_a(aX, aY, aZ), 1, aWorld.func_72805_g(aX, aY, aZ))), new SplittableRandom(), 1000);
        for (String key : this.ores.keySet()) {
            int value = this.ores.get(key);
            this.addChatMassageByValue(aPlayer, value, key);
        }
        if (Mods.VisualProspecting.isModLoaded()) {
            VisualProspecting_API.LogicalServer.sendProspectionResultsToClient((EntityPlayerMP)((EntityPlayerMP)aPlayer), (List)VisualProspecting_API.LogicalServer.prospectOreVeinsWithinRadius((int)aWorld.field_73011_w.field_76574_g, (int)((int)aPlayer.field_70165_t), (int)((int)aPlayer.field_70161_v), (int)0), new ArrayList());
        }
    }

    protected void processOreProspecting(DetravMetaGeneratedTool01 aItem, ItemStack aStack, EntityPlayer aPlayer, Chunk aChunk, TileEntity aTileEntity, ItemData tAssotiation, SplittableRandom aRandom, int chance) {
        if (aTileEntity != null) {
            if (aTileEntity instanceof TileEntityOres) {
                TileEntityOres gt_entity = (TileEntityOres)aTileEntity;
                short meta = gt_entity.getMetaData();
                String format = LanguageRegistry.instance().getStringLocalization("gt.blockores." + meta + ".name");
                String name = Materials.getLocalizedNameForItem(format, meta % 1000);
                this.addOreToHashMap(name, aPlayer);
                if (!aPlayer.field_71075_bZ.field_75098_d) {
                    aItem.doDamage(aStack, this.mCosts);
                }
                return;
            }
        } else if (tAssotiation != null) {
            try {
                String name = tAssotiation.toString();
                this.addChatMassageByValue(aPlayer, -1, name);
                if (!aPlayer.field_71075_bZ.field_75098_d) {
                    aItem.doDamage(aStack, this.mCosts);
                }
                return;
            }
            catch (Exception e) {
                this.addChatMassageByValue(aPlayer, -1, "ERROR, lol ^_^");
            }
        } else {
            if (aRandom.nextInt(100) < chance) {
                int data = DetravMetaGeneratedTool01.INSTANCE.getToolGTDetravData(aStack).intValue();
                String small_ore_keyword = StatCollector.func_74838_a((String)"detrav.scanner.small_ore.keyword");
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int ySize = aChunk.func_76611_b(x, z);
                        for (int y = 1; y < ySize; ++y) {
                            Block tBlock = aChunk.func_150810_a(x, y, z);
                            short tMetaID = (short)aChunk.func_76628_c(x, y, z);
                            if (tBlock instanceof BlockOresAbstract) {
                                String name;
                                TileEntity tTileEntity = aChunk.getTileEntityUnsafe(x, y, z);
                                if (!(tTileEntity instanceof TileEntityOres) || !((TileEntityOres)tTileEntity).mNatural) continue;
                                tMetaID = ((TileEntityOres)tTileEntity).getMetaData();
                                try {
                                    String format = LanguageRegistry.instance().getStringLocalization(tBlock.func_149739_a() + "." + tMetaID + ".name");
                                    name = Materials.getLocalizedNameForItem(format, tMetaID % 1000);
                                    if (data != 1 && name.startsWith(small_ore_keyword)) continue;
                                    this.addOreToHashMap(name, aPlayer);
                                }
                                catch (Exception e) {
                                    name = tBlock.func_149739_a() + ".";
                                    if (data != 1 && name.contains(".small.")) continue;
                                    this.addOreToHashMap(name, aPlayer);
                                }
                                continue;
                            }
                            if (GTppHelper.isGTppBlock(tBlock)) {
                                String name = GTppHelper.getGTppVeinName(tBlock);
                                if (name.isEmpty()) continue;
                                this.addOreToHashMap(name, aPlayer);
                                continue;
                            }
                            if (BartWorksHelper.isOre(tBlock)) {
                                if (data != 1 && BartWorksHelper.isSmallOre(tBlock)) continue;
                                Werkstoff werkstoff = Werkstoff.werkstoffHashMap.getOrDefault((short)(BartWorksHelper.getMetaFromBlock(aChunk, x, y, z, tBlock) * -1), null);
                                String type = BartWorksHelper.isSmallOre(tBlock) ? "oreSmall" : "ore";
                                String translated = GTLanguageManager.getTranslation("bw.blocktype." + type);
                                this.addOreToHashMap(translated.replace("%material", werkstoff.getLocalizedName()), aPlayer);
                                continue;
                            }
                            if (data != 1 || (tAssotiation = GTOreDictUnificator.getAssociation(new ItemStack(tBlock, 1, (int)tMetaID))) == null || !tAssotiation.mPrefix.toString().startsWith("ore")) continue;
                            try {
                                String name;
                                try {
                                    tMetaID = (short)tAssotiation.mMaterial.mMaterial.mMetaItemSubID;
                                    String format = LanguageRegistry.instance().getStringLocalization("gt.blockores." + tMetaID + ".name");
                                    name = Materials.getLocalizedNameForItem(format, tMetaID % 1000);
                                    this.addOreToHashMap(name, aPlayer);
                                }
                                catch (Exception e1) {
                                    name = tAssotiation.toString();
                                    this.addOreToHashMap(name, aPlayer);
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!aPlayer.field_71075_bZ.field_75098_d) {
                    aItem.doDamage(aStack, this.mCosts);
                }
                return;
            }
            if (DetravScannerMod.DEBUG_ENABLED) {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + " Failed on this chunk"));
            }
            ++this.badluck;
            if (!aPlayer.field_71075_bZ.field_75098_d) {
                aItem.doDamage(aStack, this.mCosts / 4);
            }
        }
    }

    void addOreToHashMap(String orename, EntityPlayer aPlayer) {
        String oreDistance = orename + StatCollector.func_74838_a((String)("detrav.scanner.distance.texts." + this.distTextIndex));
        if (!this.ores.containsKey(oreDistance)) {
            if (DetravScannerMod.DEBUG_ENABLED) {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + " Adding to oremap " + oreDistance));
            }
            this.ores.put(oreDistance, 1);
        } else {
            int val = this.ores.get(oreDistance);
            this.ores.put(oreDistance, val + 1);
        }
    }

    void addChatMassageByValue(EntityPlayer aPlayer, int value, String name) {
        if (value < 0) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"detrav.scanner.found.texts.6") + name));
        } else if (value < 1) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"detrav.scanner.found.texts.0")));
        } else if (value < 10) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.1")));
        } else if (value < 30) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.2")));
        } else if (value < 60) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.3")));
        } else if (value < 100) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.4")));
        } else {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.5")));
        }
    }

    void appendChatMessageByValue(List<ChatComponentText> chatMessageList, EntityPlayer aPlayer, int value, String name) {
        if (value < 0) {
            chatMessageList.add(new ChatComponentText(StatCollector.func_74838_a((String)"detrav.scanner.found.texts.6") + name));
        } else if (value < 1) {
            chatMessageList.add(new ChatComponentText(StatCollector.func_74838_a((String)"detrav.scanner.found.texts.0")));
        } else if (value < 10) {
            chatMessageList.add(new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.1")));
        } else if (value < 30) {
            chatMessageList.add(new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.2")));
        } else if (value < 60) {
            chatMessageList.add(new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.3")));
        } else if (value < 100) {
            chatMessageList.add(new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.4")));
        } else {
            chatMessageList.add(new ChatComponentText(name + StatCollector.func_74838_a((String)"detrav.scanner.found.texts.5")));
        }
    }

    public static int getPollution(World aWorld, int aX, int aZ) {
        return Pollution.getPollution(aWorld.func_72938_d(aX, aZ));
    }
}

