/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.auxiliary;

import galacticgreg.GalacticGreg;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public abstract class ConfigManager {
    private File _mainconfigDir = null;
    private File _blocksconfigDir = null;
    private String _mModCollection = "";
    private String _mModID = "";
    protected Configuration _mainConfig = null;
    protected File _mConfigBaseDirectory;
    public boolean DoDebugMessages = false;

    protected abstract void PreInit();

    protected abstract void Init();

    protected abstract void PostInit();

    public ConfigManager(File pConfigBaseDirectory, String pModCollectionDirectory, String pModID) {
        this._mModCollection = pModCollectionDirectory;
        this._mModID = pModID;
        this._mConfigBaseDirectory = pConfigBaseDirectory;
    }

    public boolean LoadConfig() {
        try {
            this.InitConfigDirs();
            if (this._mainConfig == null) {
                return false;
            }
            this.PreInit();
            this._mainConfig.load();
            this.Init();
            this._mainConfig.save();
            this.PostInit();
            return true;
        }
        catch (Exception e) {
            GalacticGreg.Logger.error("Unable to init config file", new Object[0]);
            e.printStackTrace();
            return false;
        }
    }

    private void InitConfigDirs() {
        GalacticGreg.Logger.debug("Checking/creating config folders", new Object[0]);
        this._mainconfigDir = new File(String.format("%s%s%s", this._mConfigBaseDirectory, File.separator, this._mModCollection));
        if (!this._mainconfigDir.exists()) {
            GalacticGreg.Logger.info("Config folder not found. Creating...", new Object[0]);
            this._mainconfigDir.mkdir();
        }
        File tRealConfigFile = new File(String.format("%s%s%s%s", this._mainconfigDir, File.separator, this._mModID, ".cfg"));
        this._mainConfig = new Configuration(tRealConfigFile);
    }
}

