/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class MTEFuelRefineFactory
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    private IStructureDefinition<MTEFuelRefineFactory> multiDefinition = null;
    private int Tier = -1;
    private int[] cnt = new int[]{0, 0, 0, 0};
    private static final Block[] coils = new Block[]{Loaders.FRF_Coil_1, Loaders.FRF_Coil_2, Loaders.FRF_Coil_3, Loaders.FRF_Coil_4};

    public MTEFuelRefineFactory(String name) {
        super(name);
        this.useLongPower = true;
    }

    public MTEFuelRefineFactory(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.useLongPower = true;
    }

    @Override
    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 7, 12, 1, itemStack, hintsOnly);
    }

    public IStructureDefinition<MTEFuelRefineFactory> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"               ", "      CCC      ", "               "}, {"      XGX      ", "    CCFFFCC    ", "      XGX      "}, {"    CC   CC    ", "   CFFCCCFFC   ", "    CC   CC    "}, {"   C       C   ", "  CFCC   CCFC  ", "   C       C   "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {" X           X ", "CFC         CFC", " X           X "}, {" G           G ", "CFC         CFC", " G           G "}, {" X           X ", "CFC         CFC", " X           X "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"   C       C   ", "  CFCC   CCFC  ", "   C       C   "}, {"    CC   CC    ", "   CFFC~CFFC   ", "    CC   CC    "}, {"      XGX      ", "    CCFFFCC    ", "      XGX      "}, {"               ", "      CCC      ", "               "}})).addElement('X', GTStructureUtility.buildHatchAdder(MTEFuelRefineFactory.class).atLeast(HatchElement.Maintenance, HatchElement.InputHatch, HatchElement.InputBus, HatchElement.OutputHatch, TTMultiblockBase.HatchElement.EnergyMulti.or(HatchElement.Energy)).casingIndex(179).dot(1).buildAndChain(StructureUtility.ofBlock((Block)Loaders.FRF_Casings, (int)0))).addElement('C', StructureUtility.ofBlock((Block)Loaders.FRF_Casings, (int)0)).addElement('G', StructureUtility.ofBlock((Block)Loaders.fieldRestrictingGlass, (int)0)).addElement('F', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> {
                x.cnt[0] = x.cnt[0] + 1;
            }, MTEFuelRefineFactory.ofFieldCoil(0)), StructureUtility.onElementPass(x -> {
                x.cnt[1] = x.cnt[1] + 1;
            }, MTEFuelRefineFactory.ofFieldCoil(1)), StructureUtility.onElementPass(x -> {
                x.cnt[2] = x.cnt[2] + 1;
            }, MTEFuelRefineFactory.ofFieldCoil(2)), StructureUtility.onElementPass(x -> {
                x.cnt[3] = x.cnt[3] + 1;
            }, MTEFuelRefineFactory.ofFieldCoil(3))})).build();
        }
        return this.multiDefinition;
    }

    public static <T> IStructureElement<T> ofFieldCoil(final int aIndex) {
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block block = world.func_147439_a(x, y, z);
                return block.equals(coils[aIndex]);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)coils[this.getIndex(trigger)], (int)0);
                return true;
            }

            private int getIndex(ItemStack trigger) {
                int s = trigger.field_77994_a;
                if (s > 4 || s <= 0) {
                    s = 4;
                }
                return s - 1;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, coils[this.getIndex(trigger)], 0, 3);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)coils[this.getIndex(trigger)], (int)0);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)coils[this.getIndex(trigger)], (int)0, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Naquadah Fuel Refinery").addInfo("Controller block for the Naquadah Fuel Refinery").addInfo("But at what cost?").addInfo("Produces naquadah fuels.").addInfo("Needs field restriction coils to control the fatal radiation.").addInfo("Use higher tier coils to unlock more fuel types and reduce the processing times.").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().beginStructureBlock(3, 15, 15, false).addInputHatch("The casings adjacent to field restriction glass.").addInputBus("The casings adjacent to field restriction glass.", 1).addOutputHatch("The casings adjacent to field restriction glass.", 1).addEnergyHatch("The casings adjacent to field restriction glass.", 1).toolTipFinisher("Good Generator");
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.Tier = aNBT.func_74762_e("mTier");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mTier", this.Tier);
        super.saveNBTData(aNBT);
    }

    @Override
    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("FuelRefineFactory.hint", 8);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.cnt[0] = 0;
        this.cnt[1] = 0;
        this.cnt[2] = 0;
        this.cnt[3] = 0;
        return this.structureCheck_EM(this.mName, 7, 12, 1) && this.getTier() != -1;
    }

    public int getTier() {
        for (int i = 0; i < 4; ++i) {
            if (this.cnt[i] != 32) continue;
            this.Tier = i + 1;
            return i;
        }
        this.Tier = -1;
        return -1;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GoodGeneratorRecipeMaps.naquadahFuelRefineFactoryRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (recipe.mSpecialValue > MTEFuelRefineFactory.this.Tier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(recipe.mSpecialValue);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                int overclockAmount = MTEFuelRefineFactory.this.Tier - recipe.mSpecialValue;
                return super.createOverclockCalculator(recipe).limitOverclockCount(overclockAmount);
            }
        }.setOverclock(4.0, 4.0);
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getMaxInputEu());
        logic.setAvailableAmperage(1L);
    }

    public final boolean addToFRFList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            return this.mInputHatches.add((MTEHatchInput)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            return this.mOutputHatches.add((MTEHatchOutput)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchInputBus) {
            return this.mInputBusses.add((MTEHatchInputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            return this.mEnergyHatches.add((MTEHatchEnergy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyMulti) {
            return this.eEnergyMulti.add((MTEHatchEnergyMulti)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEFuelRefineFactory(this.mName);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getInfoData() {
        String[] infoData = new String[super.getInfoData().length + 1];
        System.arraycopy(super.getInfoData(), 0, infoData, 0, super.getInfoData().length);
        infoData[super.getInfoData().length] = StatCollector.func_74838_a((String)"scanner.info.FRF") + " " + this.Tier;
        return infoData;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(179), new GTRenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(179), new GTRenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(179)};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 7, 12, 1, elementBudget, env, false, true);
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

