/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import appeng.api.implementations.items.IAEWrench;
import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.tool.ITool;
import forestry.api.arboriculture.IToolGrafter;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enchants.EnchantmentRadioactivity;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TCAspects;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.common.tools.ToolTurbine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import mods.railcraft.api.core.items.IToolCrowbar;
import mrtjp.projectred.api.IScrewdriver;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

@Optional.InterfaceList(value={@Optional.Interface(iface="forestry.api.arboriculture.IToolGrafter", modid="ForestryAPI|arboriculture"), @Optional.Interface(iface="mods.railcraft.api.core.items.IToolCrowbar", modid="RailcraftAPI|items"), @Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraftAPI|tools"), @Optional.Interface(iface="crazypants.enderio.api.tool.ITool", modid="EnderIOAPI|Tools"), @Optional.Interface(iface="mrtjp.projectred.api.IScrewdriver", modid="ProjRed|Core")})
public abstract class MetaGeneratedTool
extends MetaBaseItem
implements IDamagableItem,
IToolGrafter,
IToolCrowbar,
IToolWrench,
ITool,
IScrewdriver,
IAEWrench {
    public static final ConcurrentHashMap<String, MetaGeneratedTool> sInstances = new ConcurrentHashMap();
    public final ConcurrentHashMap<Short, IToolStats> mToolStats = new ConcurrentHashMap();

    public MetaGeneratedTool(String aUnlocalized) {
        super(aUnlocalized);
        this.func_77637_a(GregTechAPI.TAB_GREGTECH);
        this.func_77625_d(1);
        sInstances.put(this.func_77658_a(), this);
    }

    public static final Materials getPrimaryMaterial(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            return Materials.getRealMaterial(aNBT.func_74779_i("PrimaryMaterial"));
        }
        return Materials._NULL;
    }

    public static final Materials getSecondaryMaterial(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            return Materials.getRealMaterial(aNBT.func_74779_i("SecondaryMaterial"));
        }
        return Materials._NULL;
    }

    public static final long getToolMaxDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            return aNBT.func_74763_f("MaxDamage");
        }
        return 0L;
    }

    public static final long getToolDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            return aNBT.func_74763_f("Damage");
        }
        return 0L;
    }

    public static final boolean setToolDamage(ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            aNBT.func_74772_a("Damage", aDamage);
            return true;
        }
        return false;
    }

    public static final boolean setToolMode(ItemStack aStack, byte aMode) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            aNBT.func_74774_a("Mode", aMode);
            return true;
        }
        return false;
    }

    public static final byte getToolMode(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null) {
            return aNBT.func_74771_c("Mode");
        }
        return 0;
    }

    public final ItemStack addTool(int aID, String aEnglish, String aToolTip, IToolStats aToolStats, Object ... aOreDictNamesAndAspects) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < 32766 && aID % 2 == 0) {
            GTLanguageManager.addStringLocalization(this.func_77658_a() + "." + aID + ".name", aEnglish);
            GTLanguageManager.addStringLocalization(this.func_77658_a() + "." + aID + ".tooltip", aToolTip);
            GTLanguageManager.addStringLocalization(this.func_77658_a() + "." + (aID + 1) + ".name", aEnglish + " (Empty)");
            GTLanguageManager.addStringLocalization(this.func_77658_a() + "." + (aID + 1) + ".tooltip", "You need to recharge it");
            this.mToolStats.put((short)aID, aToolStats);
            this.mToolStats.put((short)(aID + 1), aToolStats);
            aToolStats.onStatsAddedToTool(this, aID);
            ItemStack rStack = new ItemStack((Item)this, 1, aID);
            ArrayList<TCAspects.TC_AspectStack> tAspects = new ArrayList<TCAspects.TC_AspectStack>();
            for (Object tOreDictNameOrAspect : aOreDictNamesAndAspects) {
                if (tOreDictNameOrAspect instanceof TCAspects.TC_AspectStack) {
                    ((TCAspects.TC_AspectStack)tOreDictNameOrAspect).addToAspectList(tAspects);
                    continue;
                }
                GTOreDictUnificator.registerOre(tOreDictNameOrAspect, rStack);
            }
            if (GregTechAPI.sThaumcraftCompat != null) {
                GregTechAPI.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            GTModHandler.registerBoxableItemToToolBox(rStack);
            return rStack;
        }
        return null;
    }

    public final ItemStack getToolWithStats(int aToolID, int aAmount, Materials aPrimaryMaterial, Materials aSecondaryMaterial, long[] aElectricArray) {
        ItemStack rStack = new ItemStack((Item)this, aAmount, aToolID);
        IToolStats tToolStats = this.getToolStats(rStack);
        if (tToolStats != null) {
            NBTTagCompound tMainNBT = new NBTTagCompound();
            NBTTagCompound tToolNBT = new NBTTagCompound();
            tToolNBT.func_74774_a("Mode", (byte)0);
            if (aPrimaryMaterial != null) {
                tToolNBT.func_74778_a("PrimaryMaterial", aPrimaryMaterial.mName);
                tToolNBT.func_74772_a("MaxDamage", 100L * (long)((float)aPrimaryMaterial.mDurability * tToolStats.getMaxDurabilityMultiplier()));
            }
            if (aSecondaryMaterial != null) {
                tToolNBT.func_74778_a("SecondaryMaterial", aSecondaryMaterial.mName);
            }
            if (aElectricArray != null) {
                tToolNBT.func_74757_a("Electric", true);
                tToolNBT.func_74772_a("MaxCharge", aElectricArray[0]);
                tToolNBT.func_74772_a("Voltage", aElectricArray[1]);
                tToolNBT.func_74772_a("Tier", aElectricArray[2]);
                tToolNBT.func_74772_a("SpecialData", aElectricArray[3]);
            }
            tMainNBT.func_74782_a("GT.ToolStats", (NBTBase)tToolNBT);
            rStack.func_77982_d(tMainNBT);
        }
        this.isItemStackUsable(rStack);
        return rStack;
    }

    @Mod.EventHandler
    public void onHarvestBlockEvent(ArrayList<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        IToolStats tStats = this.getToolStats(aStack);
        if (this.isItemStackUsable(aStack) && this.getDigSpeed(aStack, aBlock, aMetaData) > 0.0f) {
            this.doDamage(aStack, (long)tStats.convertBlockDrops(aDrops, aStack, aPlayer, aBlock, aX, aY, aZ, aMetaData, aFortune, aSilkTouch, aEvent) * (long)tStats.getToolDamagePerDropConversion());
        }
    }

    @Mod.EventHandler
    public float onBlockBreakSpeedEvent(float aDefault, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, PlayerEvent.BreakSpeed aEvent) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats == null ? aDefault : tStats.getMiningSpeed(aBlock, aMetaData, aDefault, aPlayer, aPlayer.field_70170_p, aX, aY, aZ);
    }

    public boolean onBlockStartBreak(ItemStack aStack, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        if (aPlayer.field_70170_p.field_72995_K) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        Block aBlock = aPlayer.field_70170_p.func_147439_a(aX, aY, aZ);
        if (tStats.isChainsaw() && aBlock instanceof IShearable) {
            IShearable target = (IShearable)aBlock;
            if (target.isShearable(aStack, (IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ)) {
                ArrayList drops = target.onSheared(aStack, (IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)aStack));
                for (ItemStack stack : drops) {
                    float f = 0.7f;
                    double d = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(aPlayer.field_70170_p, (double)aX + d, (double)aY + d1, (double)aZ + d2, stack);
                    entityitem.field_145804_b = 10;
                    aPlayer.field_70170_p.func_72838_d((Entity)entityitem);
                }
                aPlayer.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)aBlock)], 1);
                this.func_150894_a(aStack, aPlayer.field_70170_p, aBlock, aX, aY, aZ, (EntityLivingBase)aPlayer);
            }
            return false;
        }
        return super.onBlockStartBreak(aStack, aX, aY, aZ, aPlayer);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || !this.isItemStackUsable(aStack)) {
            return true;
        }
        GTUtility.doSoundAtClient(tStats.getEntityHitSound(), 1, 1.0f);
        if (super.onLeftClickEntity(aStack, aPlayer, aEntity)) {
            return true;
        }
        if (aEntity.func_70075_an() && !aEntity.func_85031_j((Entity)aPlayer)) {
            float tMagicDamage = tStats.getMagicDamageAgainstEntity(aEntity instanceof EntityLivingBase ? EnchantmentHelper.func_77512_a((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0.0f, aEntity, aStack, aPlayer);
            float tDamage = tStats.getNormalDamageAgainstEntity((float)aPlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + this.getToolCombatDamage(aStack), aEntity, aStack, aPlayer);
            if (tDamage + tMagicDamage > 0.0f) {
                boolean tCriticalHit;
                boolean bl = tCriticalHit = aPlayer.field_70143_R > 0.0f && !aPlayer.field_70122_E && !aPlayer.func_70617_f_() && !aPlayer.func_70090_H() && !aPlayer.func_70644_a(Potion.field_76440_q) && aPlayer.field_70154_o == null && aEntity instanceof EntityLivingBase;
                if (tCriticalHit && tDamage > 0.0f) {
                    tDamage *= 1.5f;
                }
                if (aEntity.func_70097_a(tStats.getDamageSource((EntityLivingBase)aPlayer, aEntity), tDamage += tMagicDamage)) {
                    int tKnockcack;
                    if (aEntity instanceof EntityLivingBase) {
                        aEntity.func_70015_d(EnchantmentHelper.func_90036_a((EntityLivingBase)aPlayer) * 4);
                    }
                    if ((tKnockcack = (aPlayer.func_70051_ag() ? 1 : 0) + (aEntity instanceof EntityLivingBase ? EnchantmentHelper.func_77507_b((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0)) > 0) {
                        aEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(aPlayer.field_70177_z * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(aPlayer.field_70177_z * (float)Math.PI / 180.0f)) * (float)tKnockcack * 0.5f));
                        aPlayer.field_70159_w *= 0.6;
                        aPlayer.field_70179_y *= 0.6;
                        aPlayer.func_70031_b(false);
                    }
                    if (tCriticalHit) {
                        aPlayer.func_71009_b(aEntity);
                    }
                    if (tMagicDamage > 0.0f) {
                        aPlayer.func_71047_c(aEntity);
                    }
                    if (tDamage >= 18.0f) {
                        aPlayer.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    aPlayer.func_130011_c(aEntity);
                    if (aEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)aEntity), (Entity)aPlayer);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)aPlayer, (Entity)aEntity);
                    if (aEntity instanceof EntityLivingBase) {
                        aPlayer.func_71064_a(StatList.field_75951_w, Math.round(tDamage * 10.0f));
                    }
                    aEntity.field_70172_ad = Math.max(1, tStats.getHurtResistanceTime(aEntity.field_70172_ad, aEntity));
                    aPlayer.func_71020_j(0.3f);
                    this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
                }
            }
        }
        if (aStack.field_77994_a <= 0) {
            aPlayer.func_71028_bD();
        }
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            aPlayer.func_71008_a(aStack, 72000);
        }
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    public final int func_77626_a(ItemStack aStack) {
        return 72000;
    }

    public final EnumAction func_77661_b(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && tStats.canBlock()) {
            return EnumAction.block;
        }
        return EnumAction.none;
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        for (int i = 0; i < 32766; i += 2) {
            if (this.getToolStats(new ItemStack((Item)this, 1, i)) == null) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
            aList.add(this.getToolWithStats(i, 1, Materials.Neutronium, Materials.Neutronium, null));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void func_94581_a(IIconRegister aIconRegister) {
    }

    @Override
    public final IIcon func_77617_a(int aMetaData) {
        return null;
    }

    @Override
    public void addAdditionalToolTips(List<String> aList, ItemStack aStack, EntityPlayer aPlayer) {
        int tOffset;
        long tMaxDamage = MetaGeneratedTool.getToolMaxDamage(aStack);
        Materials tMaterial = MetaGeneratedTool.getPrimaryMaterial(aStack);
        IToolStats tStats = this.getToolStats(aStack);
        int n = tOffset = this.getElectricStats(aStack) != null ? 2 : 1;
        if (tStats != null) {
            if (tStats instanceof ToolTurbine) {
                float aBaseEff = (5.0f + this.getToolCombatDamage(aStack)) * 1000.0f;
                TurbineStatCalculator turbine = new TurbineStatCalculator((MetaGeneratedTool)aStack.func_77973_b(), aStack);
                float aOptFlow = Math.max(Float.MIN_NORMAL, turbine.getOptimalFlow());
                aList.add(tOffset + 0, EnumChatFormatting.GRAY + String.format(this.transItem("001", "Durability: %s/%s"), "" + EnumChatFormatting.GREEN + GTUtility.formatNumbers(turbine.getCurrentDurability()) + " ", " " + GTUtility.formatNumbers(turbine.getMaxDurability())) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 1, EnumChatFormatting.GRAY + String.format(this.transItem("002", "%s Tier %s"), tMaterial.mLocalizedName + ":" + EnumChatFormatting.YELLOW, "" + this.getHarvestLevel(aStack, "")) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 2, EnumChatFormatting.WHITE + String.format(this.transItem("005", "Base Efficiency: %s"), "" + EnumChatFormatting.BLUE + (int)Math.ceil(turbine.getEfficiency() * 100.0f)) + "%" + EnumChatFormatting.GRAY);
                aList.add(tOffset + 3, EnumChatFormatting.GRAY + this.transItem("006", "Fuel | Optimal Flow > EU/t Produced | Efficiency"));
                aList.add(tOffset + 4, EnumChatFormatting.WHITE + "  Steam " + EnumChatFormatting.GRAY + " | " + String.format("%s L/t > %s EU/t | %s", "" + EnumChatFormatting.GOLD + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalSteamFlow())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.DARK_GREEN + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalSteamEUt())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.BLUE + (int)(turbine.getSteamEfficiency() * 100.0f) + "%" + EnumChatFormatting.GRAY));
                aList.add(tOffset + 5, EnumChatFormatting.WHITE + "  Loose " + EnumChatFormatting.GRAY + " | " + String.format("%s L/t > %s EU/t | %s", "" + EnumChatFormatting.GOLD + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalLooseSteamFlow())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.DARK_GREEN + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalLooseSteamEUt())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.BLUE + (int)(turbine.getLooseSteamEfficiency() * 100.0f) + "%" + EnumChatFormatting.GRAY));
                aList.add(tOffset + 6, EnumChatFormatting.DARK_GRAY + "  Supercritical and Superheated EU values are 2x");
                aList.add(tOffset + 7, EnumChatFormatting.AQUA + "  Gas " + EnumChatFormatting.GRAY + " | " + String.format("%s EU/t > %s EU/t | %s", "" + EnumChatFormatting.GOLD + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalGasFlow())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.DARK_GREEN + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalGasEUt())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.BLUE + (int)(turbine.getGasEfficiency() * 100.0f) + "%" + EnumChatFormatting.GRAY));
                aList.add(tOffset + 8, EnumChatFormatting.AQUA + "  Loose " + EnumChatFormatting.GRAY + " | " + String.format("%s EU/t > %s EU/t | %s", "" + EnumChatFormatting.GOLD + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalLooseGasFlow())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.DARK_GREEN + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalLooseGasEUt())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.BLUE + (int)(turbine.getLooseGasEfficiency() * 100.0f) + "%" + EnumChatFormatting.GRAY));
                aList.add(tOffset + 9, EnumChatFormatting.LIGHT_PURPLE + "  Plasma" + EnumChatFormatting.GRAY + " | " + String.format("%s EU/t > %s EU/t | %s", "" + EnumChatFormatting.GOLD + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalPlasmaFlow())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.DARK_GREEN + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalPlasmaEUt())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.BLUE + (int)(turbine.getPlasmaEfficiency() * 100.0f) + "%" + EnumChatFormatting.GRAY));
                aList.add(tOffset + 10, EnumChatFormatting.LIGHT_PURPLE + "  Loose" + EnumChatFormatting.GRAY + " | " + String.format("%s EU/t > %s EU/t | %s", "" + EnumChatFormatting.GOLD + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalLoosePlasmaFlow())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.DARK_GREEN + GTUtility.formatNumbers(GTUtility.safeInt((long)turbine.getOptimalLoosePlasmaEUt())) + EnumChatFormatting.GRAY, "" + EnumChatFormatting.BLUE + (int)(turbine.getLoosePlasmaEfficiency() * 100.0f) + "%" + EnumChatFormatting.GRAY));
                aList.add(tOffset + 11, EnumChatFormatting.LIGHT_PURPLE + String.format(this.transItem("502", "Overflow Efficiency Tier: %s"), "" + EnumChatFormatting.GOLD + turbine.getOverflowEfficiency() + EnumChatFormatting.GRAY));
            } else {
                aList.add(tOffset, EnumChatFormatting.WHITE + String.format(this.transItem("001", "Durability: %s/%s"), "" + EnumChatFormatting.GREEN + GTUtility.formatNumbers(tMaxDamage - MetaGeneratedTool.getToolDamage(aStack)) + " ", " " + GTUtility.formatNumbers(tMaxDamage)) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 1, EnumChatFormatting.WHITE + String.format(this.transItem("002", "%s lvl %s"), tMaterial.mLocalizedName + EnumChatFormatting.YELLOW, "" + this.getHarvestLevel(aStack, "")) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 2, EnumChatFormatting.WHITE + String.format(this.transItem("003", "Attack Damage: %s"), "" + EnumChatFormatting.BLUE + this.getToolCombatDamage(aStack)) + EnumChatFormatting.GRAY);
                aList.add(tOffset + 3, EnumChatFormatting.WHITE + String.format(this.transItem("004", "Mining Speed: %s"), "" + EnumChatFormatting.GOLD + Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed)) + EnumChatFormatting.GRAY);
                NBTTagCompound aNBT = aStack.func_77978_p();
                if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null && aNBT.func_74764_b("Heat")) {
                    int tHeat = aNBT.func_74762_e("Heat");
                    long tWorldTime = aPlayer.func_130014_f_().func_72820_D();
                    if (aNBT.func_74764_b("HeatTime")) {
                        long tHeatTime = aNBT.func_74763_f("HeatTime");
                        if (tWorldTime > tHeatTime + 10L && (tHeat = (int)((long)tHeat - (tWorldTime - tHeatTime) / 10L)) < 300 && tHeat > -10000) {
                            tHeat = 300;
                        }
                        aNBT.func_74772_a("HeatTime", tWorldTime);
                        if (tHeat > -10000) {
                            aNBT.func_74768_a("Heat", tHeat);
                        }
                    }
                    aList.add(tOffset + 3, EnumChatFormatting.RED + "Heat: " + aNBT.func_74762_e("Heat") + " K" + EnumChatFormatting.GRAY);
                }
            }
        }
    }

    @Override
    public Long[] getFluidContainerStats(ItemStack aStack) {
        return null;
    }

    @Override
    public Long[] getElectricStats(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("GT.ToolStats")) != null && aNBT.func_74767_n("Electric")) {
            return new Long[]{aNBT.func_74763_f("MaxCharge"), aNBT.func_74763_f("Voltage"), aNBT.func_74763_f("Tier"), aNBT.func_74763_f("SpecialData")};
        }
        return null;
    }

    public float getToolCombatDamage(ItemStack aStack) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return 0.0f;
        }
        return tStats.getBaseDamage() + (float)MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mToolQuality;
    }

    @Override
    public final boolean doDamageToItem(ItemStack aStack, int aVanillaDamage) {
        return this.doDamage(aStack, (long)aVanillaDamage * 100L);
    }

    public final boolean doDamage(ItemStack aStack, long aAmount) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        Long[] tElectric = this.getElectricStats(aStack);
        if (tElectric == null) {
            IToolStats tStats;
            long tNewDamage = MetaGeneratedTool.getToolDamage(aStack) + aAmount;
            MetaGeneratedTool.setToolDamage(aStack, tNewDamage);
            if (tNewDamage >= MetaGeneratedTool.getToolMaxDamage(aStack) && ((tStats = this.getToolStats(aStack)) == null || GTUtility.setStack(aStack, tStats.getBrokenItem(aStack)) == null)) {
                if (tStats != null) {
                    GTUtility.doSoundAtClient(tStats.getBreakingSound(), 1, 1.0f);
                }
                if (aStack.field_77994_a > 0) {
                    --aStack.field_77994_a;
                }
            }
            return true;
        }
        if (this.use(aStack, (int)aAmount, null)) {
            if (ThreadLocalRandom.current().nextInt(0, 25) == 0) {
                IToolStats tStats;
                long tNewDamage = MetaGeneratedTool.getToolDamage(aStack) + aAmount;
                MetaGeneratedTool.setToolDamage(aStack, tNewDamage);
                if (tNewDamage >= MetaGeneratedTool.getToolMaxDamage(aStack) && ((tStats = this.getToolStats(aStack)) == null || GTUtility.setStack(aStack, tStats.getBrokenItem(aStack)) == null)) {
                    if (tStats != null) {
                        GTUtility.doSoundAtClient(tStats.getBreakingSound(), 1, 1.0f);
                    }
                    if (aStack.field_77994_a > 0) {
                        --aStack.field_77994_a;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public float getDigSpeed(ItemStack aStack, Block aBlock, int aMetaData) {
        if (!this.isItemStackUsable(aStack)) {
            return 0.0f;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null || Math.max(0, this.getHarvestLevel(aStack, "")) < aBlock.getHarvestLevel(aMetaData)) {
            return 0.0f;
        }
        return tStats.isMinableBlock(aBlock, (byte)aMetaData) ? Math.max(Float.MIN_NORMAL, tStats.getSpeedMultiplier() * MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed) : 0.0f;
    }

    public final boolean canHarvestBlock(Block aBlock, ItemStack aStack) {
        return this.getDigSpeed(aStack, aBlock, 0) > 0.0f;
    }

    public final int getHarvestLevel(ItemStack aStack, String aToolClass) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats == null ? -1 : tStats.getBaseQuality() + MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mToolQuality;
    }

    public boolean func_150894_a(ItemStack aStack, World aWorld, Block aBlock, int aX, int aY, int aZ, EntityLivingBase aPlayer) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats == null) {
            return false;
        }
        GTUtility.doSoundAtClient(tStats.getMiningSound(), 1, 1.0f);
        this.doDamage(aStack, (int)Math.max(1.0f, aBlock.func_149712_f(aWorld, aX, aY, aZ) * (float)tStats.getToolDamagePerBlockBreak()));
        return this.getDigSpeed(aStack, aBlock, aWorld.func_72805_g(aX, aY, aZ)) > 0.0f;
    }

    @Override
    public final ItemStack getContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack, true);
    }

    @Override
    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack, false) != null;
    }

    private ItemStack getContainerItem(ItemStack aStack, boolean playSound) {
        if (!this.isItemStackUsable(aStack)) {
            return null;
        }
        IToolStats tStats = this.getToolStats(aStack = GTUtility.copyAmount(1, aStack));
        if (tStats == null) {
            return null;
        }
        this.doDamage(aStack, tStats.getToolDamagePerContainerCraft());
        Object object = aStack = aStack.field_77994_a > 0 ? aStack : null;
        if (playSound && GTMod.gregtechproxy.mTicksUntilNextCraftSound <= 0) {
            GTMod.gregtechproxy.mTicksUntilNextCraftSound = 10;
            String sound = aStack == null ? tStats.getBreakingSound() : tStats.getCraftingSound();
            GTUtility.doSoundAtClient(sound, 1, 1.0f);
        }
        return aStack;
    }

    public IToolStats getToolStats(ItemStack aStack) {
        this.isItemStackUsable(aStack);
        return this.getToolStatsInternal(aStack);
    }

    public byte getToolMaxMode(ItemStack aStack) {
        IToolStats stats = this.getToolStats(aStack);
        if (stats != null) {
            return stats.getMaxMode();
        }
        return 1;
    }

    private IToolStats getToolStatsInternal(ItemStack aStack) {
        return aStack == null ? null : this.mToolStats.get((short)aStack.func_77960_j());
    }

    public float getSaplingModifier(ItemStack aStack, World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isGrafter() ? Math.min(100.0f, (float)(1 + this.getHarvestLevel(aStack, "")) * 20.0f) : 0.0f;
    }

    public boolean canWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onWhack(EntityPlayer aPlayer, ItemStack aStack, int aX, int aY, int aZ) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        if (player == null) {
            return false;
        }
        return this.canWrench(player.func_70694_bm(), player, x, y, z);
    }

    public boolean canWrench(ItemStack wrench, EntityPlayer player, int x, int y, int z) {
        if (wrench == null) {
            return false;
        }
        if (!this.isItemStackUsable(wrench)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(player.func_71045_bC());
        return tStats != null && tStats.isWrench();
    }

    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        if (player == null) {
            return;
        }
        if (player.func_71045_bC() == null) {
            return;
        }
        IToolStats tStats = this.getToolStats(player.func_71045_bC());
        if (tStats != null) {
            this.doDamage(player.func_71045_bC(), tStats.getToolDamagePerEntityAttack());
        }
    }

    public boolean canUse(ItemStack stack, EntityPlayer player, int x, int y, int z) {
        return this.canWrench(player, x, y, z);
    }

    public boolean canUse(EntityPlayer player, ItemStack stack) {
        if (player == null) {
            return false;
        }
        if (GTUtility.isStackInvalid(stack) || !this.isItemStackUsable(stack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(stack);
        return tStats != null && tStats.isScrewdriver();
    }

    public void damageScrewdriver(EntityPlayer player, ItemStack stack) {
        if (player == null) {
            return;
        }
        if (GTUtility.isStackInvalid(stack) || !this.isItemStackUsable(stack)) {
            return;
        }
        IToolStats tStats = this.getToolStats(stack);
        if (tStats != null) {
            this.doDamage(stack, tStats.getToolDamagePerEntityAttack());
        }
    }

    public void used(ItemStack stack, EntityPlayer player, int x, int y, int z) {
        this.wrenchUsed(player, x, y, z);
    }

    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (player.func_71045_bC() == null) {
            return false;
        }
        if (!this.isItemStackUsable(player.func_71045_bC())) {
            return false;
        }
        IToolStats tStats = this.getToolStats(player.func_71045_bC());
        return tStats.isWrench();
    }

    public boolean canLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onLink(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    public boolean canBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        if (!this.isItemStackUsable(aStack)) {
            return false;
        }
        IToolStats tStats = this.getToolStats(aStack);
        return tStats != null && tStats.isCrowbar();
    }

    public void onBoost(EntityPlayer aPlayer, ItemStack aStack, EntityMinecart cart) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null) {
            this.doDamage(aStack, tStats.getToolDamagePerEntityAttack());
        }
    }

    @Override
    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        IToolStats tStats = this.getToolStats(aStack);
        if (tStats != null && aPlayer != null) {
            tStats.onToolCrafted(aStack, aPlayer);
        }
        super.func_77622_d(aStack, aWorld, aPlayer);
    }

    public final boolean func_77630_h(ItemStack aStack) {
        return false;
    }

    @Override
    public final int getItemStackLimit(ItemStack aStack) {
        return 1;
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean isItemStackUsable(ItemStack aStack) {
        IToolStats tStats = this.getToolStatsInternal(aStack);
        if (aStack.func_77960_j() % 2 != 0 || tStats == null) {
            NBTTagCompound aNBT = aStack.func_77978_p();
            if (aNBT != null) {
                aNBT.func_82580_o("ench");
            }
            return false;
        }
        Materials aMaterial = MetaGeneratedTool.getPrimaryMaterial(aStack);
        HashMap<Integer, Integer> tMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> tResult = new HashMap<Integer, Integer>();
        if (aMaterial.mEnchantmentTools != null) {
            tMap.put(aMaterial.mEnchantmentTools.field_77352_x, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            if (aMaterial.mEnchantmentTools == Enchantment.field_77346_s) {
                tMap.put(Enchantment.field_77335_o.field_77352_x, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
            if (aMaterial.mEnchantmentTools == Enchantment.field_77337_m) {
                tMap.put(Enchantment.field_77345_t.field_77352_x, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
            if (aMaterial.mEnchantmentTools == Enchantment.field_77334_n) {
                tMap.put(Enchantment.field_77343_v.field_77352_x, Integer.valueOf(aMaterial.mEnchantmentToolsLevel));
            }
        }
        Enchantment[] tEnchants = tStats.getEnchantments(aStack);
        int[] tLevels = tStats.getEnchantmentLevels(aStack);
        for (int i = 0; i < tEnchants.length; ++i) {
            if (tLevels[i] <= 0) continue;
            Integer tLevel = (Integer)tMap.get(tEnchants[i].field_77352_x);
            tMap.put(tEnchants[i].field_77352_x, tLevel == null ? tLevels[i] : (tLevel == tLevels[i] ? tLevel + 1 : Math.max(tLevel, tLevels[i])));
        }
        for (Map.Entry tEntry : tMap.entrySet()) {
            if ((Integer)tEntry.getKey() == 33 || (Integer)tEntry.getKey() == 20 && (Integer)tEntry.getValue() > 2 || (Integer)tEntry.getKey() == EnchantmentRadioactivity.INSTANCE.field_77352_x) {
                tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                continue;
            }
            switch (Enchantment.field_77331_b[((Integer)tEntry.getKey()).intValue()].field_77351_y) {
                case weapon: {
                    if (!tStats.isWeapon()) break;
                    tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                    break;
                }
                case all: {
                    tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                    break;
                }
                case armor: 
                case armor_feet: 
                case armor_head: 
                case armor_legs: 
                case armor_torso: {
                    break;
                }
                case bow: {
                    if (!tStats.isRangedWeapon()) break;
                    tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                    break;
                }
                case breakable: {
                    break;
                }
                case fishing_rod: {
                    break;
                }
                case digger: {
                    if (!tStats.isMiningTool()) break;
                    tResult.put((Integer)tEntry.getKey(), (Integer)tEntry.getValue());
                }
            }
        }
        EnchantmentHelper.func_82782_a(tResult, (ItemStack)aStack);
        return true;
    }

    public String func_77653_i(ItemStack aStack) {
        String result = super.func_77653_i(aStack);
        IToolStats toolStats = this.getToolStats(aStack);
        if (toolStats != null) {
            String toolName = toolStats.getToolTypeName();
            if (toolName == null) {
                return result;
            }
            String key = "gt." + toolName + ".mode." + MetaGeneratedTool.getToolMode(aStack);
            if (StatCollector.func_94522_b((String)key)) {
                result = result + " (" + StatCollector.func_74838_a((String)key) + ")";
            }
        }
        return result;
    }

    @Override
    public short getChargedMetaData(ItemStack aStack) {
        return (short)(aStack.func_77960_j() - aStack.func_77960_j() % 2);
    }

    @Override
    public short getEmptyMetaData(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            aNBT.func_82580_o("ench");
        }
        return (short)(aStack.func_77960_j() + 1 - aStack.func_77960_j() % 2);
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }
}

