/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.google.common.math.LongMath;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.InventoryType;
import gregtech.api.enums.Textures;
import gregtech.api.fluid.GTFluidTank;
import gregtech.api.gui.GUIHost;
import gregtech.api.gui.GUIProvider;
import gregtech.api.interfaces.ITexture;
import gregtech.api.logic.FluidInventoryLogic;
import gregtech.api.logic.ItemInventoryLogic;
import gregtech.api.logic.NullPowerLogic;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.WeakTargetRef;
import gregtech.api.multitileentity.base.NonTickableMultiTileEntity;
import gregtech.api.multitileentity.enums.MultiTileCasingPurpose;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.interfaces.IMultiBlockPart;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverInfo;
import gregtech.common.gui.PartGUIProvider;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class MultiBlockPart
extends NonTickableMultiTileEntity
implements IMultiBlockPart,
PowerLogicHost,
GUIHost {
    public static final int NOTHING = 0;
    public static final int ENERGY_IN = GTValues.B[0];
    public static final int ENERGY_OUT = GTValues.B[1];
    public static final int FLUID_IN = GTValues.B[2];
    public static final int FLUID_OUT = GTValues.B[3];
    public static final int ITEM_IN = GTValues.B[4];
    public static final int ITEM_OUT = GTValues.B[5];
    protected final List<Integer> BASIC_MODES = new ArrayList<Integer>(Arrays.asList(0, ENERGY_IN, ENERGY_OUT, FLUID_IN, FLUID_OUT, ITEM_IN, ITEM_OUT));
    protected Set<MultiTileCasingPurpose> registeredPurposes = new HashSet<MultiTileCasingPurpose>();
    protected final WeakTargetRef<IMultiBlockController> controller = new WeakTargetRef<Class<IMultiBlockController>>(IMultiBlockController.class, false);
    protected int allowedModes = 0;
    protected int mode = 0;
    protected UUID lockedInventory;
    protected int mLockedInventoryIndex = 0;
    protected GTFluidTank configurationTank = new GTFluidTank();
    @Nonnull
    protected final GUIProvider<?> guiProvider = this.createGUIProvider();

    public int getPartTier() {
        return 1;
    }

    @Override
    public UUID getLockedInventory() {
        return this.lockedInventory;
    }

    public void setTarget(IMultiBlockController newController, int aAllowedModes) {
        IMultiBlockController currentController = this.getTarget(false);
        if (currentController != null && currentController != newController) {
            for (MultiTileCasingPurpose purpose : this.registeredPurposes) {
                this.unregisterPurpose(purpose);
            }
        }
        this.allowedModes = aAllowedModes;
        if (newController != currentController) {
            this.registerCovers(newController);
            this.registerPurposes();
        }
    }

    protected void registerPurpose(MultiTileCasingPurpose purpose) {
        IMultiBlockController target = this.getTarget(false);
        if (target != null) {
            target.registerCaseWithPurpose(purpose, this);
            this.registeredPurposes.add(purpose);
        }
    }

    protected void unregisterPurpose(MultiTileCasingPurpose purpose) {
        IMultiBlockController target = this.getTarget(false);
        if (target != null) {
            target.unregisterCaseWithPurpose(purpose, this);
        }
        this.registeredPurposes.remove((Object)purpose);
    }

    @Override
    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
        IMultiBlockController controller = this.getTarget(false);
        if (controller != null) {
            tList.add("Has controller");
        } else {
            tList.add("No Controller");
        }
        tList.add("Casing Mode: " + this.getModeName(this.mode));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        currentTip.add(String.format("Mode: %s", this.getModeName(this.mode)));
        if (this.modeSelected(FLUID_OUT)) {
            if (this.configurationTank != null && this.configurationTank.get() != null) {
                currentTip.add(String.format("Locked to: %s", this.configurationTank.get().getLocalizedName()));
            } else {
                currentTip.add("Locked to: Nothing");
            }
        }
    }

    public IMultiBlockController getTarget(boolean aCheckValidity) {
        IMultiBlockController res = this.controller.get();
        if (res != null && aCheckValidity) {
            return res.checkStructure(false) ? res : null;
        }
        return res;
    }

    public void registerCovers(IMultiBlockController controller) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.isValid() || coverInfo.getTickRate() <= 0) continue;
            controller.registerCoveredPartOnSide(side, this);
        }
    }

    protected void registerPurposes() {
        for (MultiTileCasingPurpose purpose : this.registeredPurposes) {
            this.registerPurpose(purpose);
        }
    }

    @Override
    public void setCoverItemAtSide(ForgeDirection side, ItemStack aCover) {
        super.setCoverItemAtSide(side, aCover);
        IMultiBlockController tTarget = this.getTarget(true);
        if (tTarget == null) {
            return;
        }
        CoverInfo coverInfo = this.getCoverInfoAtSide(side);
        if (coverInfo.isValid() && coverInfo.getTickRate() > 0) {
            tTarget.registerCoveredPartOnSide(side, this);
        }
    }

    public void unregisterCovers(IMultiBlockController controller) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.getCoverInfoAtSide(side).isValid()) continue;
            controller.unregisterCoveredPartOnSide(side, this);
        }
    }

    @Override
    public boolean dropCover(ForgeDirection side, ForgeDirection droppedSide, boolean aForced) {
        boolean res = super.dropCover(side, droppedSide, aForced);
        IMultiBlockController tTarget = this.getTarget(true);
        if (tTarget != null) {
            tTarget.unregisterCoveredPartOnSide(side, this);
        }
        return res;
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("gt.amode")) {
            this.allowedModes = aNBT.func_74762_e("gt.amode");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.setMode(aNBT.func_74771_c("gt.mode"));
        }
        if (aNBT.func_74764_b("gt.target")) {
            this.controller.setPosition(aNBT.func_74762_e("gt.target.x"), aNBT.func_74765_d("gt.target.y"), aNBT.func_74762_e("gt.target.z"));
            this.controller.setWorld(this.field_145850_b);
        }
        if (aNBT.func_74764_b("gt.locked.inv")) {
            this.lockedInventory = UUID.fromString(aNBT.func_74779_i("gt.locked.inv"));
        }
        if (aNBT.func_74764_b("gt.locked.inv.index")) {
            this.mLockedInventoryIndex = aNBT.func_74762_e("gt.locked.inv.index");
        }
        if (aNBT.func_74764_b("gt.locked.fluid")) {
            this.configurationTank.readFromNBT(aNBT, "gt.locked.fluid");
        }
        if (this.modeSelected(ITEM_OUT)) {
            this.registeredPurposes.add(MultiTileCasingPurpose.ItemOutput);
        }
        if (this.modeSelected(FLUID_OUT)) {
            this.registeredPurposes.add(MultiTileCasingPurpose.FluidOutput);
        }
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        if (this.allowedModes != 0) {
            nbt.func_74768_a("gt.amode", this.allowedModes);
        }
        if (this.mode != 0) {
            nbt.func_74768_a("gt.mode", this.mode);
        }
        ChunkCoordinates pos = this.controller.getPosition();
        if (pos.field_71572_b >= 0) {
            nbt.func_74757_a("gt.target", true);
            nbt.func_74768_a("gt.target.x", pos.field_71574_a);
            nbt.func_74777_a("gt.target.y", (short)pos.field_71572_b);
            nbt.func_74768_a("gt.target.z", pos.field_71573_c);
        }
        if (this.lockedInventory != null) {
            nbt.func_74778_a("gt.locked.inv", this.lockedInventory.toString());
        }
        if (this.mLockedInventoryIndex != 0) {
            nbt.func_74768_a("gt.locked.inv.index", this.mLockedInventoryIndex);
        }
        this.configurationTank.writeToNBT(nbt, "gt.locked.fluid");
    }

    @Override
    public void setLockedInventoryIndex(int index) {
        this.mLockedInventoryIndex = index;
    }

    @Override
    public int getLockedInventoryIndex() {
        return this.mLockedInventoryIndex;
    }

    @Override
    public ChunkCoordinates getTargetPos() {
        return this.controller.getPosition();
    }

    @Override
    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        if (this.modeSelected(FLUID_OUT)) {
            this.unregisterPurpose(MultiTileCasingPurpose.FluidOutput);
        }
        if (this.modeSelected(ITEM_OUT)) {
            this.unregisterPurpose(MultiTileCasingPurpose.ItemOutput);
        }
        this.mode = mode;
        if (this.modeSelected(FLUID_OUT)) {
            this.registerPurpose(MultiTileCasingPurpose.FluidOutput);
        }
        if (this.modeSelected(ITEM_OUT)) {
            this.registerPurpose(MultiTileCasingPurpose.ItemOutput);
        }
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public int getAllowedModes() {
        return this.allowedModes;
    }

    @Override
    public void setAllowedModes(int aAllowedModes) {
        this.allowedModes = aAllowedModes;
    }

    public boolean hasMode(int mode) {
        return (this.allowedModes & mode) != 0;
    }

    public boolean modeSelected(int ... modes) {
        for (int mode : modes) {
            if (!this.hasMode(mode) || this.mode != this.getModeOrdinal(mode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockBroken() {
        IMultiBlockController tTarget = this.getTarget(false);
        if (tTarget != null) {
            this.unregisterCovers(tTarget);
            tTarget.onStructureChange();
        }
        return false;
    }

    @Override
    public void onBlockAdded() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.getTileEntityAtSide(side);
            if (te instanceof MultiBlockPart) {
                MultiBlockPart part = (MultiBlockPart)te;
                IMultiBlockController tController = part.getTarget(false);
                if (tController == null) continue;
                tController.onStructureChange();
                continue;
            }
            if (!(te instanceof IMultiBlockController)) continue;
            IMultiBlockController controller = (IMultiBlockController)te;
            controller.onStructureChange();
        }
    }

    @Override
    public ITexture getTexture(ForgeDirection side) {
        ITexture texture = super.getTexture(side);
        if (this.mode != 0 && side == this.facing) {
            if (this.mode == this.getModeOrdinal(ITEM_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(ITEM_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.ITEM_OUT_SIGN), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(FLUID_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of(Textures.BlockIcons.FLUID_IN_SIGN), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(FLUID_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.FLUID_OUT_SIGN), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(ENERGY_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ENERGY_IN_MULTI), this.getCoverTexture(side));
            }
            if (this.mode == this.getModeOrdinal(ENERGY_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ENERGY_OUT_MULTI), this.getCoverTexture(side));
            }
        }
        return TextureFactory.of(texture, this.getCoverTexture(side));
    }

    protected String getModeName(int aMode) {
        if (aMode == 0) {
            return "Nothing";
        }
        if (aMode == this.getModeOrdinal(ITEM_IN)) {
            return "Item Input";
        }
        if (aMode == this.getModeOrdinal(ITEM_OUT)) {
            return "Item Output";
        }
        if (aMode == this.getModeOrdinal(FLUID_IN)) {
            return "Fluid Input";
        }
        if (aMode == this.getModeOrdinal(FLUID_OUT)) {
            return "Fluid Output";
        }
        if (aMode == this.getModeOrdinal(ENERGY_IN)) {
            return "Energy Input";
        }
        if (aMode == this.getModeOrdinal(ENERGY_OUT)) {
            return "Energy Output";
        }
        return "Unknown";
    }

    protected byte getModeOrdinal(int aMode) {
        return (byte)(LongMath.log2((long)aMode, (RoundingMode)RoundingMode.UNNECESSARY) + 1);
    }

    protected byte getNextAllowedMode(List<Integer> allowedModes) {
        if (this.allowedModes == 0) {
            return 0;
        }
        int numModes = allowedModes.size();
        for (int i = 1; i <= numModes; i = (int)((byte)(i + 1))) {
            byte curMode = (byte)((this.mode + i) % numModes);
            if (curMode != 0 && !this.hasMode(1 << curMode - 1)) continue;
            return curMode;
        }
        return 0;
    }

    @Override
    public boolean onMalletRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        if (this.allowedModes == 0) {
            return true;
        }
        if (this.mode == 0) {
            this.facing = wrenchSide;
        }
        this.setMode(this.getNextAllowedMode(this.BASIC_MODES));
        if (aPlayer.func_70093_af()) {
            this.facing = wrenchSide;
        }
        GTUtility.sendChatToPlayer(aPlayer, "Mode set to `" + this.getModeName(this.mode) + "' (" + this.mode + ")");
        this.sendClientData((EntityPlayerMP)aPlayer);
        return true;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.part";
    }

    @Override
    public boolean shouldTick(long tickTimer) {
        return this.modeSelected(ITEM_OUT, FLUID_OUT);
    }

    @Override
    @Nullable
    public FluidInventoryLogic getFluidLogic(@Nonnull ForgeDirection side, @Nonnull InventoryType type) {
        if (side != this.facing && side != ForgeDirection.UNKNOWN) {
            return null;
        }
        if (!this.modeSelected(FLUID_IN, FLUID_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return null;
        }
        return controller.getFluidLogic(this.modeSelected(FLUID_IN) ? InventoryType.Input : InventoryType.Output, this.lockedInventory);
    }

    @Override
    @Nonnull
    public PowerLogic getPowerLogic(@Nonnull ForgeDirection side) {
        if (side != this.facing && side != ForgeDirection.UNKNOWN) {
            return new NullPowerLogic();
        }
        if (!this.modeSelected(ENERGY_IN, ENERGY_OUT)) {
            return new NullPowerLogic();
        }
        IMultiBlockController controller = this.getTarget(true);
        if (controller == null) {
            return new NullPowerLogic();
        }
        return controller.getPowerLogic();
    }

    @Override
    public boolean isEnetInput() {
        return this.modeSelected(ENERGY_IN);
    }

    @Override
    public boolean isEnetOutput() {
        return this.modeSelected(ENERGY_OUT);
    }

    @Override
    @Nullable
    public ItemInventoryLogic getItemLogic(@Nonnull ForgeDirection side, @Nonnull InventoryType unused) {
        if (side != this.facing && side != ForgeDirection.UNKNOWN) {
            return null;
        }
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return null;
        }
        return controller.getItemLogic(this.modeSelected(ITEM_IN) ? InventoryType.Input : InventoryType.Output, this.lockedInventory);
    }

    @Override
    @Nullable
    public InventoryType getItemInventoryType() {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return InventoryType.Both;
        }
        return this.modeSelected(ITEM_IN) ? InventoryType.Input : InventoryType.Output;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public String getLocalName() {
        if (this.modeSelected(ITEM_IN)) {
            return "Input Inventory";
        }
        if (this.modeSelected(ITEM_OUT)) {
            return "Output Inventory";
        }
        if (this.modeSelected(FLUID_IN)) {
            return "Fluid Input Hatch";
        }
        if (this.modeSelected(FLUID_OUT)) {
            return "Fluid Output Hatch";
        }
        return "Unknown";
    }

    @Override
    public boolean hasGui(ForgeDirection side) {
        if (this.modeSelected(ENERGY_IN, ENERGY_OUT) && this.facing == side) {
            return false;
        }
        return this.getTarget(true) != null;
    }

    protected boolean isWrongFluid(Fluid fluid) {
        if (fluid == null) {
            return true;
        }
        Fluid lockedFluid = this.getLockedFluid();
        if (lockedFluid != null) {
            return !fluid.equals(lockedFluid);
        }
        return false;
    }

    protected Fluid getLockedFluid() {
        if (this.configurationTank.get() != null && this.configurationTank.get().getFluid() != null) {
            return this.configurationTank.get().getFluid();
        }
        return null;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return;
        }
        if (this.modeSelected(ITEM_IN, ITEM_OUT)) {
            builder.widget(controller.getItemLogic(this.modeSelected(ITEM_IN) ? InventoryType.Input : InventoryType.Output, this.lockedInventory).getGuiPart().setSize(76, 90).setPos(52, 7));
        }
        if (this.modeSelected(FLUID_IN, FLUID_OUT)) {
            builder.widget(controller.getFluidLogic(this.modeSelected(FLUID_IN) ? InventoryType.Input : InventoryType.Output, this.lockedInventory).getGuiPart().setSize(76, 90).setPos(52, 7));
        }
    }

    protected boolean canOpenControllerGui() {
        return true;
    }

    @Override
    protected int getGUIHeight() {
        return super.getGUIHeight() + 20;
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        if (this.modeSelected(ITEM_IN, ITEM_OUT)) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 74));
        } else if (this.modeSelected(FLUID_IN, FLUID_OUT)) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 82));
        } else {
            super.addGregTechLogo(builder);
        }
    }

    @Override
    public void addToolTips(List<String> list, ItemStack stack, boolean f3_h) {
        list.add("A MultiTileEntity Casing");
    }

    @Override
    public String func_145825_b() {
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return "";
        }
        if (this.modeSelected(ITEM_IN, ITEM_OUT)) {
            InventoryType type = this.modeSelected(ITEM_IN) ? InventoryType.Input : InventoryType.Output;
            ItemInventoryLogic itemLogic = controller.getItemLogic(type, this.lockedInventory);
            return itemLogic.getDisplayName();
        }
        if (this.modeSelected(FLUID_IN, FLUID_OUT)) {
            InventoryType type = this.modeSelected(FLUID_IN) ? InventoryType.Input : InventoryType.Output;
            FluidInventoryLogic fluidLogic = controller.getFluidLogic(type, this.lockedInventory);
            return fluidLogic.getDisplayName();
        }
        return "";
    }

    @Override
    @Nonnull
    public ForgeDirection getPowerOutputSide() {
        if (!this.modeSelected(ENERGY_OUT)) {
            return ForgeDirection.UNKNOWN;
        }
        return this.facing;
    }

    @Nonnull
    protected GUIProvider<?> createGUIProvider() {
        return new PartGUIProvider<MultiBlockPart>(this);
    }

    @Override
    @Nonnull
    public GUIProvider<?> getGUI(@Nonnull UIBuildContext uiContext) {
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return this.guiProvider;
        }
        if (!this.modeSelected(0, ENERGY_IN, ENERGY_OUT)) {
            return this.guiProvider;
        }
        if (!this.canOpenControllerGui()) {
            return this.guiProvider;
        }
        if (uiContext.getPlayer().func_70093_af()) {
            return this.guiProvider;
        }
        GUIProvider controllerGUI = controller.getGUI(uiContext);
        return controllerGUI;
    }

    @Override
    public ItemStack getAsItem() {
        return MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID()).getItem(this.getMultiTileEntityID());
    }

    @Override
    public String getMachineName() {
        return StatCollector.func_74838_a((String)this.getAsItem().func_77977_a());
    }
}

