/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacketNew;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.net.data.CasingData;
import gregtech.api.net.data.CommonData;
import gregtech.api.net.data.CoordinateData;
import gregtech.api.net.data.MultiTileEntityData;
import gregtech.api.net.data.MultiTileEntityProcess;
import gregtech.api.net.data.PacketData;
import io.netty.buffer.ByteBuf;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.IBlockAccess;

public class GTPacketMultiTileEntity
extends GTPacketNew {
    private final Set<PacketData<MultiTileEntityProcess>> data = new HashSet<PacketData<MultiTileEntityProcess>>();
    public static final int COVERS = GTValues.B[0];
    public static final int REDSTONE = GTValues.B[1];
    public static final int MODES = GTValues.B[2];
    public static final int CONTROLLER = GTValues.B[3];
    public static final int INVENTORY_INDEX = GTValues.B[4];
    public static final int INVENTORY_NAME_ID = GTValues.B[5];
    public static final int BOOLEANS = GTValues.B[6];
    public static final int SOUND = GTValues.B[7];

    public GTPacketMultiTileEntity(boolean reference) {
        super(reference);
    }

    @Override
    public void encode(ByteBuf aOut) {
        Set set = this.data.stream().sorted().collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        this.clearData();
        this.data.addAll(set);
        int features = 0;
        for (PacketData<MultiTileEntityProcess> data : this.data) {
            features |= 1 << data.getId();
        }
        aOut.writeInt(features);
        for (PacketData<MultiTileEntityProcess> data : this.data) {
            data.encode(aOut);
        }
    }

    @Override
    public GTPacketNew decode(ByteArrayDataInput in) {
        Objects.requireNonNull(in);
        int packetFeatures = in.readInt();
        GTPacketMultiTileEntity packet = new GTPacketMultiTileEntity(false);
        if (GTPacketMultiTileEntity.containsBit(packetFeatures, 0)) {
            packet.addData(new CoordinateData());
        }
        if (GTPacketMultiTileEntity.containsBit(packetFeatures, 1)) {
            packet.addData(new MultiTileEntityData());
        }
        if (GTPacketMultiTileEntity.containsBit(packetFeatures, 2)) {
            packet.addData(new CommonData());
        }
        if (GTPacketMultiTileEntity.containsBit(packetFeatures, 4)) {
            packet.addData(new CasingData());
        }
        Set set = packet.data.stream().sorted().collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        packet.clearData();
        packet.data.addAll(set);
        for (PacketData<MultiTileEntityProcess> data : packet.data) {
            data.decode(in);
        }
        return packet;
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (aWorld == null) {
            return;
        }
        MultiTileEntityProcess process = new MultiTileEntityProcess(aWorld);
        for (PacketData<MultiTileEntityProcess> data : this.data) {
            data.process(process);
        }
        process.process();
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.MULTI_TILE_ENTITY.id;
    }

    public void clearData() {
        this.data.clear();
    }

    public void addData(PacketData<MultiTileEntityProcess> data) {
        this.data.add(data);
    }

    private static boolean containsBit(int toCheck, int bit) {
        return (toCheck & 1 << bit) > 0;
    }
}

