/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import gregtech.api.net.GTPacketBlockEvent;
import gregtech.api.net.GTPacketClientPreference;
import gregtech.api.net.GTPacketInfiniteSpraycan;
import gregtech.api.net.GTPacketMultiTileEntity;
import gregtech.api.net.GTPacketMusicSystemData;
import gregtech.api.net.GTPacketNew;
import gregtech.api.net.GTPacketPollution;
import gregtech.api.net.GTPacketRequestCoverData;
import gregtech.api.net.GTPacketSendCoverData;
import gregtech.api.net.GTPacketSendOregenPattern;
import gregtech.api.net.GTPacketSetConfigurationCircuit;
import gregtech.api.net.GTPacketSound;
import gregtech.api.net.GTPacketTileEntity;
import gregtech.api.net.GTPacketToolSwitchMode;
import gregtech.api.net.GTPacketUpdateItem;
import gregtech.common.blocks.PacketOres;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;

public enum GTPacketTypes {
    TILE_ENTITY(0, new GTPacketTileEntity()),
    SOUND(1, new GTPacketSound()),
    BLOCK_EVENT(2, new GTPacketBlockEvent()),
    ORES(3, new PacketOres()),
    POLLUTION(4, new GTPacketPollution()),
    CLIENT_PREFERENCE(9, new GTPacketClientPreference()),
    SET_CONFIGURATION_CIRCUIT(12, new GTPacketSetConfigurationCircuit()),
    UPDATE_ITEM(13, new GTPacketUpdateItem()),
    SEND_COVER_DATA(16, new GTPacketSendCoverData()),
    REQUEST_COVER_DATA(17, new GTPacketRequestCoverData()),
    MULTI_TILE_ENTITY(18, new GTPacketMultiTileEntity(true)),
    SEND_OREGEN_PATTERN(19, new GTPacketSendOregenPattern()),
    TOOL_SWITCH_MODE(20, new GTPacketToolSwitchMode()),
    MUSIC_SYSTEM_DATA(21, new GTPacketMusicSystemData()),
    INFINITE_SPRAYCAN(22, new GTPacketInfiniteSpraycan());

    public final byte id;
    public final GTPacketNew referencePacket;

    private GTPacketTypes(int id, GTPacketNew referencePacket) {
        if ((byte)id != id) {
            throw new IllegalArgumentException("Value outside of byte normal range: " + id);
        }
        this.id = (byte)id;
        this.referencePacket = referencePacket;
    }

    public static GTPacketNew[] referencePackets() {
        return (GTPacketNew[])Arrays.stream(GTPacketTypes.values()).map(p -> p.referencePacket).toArray(GTPacketNew[]::new);
    }

    static {
        GTPacketTypes[] types = GTPacketTypes.values();
        Int2ObjectOpenHashMap foundIds = new Int2ObjectOpenHashMap(types.length);
        for (GTPacketTypes type : types) {
            GTPacketNew previous = (GTPacketNew)foundIds.get((int)type.id);
            if (previous != null) {
                throw new IllegalStateException("Duplicate packet IDs defined: " + type.id + " for " + ((Object)((Object)type)).getClass() + " and " + previous.getClass());
            }
            foundIds.put((int)type.id, (Object)type.referencePacket);
        }
    }
}

