/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipeRegistrator;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GTOreDictUnificator {
    private static final Map<String, ItemStack> sName2StackMap = new HashMap<String, ItemStack>();
    private static final Map<ItemStack, ItemData> sItemStack2DataMap = new Object2ObjectOpenCustomHashMap(GTItemStack.ITEMSTACK_HASH_STRATEGY2);
    private static final Map<ItemStack, List<ItemStack>> sUnificationTable = new Object2ObjectOpenCustomHashMap(GTItemStack.ITEMSTACK_HASH_STRATEGY2);
    private static final Set<ItemStack> sNoUnificationList = new ObjectOpenCustomHashSet(GTItemStack.ITEMSTACK_HASH_STRATEGY2);
    private static int isRegisteringOre = 0;
    private static int isAddingOre = 0;
    private static boolean mRunThroughTheList = true;

    public static void addToBlacklist(ItemStack aStack) {
        if (GTUtility.isStackValid(aStack) && !GTUtility.isStackInStackSet(aStack, sNoUnificationList)) {
            sNoUnificationList.add(aStack);
        }
    }

    public static boolean isBlacklisted(ItemStack aStack) {
        return GTUtility.isStackInStackSet(aStack, sNoUnificationList);
    }

    public static void add(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack) {
        GTOreDictUnificator.set(aPrefix, aMaterial, aStack, false, false);
    }

    public static void set(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack) {
        GTOreDictUnificator.set(aPrefix, aMaterial, aStack, true, false);
    }

    public static void set(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered) {
        if (aMaterial == null || aPrefix == null || GTUtility.isStackInvalid(aStack) || Items.field_151008_G.getDamage(aStack) == Short.MAX_VALUE) {
            return;
        }
        ++isAddingOre;
        aStack = GTUtility.copyAmount(1, aStack);
        if (!aAlreadyRegistered) {
            GTOreDictUnificator.registerOre(aPrefix.get(aMaterial), aStack);
        }
        GTOreDictUnificator.addAssociation(aPrefix, aMaterial, aStack, GTOreDictUnificator.isBlacklisted(aStack));
        if (aOverwrite || GTUtility.isStackInvalid(sName2StackMap.get(aPrefix.get(aMaterial).toString()))) {
            sName2StackMap.put(aPrefix.get(aMaterial).toString(), aStack);
        }
        --isAddingOre;
    }

    public static ItemStack getFirstOre(Object aName, long aAmount) {
        if (GTUtility.isStringInvalid(aName)) {
            return null;
        }
        ItemStack tStack = sName2StackMap.get(aName.toString());
        if (GTUtility.isStackValid(tStack)) {
            return GTUtility.copyAmount(aAmount, tStack);
        }
        return GTUtility.copyAmount(aAmount, GTOreDictUnificator.getOresImmutable(aName).toArray());
    }

    public static ItemStack get(Object aName, long aAmount) {
        return GTOreDictUnificator.get(aName, null, aAmount, true, true);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount) {
        return GTOreDictUnificator.get(aName, aReplacement, aAmount, true, true);
    }

    public static ItemStack get(OrePrefixes aPrefix, Object aMaterial, long aAmount) {
        return GTOreDictUnificator.get(aPrefix, aMaterial, null, aAmount);
    }

    public static ItemStack get(OrePrefixes aPrefix, Object aMaterial, ItemStack aReplacement, long aAmount) {
        if (OrePrefixes.mPreventableComponents.contains((Object)aPrefix) && aPrefix.mDisabledItems.contains(aMaterial)) {
            return aReplacement;
        }
        return GTOreDictUnificator.get(aPrefix.get(aMaterial), aReplacement, aAmount, false, true);
    }

    public static ItemStack get(OrePrefixes aPrefix, Object aMaterial, long aAmount, boolean aNoInvalidAmounts) {
        if (OrePrefixes.mPreventableComponents.contains((Object)aPrefix) && aPrefix.mDisabledItems.contains(aMaterial)) {
            return null;
        }
        return GTOreDictUnificator.get(aPrefix.get(aMaterial), null, aAmount, false, aNoInvalidAmounts);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount, boolean aMentionPossibleTypos, boolean aNoInvalidAmounts) {
        ItemStack stackFirstOre;
        if (aNoInvalidAmounts && aAmount < 1L) {
            return null;
        }
        ItemStack stackFromName = sName2StackMap.get(aName.toString());
        if (stackFromName != null) {
            return GTUtility.copyAmount(aAmount, stackFromName);
        }
        if (aMentionPossibleTypos) {
            GTLog.err.println("Unknown Key for Unification, Typo? " + aName);
        }
        if ((stackFirstOre = GTOreDictUnificator.getFirstOre(aName, aAmount)) != null) {
            return GTUtility.copyAmount(aAmount, stackFirstOre);
        }
        return GTUtility.copyAmount(aAmount, aReplacement);
    }

    public static ItemStack[] setStackArray(boolean aUseBlackList, ItemStack ... aStacks) {
        return GTOreDictUnificator.setStackArray(aUseBlackList, false, aStacks);
    }

    public static ItemStack[] setStackArray(boolean aUseBlackList, boolean aUnsafe, ItemStack ... aStacks) {
        for (int i = 0; i < aStacks.length; ++i) {
            aStacks[i] = GTOreDictUnificator.get(aUseBlackList, GTUtility.copyOrNull(aStacks[i]), aUnsafe);
        }
        return aStacks;
    }

    public static ItemStack[] getStackArray(boolean aUseBlackList, Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = GTOreDictUnificator.get(aUseBlackList, GTUtility.copy(aStacks[i]), true);
        }
        return rStacks;
    }

    public static ItemStack setStack(ItemStack aStack) {
        return GTOreDictUnificator.setStack(true, aStack);
    }

    public static ItemStack setStack(boolean aUseBlackList, ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return aStack;
        }
        ItemStack tStack = GTOreDictUnificator.get(aUseBlackList, aStack);
        if (GTUtility.areStacksEqual(aStack, tStack)) {
            return aStack;
        }
        aStack.func_150996_a(tStack.func_77973_b());
        Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(tStack));
        return aStack;
    }

    public static ItemStack get(ItemStack aStack) {
        return GTOreDictUnificator.get(true, aStack);
    }

    public static ItemStack get(boolean aUseBlackList, ItemStack aStack) {
        return GTOreDictUnificator.get(aUseBlackList, aStack, false);
    }

    public static ItemStack get(boolean aUseBlackList, ItemStack aStack, boolean unsafe) {
        ItemStack rStack;
        if (GTUtility.isStackInvalid(aStack)) {
            return null;
        }
        ItemData tPrefixMaterial = GTOreDictUnificator.getAssociation(aStack);
        if (tPrefixMaterial == null || !tPrefixMaterial.hasValidPrefixMaterialData() || aUseBlackList && tPrefixMaterial.mBlackListed) {
            return GTUtility.copyOrNull(aStack);
        }
        if (aUseBlackList && !GregTechAPI.sUnificationEntriesRegistered && GTOreDictUnificator.isBlacklisted(aStack)) {
            tPrefixMaterial.mBlackListed = true;
            return GTUtility.copyOrNull(aStack);
        }
        if (tPrefixMaterial.mUnificationTarget == null) {
            tPrefixMaterial.mUnificationTarget = sName2StackMap.get(tPrefixMaterial.toString());
        }
        if (GTUtility.isStackInvalid(rStack = tPrefixMaterial.mUnificationTarget)) {
            return GTUtility.copyOrNull(aStack);
        }
        ItemStack newStack = unsafe ? GTUtility.copyAmountUnsafe(aStack.field_77994_a, rStack) : GTUtility.copyAmount(aStack.field_77994_a, rStack);
        newStack.func_77982_d(aStack.func_77978_p());
        return newStack;
    }

    public static ItemStack get_nocopy(ItemStack aStack) {
        return GTOreDictUnificator.get_nocopy(true, aStack);
    }

    static ItemStack get_nocopy(boolean aUseBlackList, ItemStack aStack) {
        ItemStack rStack;
        if (GTUtility.isStackInvalid(aStack)) {
            return null;
        }
        ItemData tPrefixMaterial = GTOreDictUnificator.getAssociation(aStack);
        if (tPrefixMaterial == null || !tPrefixMaterial.hasValidPrefixMaterialData() || aUseBlackList && tPrefixMaterial.mBlackListed) {
            return aStack;
        }
        if (aUseBlackList && !GregTechAPI.sUnificationEntriesRegistered && GTOreDictUnificator.isBlacklisted(aStack)) {
            tPrefixMaterial.mBlackListed = true;
            return aStack;
        }
        if (tPrefixMaterial.mUnificationTarget == null) {
            tPrefixMaterial.mUnificationTarget = sName2StackMap.get(tPrefixMaterial.toString());
        }
        if (GTUtility.isStackInvalid(rStack = tPrefixMaterial.mUnificationTarget)) {
            return aStack;
        }
        if (aStack.func_77978_p() == rStack.func_77978_p()) {
            return rStack;
        }
        ItemStack newStack = new ItemStack(rStack.func_77973_b(), aStack.field_77994_a, Items.field_151008_G.getDamage(rStack));
        newStack.func_77982_d(aStack.func_77978_p());
        return newStack;
    }

    public static boolean isInputStackEqual(ItemStack aStack, ItemStack unified_tStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        return GTOreDictUnificator.isInputStackEqual(aStack, GTOreDictUnificator.getAssociation(aStack), unified_tStack);
    }

    public static boolean isInputStackEqual(ItemStack aStack, ItemData aStackPrefixData, ItemStack unified_tStack) {
        boolean alreadyCompared = false;
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        ItemStack rStack = null;
        if (aStackPrefixData == null || !aStackPrefixData.hasValidPrefixMaterialData()) {
            return GTUtility.areStacksEqual(aStack, unified_tStack, true);
        }
        if (aStackPrefixData.mBlackListed) {
            if (GTUtility.areStacksEqual(aStack, unified_tStack, true)) {
                return true;
            }
            alreadyCompared = true;
        }
        if (!alreadyCompared && !GregTechAPI.sUnificationEntriesRegistered && GTOreDictUnificator.isBlacklisted(aStack)) {
            aStackPrefixData.mBlackListed = true;
            if (GTUtility.areStacksEqual(aStack, unified_tStack, true)) {
                return true;
            }
            alreadyCompared = true;
        }
        if (aStackPrefixData.mUnificationTarget == null) {
            aStackPrefixData.mUnificationTarget = sName2StackMap.get(aStackPrefixData.toString());
        }
        if (GTUtility.isStackInvalid(rStack = aStackPrefixData.mUnificationTarget)) {
            return !alreadyCompared && GTUtility.areStacksEqual(aStack, unified_tStack, true);
        }
        return GTUtility.areStacksEqual(rStack, unified_tStack, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ItemStack> getNonUnifiedStacks(Object obj) {
        if (sUnificationTable.isEmpty() && !sItemStack2DataMap.isEmpty()) {
            Map<ItemStack, List<ItemStack>> map = sUnificationTable;
            synchronized (map) {
                if (sUnificationTable.isEmpty() && !sItemStack2DataMap.isEmpty()) {
                    for (ItemStack tGTStack0 : sItemStack2DataMap.keySet()) {
                        ItemStack tStack1;
                        ItemStack tStack0 = GTItemStack.internalCopyStack(tGTStack0);
                        if (GTUtility.areStacksEqual(tStack0, tStack1 = GTOreDictUnificator.get_nocopy(false, tStack0))) continue;
                        List list = sUnificationTable.computeIfAbsent(tStack1, k -> new ArrayList());
                        list.add(tStack0);
                    }
                }
            }
        }
        ItemStack[] aStacks = new ItemStack[]{};
        if (obj instanceof ItemStack) {
            aStacks = new ItemStack[]{(ItemStack)obj};
        } else if (obj instanceof ItemStack[]) {
            aStacks = (ItemStack[])obj;
        } else if (obj instanceof List) {
            aStacks = ((List)obj).toArray(new ItemStack[0]);
        }
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (ItemStack aStack : aStacks) {
            if (aStack == null) continue;
            rList.add(aStack);
            List<ItemStack> tList = sUnificationTable.get(aStack);
            if (tList == null) continue;
            for (ItemStack tStack : tList) {
                ItemStack tStack1 = GTUtility.copyAmountUnsafe(aStack.field_77994_a, tStack);
                rList.add(tStack1);
            }
        }
        return rList;
    }

    public static void addItemData(ItemStack aStack, ItemData aData) {
        if (GTUtility.isStackValid(aStack) && GTOreDictUnificator.getItemData(aStack) == null && aData != null) {
            GTOreDictUnificator.setItemData(aStack, aData);
        }
    }

    public static void addItemDataFromInputs(ItemStack output, Object ... inputs) {
        int length = inputs.length;
        ItemData[] tData = new ItemData[length];
        for (int i = 0; i < length; ++i) {
            if (inputs[i] instanceof ItemStack) {
                tData[i] = GTOreDictUnificator.getItemData((ItemStack)inputs[i]);
                continue;
            }
            if (inputs[i] instanceof ItemData) {
                tData[i] = (ItemData)inputs[i];
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (GTUtility.arrayContainsNonNull(tData)) {
            GTOreDictUnificator.addItemData(output, new ItemData(tData));
        }
    }

    public static void setItemData(ItemStack aStack, ItemData aData) {
        block13: {
            ItemData tData;
            block11: {
                block12: {
                    if (GTUtility.isStackInvalid(aStack) || aData == null) {
                        return;
                    }
                    tData = GTOreDictUnificator.getItemData(aStack);
                    if (tData != null && tData.hasValidPrefixMaterialData()) break block11;
                    if (tData != null) {
                        for (Object tObject : tData.mExtraData) {
                            if (aData.mExtraData.contains(tObject)) continue;
                            aData.mExtraData.add(tObject);
                        }
                    }
                    if (aStack.field_77994_a > 1) {
                        if (aData.mMaterial != null) {
                            aData.mMaterial.mAmount /= (long)aStack.field_77994_a;
                        }
                        for (MaterialStack tMaterial : aData.mByProducts) {
                            tMaterial.mAmount /= (long)aStack.field_77994_a;
                        }
                        aStack = GTUtility.copyAmount(1, aStack);
                    }
                    sItemStack2DataMap.put(aStack, aData);
                    if (aData.hasValidMaterialData()) {
                        long tValidMaterialAmount = aData.mMaterial.mMaterial.contains(SubTag.NO_RECYCLING) ? 0L : (aData.mMaterial.mAmount >= 0L ? aData.mMaterial.mAmount : 3628800L);
                        for (MaterialStack tMaterial : aData.mByProducts) {
                            tValidMaterialAmount += tMaterial.mMaterial.contains(SubTag.NO_RECYCLING) ? 0L : (tMaterial.mAmount >= 0L ? tMaterial.mAmount : 3628800L);
                        }
                        if (tValidMaterialAmount < 3628800L) {
                            GTModHandler.addToRecyclerBlackList(aStack);
                        }
                    }
                    if (!mRunThroughTheList) break block12;
                    if (!GregTechAPI.sLoadStarted) break block13;
                    mRunThroughTheList = false;
                    for (Map.Entry<ItemStack, ItemData> tEntry : sItemStack2DataMap.entrySet()) {
                        if (tEntry.getValue().hasValidPrefixData() && !tEntry.getValue().mPrefix.mAllowNormalRecycling) continue;
                        GTRecipeRegistrator.registerMaterialRecycling(GTItemStack.internalCopyStack(tEntry.getKey()), tEntry.getValue());
                    }
                    break block13;
                }
                if (aData.hasValidPrefixData() && !aData.mPrefix.mAllowNormalRecycling) break block13;
                GTRecipeRegistrator.registerMaterialRecycling(aStack, aData);
                break block13;
            }
            for (Object tObject : aData.mExtraData) {
                if (tData.mExtraData.contains(tObject)) continue;
                tData.mExtraData.add(tObject);
            }
        }
    }

    public static void removeItemData(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return;
        }
        sItemStack2DataMap.remove(aStack);
    }

    public static void addAssociation(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aBlackListed) {
        if (aPrefix == null || aMaterial == null || GTUtility.isStackInvalid(aStack)) {
            return;
        }
        if (Items.field_151008_G.getDamage(aStack) == Short.MAX_VALUE) {
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                GTOreDictUnificator.setItemData(GTUtility.copyAmountAndMetaData(1, i, aStack), new ItemData(aPrefix, aMaterial, aBlackListed));
            }
        }
        GTOreDictUnificator.setItemData(aStack, new ItemData(aPrefix, aMaterial, aBlackListed));
    }

    @Nullable
    public static ItemData getItemData(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return null;
        }
        ItemData rData = sItemStack2DataMap.get(aStack);
        if (rData == null) {
            rData = sItemStack2DataMap.get(GTItemStack.internalCopyStack(aStack, true));
        }
        return rData;
    }

    @Nullable
    public static ItemData getAssociation(ItemStack aStack) {
        ItemData rData = GTOreDictUnificator.getItemData(aStack);
        return rData != null && rData.hasValidPrefixMaterialData() ? rData : null;
    }

    public static boolean isItemStackInstanceOf(ItemStack aStack, Object aName) {
        if (GTUtility.isStringInvalid(aName) || GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        for (ItemStack tOreStack : GTOreDictUnificator.getOresImmutable(aName.toString())) {
            if (!GTUtility.areStacksEqual(tOreStack, aStack, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemStackDye(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        for (Dyes tDye : Dyes.VALUES) {
            if (!GTOreDictUnificator.isItemStackInstanceOf(aStack, tDye.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean registerOre(OrePrefixes aPrefix, Object aMaterial, ItemStack aStack) {
        return GTOreDictUnificator.registerOre(aPrefix.get(aMaterial), aStack);
    }

    public static boolean registerOre(Object aName, ItemStack aStack) {
        if (aName == null || GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        String tName = aName.toString();
        if (GTUtility.isStringInvalid(tName)) {
            return false;
        }
        for (ItemStack itemStack : GTOreDictUnificator.getOresImmutable(tName)) {
            if (!GTUtility.areStacksEqual(itemStack, aStack, true)) continue;
            return false;
        }
        ++isRegisteringOre;
        OreDictionary.registerOre((String)tName, (ItemStack)GTUtility.copyAmount(1, aStack));
        --isRegisteringOre;
        return true;
    }

    public static boolean isRegisteringOres() {
        return isRegisteringOre > 0;
    }

    public static boolean isAddingOres() {
        return isAddingOre > 0;
    }

    public static void resetUnificationEntries() {
        for (ItemData tPrefixMaterial : sItemStack2DataMap.values()) {
            tPrefixMaterial.mUnificationTarget = null;
        }
    }

    public static ItemStack getGem(MaterialStack aMaterial) {
        return aMaterial == null ? null : GTOreDictUnificator.getGem(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getGem(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GTOreDictUnificator.getGem(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getGem(Materials aMaterial, long aMaterialAmount) {
        ItemStack rStack = null;
        if (aMaterialAmount >= 3628800L) {
            rStack = GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null) {
            if (aMaterialAmount * 2L % 3628800L == 0L || aMaterialAmount >= 58060800L) {
                rStack = GTOreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, aMaterialAmount * 2L / 3628800L);
            }
            if (aMaterialAmount * 4L >= 3628800L) {
                rStack = GTOreDictUnificator.get(OrePrefixes.gemChipped, aMaterial, aMaterialAmount * 4L / 3628800L);
            }
        }
        return rStack;
    }

    public static ItemStack getDust(MaterialStack aMaterial) {
        return aMaterial == null ? null : GTOreDictUnificator.getDust(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getDust(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GTOreDictUnificator.getDust(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getDust(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = null;
        if (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 58060800L) {
            rStack = GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null && (aMaterialAmount * 4L % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            rStack = GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, aMaterialAmount * 4L / 3628800L);
        }
        if (rStack == null && aMaterialAmount * 9L >= 3628800L) {
            rStack = GTOreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, aMaterialAmount * 9L / 3628800L);
        }
        return rStack;
    }

    public static ItemStack getIngot(MaterialStack aMaterial) {
        return aMaterial == null ? null : GTOreDictUnificator.getIngot(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getIngot(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GTOreDictUnificator.getIngot(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getIngot(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = null;
        if (aMaterialAmount % 32659200L == 0L && aMaterialAmount / 32659200L > 1L || aMaterialAmount >= 261273600L) {
            rStack = GTOreDictUnificator.get(OrePrefixes.block, aMaterial, aMaterialAmount / 32659200L);
        }
        if (rStack == null && (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            rStack = GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null && aMaterialAmount * 9L >= 3628800L) {
            rStack = GTOreDictUnificator.get(OrePrefixes.nugget, aMaterial, aMaterialAmount * 9L / 3628800L);
        }
        return rStack;
    }

    public static ItemStack getIngotOrDust(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = GTOreDictUnificator.getIngot(aMaterial, aMaterialAmount);
        if (rStack == null) {
            rStack = GTOreDictUnificator.getDust(aMaterial, aMaterialAmount);
        }
        return rStack;
    }

    public static ItemStack getIngotOrDust(MaterialStack aMaterial) {
        ItemStack rStack = GTOreDictUnificator.getIngot(aMaterial);
        if (rStack == null) {
            rStack = GTOreDictUnificator.getDust(aMaterial);
        }
        return rStack;
    }

    public static ItemStack getDustOrIngot(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = GTOreDictUnificator.getDust(aMaterial, aMaterialAmount);
        if (rStack == null) {
            rStack = GTOreDictUnificator.getIngot(aMaterial, aMaterialAmount);
        }
        return rStack;
    }

    public static ItemStack getDustOrIngot(MaterialStack aMaterial) {
        ItemStack rStack = GTOreDictUnificator.getDust(aMaterial);
        if (rStack == null) {
            rStack = GTOreDictUnificator.getIngot(aMaterial);
        }
        return rStack;
    }

    public static ArrayList<ItemStack> getOres(OrePrefixes aPrefix, Object aMaterial) {
        return GTOreDictUnificator.getOres(aPrefix.get(aMaterial));
    }

    public static ArrayList<ItemStack> getOres(Object aOreName) {
        String aName = aOreName == null ? "" : aOreName.toString();
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GTUtility.isStringValid(aName)) {
            rList.addAll(OreDictionary.getOres((String)aName));
        }
        return rList;
    }

    public static List<ItemStack> getOresImmutable(@Nullable Object aOreName) {
        String aName = aOreName == null ? "" : aOreName.toString();
        return GTUtility.isStringValid(aName) ? Collections.unmodifiableList(OreDictionary.getOres((String)aName)) : Collections.emptyList();
    }

    static {
        GregTechAPI.sItemStackMappings.add(sItemStack2DataMap);
        GregTechAPI.sItemStackMappings.add(sUnificationTable);
    }
}

