/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IAllSidedTexturedTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.PacketOres;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class TileEntityOres
extends TileEntity
implements IAllSidedTexturedTileEntity {
    public short mMetaData = 0;
    protected static boolean shouldFortune = false;
    protected static boolean shouldSilkTouch = false;
    public boolean mNatural = false;
    public boolean mBlocked = true;
    public boolean mBlockedChecked = false;
    private short mMetadataForCachedTexture = (short)-1;
    private ITexture[] mCachedTexture;

    public static byte getHarvestData(short aMetaData, int aBaseBlockHarvestLevel) {
        byte tByte;
        Materials aMaterial = GregTechAPI.sGeneratedMaterials[aMetaData % 1000];
        byte by = aMaterial == null ? (byte)0 : (tByte = (byte)Math.max(aBaseBlockHarvestLevel, Math.min(7, aMaterial.mToolQuality - (aMetaData < 16000 ? (byte)0 : 1))));
        if (GTMod.gregtechproxy.mChangeHarvestLevels) {
            tByte = aMaterial == null ? (byte)0 : (byte)Math.max(aBaseBlockHarvestLevel, Math.min(GTMod.gregtechproxy.mMaxHarvestLevel, GTMod.gregtechproxy.mHarvestLevel[aMaterial.mMetaItemSubID] - (aMetaData < 16000 ? 0 : 1)));
        }
        return tByte;
    }

    public static boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int aMetaData, boolean isSmallOre) {
        return TileEntityOres.setOreBlock(aWorld, aX, aY, aZ, aMetaData, isSmallOre, true);
    }

    public static boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int aMetaData, boolean isSmallOre, boolean air) {
        if (!air) {
            aY = Math.min(aWorld.func_72940_L(), Math.max(aY, 1));
        }
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        Block tOreBlock = GregTechAPI.sBlockOres1;
        int BlockMeta = aWorld.func_72805_g(aX, aY, aZ);
        String BlockName = tBlock.func_149739_a();
        if ((aMetaData += isSmallOre ? 16000 : 0) > 0 && (tBlock != Blocks.field_150350_a || air)) {
            if (!tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b)) {
                if (tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL)) {
                    aMetaData += 1000;
                } else if (tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs)) {
                    aMetaData += 2000;
                } else if (tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTechAPI.sBlockGranites)) {
                    aMetaData = tBlock == GregTechAPI.sBlockGranites ? (aWorld.func_72805_g(aX, aY, aZ) < 8 ? (aMetaData += 3000) : (aMetaData += 4000)) : (aMetaData += 3000);
                } else if (tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTechAPI.sBlockStones)) {
                    aMetaData = tBlock == GregTechAPI.sBlockStones ? (aWorld.func_72805_g(aX, aY, aZ) < 8 ? (aMetaData += 5000) : (aMetaData += 6000)) : (aMetaData += 5000);
                } else if (BlockName.equals("tile.igneousStone")) {
                    if (GregTechAPI.sBlockOresUb1 != null) {
                        tOreBlock = GregTechAPI.sBlockOresUb1;
                        aMetaData += BlockMeta * 1000;
                    }
                } else if (BlockName.equals("tile.metamorphicStone")) {
                    if (GregTechAPI.sBlockOresUb2 != null) {
                        tOreBlock = GregTechAPI.sBlockOresUb2;
                        aMetaData += BlockMeta * 1000;
                    }
                } else if (BlockName.equals("tile.sedimentaryStone")) {
                    if (GregTechAPI.sBlockOresUb3 != null) {
                        tOreBlock = GregTechAPI.sBlockOresUb3;
                        aMetaData += BlockMeta * 1000;
                    }
                } else {
                    return false;
                }
            }
            aWorld.func_147465_d(aX, aY, aZ, tOreBlock, (int)TileEntityOres.getHarvestData((short)aMetaData, ((BlockOresAbstract)tOreBlock).getBaseBlockHarvestLevel(aMetaData % 16000 / 1000)), 0);
            TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (tTileEntity instanceof TileEntityOres) {
                ((TileEntityOres)tTileEntity).mMetaData = (short)aMetaData;
                ((TileEntityOres)tTileEntity).mNatural = true;
            }
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound aNBT) {
        super.func_145839_a(aNBT);
        this.mMetaData = aNBT.func_74765_d("m");
        this.mNatural = aNBT.func_74767_n("n");
    }

    public void func_145841_b(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
        aNBT.func_74777_a("m", this.mMetaData);
        aNBT.func_74757_a("n", this.mNatural);
    }

    public void onUpdated() {
        if (!this.field_145850_b.field_72995_K && this.mBlocked) {
            this.mBlocked = false;
            GTValues.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new PacketOres(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mMetaData), this.field_145851_c, this.field_145849_e);
        }
    }

    public Packet func_145844_m() {
        if (!this.field_145850_b.field_72995_K) {
            boolean sendUpdate;
            boolean bl = this.mBlockedChecked ? !this.mBlocked : (sendUpdate = this.checkBlocked());
            if (sendUpdate) {
                GTValues.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new PacketOres(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mMetaData), this.field_145851_c, this.field_145849_e);
            }
        }
        return null;
    }

    private boolean checkBlocked() {
        this.mBlockedChecked = true;
        if (!this.field_145850_b.func_72899_e(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
            this.mBlockedChecked = false;
        } else if (!GTUtility.isOpaqueBlock(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
            this.mBlocked = false;
            return true;
        }
        if (!this.field_145850_b.func_72899_e(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
            this.mBlockedChecked = false;
        } else if (!GTUtility.isOpaqueBlock(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
            this.mBlocked = false;
            return true;
        }
        if (!this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            this.mBlockedChecked = false;
        } else if (!GTUtility.isOpaqueBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            this.mBlocked = false;
            return true;
        }
        if (!this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            this.mBlockedChecked = false;
        } else if (!GTUtility.isOpaqueBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            this.mBlocked = false;
            return true;
        }
        if (!this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
            this.mBlockedChecked = false;
        } else if (!GTUtility.isOpaqueBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
            this.mBlocked = false;
            return true;
        }
        if (!this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
            this.mBlockedChecked = false;
        } else if (!GTUtility.isOpaqueBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
            this.mBlocked = false;
            return true;
        }
        this.mBlocked = true;
        return false;
    }

    public void overrideOreBlockMaterial(Block aOverridingStoneBlock, byte aOverridingStoneMeta) {
        if (this.field_145850_b == null || this.field_145854_h == null) {
            return;
        }
        this.mMetaData = (short)((long)this.mMetaData % 1000L + (long)this.mMetaData / 16000L * 16000L);
        if (aOverridingStoneBlock.isReplaceableOreGen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150424_aL)) {
            this.mMetaData = (short)(this.mMetaData + 1000);
        } else if (aOverridingStoneBlock.isReplaceableOreGen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150377_bs)) {
            this.mMetaData = (short)(this.mMetaData + 2000);
        } else if (aOverridingStoneBlock.isReplaceableOreGen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, GregTechAPI.sBlockGranites)) {
            this.mMetaData = aOverridingStoneBlock == GregTechAPI.sBlockGranites ? (aOverridingStoneMeta < 8 ? (short)(this.mMetaData + 3000) : (short)(this.mMetaData + 4000)) : (short)(this.mMetaData + 3000);
        } else if (aOverridingStoneBlock.isReplaceableOreGen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, GregTechAPI.sBlockStones)) {
            this.mMetaData = aOverridingStoneBlock == GregTechAPI.sBlockStones ? (aOverridingStoneMeta < 8 ? (short)(this.mMetaData + 5000) : (short)(this.mMetaData + 6000)) : (short)(this.mMetaData + 5000);
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)TileEntityOres.getHarvestData(this.mMetaData, ((BlockOresAbstract)this.field_145854_h).getBaseBlockHarvestLevel(this.mMetaData % 16000 / 1000)), 0);
    }

    public void convertOreBlock(World aWorld, int aX, int aY, int aZ) {
        short aMeta = (short)(this.mMetaData % 1000 + this.mMetaData / 16000 * 16000);
        aWorld.func_147449_b(aX, aY, aZ, GregTechAPI.sBlockOres1);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof TileEntityOres) {
            ((TileEntityOres)tTileEntity).mMetaData = aMeta;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)TileEntityOres.getHarvestData(aMeta, ((BlockOresAbstract)tTileEntity.field_145854_h).getBaseBlockHarvestLevel(aMeta % 16000 / 1000)), 0);
        }
    }

    public short getMetaData() {
        return this.mMetaData;
    }

    public boolean canUpdate() {
        return false;
    }

    public ArrayList<ItemStack> getDrops(Block aDroppedOre, int aFortune) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (this.mMetaData <= 0) {
            rList.add(new ItemStack(Blocks.field_150347_e, 1, 0));
            return rList;
        }
        Materials aOreMaterial = GregTechAPI.sGeneratedMaterials[this.mMetaData % 1000];
        if (this.mMetaData < 16000) {
            boolean tIsRich = false;
            if (GTMod.gregtechproxy.mNetherOreYieldMultiplier && !tIsRich) {
                boolean bl = tIsRich = this.mMetaData >= 1000 && this.mMetaData < 2000;
            }
            if (GTMod.gregtechproxy.mEndOreYieldMultiplier && !tIsRich) {
                boolean bl = tIsRich = this.mMetaData >= 2000 && this.mMetaData < 3000;
            }
            if (shouldSilkTouch) {
                rList.add(new ItemStack(aDroppedOre, 1, (int)this.mMetaData));
            } else {
                switch (GTMod.gregtechproxy.oreDropSystem) {
                    case Item: {
                        rList.add(GTOreDictUnificator.get(OrePrefixes.rawOre, aOreMaterial, (long)(tIsRich ? 2 : 1)));
                        break;
                    }
                    case FortuneItem: {
                        if (shouldFortune && this.mNatural && aFortune > 0) {
                            int aMinAmount = 1;
                            if (aFortune > 3) {
                                aFortune = 3;
                            }
                            int amount = aMinAmount + Math.max(this.field_145850_b.field_73012_v.nextInt(aFortune * (tIsRich ? 2 : 1) + 2) - 1, 0);
                            for (int i = 0; i < amount; ++i) {
                                rList.add(GTOreDictUnificator.get(OrePrefixes.rawOre, aOreMaterial, 1L));
                            }
                        } else {
                            for (int i = 0; i < (tIsRich ? 2 : 1); ++i) {
                                rList.add(GTOreDictUnificator.get(OrePrefixes.rawOre, aOreMaterial, 1L));
                            }
                        }
                        break;
                    }
                    case UnifiedBlock: {
                        for (int i = 0; i < (tIsRich ? 2 : 1); ++i) {
                            rList.add(new ItemStack(aDroppedOre, 1, this.mMetaData % 1000));
                        }
                        break;
                    }
                    case PerDimBlock: {
                        if (tIsRich) {
                            rList.add(new ItemStack(aDroppedOre, 1, (int)this.mMetaData));
                            break;
                        }
                        rList.add(new ItemStack(aDroppedOre, 1, this.mMetaData % 1000));
                        break;
                    }
                    case Block: {
                        rList.add(new ItemStack(aDroppedOre, 1, (int)this.mMetaData));
                    }
                }
            }
            return rList;
        }
        ++aFortune;
        if (!this.mNatural) {
            aFortune = 0;
        }
        if (aOreMaterial != null) {
            Materials dustMat;
            int i;
            XSTR tRandom = new XSTR(this.field_145851_c ^ this.field_145848_d ^ this.field_145849_e);
            ArrayList<ItemStack> tSelector = new ArrayList<ItemStack>();
            Materials aMaterial = aOreMaterial.mOreReplacement;
            ItemStack tStack = GTOreDictUnificator.get(OrePrefixes.gemExquisite, (Object)aMaterial, GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), 1L);
            if (tStack != null) {
                for (i = 0; i < 1; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GTOreDictUnificator.get(OrePrefixes.gemFlawless, (Object)aMaterial, GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), 1L)) != null) {
                for (i = 0; i < 2; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)) != null) {
                for (i = 0; i < 12; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GTOreDictUnificator.get(OrePrefixes.gemFlawed, (Object)aMaterial, GTOreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L), 1L)) != null) {
                for (i = 0; i < 5; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GTOreDictUnificator.get(OrePrefixes.crushed, aMaterial, 1L)) != null) {
                for (i = 0; i < 10; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GTOreDictUnificator.get(OrePrefixes.gemChipped, (Object)aMaterial, GTOreDictUnificator.get(OrePrefixes.dustImpure, aMaterial, 1L), 1L)) != null) {
                for (i = 0; i < 5; ++i) {
                    tSelector.add(tStack);
                }
            }
            if ((tStack = GTOreDictUnificator.get(OrePrefixes.dustImpure, aMaterial, 1L)) != null) {
                for (i = 0; i < 10; ++i) {
                    tSelector.add(tStack);
                }
            }
            if (!tSelector.isEmpty()) {
                int j = Math.max(1, aMaterial.mOreMultiplier + (aFortune > 0 ? ((Random)tRandom).nextInt(1 + aFortune * aMaterial.mOreMultiplier) : 0) / 2);
                for (i = 0; i < j; ++i) {
                    rList.add(GTUtility.copyAmount(1, (ItemStack)tSelector.get(((Random)tRandom).nextInt(tSelector.size()))));
                }
            }
            if (((Random)tRandom).nextInt(3 + aFortune) > 1 && (dustMat = ((BlockOresAbstract)aDroppedOre).getDroppedDusts()[this.mMetaData / 1000 % 16]) != null) {
                rList.add(GTOreDictUnificator.get(((Random)tRandom).nextInt(3) > 0 ? OrePrefixes.dustImpure : OrePrefixes.dust, dustMat, 1L));
            }
        }
        return rList;
    }

    @Override
    public ITexture[] getTexture(Block aBlock) {
        if (this.mMetadataForCachedTexture == this.mMetaData && this.mCachedTexture != null) {
            return this.mCachedTexture;
        }
        this.mMetadataForCachedTexture = this.mMetaData;
        this.mCachedTexture = this.getTextureInternal(aBlock);
        return this.mCachedTexture;
    }

    private ITexture @NotNull [] getTextureInternal(Block aBlock) {
        Materials aMaterial = GregTechAPI.sGeneratedMaterials[this.mMetaData % 1000];
        if (aMaterial != null && this.mMetaData < 32000 && aBlock instanceof BlockOresAbstract) {
            ITexture iTexture = TextureFactory.builder().addIcon(aMaterial.mIconSet.mTextures[this.mMetaData / 16000 == 0 ? OrePrefixes.ore.mTextureIndex : OrePrefixes.oreSmall.mTextureIndex]).setRGBA(aMaterial.mRGBa).stdOrient().build();
            return new ITexture[]{((BlockOresAbstract)aBlock).getTextureSet()[this.mMetaData / 1000 % 16], iTexture};
        }
        return new ITexture[]{TextureFactory.of(Blocks.field_150348_b, 0), TextureFactory.builder().addIcon(TextureSet.SET_NONE.mTextures[OrePrefixes.ore.mTextureIndex]).stdOrient().build()};
    }
}

