/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.config;

import com.gtnewhorizon.gtnhlib.config.Config;
import gregtech.api.recipe.RecipeCategorySetting;

@Config(modid="gregtech", category="client", configSubDirectory="GregTech", filename="Client")
@Config.LangKey(value="GT5U.gui.config.client")
public class Client {
    @Config.Comment(value={"Color Modulation section"})
    public static final ColorModulation colorModulation = new ColorModulation();
    @Config.Comment(value={"Interface section"})
    public static final Interface iface = new Interface();
    @Config.Comment(value={"Preference section"})
    public static final Preference preference = new Preference();
    @Config.Comment(value={"Render section"})
    public static final Render render = new Render();
    @Config.Comment(value={"Waila section"})
    public static final Waila waila = new Waila();
    @Config.Comment(value={"NEI section"})
    public static final NEI nei = new NEI();

    @Config.LangKey(value="GT5U.gui.config.client.color_modulation")
    public static class ColorModulation {
        @Config.Comment(value={"RGB values for the cable insulation color modulation."})
        public CableInsulation cableInsulation = new CableInsulation();
        @Config.Comment(value={"RGB values for the construction foam color modulation."})
        public ConstructionFoam constructionFoam = new ConstructionFoam();
        @Config.Comment(value={"RGB values for the machine metal color modulation (default GUI color)."})
        public MachineMetal machineMetal = new MachineMetal();

        @Config.LangKey(value="GT5U.gui.config.client.color_modulation.cable_insulation")
        public static class CableInsulation {
            @Config.DefaultInt(value=64)
            public int red;
            @Config.DefaultInt(value=64)
            public int green;
            @Config.DefaultInt(value=64)
            public int blue;
        }

        @Config.LangKey(value="GT5U.gui.config.client.color_modulation.construction_foam")
        public static class ConstructionFoam {
            @Config.DefaultInt(value=64)
            public int red;
            @Config.DefaultInt(value=64)
            public int green;
            @Config.DefaultInt(value=64)
            public int blue;
        }

        @Config.LangKey(value="GT5U.gui.config.client.color_modulation.machine_metal")
        public static class MachineMetal {
            @Config.DefaultInt(value=210)
            public int red;
            @Config.DefaultInt(value=220)
            public int green;
            @Config.DefaultInt(value=255)
            public int blue;
        }
    }

    @Config.LangKey(value="GT5U.gui.config.client.interface")
    public static class Interface {
        @Config.Comment(value={"if true, makes cover tabs visible on GregTech machines."})
        @Config.DefaultBoolean(value=true)
        public boolean coverTabsVisible;
        @Config.Comment(value={"if true, puts the cover tabs display on the right of the UI instead of the left."})
        @Config.DefaultBoolean(value=false)
        public boolean coverTabsFlipped;
        @Config.Comment(value={"How verbose should tooltips be? 0: disabled, 1: one-line, 2: normal, 3+: extended."})
        @Config.DefaultInt(value=2)
        public int tooltipVerbosity;
        @Config.Comment(value={"How verbose should tooltips be when LSHIFT is held? 0: disabled, 1: one-line, 2: normal, 3+: extended."})
        @Config.DefaultInt(value=3)
        public int tooltipShiftVerbosity;
        @Config.Comment(value={"Which style to use for title tab on machine GUI? 0: text tab split-dark, 1: text tab unified, 2: item icon tab."})
        @Config.DefaultInt(value=0)
        public int titleTabStyle;
    }

    @Config.LangKey(value="GT5U.gui.config.client.preference")
    public static class Preference {
        @Config.Comment(value={"if true, input filter will initially be on when input buses are placed in the world."})
        @Config.DefaultBoolean(value=false)
        public boolean inputBusInitialFilter;
        @Config.Comment(value={"if true, allow multistacks on single blocks by default when they are first placed in the world."})
        @Config.DefaultBoolean(value=false)
        public boolean singleBlockInitialAllowMultiStack;
        @Config.Comment(value={"if true, input filter will initially be on when machines are placed in the world."})
        @Config.DefaultBoolean(value=false)
        public boolean singleBlockInitialFilter;
    }

    @Config.LangKey(value="GT5U.gui.config.client.render")
    public static class Render {
        @Config.Comment(value={"if true, enables ambient-occlusion smooth lighting on tiles."})
        @Config.DefaultBoolean(value=true)
        public boolean renderTileAmbientOcclusion;
        @Config.Comment(value={"if true, enables glowing of the machine controllers."})
        @Config.DefaultBoolean(value=true)
        public boolean renderGlowTextures;
        @Config.Comment(value={"if true, render flipped machine with flipped textures."})
        @Config.DefaultBoolean(value=true)
        public boolean renderFlippedMachinesFlipped;
        @Config.Comment(value={"if true, render indicators on hatches."})
        @Config.DefaultBoolean(value=true)
        public boolean renderIndicatorsOnHatch;
        @Config.Comment(value={"if true, enables dirt particles when pollution reaches the threshold."})
        @Config.DefaultBoolean(value=true)
        public boolean renderDirtParticles;
        @Config.Comment(value={"if true, enables pollution fog when pollution reaches the threshold."})
        @Config.DefaultBoolean(value=true)
        public boolean renderPollutionFog;
        @Config.Comment(value={"if true, enables the green -> red durability for an item's damage value."})
        @Config.DefaultBoolean(value=true)
        public boolean renderItemDurabilityBar;
        @Config.Comment(value={"if true, enables the blue charge bar for an electric item's charge."})
        @Config.DefaultBoolean(value=true)
        public boolean renderItemChargeBar;
        @Config.Comment(value={"enables BaseMetaTileEntity block updates handled by BlockUpdateHandler."})
        @Config.DefaultBoolean(value=false)
        public boolean useBlockUpdateHandler;
    }

    @Config.LangKey(value="GT5U.gui.config.client.waila")
    public static class Waila {
        @Config.Comment(value={"if true, enables showing voltage tier of transformer for Waila, instead of raw voltage number."})
        @Config.DefaultBoolean(value=true)
        public boolean wailaTransformerVoltageTier;
        @Config.Comment(value={"if true, enables showing voltage tier of transformer for Waila, instead of raw voltage number."})
        @Config.DefaultBoolean(value=false)
        public boolean wailaAverageNS;
    }

    @Config.LangKey(value="GT5U.gui.config.client.nei")
    public static class NEI {
        @Config.Comment(value={"Recipe category section"})
        public final RecipeCategories recipeCategories = new RecipeCategories();
        @Config.Comment(value={"if true, shows the recipes using seconds (as opposed to ticks)."})
        @Config.DefaultBoolean(value=true)
        public boolean NEIRecipeSecondMode;
        @Config.Comment(value={"if true, shows the mod which added the recipe."})
        @Config.DefaultBoolean(value=false)
        public boolean NEIRecipeOwner;
        @Config.Comment(value={"if true, show the stacktrace related to the recipe addition."})
        @Config.DefaultBoolean(value=false)
        public boolean NEIRecipeOwnerStackTrace;
        @Config.Comment(value={"if true, show original voltage when overclocked."})
        @Config.DefaultBoolean(value=false)
        public boolean NEIOriginalVoltage;

        @Config.LangKey(value="GT5U.gui.config.client.nei.recipe_categories")
        public static class RecipeCategories {
            @Config.LangKey(value="gt.recipe.category.arc_furnace_recycling")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting arcFurnaceRecycling = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gt.recipe.category.plasma_arc_furnace_recycling")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting plasmaArcFurnaceRecycling = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gt.recipe.category.macerator_recycling")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting maceratorRecycling = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gt.recipe.category.fluid_extractor_recycling")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting fluidExtractorRecycling = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gt.recipe.category.alloy_smelter_recycling")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting alloySmelterRecycling = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gt.recipe.category.alloy_smelter_molding")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting alloySmelterMolding = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gt.recipe.category.forge_hammer_recycling")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting forgeHammerRecycling = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gt.recipe.category.tic_part_extruding")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting ticPartExtruding = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gt.recipe.category.tic_bolt_molding")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting ticBoltMolding = RecipeCategorySetting.ENABLE;
            @Config.LangKey(value="gtpp.recipe.category.abs_non_alloy_recipes")
            @Config.DefaultEnum(value="ENABLE")
            public RecipeCategorySetting absNonAlloyRecipes = RecipeCategorySetting.ENABLE;
        }
    }
}

