/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.redstone.CoverAdvancedWirelessRedstoneBase;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class CoverAdvancedRedstoneReceiverBase
extends CoverAdvancedWirelessRedstoneBase<ReceiverData> {
    public CoverAdvancedRedstoneReceiverBase(ITexture coverTexture) {
        super(ReceiverData.class, coverTexture);
    }

    @Override
    public ReceiverData createDataObject() {
        return new ReceiverData();
    }

    @Override
    public ReceiverData createDataObject(int aLegacyData) {
        return this.createDataObject();
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new AdvancedRedstoneReceiverBaseUIFactory(buildContext).createWindow();
    }

    public static class ReceiverData
    extends CoverAdvancedWirelessRedstoneBase.WirelessData {
        private GateMode mode;

        public ReceiverData(int frequency, UUID uuid, GateMode mode) {
            super(frequency, uuid);
            this.mode = mode;
        }

        public ReceiverData() {
            this(0, null, GateMode.AND);
        }

        public GateMode getGateMode() {
            return this.mode;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new ReceiverData(this.frequency, this.uuid, this.mode);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = (NBTTagCompound)super.saveDataToNBT();
            tag.func_74774_a("mode", (byte)this.mode.ordinal());
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            super.writeToByteBuf(aBuf);
            aBuf.writeByte(this.mode.ordinal());
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            super.loadDataFromNBT(aNBT);
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.mode = GateMode.values()[tag.func_74771_c("mode")];
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            super.readFromPacket(aBuf, aPlayer);
            this.mode = GateMode.values()[aBuf.readByte()];
            return this;
        }
    }

    private class AdvancedRedstoneReceiverBaseUIFactory
    extends CoverAdvancedWirelessRedstoneBase.AdvancedWirelessRedstoneBaseUIFactory {
        public AdvancedRedstoneReceiverBaseUIFactory(CoverUIBuildContext buildContext) {
            super(CoverAdvancedRedstoneReceiverBase.this, buildContext);
        }

        @Override
        protected int getFrequencyRow() {
            return 0;
        }

        @Override
        protected int getButtonRow() {
            return 1;
        }

        @Override
        protected boolean isShiftPrivateLeft() {
            return false;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            super.addUIWidgets(builder);
            builder.widget(new TextWidget(GTUtility.trans("335", "Gate Mode")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(100, 65));
        }

        protected void addUIForDataController(CoverDataControllerWidget<ReceiverData> controller) {
            super.addUIForDataController(controller);
            ((CoverDataControllerWidget)((CoverDataControllerWidget)((CoverDataControllerWidget)((CoverDataControllerWidget)controller.addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> ((ReceiverData)coverData).mode == GateMode.AND, (coverData, state) -> {
                ((ReceiverData)coverData).mode = GateMode.AND;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_GATE_AND).addTooltip(GTUtility.trans("331", "AND Gate")).setPos(0, 36))).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> ((ReceiverData)coverData).mode == GateMode.NAND, (coverData, state) -> {
                ((ReceiverData)coverData).mode = GateMode.NAND;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_GATE_NAND).addTooltip(GTUtility.trans("332", "NAND Gate")).setPos(18, 36))).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> ((ReceiverData)coverData).mode == GateMode.OR, (coverData, state) -> {
                ((ReceiverData)coverData).mode = GateMode.OR;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_GATE_OR).addTooltip(GTUtility.trans("333", "OR Gate")).setPos(36, 36))).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> ((ReceiverData)coverData).mode == GateMode.NOR, (coverData, state) -> {
                ((ReceiverData)coverData).mode = GateMode.NOR;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_GATE_NOR).addTooltip(GTUtility.trans("334", "NOR Gate")).setPos(54, 36))).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofDisableable(), coverData -> ((ReceiverData)coverData).mode == GateMode.SINGLE_SOURCE, (coverData, state) -> {
                ((ReceiverData)coverData).mode = GateMode.SINGLE_SOURCE;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_ANALOG).addTooltips(Arrays.asList("ANALOG Mode", "Only use this mode with ONE transmitter in total,", "no logic involved")).setPos(72, 36));
        }
    }

    public static enum GateMode {
        AND,
        NAND,
        OR,
        NOR,
        SINGLE_SOURCE;

    }
}

