/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.net.GTPacketInfiniteSpraycan;
import gregtech.api.util.ColoredBlockContainer;
import gregtech.api.util.GTUtility;
import gregtech.common.config.Other;
import gregtech.common.gui.modularui.uifactory.SelectItemUIFactory;
import gregtech.common.items.behaviors.BehaviourSprayColor;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BehaviourSprayColorInfinite
extends BehaviourSprayColor {
    private static final byte REMOVE_COLOR = (byte)Dyes.VALUES.length;
    private static final List<ItemStack> COLOR_SELECTIONS;
    public static final String COLOR_NBT_TAG = "current_color";
    public static final String LOCK_NBT_TAG = "is_locked";
    public static final String SEPARATOR = "-----------------------------------------";
    private byte mCurrentColor;

    public BehaviourSprayColorInfinite(ItemStack sprayCan) {
        super(sprayCan, sprayCan, sprayCan, Other.sprayCanChainRange, 0);
        this.mTooltip = "";
        this.mCurrentColor = 0;
    }

    @Override
    protected long getUses(ItemStack itemStack, NBTTagCompound tNBT) {
        return Other.sprayCanChainRange;
    }

    @Override
    protected void setRemainingUses(ItemStack itemStack, NBTTagCompound tNBT, long tUses) {
    }

    @Override
    protected byte getColor() {
        if (this.mCurrentColor == REMOVE_COLOR) {
            throw new RuntimeException("Attempting to get invalid color");
        }
        return this.mCurrentColor;
    }

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack itemStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        NBTTagCompound tag;
        if (aWorld.field_72995_K || itemStack.field_77994_a != 1) {
            return false;
        }
        if (itemStack.func_77942_o() && (tag = itemStack.func_77978_p()).func_74764_b(COLOR_NBT_TAG)) {
            this.mCurrentColor = tag.func_74771_c(COLOR_NBT_TAG);
        }
        return super.onItemUseFirst(aItem, itemStack, aPlayer, aWorld, aX, aY, aZ, side, hitX, hitY, hitZ);
    }

    @Override
    protected boolean colorize(World aWorld, int aX, int aY, int aZ, ForgeDirection side, EntityPlayer player) {
        ColoredBlockContainer block = ColoredBlockContainer.getInstance(aWorld, aX, aY, aZ, side, player);
        if (this.mCurrentColor == REMOVE_COLOR) {
            return block.removeColor();
        }
        return block.setColor(this.getColor());
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack itemStack) {
        aList.add(StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.tooltip.infinite"));
        aList.add(this.mTooltipChain);
        aList.add(SEPARATOR);
        aList.add(StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.tooltip.more_info"));
        aList.add(SEPARATOR);
        aList.add(GTValues.AuthorQuerns);
        return aList;
    }

    @Override
    public List<String> getAdditionalToolTipsWhileSneaking(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(SEPARATOR);
        aList.add(StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.tooltip.switch"));
        aList.add(StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.tooltip.gui"));
        aList.add(StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.tooltip.pick"));
        aList.add(StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.tooltip.lock"));
        aList.add(SEPARATOR);
        aList.add(GTValues.AuthorQuerns);
        return aList;
    }

    @Override
    public boolean onLeftClick(MetaBaseItem item, ItemStack itemStack, EntityPlayer aPlayer) {
        if (this.isLocked(itemStack)) {
            BehaviourSprayColorInfinite.displayLockedMessage();
        } else {
            BehaviourSprayColorInfinite.sendPacket(GTPacketInfiniteSpraycan.Action.INCREMENT_COLOR);
        }
        return true;
    }

    @Override
    public boolean onMiddleClick(MetaBaseItem item, ItemStack itemStack, EntityPlayer player) {
        if (player.func_70093_af()) {
            BehaviourSprayColorInfinite.sendPacket(GTPacketInfiniteSpraycan.Action.LOCK_CAN);
        } else if (this.isLocked(itemStack)) {
            BehaviourSprayColorInfinite.displayLockedMessage();
        } else {
            ColoredBlockContainer block;
            MovingObjectPosition position = GTUtility.getPlayerLookingTarget(player);
            if (position != null && position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = ColoredBlockContainer.getInstance(player, position)).getColor().isPresent()) {
                BehaviourSprayColorInfinite.sendPacket(GTPacketInfiniteSpraycan.Action.SET_COLOR, block.getColor().get());
                return true;
            }
            this.openGUI(player, itemStack);
        }
        return true;
    }

    private void openGUI(EntityPlayer player, ItemStack itemStack) {
        UIInfos.openClientUI((EntityPlayer)player, buildContext -> new DyeSelectGUI(StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.gui.header"), itemStack, selectedStack -> BehaviourSprayColorInfinite.sendPacket(GTPacketInfiniteSpraycan.Action.SET_COLOR, selectedStack.func_77973_b() == Items.field_151100_aR ? selectedStack.func_77960_j() : REMOVE_COLOR), COLOR_SELECTIONS, this.getColor(itemStack), true).createWindow((UIBuildContext)buildContext));
    }

    private byte getColor(ItemStack sprayCan) {
        NBTTagCompound tag;
        if (sprayCan.func_77942_o() && (tag = sprayCan.func_77978_p()).func_74764_b(COLOR_NBT_TAG)) {
            return tag.func_74771_c(COLOR_NBT_TAG);
        }
        return REMOVE_COLOR;
    }

    private static void displayLockedMessage() {
        GTNHLib.proxy.printMessageAboveHotbar(StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.gui.lock_error"), 120, true, true);
    }

    private static void sendPacket(GTPacketInfiniteSpraycan.Action action) {
        GTValues.NW.sendToServer(new GTPacketInfiniteSpraycan(action));
    }

    private static void sendPacket(GTPacketInfiniteSpraycan.Action action, int newColor) {
        GTValues.NW.sendToServer(new GTPacketInfiniteSpraycan(action, newColor));
    }

    public void incrementColor(ItemStack itemStack, boolean wasSneaking) {
        byte newColor;
        if (this.isLocked(itemStack)) {
            return;
        }
        NBTTagCompound tag = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        byte color = 0;
        if (tag.func_74764_b(COLOR_NBT_TAG)) {
            color = tag.func_74771_c(COLOR_NBT_TAG);
        }
        if ((newColor = (byte)(color + (wasSneaking ? -1 : 1))) > REMOVE_COLOR) {
            newColor = 0;
        } else if (newColor < 0) {
            newColor = REMOVE_COLOR;
        }
        color = newColor;
        this.setColor(itemStack, color);
    }

    public void setColor(ItemStack itemStack, byte color) {
        if (this.isLocked(itemStack)) {
            return;
        }
        NBTTagCompound tag = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        tag.func_74774_a(COLOR_NBT_TAG, color);
        this.mCurrentColor = color;
        itemStack.func_77982_d(tag);
        this.setItemStackName(itemStack);
    }

    public boolean toggleLock(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        boolean newLockStatus = !tag.func_74767_n(LOCK_NBT_TAG);
        tag.func_74757_a(LOCK_NBT_TAG, newLockStatus);
        itemStack.func_77982_d(tag);
        this.setItemStackName(itemStack);
        return newLockStatus;
    }

    private void setItemStackName(ItemStack itemStack) {
        char rBracket;
        boolean isLocked = this.isLocked(itemStack);
        char lBracket = isLocked ? (char)'[' : '(';
        char c = rBracket = isLocked ? (char)']' : ')';
        if (this.mCurrentColor == REMOVE_COLOR) {
            itemStack.func_151001_c(String.format("Infinite Spray Can %cSolvent%c", Character.valueOf(lBracket), Character.valueOf(rBracket)));
        } else {
            itemStack.func_151001_c(String.format("Infinite Spray Can %c" + Dyes.get((int)this.mCurrentColor).mName + "%c", Character.valueOf(lBracket), Character.valueOf(rBracket)));
        }
    }

    public static Dyes getDye(ItemStack itemStack) {
        byte color;
        if (itemStack.func_77942_o() && (color = itemStack.func_77978_p().func_74771_c(COLOR_NBT_TAG)) != REMOVE_COLOR) {
            return Dyes.getDyeFromIndex(color);
        }
        return Dyes.MACHINE_METAL;
    }

    public boolean isLocked(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74767_n(LOCK_NBT_TAG);
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 16; ++i) {
            builder.add((Object)new ItemStack(Items.field_151100_aR, 1, i));
        }
        builder.add((Object)ItemList.Spray_Color_Remover.get(1L, new Object[0]));
        COLOR_SELECTIONS = builder.build();
    }

    private static class DyeSelectGUI
    extends SelectItemUIFactory {
        public DyeSelectGUI(String header, ItemStack headerItem, Consumer<ItemStack> selectedCallback, List<ItemStack> stacks, int selected, boolean noDeselect) {
            super(header, headerItem, selectedCallback, stacks, selected, noDeselect);
        }

        @Override
        public void setSelected(int selected, Widget widget) {
            super.setSelected(selected, widget);
            widget.getWindow().closeWindow();
        }

        @Override
        protected List<String> getItemTooltips(int index) {
            return ImmutableList.of((Object)(index == REMOVE_COLOR ? StatCollector.func_74838_a((String)"gt.behaviour.paintspray.infinite.gui.solvent") : Dyes.getDyeFromIndex((short)((short)index)).mName));
        }
    }
}

