/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc;

import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.misc.GlobalEnergyWorldSavedData;
import gregtech.common.misc.GlobalVariableStorage;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.math.BigInteger;
import java.util.UUID;

public class WirelessNetworkManager {
    private WirelessNetworkManager() {
    }

    public static void strongCheckOrAddUser(UUID user_uuid) {
        SpaceProjectManager.checkOrCreateTeam(user_uuid);
        if (!GlobalVariableStorage.GlobalEnergy.containsKey(user_uuid)) {
            GlobalVariableStorage.GlobalEnergy.put(SpaceProjectManager.getLeader(user_uuid), BigInteger.ZERO);
        }
    }

    public static boolean addEUToGlobalEnergyMap(UUID user_uuid, BigInteger EU) {
        try {
            GlobalEnergyWorldSavedData.INSTANCE.func_76185_a();
        }
        catch (Exception exception) {
            System.out.println("COULD NOT MARK GLOBAL ENERGY AS DIRTY IN ADD EU");
            exception.printStackTrace();
        }
        UUID teamUUID = SpaceProjectManager.getLeader(user_uuid);
        BigInteger totalEU = GlobalVariableStorage.GlobalEnergy.getOrDefault(teamUUID, BigInteger.ZERO);
        totalEU = totalEU.add(EU);
        if (totalEU.signum() >= 0) {
            GlobalVariableStorage.GlobalEnergy.put(teamUUID, totalEU);
            return true;
        }
        return false;
    }

    public static boolean addEUToGlobalEnergyMap(UUID user_uuid, long EU) {
        return WirelessNetworkManager.addEUToGlobalEnergyMap(user_uuid, BigInteger.valueOf(EU));
    }

    public static boolean addEUToGlobalEnergyMap(UUID user_uuid, int EU) {
        return WirelessNetworkManager.addEUToGlobalEnergyMap(user_uuid, BigInteger.valueOf(EU));
    }

    public static BigInteger getUserEU(UUID user_uuid) {
        return GlobalVariableStorage.GlobalEnergy.getOrDefault(SpaceProjectManager.getLeader(user_uuid), BigInteger.ZERO);
    }

    public static void setUserEU(UUID user_uuid, BigInteger EU) {
        try {
            GlobalEnergyWorldSavedData.INSTANCE.func_76185_a();
        }
        catch (Exception exception) {
            System.out.println("COULD NOT MARK GLOBAL ENERGY AS DIRTY IN SET EU");
            exception.printStackTrace();
        }
        GlobalVariableStorage.GlobalEnergy.put(SpaceProjectManager.getLeader(user_uuid), EU);
    }

    public static void clearGlobalEnergyInformationMaps() {
        GlobalVariableStorage.GlobalEnergy.clear();
    }

    public static UUID processInitialSettings(IGregTechTileEntity machine) {
        UUID UUID2 = machine.getOwnerUuid();
        SpaceProjectManager.checkOrCreateTeam(UUID2);
        return UUID2;
    }
}

