/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.IModelCustomExt;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import cpw.mods.fml.client.registry.ClientRegistry;
import gregtech.api.enums.Mods;
import gregtech.common.tileentities.render.TileEntityBlackhole;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import org.joml.Matrix4fStack;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class BlackholeRenderer
extends TileEntitySpecialRenderer {
    private boolean initialized = false;
    private ShaderProgram blackholeProgram;
    private static int u_CameraPosition = -1;
    private static int u_Scale = -1;
    private static int u_Time = -1;
    private static int u_Stability = -1;
    private static final Matrix4fStack modelMatrixStack = new Matrix4fStack(4);
    private static IModelCustomExt blackholeModel;
    private static ResourceLocation blackholeTexture;
    private static float modelScale;
    private ShaderProgram laserProgram;
    private static int u_LaserCameraPosition;
    private static int u_LaserColor;
    private static int u_LaserModelMatrix;
    private static VertexBuffer laserVBO;
    private static ResourceLocation laserTexture;
    private static final Matrix4fStack modelMatrix;
    private static final float WIDTH = 0.1f;
    private static final float EXCLUSION = 1.0f;

    public BlackholeRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlackhole.class, (TileEntitySpecialRenderer)this);
    }

    private void init() {
        try {
            this.blackholeProgram = new ShaderProgram(Mods.GregTech.resourceDomain, "shaders/blackhole.vert.glsl", "shaders/blackhole.frag.glsl");
            u_CameraPosition = this.blackholeProgram.getUniformLocation("u_CameraPosition");
            u_Scale = this.blackholeProgram.getUniformLocation("u_Scale");
            u_Time = this.blackholeProgram.getUniformLocation("u_Time");
            u_Stability = this.blackholeProgram.getUniformLocation("u_Stability");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        blackholeModel = (IModelCustomExt)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/blackhole.obj"));
        blackholeTexture = new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/blackhole.png");
        this.blackholeProgram.use();
        GL20.glUniform1f((int)u_Scale, (float)modelScale);
        GL20.glUniform1f((int)u_Stability, (float)0.1f);
        ShaderProgram.clear();
        try {
            this.laserProgram = new ShaderProgram(Mods.GregTech.resourceDomain, "shaders/laser.vert.glsl", "shaders/laser.frag.glsl");
            u_LaserCameraPosition = this.laserProgram.getUniformLocation("u_CameraPosition");
            u_LaserColor = this.laserProgram.getUniformLocation("u_Color");
            u_LaserModelMatrix = this.laserProgram.getUniformLocation("u_ModelMatrix");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        laserTexture = new ResourceLocation(Mods.GregTech.resourceDomain, "textures/model/laser.png");
        TessellatorManager.startCapturing();
        CapturingTessellator tess = (CapturingTessellator)TessellatorManager.get();
        tess.func_78382_b();
        tess.func_78374_a(8.5, 0.0, (double)-0.1f, 0.0, 0.0);
        tess.func_78374_a(8.5, 0.0, (double)0.1f, 0.0, 1.0);
        tess.func_78374_a(1.0, 0.0, (double)0.02f, 1.0, 1.0);
        tess.func_78374_a(1.0, 0.0, (double)-0.02f, 1.0, 0.0);
        tess.func_78374_a(-8.5, 0.0, (double)-0.1f, 0.0, 0.0);
        tess.func_78374_a(-8.5, 0.0, (double)0.1f, 0.0, 1.0);
        tess.func_78374_a(-1.0, 0.0, (double)0.02f, 1.0, 1.0);
        tess.func_78374_a(-1.0, 0.0, (double)-0.02f, 1.0, 0.0);
        tess.func_78381_a();
        laserVBO = TessellatorManager.stopCapturingToVBO((VertexFormat)DefaultVertexFormat.POSITION_TEXTURE_NORMAL);
        this.initialized = true;
    }

    private void renderBlackHole(TileEntityBlackhole tile, double x, double y, double z, float timer) {
        this.blackholeProgram.use();
        this.func_147499_a(blackholeTexture);
        GL20.glUniform1f((int)u_Stability, (float)tile.getStability());
        modelMatrixStack.clear();
        float xLocal = (float)x + 0.5f;
        float yLocal = (float)y + 0.5f;
        float zLocal = (float)z + 0.5f;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL20.glUniform3f((int)u_CameraPosition, (float)(ActiveRenderInfo.field_74592_a - xLocal), (float)(ActiveRenderInfo.field_74590_b - yLocal), (float)(ActiveRenderInfo.field_74591_c - zLocal));
        GL20.glUniform1f((int)u_Time, (float)timer);
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        blackholeModel.renderAllVBO();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        ShaderProgram.clear();
    }

    private void renderLasers(TileEntityBlackhole tile, double x, double y, double z, float timer) {
        this.laserProgram.use();
        this.func_147499_a(laserTexture);
        float cx = (float)x + 0.5f;
        float cy = (float)y + 0.5f;
        float cz = (float)z + 0.5f;
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2884);
        GL11.glPushMatrix();
        GL20.glUniform3f((int)u_LaserColor, (float)tile.getLaserR(), (float)tile.getLaserG(), (float)tile.getLaserB());
        modelMatrix.clear();
        modelMatrix.translate(cx, cy, cz);
        FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);
        GL20.glUniformMatrix4((int)u_LaserModelMatrix, (boolean)false, (FloatBuffer)modelMatrix.get(matrixBuffer));
        modelMatrix.pushMatrix();
        modelMatrix.invert();
        Vector4f cameraPosition = new Vector4f(ActiveRenderInfo.field_74592_a, ActiveRenderInfo.field_74590_b, ActiveRenderInfo.field_74591_c, 1.0f);
        cameraPosition = modelMatrix.transform(cameraPosition);
        GL20.glUniform3f((int)u_LaserCameraPosition, (float)cameraPosition.x, (float)cameraPosition.y, (float)cameraPosition.z);
        laserVBO.render();
        modelMatrix.popMatrix();
        matrixBuffer.clear();
        modelMatrix.rotate(1.5707964f, 0.0f, 1.0f, 0.0f);
        GL20.glUniformMatrix4((int)u_LaserModelMatrix, (boolean)false, (FloatBuffer)modelMatrix.get(matrixBuffer));
        modelMatrix.invert();
        cameraPosition.set(ActiveRenderInfo.field_74592_a, ActiveRenderInfo.field_74590_b, ActiveRenderInfo.field_74591_c, 1.0f);
        cameraPosition = modelMatrix.transform(cameraPosition);
        GL20.glUniform3f((int)u_LaserCameraPosition, (float)cameraPosition.x, (float)cameraPosition.y, (float)cameraPosition.z);
        laserVBO.render();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        ShaderProgram.clear();
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float timeSinceLastTick) {
        if (!(tile instanceof TileEntityBlackhole)) {
            return;
        }
        TileEntityBlackhole blackhole = (TileEntityBlackhole)tile;
        if (!this.initialized) {
            this.init();
            if (!this.initialized) {
                return;
            }
        }
        if (((TileEntityBlackhole)tile).getLaserRender()) {
            this.renderLasers(blackhole, x, y, z, (float)tile.func_145831_w().func_72820_D() + timeSinceLastTick);
        }
        this.renderBlackHole(blackhole, x, y, z, (float)tile.func_145831_w().func_72820_D() + timeSinceLastTick);
    }

    static {
        modelScale = 0.5f;
        u_LaserCameraPosition = -1;
        u_LaserColor = -1;
        u_LaserModelMatrix = -1;
        modelMatrix = new Matrix4fStack(2);
    }
}

