/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.core.localization.WailaText;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.item.AEItemStack;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.AdaptableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.IDataCopyable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.gui.modularui.widget.AESlotWidget;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.ISmartInputHatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchInputBusME
extends MTEHatchInputBus
implements IConfigurationCircuitSupport,
IRecipeProcessingAwareHatch,
IAddGregtechLogo,
IAddUIWidgets,
IPowerChannelState,
ISmartInputHatch,
IDataCopyable {
    private static final int SLOT_COUNT = 16;
    public static final String COPIED_DATA_IDENTIFIER = "stockingBus";
    private BaseActionSource requestSource = null;
    @Nullable
    private AENetworkProxy gridProxy = null;
    private final ItemStack[] shadowInventory = new ItemStack[16];
    private final int[] savedStackSizes = new int[16];
    private boolean processingRecipe = false;
    private final boolean autoPullAvailable;
    private boolean autoPullItemList = false;
    private int minAutoPullStackSize = 1;
    private int autoPullRefreshTime = 100;
    private static final int CONFIG_WINDOW_ID = 10;
    private boolean additionalConnection = false;
    private boolean justHadNewItems = false;
    private boolean expediteRecipeCheck = false;

    public MTEHatchInputBusME(int aID, boolean autoPullAvailable, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, autoPullAvailable ? 6 : 3, 34, MTEHatchInputBusME.getDescriptionArray(autoPullAvailable));
        this.autoPullAvailable = autoPullAvailable;
        this.disableSort = true;
    }

    public MTEHatchInputBusME(String aName, boolean autoPullAvailable, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 34, aDescription, aTextures);
        this.autoPullAvailable = autoPullAvailable;
        this.disableSort = true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchInputBusME(this.mName, this.autoPullAvailable, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_INPUT_HATCH_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_INPUT_HATCH)};
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (aTimer % (long)this.autoPullRefreshTime == 0L && this.autoPullItemList) {
                this.refreshItemList();
            }
            if (aTimer % 20L == 0L) {
                this.getBaseMetaTileEntity().setActive(this.isActive());
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTimer);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing(forgeDirection) ? AECableType.SMART : AECableType.NONE;
    }

    private void updateValidGridProxySides() {
        if (this.additionalConnection) {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
        } else {
            this.getProxy().setValidSides(EnumSet.of(this.getBaseMetaTileEntity().getFrontFacing()));
        }
    }

    @Override
    public void onFacingChange() {
        this.updateValidGridProxySides();
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.additionalConnection = !this.additionalConnection;
        this.updateValidGridProxySides();
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.hatch.additionalConnection." + this.additionalConnection, new Object[0]));
        return true;
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", this.autoPullAvailable ? ItemList.Hatch_Input_Bus_ME_Advanced.get(1L, new Object[0]) : ItemList.Hatch_Input_Bus_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.updateValidGridProxySides();
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        int[] sizes = new int[16];
        for (int i = 0; i < 16; ++i) {
            sizes[i] = this.mInventory[i + 16] == null ? 0 : this.mInventory[i + 16].field_77994_a;
        }
        aNBT.func_74783_a("sizes", sizes);
        aNBT.func_74757_a("autoStock", this.autoPullItemList);
        aNBT.func_74768_a("minAutoPullStackSize", this.minAutoPullStackSize);
        aNBT.func_74757_a("additionalConnection", this.additionalConnection);
        aNBT.func_74757_a("expediteRecipeCheck", this.expediteRecipeCheck);
        aNBT.func_74768_a("refreshTime", this.autoPullRefreshTime);
        this.getProxy().writeToNBT(aNBT);
    }

    private void setAutoPullItemList(boolean pullItemList) {
        if (!this.autoPullAvailable) {
            return;
        }
        this.autoPullItemList = pullItemList;
        if (!this.autoPullItemList) {
            for (int i = 0; i < 16; ++i) {
                this.mInventory[i] = null;
            }
        } else {
            this.refreshItemList();
        }
        this.updateAllInformationSlots();
    }

    @Override
    public boolean doFastRecipeCheck() {
        return this.expediteRecipeCheck;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int[] sizes;
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("sizes") && (sizes = aNBT.func_74759_k("sizes")).length == 16) {
            for (int i = 0; i < 16; ++i) {
                if (sizes[i] == 0 || this.mInventory[i] == null) continue;
                ItemStack s = this.mInventory[i].func_77946_l();
                s.field_77994_a = sizes[i];
                this.mInventory[i + 16] = s;
            }
        }
        this.autoPullItemList = aNBT.func_74767_n("autoStock");
        this.minAutoPullStackSize = aNBT.func_74762_e("minAutoPullStackSize");
        this.additionalConnection = aNBT.func_74767_n("additionalConnection");
        this.expediteRecipeCheck = aNBT.func_74767_n("expediteRecipeCheck");
        if (aNBT.func_74764_b("refreshTime")) {
            this.autoPullRefreshTime = aNBT.func_74762_e("refreshTime");
        }
        this.getProxy().readFromNBT(aNBT);
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"The bus is " + (this.getProxy() != null && this.getProxy().isActive() ? EnumChatFormatting.GREEN + "online" : EnumChatFormatting.RED + "offline" + this.getAEDiagnostics()) + EnumChatFormatting.RESET};
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.autoPullAvailable) {
            return;
        }
        this.setAutoPullItemList(!this.autoPullItemList);
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.stocking_bus.auto_pull_toggle." + (this.autoPullItemList ? "enabled" : "disabled"), new Object[0]));
    }

    @Override
    public void updateSlots() {
        if (this.mInventory[this.getManualSlot()] != null && this.mInventory[this.getManualSlot()].field_77994_a <= 0) {
            this.mInventory[this.getManualSlot()] = null;
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        if (!this.pasteCopiedData(aPlayer, dataStick.field_77990_d)) {
            return false;
        }
        this.updateValidGridProxySides();
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.stocking_bus.loaded", new Object[0]));
        return true;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return;
        }
        dataStick.field_77990_d = this.getCopiedData(aPlayer);
        dataStick.func_151001_c("Stocking Input Bus Configuration");
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.stocking_bus.saved", new Object[0]));
    }

    @Override
    public String getCopiedDataIdentifier(EntityPlayer player) {
        return COPIED_DATA_IDENTIFIER;
    }

    @Override
    public boolean pasteCopiedData(EntityPlayer player, NBTTagCompound nbt) {
        if (nbt == null || !COPIED_DATA_IDENTIFIER.equals(nbt.func_74779_i("type"))) {
            return false;
        }
        ItemStack circuit = GTUtility.loadItem(nbt, "circuit");
        if (GTUtility.isStackInvalid(circuit)) {
            circuit = null;
        }
        if (this.autoPullAvailable) {
            this.setAutoPullItemList(nbt.func_74767_n("autoPull"));
            this.minAutoPullStackSize = nbt.func_74762_e("minStackSize");
            if (nbt.func_74764_b("refreshTime")) {
                this.autoPullRefreshTime = nbt.func_74762_e("refreshTime");
            }
        }
        this.additionalConnection = nbt.func_74767_n("additionalConnection");
        if (!this.autoPullItemList) {
            NBTTagList stockingItems = nbt.func_150295_c("itemsToStock", 10);
            for (int i = 0; i < stockingItems.func_74745_c(); ++i) {
                this.mInventory[i] = GTUtility.loadItem(stockingItems.func_150305_b(i));
            }
        }
        this.func_70299_a(this.getCircuitSlot(), circuit);
        return true;
    }

    @Override
    public NBTTagCompound getCopiedData(EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", COPIED_DATA_IDENTIFIER);
        tag.func_74757_a("autoPull", this.autoPullItemList);
        tag.func_74768_a("minStackSize", this.minAutoPullStackSize);
        tag.func_74768_a("refreshTime", this.autoPullRefreshTime);
        tag.func_74757_a("additionalConnection", this.additionalConnection);
        tag.func_74782_a("circuit", (NBTBase)GTUtility.saveItem(this.func_70301_a(this.getCircuitSlot())));
        NBTTagList stockingItems = new NBTTagList();
        if (!this.autoPullItemList) {
            for (int index = 0; index < 16; ++index) {
                stockingItems.func_74742_a((NBTBase)GTUtility.saveItem(this.mInventory[index]));
            }
            tag.func_74782_a("itemsToStock", (NBTBase)stockingItems);
        }
        return tag;
    }

    private int getManualSlot() {
        return 33;
    }

    @Override
    public int getCircuitSlot() {
        return 32;
    }

    @Override
    public int getCircuitSlotX() {
        return 80;
    }

    @Override
    public int getCircuitSlotY() {
        return 64;
    }

    @Override
    public boolean setStackToZeroInsteadOfNull(int aIndex) {
        return aIndex != this.getManualSlot();
    }

    @Override
    public boolean justUpdated() {
        if (this.expediteRecipeCheck) {
            boolean ret = this.justHadNewItems;
            this.justHadNewItems = false;
            return ret;
        }
        return false;
    }

    public void setRecipeCheck(boolean value) {
        this.expediteRecipeCheck = value;
    }

    @Override
    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (this.expediteRecipeCheck && aStack != null) {
            this.justHadNewItems = true;
        }
        super.func_70299_a(aIndex, aStack);
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        if (!this.processingRecipe) {
            return super.func_70301_a(aIndex);
        }
        if (aIndex < 0 || aIndex > this.mInventory.length) {
            return null;
        }
        if (aIndex >= 16 && aIndex < 32) {
            return null;
        }
        if (aIndex == this.getCircuitSlot() || aIndex == this.getManualSlot()) {
            return this.mInventory[aIndex];
        }
        if (this.mInventory[aIndex] != null) {
            AENetworkProxy proxy = this.getProxy();
            if (proxy == null || !proxy.isActive()) {
                return null;
            }
            try {
                IMEMonitor sg = proxy.getStorage().getItemInventory();
                AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[aIndex]);
                request.setStackSize(Integer.MAX_VALUE);
                IAEItemStack result = (IAEItemStack)sg.extractItems((IAEStack)request, Actionable.SIMULATE, this.getRequestSource());
                if (result != null) {
                    this.shadowInventory[aIndex] = result.getItemStack();
                    this.savedStackSizes[aIndex] = this.shadowInventory[aIndex].field_77994_a;
                    this.func_70299_a(aIndex + 16, this.shadowInventory[aIndex]);
                    return this.shadowInventory[aIndex];
                }
                this.func_70299_a(aIndex + 16, null);
                return null;
            }
            catch (GridAccessException gridAccessException) {
                return null;
            }
        }
        this.func_70299_a(aIndex + 16, null);
        return this.mInventory[aIndex];
    }

    private BaseActionSource getRequestSource() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    @Override
    public void onExplosion() {
        for (int i = 0; i < 16; ++i) {
            this.mInventory[i] = null;
        }
    }

    @Override
    public void startRecipeProcessing() {
        this.processingRecipe = true;
        this.updateAllInformationSlots();
    }

    private void refreshItemList() {
        AENetworkProxy proxy = this.getProxy();
        try {
            IMEMonitor sg = proxy.getStorage().getItemInventory();
            Iterator iterator = sg.getStorageList().iterator();
            int index = 0;
            while (iterator.hasNext() && index < 16) {
                IAEItemStack currItem = (IAEItemStack)iterator.next();
                if (currItem.getStackSize() < (long)this.minAutoPullStackSize) continue;
                ItemStack itemstack = GTUtility.copyAmount(1, currItem.getItemStack());
                if (this.expediteRecipeCheck) {
                    ItemStack previous = this.mInventory[index];
                    if (itemstack != null) {
                        this.justHadNewItems = !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)previous);
                    }
                }
                this.mInventory[index] = itemstack;
                ++index;
            }
            for (int i = index; i < 16; ++i) {
                this.mInventory[i] = null;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateAllInformationSlots() {
        for (int index = 0; index < 16; ++index) {
            this.updateInformationSlot(index, this.mInventory[index]);
        }
    }

    @Override
    public CheckRecipeResult endRecipeProcessing(MTEMultiBlockBase controller) {
        CheckRecipeResult checkRecipeResult = CheckRecipeResultRegistry.SUCCESSFUL;
        for (int i = 0; i < 16; ++i) {
            if (this.savedStackSizes[i] == 0) continue;
            ItemStack oldStack = this.shadowInventory[i];
            if (oldStack == null || oldStack.field_77994_a < this.savedStackSizes[i]) {
                AENetworkProxy proxy = this.getProxy();
                try {
                    IMEMonitor sg = proxy.getStorage().getItemInventory();
                    AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[i]);
                    int toExtract = this.savedStackSizes[i] - (oldStack == null ? 0 : oldStack.field_77994_a);
                    request.setStackSize((long)toExtract);
                    IAEItemStack result = (IAEItemStack)sg.extractItems((IAEStack)request, Actionable.MODULATE, this.getRequestSource());
                    proxy.getEnergy().extractAEPower((double)request.getStackSize(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.func_70299_a(i + 16, oldStack);
                    if (result == null || result.getStackSize() != (long)toExtract) {
                        controller.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
                        checkRecipeResult = SimpleCheckRecipeResult.ofFailurePersistOnShutdown("stocking_bus_fail_extraction");
                    }
                }
                catch (GridAccessException ignored) {
                    controller.stopMachine(ShutDownReasonRegistry.CRITICAL_NONE);
                    checkRecipeResult = SimpleCheckRecipeResult.ofFailurePersistOnShutdown("stocking_hatch_fail_extraction");
                }
            }
            this.savedStackSizes[i] = 0;
            this.shadowInventory[i] = null;
            if (this.mInventory[i + 16] == null || this.mInventory[i + 16].field_77994_a > 0) continue;
            this.mInventory[i + 16] = null;
        }
        this.processingRecipe = false;
        return checkRecipeResult;
    }

    public ItemStack updateInformationSlot(int aIndex, ItemStack aStack) {
        if (aIndex >= 0 && aIndex < 16) {
            if (aStack == null) {
                super.func_70299_a(aIndex + 16, null);
            } else {
                AENetworkProxy proxy = this.getProxy();
                if (!proxy.isActive()) {
                    super.func_70299_a(aIndex + 16, null);
                    return null;
                }
                try {
                    ItemStack s;
                    IMEMonitor sg = proxy.getStorage().getItemInventory();
                    AEItemStack request = AEItemStack.create((ItemStack)this.mInventory[aIndex]);
                    request.setStackSize(Integer.MAX_VALUE);
                    IAEItemStack result = (IAEItemStack)sg.extractItems((IAEStack)request, Actionable.SIMULATE, this.getRequestSource());
                    ItemStack itemStack = s = result != null ? result.getItemStack() : null;
                    if (this.expediteRecipeCheck) {
                        ItemStack previous = this.func_70301_a(aIndex + 16);
                        if (s != null) {
                            this.justHadNewItems = !ItemStack.func_77989_b((ItemStack)s, (ItemStack)previous);
                        }
                    }
                    this.func_70299_a(aIndex + 16, s);
                    return s;
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public ItemStack getShadowItemStack(int index) {
        if (index < 0 || index >= this.shadowInventory.length) {
            return null;
        }
        return this.shadowInventory[index];
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex == this.getManualSlot();
    }

    @Override
    public int getGUIHeight() {
        return 179;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        final SlotWidget[] aeSlotWidgets = new SlotWidget[16];
        if (this.autoPullAvailable) {
            buildContext.addSyncedWindow(10, this::createStackSizeConfigurationWindow);
        }
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).phantom(true).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index, true){

            public boolean isEnabled() {
                return !MTEHatchInputBusME.this.autoPullItemList && super.isEnabled();
            }
        }).widgetCreator(slot -> (SlotWidget)new SlotWidget((BaseSlot)slot){

            protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
                if (clickData.mouseButton != 0 || !this.getMcSlot().isEnabled()) {
                    return;
                }
                int aSlotIndex = this.getMcSlot().getSlotIndex();
                if (cursorStack == null) {
                    this.getMcSlot().func_75215_d(null);
                } else {
                    if (this.containsSuchStack(cursorStack)) {
                        return;
                    }
                    this.getMcSlot().func_75215_d(GTUtility.copyAmount(1, cursorStack));
                }
                if (MTEHatchInputBusME.this.getBaseMetaTileEntity().isServerSide()) {
                    ItemStack newInfo = MTEHatchInputBusME.this.updateInformationSlot(aSlotIndex, cursorStack);
                    aeSlotWidgets[this.getMcSlot().getSlotIndex()].getMcSlot().func_75215_d(newInfo);
                }
            }

            public IDrawable[] getBackground() {
                AdaptableUITexture slot = MTEHatchInputBusME.this.autoPullItemList ? GTUITextures.SLOT_DARK_GRAY : ModularUITextures.ITEM_SLOT;
                return new IDrawable[]{slot, GTUITextures.OVERLAY_SLOT_ARROW_ME};
            }

            public List<String> getExtraTooltip() {
                if (MTEHatchInputBusME.this.autoPullItemList) {
                    return Collections.singletonList(StatCollector.func_74838_a((String)"GT5U.machines.stocking_bus.cannot_set_slot"));
                }
                return Collections.singletonList(StatCollector.func_74838_a((String)"modularui.phantom.single.clear"));
            }

            private boolean containsSuchStack(ItemStack tStack) {
                for (int i = 0; i < 16; ++i) {
                    if (!GTUtility.areStacksEqual(MTEHatchInputBusME.this.mInventory[i], tStack, false)) continue;
                    return true;
                }
                return false;
            }
        }.dynamicTooltip(() -> {
            if (this.autoPullItemList) {
                return Collections.singletonList(StatCollector.func_74838_a((String)"GT5U.machines.stocking_bus.cannot_set_slot"));
            }
            return Collections.emptyList();
        }).setUpdateTooltipEveryTick(true)).build().setPos(7, 9))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(16).endAtSlot(31).phantom(true).background(new IDrawable[]{GTUITextures.SLOT_DARK_GRAY}).widgetCreator(slot -> {
            SlotWidget slotWidget = new AESlotWidget((BaseSlot)slot).disableInteraction();
            aeSlotWidgets[slot.getSlotIndex() - 16] = slotWidget;
            return slotWidget;
        }).build().setPos(97, 9))).widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_ARROW_DOUBLE).setPos(82, 30).setSize(12, 12));
        if (this.autoPullAvailable) {
            ((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                if (clickData.mouseButton == 0) {
                    this.setAutoPullItemList(!this.autoPullItemList);
                } else if (clickData.mouseButton == 1 && !widget.isClient()) {
                    widget.getContext().openSyncedWindow(10);
                }
            }).setBackground(() -> {
                if (this.autoPullItemList) {
                    return new IDrawable[]{GTUITextures.BUTTON_STANDARD_PRESSED, GTUITextures.OVERLAY_BUTTON_AUTOPULL_ME};
                }
                return new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_AUTOPULL_ME_DISABLED};
            }).addTooltips(Arrays.asList(StatCollector.func_74838_a((String)"GT5U.machines.stocking_bus.auto_pull.tooltip.1"), StatCollector.func_74838_a((String)"GT5U.machines.stocking_bus.auto_pull.tooltip.2"))).setSize(16, 16).setPos(80, 10))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.autoPullItemList, this::setAutoPullItemList));
        }
        ((ModularWindow.Builder)builder.widget(TextWidget.dynamicString(() -> {
            boolean isActive = this.isActive();
            boolean isPowered = this.isPowered();
            boolean isBooting = this.isBooting();
            EnumChatFormatting color = isActive && isPowered ? EnumChatFormatting.GREEN : EnumChatFormatting.DARK_RED;
            return color + WailaText.getPowerState((boolean)isActive, (boolean)isPowered, (boolean)isBooting);
        }).setTextAlignment(Alignment.Center).setSize(90, 9).setPos(43, 84))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.getManualSlot()).setShiftClickPriority(11).setPos(79, 45));
    }

    protected ModularWindow createStackSizeConfigurationWindow(EntityPlayer player) {
        int WIDTH = 78;
        int HEIGHT = 115;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)78, (int)115);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.TopRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(78, 115)).add(75, 0)));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.stocking_bus.min_stack_size", (Object[])new Object[0]).setPos(3, 2).setSize(74, 14))).widget(new NumericWidget().setSetter(val -> {
            this.minAutoPullStackSize = (int)val;
        }).setGetter(() -> this.minAutoPullStackSize).setBounds(1.0, 2.147483647E9).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(3, 18).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.stocking_bus.refresh_time", (Object[])new Object[0]).setPos(3, 42).setSize(74, 14))).widget(new NumericWidget().setSetter(val -> {
            this.autoPullRefreshTime = (int)val;
        }).setGetter(() -> this.autoPullRefreshTime).setBounds(1.0, 2.147483647E9).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(3, 58).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.stocking_bus.force_check", (Object[])new Object[0]).setPos(3, 88).setSize(50, 14))).widget(new CycleButtonWidget().setToggle(() -> this.expediteRecipeCheck, val -> this.setRecipeCheck((boolean)val)).setTextureGetter(state -> this.expediteRecipeCheck ? GTUITextures.OVERLAY_BUTTON_CHECKMARK : GTUITextures.OVERLAY_BUTTON_CROSS).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(53, 87).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"GT5U.machines.stocking_bus.hatch_warning")));
        return builder.build();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(80, 63));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!this.autoPullAvailable) {
            super.getWailaBody(itemStack, currenttip, accessor, config);
            return;
        }
        NBTTagCompound tag = accessor.getNBTData();
        boolean autopull = tag.func_74767_n("autoPull");
        int minSize = tag.func_74762_e("minStackSize");
        currenttip.add(StatCollector.func_74838_a((String)("GT5U.waila.stocking_bus.auto_pull." + (autopull ? "enabled" : "disabled"))));
        if (autopull) {
            currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.stocking_bus.min_stack_size", (Object[])new Object[]{GTUtility.formatNumbers(minSize)}));
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        if (!this.autoPullAvailable) {
            super.getWailaNBTData(player, tile, tag, world, x, y, z);
            return;
        }
        tag.func_74757_a("autoPull", this.autoPullItemList);
        tag.func_74768_a("minStackSize", this.minAutoPullStackSize);
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    private static String[] getDescriptionArray(boolean autoPullAvailable) {
        ArrayList<String> strings = new ArrayList<String>(8);
        strings.add("Advanced item input for Multiblocks");
        strings.add("Hatch Tier: " + GTValues.TIER_COLORS[autoPullAvailable ? 6 : 3] + GTValues.VN[autoPullAvailable ? 6 : 3]);
        strings.add("Retrieves directly from ME");
        strings.add("Keeps 16 item types in stock");
        if (autoPullAvailable) {
            strings.add("Auto-Pull from ME mode will automatically stock the first 16 items in the ME system, updated every 5 seconds.");
            strings.add("Toggle by right-clicking with screwdriver, or use the GUI.");
            strings.add("Use the GUI to limit the minimum stack size for Auto-Pulling, adjust the slot refresh timer and enable fast recipe checks.");
            strings.add("WARNING: Fast recipe checks can be laggy. Use with caution.");
        }
        strings.add("Change ME connection behavior by right-clicking with wire cutter.");
        strings.add("Configuration data can be copy+pasted using a data stick.");
        return strings.toArray(new String[0]);
    }
}

