/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.AEApi;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.items.storage.ItemBasicStorageCell;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.GTMod;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchOutputBusME
extends MTEHatchOutputBus
implements IPowerChannelState {
    private long baseCapacity = 1600L;
    private BaseActionSource requestSource = null;
    @Nullable
    private AENetworkProxy gridProxy = null;
    final IItemList<IAEItemStack> itemCache = AEApi.instance().storage().createItemList();
    long lastOutputTick = 0L;
    long lastInputTick = 0L;
    long tickCounter = 0L;
    boolean additionalConnection = false;

    public MTEHatchOutputBusME(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 3, new String[]{"Item Output for Multiblocks", "Stores directly into ME", "Can cache 1600 items by default", "Change cache size by inserting a storage cell", "Change ME connection behavior by right-clicking with wire cutter"}, 1);
    }

    public MTEHatchOutputBusME(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchOutputBusME(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_HATCH_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_HATCH)};
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    @Override
    public boolean storeAll(ItemStack aStack) {
        aStack.field_77994_a = this.store(aStack);
        return aStack.field_77994_a == 0;
    }

    private long getCachedAmount() {
        long itemAmount = 0L;
        for (IAEItemStack item : this.itemCache) {
            itemAmount += item.getStackSize();
        }
        return itemAmount;
    }

    private long getCacheCapacity() {
        ItemStack upgradeItemStack = this.mInventory[0];
        if (upgradeItemStack != null && upgradeItemStack.func_77973_b() instanceof ItemBasicStorageCell) {
            return ((ItemBasicStorageCell)upgradeItemStack.func_77973_b()).getBytesLong(upgradeItemStack) * 8L;
        }
        return this.baseCapacity;
    }

    public boolean canAcceptItem() {
        return this.getCachedAmount() < this.getCacheCapacity();
    }

    public int store(ItemStack stack) {
        if (this.canAcceptItem() || this.lastInputTick == this.tickCounter) {
            this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(stack));
            this.lastInputTick = this.tickCounter;
            return 0;
        }
        return stack.field_77994_a;
    }

    private BaseActionSource getRequest() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing(forgeDirection) ? AECableType.SMART : AECableType.NONE;
    }

    private void updateValidGridProxySides() {
        if (this.additionalConnection) {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
        } else {
            this.getProxy().setValidSides(EnumSet.of(this.getBaseMetaTileEntity().getFrontFacing()));
        }
    }

    @Override
    public void onFacingChange() {
        this.updateValidGridProxySides();
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverInfoAtSide(side).isGUIClickable()) {
            return;
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.additionalConnection = !this.additionalConnection;
        this.updateValidGridProxySides();
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.hatch.additionalConnection." + this.additionalConnection, new Object[0]));
        return true;
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", ItemList.Hatch_Output_Bus_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.updateValidGridProxySides();
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    private void flushCachedStack() {
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null) {
            return;
        }
        try {
            IMEMonitor sg = proxy.getStorage().getItemInventory();
            for (IAEItemStack s : this.itemCache) {
                if (s.getStackSize() == 0L) continue;
                IAEItemStack rest = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)sg, (IAEStack)s, (BaseActionSource)this.getRequest());
                if (rest != null && rest.getStackSize() > 0L) {
                    s.setStackSize(rest.getStackSize());
                    break;
                }
                s.setStackSize(0L);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.lastOutputTick = this.tickCounter;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.tickCounter = aTick;
            if (this.tickCounter > this.lastOutputTick + 40L) {
                this.flushCachedStack();
            }
            if (this.tickCounter % 20L == 0L) {
                this.getBaseMetaTileEntity().setActive(this.isActive());
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("baseCapacity")) {
            tooltip.add("Current cache capacity: " + EnumChatFormatting.YELLOW + ReadableNumberConverter.INSTANCE.toWideReadableForm(stack.field_77990_d.func_74763_f("baseCapacity")));
        }
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        aNBT.func_74772_a("baseCapacity", this.baseCapacity);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagList items = new NBTTagList();
        for (IAEItemStack s : this.itemCache) {
            if (s.getStackSize() == 0L) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("itemStack", (NBTBase)GTUtility.saveItem(s.getItemStack()));
            tag.func_74772_a("size", s.getStackSize());
            items.func_74742_a((NBTBase)tag);
        }
        aNBT.func_74757_a("additionalConnection", this.additionalConnection);
        aNBT.func_74782_a("cachedItems", (NBTBase)items);
        aNBT.func_74772_a("baseCapacity", this.baseCapacity);
        this.getProxy().writeToNBT(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTBase t = aNBT.func_74781_a("cachedStack");
        if (t instanceof NBTTagCompound) {
            this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(GTUtility.loadItem((NBTTagCompound)t)));
        }
        if ((t = aNBT.func_74781_a("cachedItems")) instanceof NBTTagList) {
            NBTTagList l = (NBTTagList)t;
            for (int i = 0; i < l.func_74745_c(); ++i) {
                NBTTagCompound tag = l.func_150305_b(i);
                if (!tag.func_74764_b("itemStack")) {
                    this.itemCache.add((IAEStack)AEApi.instance().storage().createItemStack(GTUtility.loadItem(l.func_150305_b(i))));
                    continue;
                }
                NBTTagCompound tagItemStack = tag.func_74775_l("itemStack");
                IAEItemStack s = AEApi.instance().storage().createItemStack(GTUtility.loadItem(tagItemStack));
                if (s != null) {
                    s.setStackSize(tag.func_74763_f("size"));
                    this.itemCache.add((IAEStack)s);
                    continue;
                }
                GTMod.GT_FML_LOGGER.warn("An error occurred while loading contents of ME Output Bus. This item has been voided: " + tagItemStack);
            }
        }
        this.additionalConnection = aNBT.func_74767_n("additionalConnection");
        this.baseCapacity = aNBT.func_74763_f("baseCapacity");
        if (this.baseCapacity == 0L) {
            this.baseCapacity = Long.MAX_VALUE;
        }
        this.getProxy().readFromNBT(aNBT);
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> ss = new ArrayList<String>();
        ss.add("The bus is " + (this.getProxy() != null && this.getProxy().isActive() ? EnumChatFormatting.GREEN + "online" : EnumChatFormatting.RED + "offline" + this.getAEDiagnostics()) + EnumChatFormatting.RESET);
        ReadableNumberConverter nc = ReadableNumberConverter.INSTANCE;
        ss.add("Item cache capacity: " + nc.toWideReadableForm(this.getCacheCapacity()));
        if (this.itemCache.isEmpty()) {
            ss.add("The bus has no cached items");
        } else {
            ss.add(String.format("The bus contains %d cached stacks: ", this.itemCache.size()));
            int counter = 0;
            for (IAEItemStack s : this.itemCache) {
                ss.add(s.getItem().func_77653_i(s.getItemStack()) + ": " + EnumChatFormatting.GOLD + nc.toWideReadableForm(s.getStackSize()) + EnumChatFormatting.RESET);
                if (++counter <= 100) continue;
                break;
            }
        }
        return ss.toArray(new String[this.itemCache.size() + 2]);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.getBaseMetaTileEntity().add1by1Slot(builder, new IDrawable[0]);
    }

    @Override
    public boolean acceptsItemLock() {
        return false;
    }
}

