/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.SteamVariant;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTWaila;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.MTEPrimitiveBlastFurnace;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class MTEBrickedBlastFurnace
extends MTEPrimitiveBlastFurnace
implements ISecondaryDescribable {
    private static final ITexture[] FACING_SIDE = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_DENSEBRICKS)};
    private static final ITexture[] FACING_FRONT = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_INACTIVE)};
    private static final ITexture[] FACING_ACTIVE = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE_GLOW).glow().build()};
    private MultiblockTooltipBuilder tooltipBuilder;

    public MTEBrickedBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEBrickedBlastFurnace(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        return this.getCurrentDescription();
    }

    @Override
    public boolean isDisplaySecondaryDescription() {
        return Keyboard.isKeyDown((int)42);
    }

    @Override
    public String[] getPrimaryDescription() {
        return this.getTooltip().getInformation();
    }

    @Override
    public String[] getSecondaryDescription() {
        return this.getTooltip().getStructureInformation();
    }

    protected MultiblockTooltipBuilder getTooltip() {
        if (this.tooltipBuilder == null) {
            this.tooltipBuilder = new MultiblockTooltipBuilder();
            this.tooltipBuilder.addMachineType("Blast Furnace").addInfo("Controller Block for the Bricked Blast Furnace").addInfo("Usable for Steel and general Pyrometallurgy").addInfo("Has a useful interface, unlike other gregtech multis").addPollutionAmount(GTMod.gregtechproxy.mPollutionPrimitveBlastFurnacePerSecond).addSeparator().beginStructureBlock(3, 4, 3, true).addController("Front center").addOtherStructurePart("Firebricks", "Everything except the controller").addStructureInfo("The top block is also empty").addStructureInfo("You can share the walls of GT multis, so").addStructureInfo("each additional one costs less, up to 4").toolTipFinisher("Gregtech");
        }
        return this.tooltipBuilder;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            return aActive ? FACING_ACTIVE : FACING_FRONT;
        }
        return FACING_SIDE;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBrickedBlastFurnace(this.mName);
    }

    @Override
    protected Block getCasingBlock() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    protected int getCasingMetaID() {
        return 15;
    }

    @Override
    public String getName() {
        return "Bricked Blast Furnace";
    }

    @Override
    public SteamVariant getSteamVariant() {
        return SteamVariant.PRIMITIVE;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        if (!this.getBaseMetaTileEntity().isInvalidTileEntity()) {
            NBTTagCompound nbt = accessor.getNBTData();
            currenttip.add(GTWaila.getMachineProgressString(this.getBaseMetaTileEntity().isActive(), nbt.func_74762_e("mMaxProgressTime"), nbt.func_74762_e("mProgressTime")));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (!this.getBaseMetaTileEntity().isInvalidTileEntity()) {
            tag.func_74768_a("mProgressTime", this.getProgresstime());
            tag.func_74768_a("mMaxProgressTime", this.maxProgresstime());
        }
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.getTooltip().getStructureHint();
    }
}

