/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.gui.widgets.LockedWhileActiveButton;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDataAccess;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.objects.GTChunkManager;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.IMachineMessage;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public abstract class MTEDrillerBase
extends MTEEnhancedMultiBlockBase<MTEDrillerBase>
implements IChunkLoader,
ISurvivalConstructable {
    private static final ItemStack miningPipe = GTModHandler.getIC2Item("miningPipe", 0L);
    private static final ItemStack miningPipeTip = GTModHandler.getIC2Item("miningPipeTip", 0L);
    private static final Block miningPipeBlock = GTUtility.getBlockFromStack(miningPipe);
    private static final Block miningPipeTipBlock = GTUtility.getBlockFromStack(miningPipeTip);
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static final ClassValue<IStructureDefinition<MTEDrillerBase>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<MTEDrillerBase>>(){

        @Override
        protected IStructureDefinition<MTEDrillerBase> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(MTEDrillerBase.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"   ", " f ", "   "}, {"   ", " f ", "   "}, {"   ", " f ", "   "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {" f ", "fcf", " f "}, {"b~b", "bbb", "bbb"}})).addElement('f', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.ofFrame(t.getFrameMaterial()))).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlockItem().getBlock(), (int)t.getCasingBlockItem().get(0L, new Object[0]).func_77960_j()))).addElement('b', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTEDrillerBase.class).atLeastList(t.getAllowedHatches()).adder(MTEDrillerBase::addToMachineList).casingIndex(t.casingTextureIndex).dot(1).buildAndChain(t.getCasingBlockItem().getBlock(), t.getCasingBlockItem().get(0L, new Object[0]).func_77960_j()))).build();
        }
    };
    private Block casingBlock;
    private int casingMeta;
    private int frameMeta;
    protected int casingTextureIndex;
    protected boolean isPickingPipes;
    private ForgeDirection back;
    private int xDrill;
    private int yDrill;
    private int zDrill;
    private int xPipe;
    private int zPipe;
    private int yHead;
    protected int workState;
    protected static final int STATE_DOWNWARD = 0;
    protected static final int STATE_AT_BOTTOM = 1;
    protected static final int STATE_UPWARD = 2;
    protected static final int STATE_ABORT = 3;
    protected boolean mChunkLoadingEnabled = true;
    protected ChunkCoordIntPair mCurrentChunk = null;
    protected boolean mWorkChunkNeedsReload = true;
    private final Map<ResultRegistryKey, CheckRecipeResult> resultRegistry = new HashMap<ResultRegistryKey, CheckRecipeResult>();
    private CheckRecipeResult runtimeFailure = null;
    private CheckRecipeResult lastRuntimeFailure = null;
    @NotNull
    private String shutdownReason = "";
    protected boolean suppressErrorWipe = false;
    private FakePlayer mFakePlayer = null;
    public ArrayList<MTEHatchDataAccess> mDataAccessHatches = new ArrayList();

    protected int getXDrill() {
        return this.xDrill;
    }

    protected int getZDrill() {
        return this.zDrill;
    }

    protected int getYHead() {
        return this.yHead;
    }

    public MTEDrillerBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.initFields();
    }

    public MTEDrillerBase(String aName) {
        super(aName);
        this.initFields();
    }

    private void initFields() {
        this.casingBlock = this.getCasingBlockItem().getBlock();
        this.casingMeta = this.getCasingBlockItem().get(0L, new Object[0]).func_77960_j();
        int frameId = 4096 + this.getFrameMaterial().mMetaItemSubID;
        this.frameMeta = GregTechAPI.METATILEENTITIES[frameId] != null ? (int)GregTechAPI.METATILEENTITIES[frameId].getTileEntityBaseType() : Short.MAX_VALUE;
        this.casingTextureIndex = this.getCasingTextureIndex();
        this.workState = 0;
        this.addResultMessage(0, true, "deploying_pipe");
        this.addResultMessage(0, false, "extracting_pipe");
        this.addResultMessage(1, true, "drilling");
        this.addResultMessage(1, false, "no_mining_pipe");
        this.addResultMessage(2, true, "retracting_pipe");
        this.addResultMessage(2, false, "drill_generic_finished");
        this.addResultMessage(3, true, "retracting_pipe");
        this.addResultMessage(3, false, "drill_retract_pipes_finished");
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex)};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("workState", this.workState);
        aNBT.func_74757_a("chunkLoadingEnabled", this.mChunkLoadingEnabled);
        aNBT.func_74757_a("isChunkloading", this.mCurrentChunk != null);
        if (this.mCurrentChunk != null) {
            aNBT.func_74768_a("loadedChunkXPos", this.mCurrentChunk.field_77276_a);
            aNBT.func_74768_a("loadedChunkZPos", this.mCurrentChunk.field_77275_b);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.workState = aNBT.func_74762_e("workState");
        if (aNBT.func_74764_b("isPickingPipes")) {
            int n = this.workState = aNBT.func_74767_n("isPickingPipes") ? 2 : 0;
        }
        if (aNBT.func_74764_b("chunkLoadingEnabled")) {
            this.mChunkLoadingEnabled = aNBT.func_74767_n("chunkLoadingEnabled");
        }
        if (aNBT.func_74767_n("isChunkloading")) {
            this.mCurrentChunk = new ChunkCoordIntPair(aNBT.func_74762_e("loadedChunkXPos"), aNBT.func_74762_e("loadedChunkZPos"));
        }
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mChunkLoadingEnabled = !this.mChunkLoadingEnabled;
            GTUtility.sendChatToPlayer(entityPlayer, this.mChunkLoadingEnabled ? GTUtility.trans("502", "Mining chunk loading enabled") : GTUtility.trans("503", "Mining chunk loading disabled"));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, entityPlayer, aX, aY, aZ);
    }

    @Override
    public void onRemoval() {
        if (this.mChunkLoadingEnabled) {
            GTChunkManager.releaseTicket((TileEntity)this.getBaseMetaTileEntity());
        }
        super.onRemoval();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mCurrentChunk != null && !this.mWorkChunkNeedsReload && !aBaseMetaTileEntity.isAllowedToWork()) {
            GTChunkManager.releaseTicket((TileEntity)aBaseMetaTileEntity);
            this.mWorkChunkNeedsReload = true;
        }
    }

    protected boolean tryPickPipe() {
        if (this.yHead == this.yDrill) {
            this.isPickingPipes = false;
            return false;
        }
        if (this.tryOutputPipe()) {
            if (this.checkBlockAndMeta(this.xPipe, this.yHead + 1, this.zPipe, miningPipeBlock, Short.MAX_VALUE)) {
                this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead + 1, this.zPipe, miningPipeTipBlock);
            }
            this.getBaseMetaTileEntity().getWorld().func_147468_f(this.xPipe, this.yHead, this.zPipe);
            this.isPickingPipes = true;
            return true;
        }
        this.isPickingPipes = false;
        return false;
    }

    protected int tryLowerPipeState() {
        return this.tryLowerPipeState(false);
    }

    protected int tryLowerPipeState(boolean isSimulating) {
        if (!this.isHasMiningPipes()) {
            return 2;
        }
        switch (this.canLowerPipe()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        Block b = this.getBaseMetaTileEntity().getBlock(this.xPipe, this.yHead - 1, this.zPipe);
        if (b != miningPipeTipBlock && !GTUtility.setBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), this.xPipe, this.yHead - 1, this.zPipe, miningPipeTipBlock, 0, isSimulating)) {
            return 3;
        }
        if (!isSimulating) {
            if (this.yHead != this.yDrill) {
                this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead, this.zPipe, miningPipeBlock);
            }
            if (b != miningPipeBlock && b != miningPipeTipBlock) {
                this.getBaseMetaTileEntity().func_70298_a(1, 1);
            }
        }
        return 0;
    }

    private void putMiningPipesFromInputsInController() {
        int maxPipes = miningPipe.func_77976_d();
        if (this.isHasMiningPipes(maxPipes)) {
            return;
        }
        ItemStack pipes = this.func_70301_a(1);
        if (pipes != null && !pipes.func_77969_a(miningPipe)) {
            return;
        }
        for (ItemStack storedItem : this.getStoredInputs()) {
            if (!storedItem.func_77969_a(miningPipe)) continue;
            if (pipes == null) {
                this.func_70299_a(1, GTUtility.copyOrNull(miningPipe));
                pipes = this.func_70301_a(1);
            }
            if (pipes.field_77994_a == maxPipes) break;
            int needPipes = maxPipes - pipes.field_77994_a;
            int transferPipes = Math.min(storedItem.field_77994_a, needPipes);
            pipes.field_77994_a += transferPipes;
            storedItem.field_77994_a -= transferPipes;
        }
        this.updateSlots();
    }

    private boolean tryOutputPipe() {
        if (!this.getBaseMetaTileEntity().addStackToSlot(1, GTUtility.copyAmount(1, miningPipe))) {
            this.mOutputItems = new ItemStack[]{GTUtility.copyAmount(1, miningPipe)};
        }
        return true;
    }

    protected int canLowerPipe() {
        IGregTechTileEntity aBaseTile = this.getBaseMetaTileEntity();
        if (this.yHead > 0 && GTUtility.getBlockHardnessAt(aBaseTile.getWorld(), this.xPipe, this.yHead - 1, this.zPipe) >= 0.0f) {
            return GTUtility.eraseBlockByFakePlayer(this.getFakePlayer(aBaseTile), this.xPipe, this.yHead - 1, this.zPipe, true) ? 0 : 2;
        }
        return 1;
    }

    protected boolean reachingVoidOrBedrock() {
        return this.yHead <= 0 || this.checkBlockAndMeta(this.xPipe, this.yHead - 1, this.zPipe, Blocks.field_150357_h, Short.MAX_VALUE);
    }

    private boolean isHasMiningPipes() {
        return this.isHasMiningPipes(1);
    }

    private boolean isHasMiningPipes(int minCount) {
        ItemStack pipe = this.func_70301_a(1);
        return pipe != null && pipe.field_77994_a > minCount - 1 && pipe.func_77969_a(miningPipe);
    }

    @Deprecated
    protected boolean waitForPipes() {
        return !this.isHasMiningPipes();
    }

    private boolean isEnergyEnough() {
        long requiredEnergy = 512L + this.getMaxInputVoltage() * 4L;
        for (MTEHatchEnergy energyHatch : this.mEnergyHatches) {
            if ((requiredEnergy -= energyHatch.getEUVar()) > 0L) continue;
            return true;
        }
        return false;
    }

    protected boolean workingDownward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        switch (this.tryLowerPipeState()) {
            case 2: {
                this.mMaxProgresstime = 0;
                this.setRuntimeFailureReason(CheckRecipeResultRegistry.MISSING_MINING_PIPE);
                return false;
            }
            case 3: {
                this.workState = 2;
                return true;
            }
            case 1: {
                this.workState = 1;
                return true;
            }
        }
        return true;
    }

    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.tryLowerPipeState(true) == 0) {
            this.workState = 0;
            return true;
        }
        this.workState = 2;
        return true;
    }

    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.tryPickPipe()) {
            return true;
        }
        this.workState = 0;
        this.stopMachine(ShutDownReasonRegistry.NONE);
        return false;
    }

    protected void onAbort() {
    }

    protected void abortDrilling() {
        if (this.workState != 3) {
            this.workState = 3;
            this.onAbort();
            this.setShutdownReason("");
            if (!this.isAllowedToWork()) {
                this.enableWorking();
            }
        }
    }

    protected boolean workingToAbortOperation(@NotNull ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.tryPickPipe()) {
            return true;
        }
        this.workState = 0;
        this.stopMachine(ShutDownReasonRegistry.NONE);
        return false;
    }

    @Override
    public void enableWorking() {
        super.enableWorking();
        this.shutdownReason = "";
    }

    @Override
    public void onDisableWorking() {
        if (this.suppressErrorWipe) {
            this.suppressErrorWipe = false;
        } else {
            super.onDisableWorking();
        }
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        boolean wasSuccessful;
        ItemStack controllerStack = this.getControllerSlot();
        this.setElectricityStats();
        int oldYHead = this.yHead;
        if (!this.checkPipesAndSetYHead()) {
            this.stopMachine(ShutDownReasonRegistry.NONE);
            return SimpleCheckRecipeResult.ofFailure("no_mining_pipe");
        }
        if (!this.isEnergyEnough()) {
            this.stopMachine(ShutDownReasonRegistry.NONE);
            return SimpleCheckRecipeResult.ofFailure("not_enough_energy");
        }
        this.putMiningPipesFromInputsInController();
        switch (this.workState) {
            case 0: {
                wasSuccessful = this.workingDownward(controllerStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
                break;
            }
            case 1: {
                wasSuccessful = this.workingAtBottom(controllerStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
                break;
            }
            case 2: {
                wasSuccessful = this.workingUpward(controllerStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
                break;
            }
            case 3: {
                wasSuccessful = this.workingToAbortOperation(controllerStack, this.xDrill, this.yDrill, this.zDrill, this.xPipe, this.zPipe, this.yHead, oldYHead);
                break;
            }
            default: {
                wasSuccessful = false;
            }
        }
        if (this.runtimeFailure == null) {
            if (wasSuccessful) {
                this.lastRuntimeFailure = null;
            }
            return this.resultRegistry.getOrDefault(new ResultRegistryKey(this.workState, wasSuccessful), SimpleCheckRecipeResult.ofFailure("no_mining_pipe"));
        }
        CheckRecipeResult result = this.lastRuntimeFailure = this.runtimeFailure;
        this.runtimeFailure = null;
        return result;
    }

    protected void setRuntimeFailureReason(@NotNull CheckRecipeResult newFailureReason) {
        this.runtimeFailure = newFailureReason;
    }

    @NotNull
    protected Optional<String> getFailureReason() {
        if (this.getBaseMetaTileEntity().isActive()) {
            return Optional.empty();
        }
        if (!this.shutdownReason.isEmpty()) {
            return Optional.of(this.shutdownReason);
        }
        return Optional.ofNullable(this.lastRuntimeFailure).map(IMachineMessage::getDisplayString);
    }

    protected void setShutdownReason(@NotNull String newReason) {
        this.shutdownReason = newReason;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> (d.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public boolean isRotationChangeAllowed() {
        return false;
    }

    @Override
    public final IStructureDefinition<MTEDrillerBase> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.updateCoordinates();
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 6, 0) && this.checkHatches() && GTUtility.getTier(this.getMaxInputVoltage()) >= this.getMinTier() && this.mMaintenanceHatches.size() == 1;
    }

    private void updateCoordinates() {
        this.xDrill = this.getBaseMetaTileEntity().getXCoord();
        this.yDrill = this.getBaseMetaTileEntity().getYCoord();
        this.zDrill = this.getBaseMetaTileEntity().getZCoord();
        this.back = this.getBaseMetaTileEntity().getBackFacing();
        this.xPipe = this.xDrill + this.back.offsetX;
        this.zPipe = this.zDrill + this.back.offsetZ;
    }

    private boolean checkPipesAndSetYHead() {
        this.yHead = this.yDrill - 1;
        while (this.checkBlockAndMeta(this.xPipe, this.yHead, this.zPipe, miningPipeBlock, Short.MAX_VALUE)) {
            --this.yHead;
        }
        if (this.checkBlockAndMeta(this.xPipe, this.yHead, this.zPipe, miningPipeTipBlock, Short.MAX_VALUE) || ++this.yHead == this.yDrill) {
            return true;
        }
        this.getBaseMetaTileEntity().getWorld().func_147449_b(this.xPipe, this.yHead, this.zPipe, miningPipeTipBlock);
        return true;
    }

    private boolean checkBlockAndMeta(int x, int y, int z, Block block, int meta) {
        return (meta == Short.MAX_VALUE || this.getBaseMetaTileEntity().getMetaID(x, y, z) == meta) && this.getBaseMetaTileEntity().getBlock(x, y, z) == block;
    }

    protected FakePlayer getFakePlayer(IGregTechTileEntity aBaseTile) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GTUtility.getFakePlayer(aBaseTile);
        }
        this.mFakePlayer.func_70029_a(aBaseTile.getWorld());
        this.mFakePlayer.func_70107_b((double)aBaseTile.getXCoord(), (double)aBaseTile.getYCoord(), (double)aBaseTile.getZCoord());
        return this.mFakePlayer;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected abstract ItemList getCasingBlockItem();

    protected abstract Materials getFrameMaterial();

    protected abstract int getCasingTextureIndex();

    protected abstract int getMinTier();

    protected abstract boolean checkHatches();

    protected abstract void setElectricityStats();

    public int getTotalConfigValue() {
        int config = 0;
        ArrayList<ItemStack> tCircuitList = this.getDataItems(1);
        for (ItemStack tCircuit : tCircuitList) {
            config += tCircuit.func_77960_j();
        }
        return config;
    }

    private boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual(aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual(aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GTUtility.isStackValid(this.mInventory[1]) && this.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (MTEHatchDataAccess tHatch : GTUtility.validMTEList(this.mDataAccessHatches)) {
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null || !this.isCorrectDataItem(tHatch.getBaseMetaTileEntity().func_70301_a(i), state)) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return super.addToMachineList(aTileEntity, aBaseCasingIndex) || this.addDataAccessToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchDataAccess) {
            ((MTEHatch)aMetaTileEntity).updateTexture((byte)aBaseCasingIndex);
            return this.mDataAccessHatches.add((MTEHatchDataAccess)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public ChunkCoordIntPair getActiveChunk() {
        return this.mCurrentChunk;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 6, 0, elementBudget, env, false, true);
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)screenElements.widget(TextWidget.dynamicString(() -> this.shutdownReason).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive() && !this.shutdownReason.isEmpty()))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.shutdownReason, newString -> {
            this.shutdownReason = newString;
        }));
    }

    @Override
    protected boolean showRecipeTextInGUI() {
        return false;
    }

    protected List<ButtonWidget> getAdditionalButtons(ModularWindow.Builder builder, UIBuildContext buildContext) {
        return ImmutableList.of();
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        int BUTTON_Y_LEVEL = 91;
        ((ModularWindow.Builder)builder.widget(new LockedWhileActiveButton(this.getBaseMetaTileEntity(), builder).setOnClick((clickData, widget) -> {
            this.mChunkLoadingEnabled = !this.mChunkLoadingEnabled;
        }).setPlayClickSound(true).setBackground(() -> {
            if (this.mChunkLoadingEnabled) {
                return new IDrawable[]{GTUITextures.BUTTON_STANDARD_PRESSED, GTUITextures.OVERLAY_BUTTON_CHUNK_LOADING};
            }
            return new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_CHUNK_LOADING_OFF};
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.mChunkLoadingEnabled, newBoolean -> {
            this.mChunkLoadingEnabled = newBoolean;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).dynamicTooltip(() -> ImmutableList.of((Object)StatCollector.func_74838_a((String)(this.mChunkLoadingEnabled ? "GT5U.gui.button.chunk_loading_on" : "GT5U.gui.button.chunk_loading_off")))).setTooltipShowUpDelay(5).setPos(new Pos2d(80, 91)).setSize(16, 16))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.abortDrilling()).setPlayClickSound(true).setBackground(() -> {
            if (this.workState == 3) {
                return new IDrawable[]{GTUITextures.BUTTON_STANDARD_PRESSED, GTUITextures.OVERLAY_BUTTON_RETRACT_PIPE, GTUITextures.OVERLAY_BUTTON_LOCKED};
            }
            return new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_RETRACT_PIPE};
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.workState, newInt -> {
            this.workState = newInt;
        }), (IWidgetBuilder)builder, (widget, integer) -> widget.notifyTooltipChange()).dynamicTooltip(() -> ImmutableList.of((Object)StatCollector.func_74837_a((String)(this.workState == 3 ? "GT5U.gui.button.drill_retract_pipes_active" : "GT5U.gui.button.drill_retract_pipes"), (Object[])new Object[0]))).setTooltipShowUpDelay(5).setPos(new Pos2d(174, 112)).setSize(16, 16));
        int left = 98;
        for (ButtonWidget button : this.getAdditionalButtons(builder, buildContext)) {
            button.setPos(new Pos2d(left, 91)).setSize(16, 16);
            builder.widget((Widget)button);
            left += 18;
        }
    }

    protected List<IHatchElement<? super MTEDrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.OutputHatch, (Object)HatchElement.InputBus, (Object)HatchElement.OutputBus, (Object)HatchElement.Muffler, (Object)HatchElement.Maintenance, (Object)HatchElement.Energy, (Object)DataHatchElement.DataAccess);
    }

    protected void addResultMessage(int state, @NotNull CheckRecipeResult result) {
        this.resultRegistry.put(new ResultRegistryKey(state, result.wasSuccessful()), result);
    }

    protected void addResultMessage(int state, boolean wasSuccessful, @NotNull String resultKey) {
        this.addResultMessage(state, wasSuccessful ? SimpleCheckRecipeResult.ofSuccess(resultKey) : SimpleCheckRecipeResult.ofFailure(resultKey));
    }

    private static final class ResultRegistryKey {
        private final int state;
        private final boolean successful;

        public ResultRegistryKey(int state, boolean successful) {
            this.state = state;
            this.successful = successful;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResultRegistryKey)) {
                return false;
            }
            ResultRegistryKey other = (ResultRegistryKey)obj;
            return this.state == other.state && this.successful == other.successful;
        }

        public int hashCode() {
            return Objects.hash(this.state, this.successful);
        }
    }

    protected static enum DataHatchElement implements IHatchElement<MTEDrillerBase>
    {
        DataAccess;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchDataAccess.class);
        }

        @Override
        public IGTHatchAdder<MTEDrillerBase> adder() {
            return MTEDrillerBase::addDataAccessToMachineList;
        }

        @Override
        public long count(MTEDrillerBase t) {
            return t.mDataAccessHatches.size();
        }
    }
}

