/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.MTEFusionComputer;
import net.minecraft.block.Block;

public class MTEFusionComputer2
extends MTEFusionComputer {
    private static final ITexture textureOverlay = TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION2).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION2_GLOW).extFacing().glow().build());

    public MTEFusionComputer2(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEFusionComputer2(String aName) {
        super(aName);
    }

    @Override
    public int tier() {
        return 7;
    }

    @Override
    public long maxEUStore() {
        return 320006000L * (long)Math.min(16, this.mEnergyHatches.size()) / 16L;
    }

    @Override
    public long capableStartupCanonical() {
        return 320000000L;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEFusionComputer2(this.mName);
    }

    @Override
    public Block getCasing() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    public int getCasingMeta() {
        return 6;
    }

    @Override
    public Block getFusionCoil() {
        return GregTechAPI.sBlockCasings4;
    }

    @Override
    public int getFusionCoilMeta() {
        return 7;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fusion Reactor").addInfo("It's over 9000!!!").addInfo("Controller block for the Fusion Reactor Mk II").addInfo("8192EU/t and 20M EU capacity per Energy Hatch").addInfo("If the recipe has a startup cost greater than the").addInfo("number of energy hatches * cap, you can't do it").addSeparator().beginStructureBlock(15, 3, 15, false).addController("See diagram when placed").addCasingInfoRange("Fusion Machine Casing", 79, 123, false).addStructureInfo("Cover the coils with casing").addOtherStructurePart("Fusion Coil Block", "Center part of the ring").addEnergyHatch("1-16, Specified casings", 2).addInputHatch("2-16, Specified casings", 1).addOutputHatch("1-16, Specified casings", 3).addStructureInfo("ALL Hatches must be ZPM or better").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture getTextureOverlay() {
        return textureOverlay;
    }
}

