/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import kekztech.util.Util;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTETranscendentPlasmaMixer
extends MTEEnhancedMultiBlockBase<MTETranscendentPlasmaMixer>
implements ISurvivalConstructable {
    private static final String[][] structure = new String[][]{{" CAC ", " ABA ", " ABA ", " A~A ", " ABA ", " ABA ", " CAC "}, {"CBBBC", "A   A", "A   A", "A   A", "A   A", "A   A", "CBBBC"}, {"ABBBA", "B   B", "B   B", "B   B", "B   B", "B   B", "ABBBA"}, {"CBBBC", "A   A", "A   A", "A   A", "A   A", "A   A", "CBBBC"}, {" CAC ", " ABA ", " ABA ", " ABA ", " ABA ", " ABA ", " CAC "}};
    private static final String STRUCTURE_PIECE_MAIN = "MAIN";
    private static final IStructureDefinition<MTETranscendentPlasmaMixer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("MAIN", structure).addElement('B', GTStructureUtility.buildHatchAdder(MTETranscendentPlasmaMixer.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.Maintenance).casingIndex(13).dot(1).buildAndChain(GregTechAPI.sBlockCasings1, 13)).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)12)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)14)).build();
    private UUID ownerUUID;
    int multiplier = 1;
    BigInteger finalConsumption = BigInteger.ZERO;
    private static final int HORIZONTAL_OFFSET = 2;
    private static final int VERTICAL_OFFSET = 3;
    private static final int DEPTH_OFFSET = 0;
    private static final int PARALLEL_WINDOW_ID = 10;

    public MTETranscendentPlasmaMixer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTETranscendentPlasmaMixer(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTETranscendentPlasmaMixer> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Transcendent Mixer").addInfo("Assisting in all your DTPF needs.").addInfo("This multiblock will run in parallel according to the amount set").addInfo("in the parallel menu. All inputs will scale, except time.").addInfo("All EU is deducted from wireless EU networks only.").addInfo(GTValues.AuthorColen).addSeparator().beginStructureBlock(5, 7, 5, false).addStructureInfo(EnumChatFormatting.GOLD + "1+ " + EnumChatFormatting.GRAY + "Input Hatch").addStructureInfo(EnumChatFormatting.GOLD + "1+ " + EnumChatFormatting.GRAY + "Output Hatch").addStructureInfo(EnumChatFormatting.GOLD + "1+ " + EnumChatFormatting.GRAY + "Input Bus").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETranscendentPlasmaMixer(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_DTPF_ON).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_DTPF_OFF).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12]};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.transcendentPlasmaMixerRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){
            BigInteger recipeEU;

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                BigInteger availableEU = WirelessNetworkManager.getUserEU(MTETranscendentPlasmaMixer.this.ownerUUID);
                long multiplier = recipe.getMetadataOrDefault(GTRecipeConstants.EU_MULTIPLIER, 10).intValue();
                this.recipeEU = BigInteger.valueOf(multiplier * (long)recipe.mEUt * (long)recipe.mDuration);
                if (availableEU.compareTo(this.recipeEU) < 0) {
                    MTETranscendentPlasmaMixer.this.finalConsumption = BigInteger.ZERO;
                    return CheckRecipeResultRegistry.insufficientStartupPower(this.recipeEU);
                }
                this.maxParallel = availableEU.divide(this.recipeEU).min(BigInteger.valueOf(this.maxParallel)).intValue();
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GTRecipe recipe) {
                MTETranscendentPlasmaMixer.this.finalConsumption = this.recipeEU.multiply(BigInteger.valueOf(-this.calculatedParallels));
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap(MTETranscendentPlasmaMixer.this.ownerUUID, MTETranscendentPlasmaMixer.this.finalConsumption)) {
                    return CheckRecipeResultRegistry.insufficientStartupPower(MTETranscendentPlasmaMixer.this.finalConsumption);
                }
                this.setCalculatedEut(0L);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return OverclockCalculator.ofNoOverclock(recipe);
            }
        }.setMaxParallelSupplier(() -> this.multiplier);
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(1L);
        logic.setAmperageOC(false);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 3, 0)) {
            return false;
        }
        return this.mMaintenanceHatches.size() <= 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick == 1L) {
            this.ownerUUID = WirelessNetworkManager.processInitialSettings(aBaseMetaTileEntity);
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        buildContext.addSyncedWindow(10, this::createParallelWindow);
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GTUITextures.BUTTON_STANDARD);
            ret.add(GTUITextures.OVERLAY_BUTTON_BATCH_MODE_ON);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.tpm.parallelwindow")).setTooltipShowUpDelay(5).setPos(174, 112).setSize(16, 16));
        super.addUIWidgets(builder, buildContext);
    }

    protected ModularWindow createParallelWindow(EntityPlayer player) {
        int WIDTH = 158;
        int HEIGHT = 52;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        ModularWindow.Builder builder = ModularWindow.builder((int)158, (int)52);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.BottomRight.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(158, 52)).add(155, 0).subtract(0, 10)));
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GTPP.CC.parallel", (Object[])new Object[0]).setPos(3, 4).setSize(150, 20))).widget(new NumericWidget().setSetter(val -> {
            this.multiplier = (int)val;
        }).setGetter(() -> this.multiplier).setBounds(1.0, 2.147483647E9).setDefaultValue(1.0).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(150, 18).setPos(4, 25).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.multiplier, val -> {
            this.multiplier = val;
        }), (IWidgetBuilder)builder));
        return builder.build();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("eMultiplier", this.multiplier);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.multiplier = aNBT.func_74762_e("eMultiplier");
        super.loadNBTData(aNBT);
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + (this.mMaxProgresstime == 0 ? "0" : Util.toStandardForm(this.finalConsumption.divide(BigInteger.valueOf(-this.mMaxProgresstime)))) + EnumChatFormatting.RESET + " EU/t"};
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

