/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.compressor;

import bartworks.util.MathUtils;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.metadata.CompressionTierKey;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.SimpleShutDownReason;
import gregtech.common.blocks.BlockCasings10;
import gregtech.common.tileentities.machines.multi.compressor.MTEHeatSensor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEHIPCompressor
extends MTEExtendedPowerMultiBlockBase<MTEHIPCompressor>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEHIPCompressor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"               ", "               ", "               ", " CCCCCC DDDDDD ", "               ", "               ", "               "}, {"               ", "               ", "               ", " C    C D    D ", "               ", "               ", "               "}, {"               ", "      HHH      ", "     HHHHH     ", " C   HHHHH   D ", "     HHHHH     ", "      HHH      ", "               "}, {"      BBB      ", "     BBBBB     ", "    BBBBBBB    ", " C  BBBBBBB  D ", "    BBBBBBB    ", "     BBBBB     ", "      BBB      "}, {"      HHH      ", "     B   B     ", "    BF   FB    ", " C  BF   FB  D ", "    BF   FB    ", "     B   B     ", "      HHH      "}, {"      HAH      ", "     B   B     ", "    GF   FG    ", " C  GF   FG  D ", "    GF   FG    ", "     B   B     ", "      HAH      "}, {"      HAH      ", "     B   B     ", " B  GF   FG  B ", "BBB GF   FG BBB", " B  GF   FG  B ", "     B   B     ", "      HAH      "}, {"      HAH      ", "     B   B     ", " A  GF   FG  A ", "A A GF   FG A A", " A  GF   FG  A ", "     B   B     ", "      HAH      "}, {"      HHH      ", "     B   B     ", " A  BF   FB  A ", "A A BF   FB A A", " A  BF   FB  A ", "     B   B     ", "      HHH      "}, {"      B~B      ", "     BBBBB     ", " B  BBBBBBB  B ", "BBB BBBBBBB BBB", " B  BBBBBBB  B ", "     BBBBB     ", "      BBB      "}})).addElement('A', Glasses.chainAllGlasses()).addElement('B', GTStructureUtility.buildHatchAdder(MTEHIPCompressor.class).atLeast(HatchElement.Maintenance, HatchElement.Energy, SpecialHatchElement.HeatSensor).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(4)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEHIPCompressor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)4)))).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)9)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)10)).addElement('F', GTStructureUtility.ofCoil(MTEHIPCompressor::setCoilLevel, MTEHIPCompressor::getCoilLevel)).addElement('G', GTStructureUtility.buildHatchAdder(MTEHIPCompressor.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(5)).dot(2).buildAndChain(StructureUtility.onElementPass(MTEHIPCompressor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)5)))).addElement('H', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)5)).build();
    private final ArrayList<MTEHeatSensor> sensorHatches = new ArrayList();
    private HeatingCoilLevel heatLevel;
    private int coilTier = 0;
    private float heat = 0.0f;
    private boolean cooling = false;
    private int mCasingAmount;
    private boolean doingHIP = false;

    public MTEHIPCompressor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEHIPCompressor(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEHIPCompressor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHIPCompressor(this.mName);
    }

    @Override
    public void onValueUpdate(byte aValue) {
        boolean oCooling = this.cooling;
        boolean bl = this.cooling = (aValue & 1) == 1;
        if (oCooling != this.cooling) {
            this.getBaseMetaTileEntity().issueTextureUpdate();
        }
    }

    @Override
    public byte getUpdateData() {
        return (byte)(this.cooling ? 1 : 0);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (this.cooling ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 4)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_COMPRESSOR_COOLING).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_COMPRESSOR_COOLING_GLOW).extFacing().glow().build()} : (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 4)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_COMPRESSOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_COMPRESSOR_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 4)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_COMPRESSOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_COMPRESSOR_GLOW).extFacing().glow().build()})) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 4))};
        return rTexture;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Compressor").addInfo("Controller Block for the Hot Isostatic Pressurization Unit").addInfo("HIP Unit heats up while running").addInfo("When it reaches maximum heat, it becomes " + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + "overheated!").addInfo("This is only resolved by letting the machine fully cool down").addInfo("When " + EnumChatFormatting.DARK_RED + "overheated" + EnumChatFormatting.GRAY + ", recipes are slowed down drastically").addSeparator().addInfo("Some recipes " + EnumChatFormatting.BOLD + "require" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + " HIP").addInfo("If the machine " + EnumChatFormatting.DARK_RED + "overheats" + EnumChatFormatting.GRAY + " during these recipes, recipe will be voided!").addInfo("Read the current heat using Heat Sensor Hatches").addSeparator().addInfo("More advanced coils allow better heat control - the unit will take longer to overheat").addInfo("Unit heats by " + EnumChatFormatting.GREEN + "(5% x 0.90 ^ (Coil Tier - 1))" + EnumChatFormatting.GRAY + " every second while running").addInfo("Unit cools by " + EnumChatFormatting.GREEN + "2%" + EnumChatFormatting.GRAY + " every second while not running").addSeparator().addInfo("250% " + EnumChatFormatting.RED + "faster" + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.BLUE + "slower" + EnumChatFormatting.GRAY + " than singleblock machines of the same voltage").addInfo("Uses " + EnumChatFormatting.RED + "75%" + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.BLUE + "110%" + EnumChatFormatting.GRAY + " the EU/t normally required").addInfo("Gains " + EnumChatFormatting.RED + "4" + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.BLUE + "1" + EnumChatFormatting.GRAY + " parallels per voltage tier").addInfo(GTValues.AuthorFourIsTheNumber + EnumChatFormatting.RESET + " & " + GTValues.Ollie).addSeparator().beginStructureBlock(7, 5, 7, true).addController("Front Center").addCasingInfoMin("Electric Compressor Casing", 95, false).addCasingInfoMin("Compressor Pipe Casing", 45, false).addCasingInfoExactly("Coolant Duct", 12, false).addCasingInfoExactly("Heating Duct", 12, false).addCasingInfoExactly("EV+ Glass", 22, false).addCasingInfoExactly("Clean Stainless Steel Machine Casing", 20, false).addCasingInfoExactly("Coil", 30, true).addInputBus("Pipe Casings on Side", 2).addOutputBus("Pipe Casings on Side", 2).addEnergyHatch("Any Electric Compressor Casing", 1).addMaintenanceHatch("Any Electric Compressor Casing", 1).toolTipFinisher("GregTech");
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 9, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 9, 0, elementBudget, env, false, true);
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.setCoilLevel(HeatingCoilLevel.None);
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 9, 0) && this.mCasingAmount >= 95;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTUtility.roundUpVoltage(this.getMaxInputVoltage()));
        logic.setAvailableAmperage(1L);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74776_a("heat", this.heat);
        aNBT.func_74757_a("cooling", this.cooling);
        aNBT.func_74768_a("coilTier", this.coilTier);
        aNBT.func_74757_a("doingHIP", this.doingHIP);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("heat")) {
            this.heat = aNBT.func_74760_g("heat");
        }
        if (aNBT.func_74764_b("cooling")) {
            this.cooling = aNBT.func_74767_n("cooling");
        }
        if (aNBT.func_74764_b("coilTier")) {
            this.coilTier = aNBT.func_74762_e("coilTier");
        }
        if (aNBT.func_74764_b("doingHIP")) {
            this.doingHIP = aNBT.func_74767_n("doingHIP");
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("heat", Math.round(this.heat));
        tag.func_74757_a("cooling", this.cooling);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("cooling")) {
            currentTip.add("HIP Heat: " + EnumChatFormatting.RED + EnumChatFormatting.BOLD + tag.func_74762_e("heat") + "%" + EnumChatFormatting.RESET);
        } else {
            currentTip.add("HIP Heat: " + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + tag.func_74762_e("heat") + "%" + EnumChatFormatting.RESET);
        }
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                int recipeReq;
                MTEHIPCompressor.this.doingHIP = false;
                this.setSpeedBonus(0.8f);
                this.setEuModifier(0.75);
                if (MTEHIPCompressor.this.cooling) {
                    this.setSpeedBonus(2.5);
                    this.setEuModifier(1.1f);
                }
                if ((recipeReq = recipe.getMetadataOrDefault(CompressionTierKey.INSTANCE, 0).intValue()) == 1) {
                    MTEHIPCompressor.this.doingHIP = true;
                } else if (recipeReq == 2) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                return super.validateRecipe(recipe);
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.cooling && this.doingHIP) {
            this.stopMachine(SimpleShutDownReason.ofCritical("overheated"));
            this.doingHIP = false;
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 20L == 0L) {
            float heatMod = -2.0f;
            if (this.maxProgresstime() != 0) {
                heatMod = (float)(5.0 * Math.pow(0.9, this.coilTier));
            }
            this.heat = MathUtils.clamp(this.heat + heatMod, 0.0f, 100.0f);
            if (this.cooling && this.heat <= 0.0f || !this.cooling && this.heat >= 100.0f) {
                this.cooling = !this.cooling;
            }
        }
        for (MTEHeatSensor hatch : this.sensorHatches) {
            hatch.updateRedstoneOutput(this.heat);
        }
    }

    public int getMaxParallelRecipes() {
        return this.cooling ? GTUtility.getTier(this.getMaxInputVoltage()) : 4 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.compressorRecipes;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.heatLevel = aCoilLevel;
        this.coilTier = aCoilLevel.getTier();
    }

    public boolean addSensorHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHeatSensor) {
            MTEHeatSensor sensor = (MTEHeatSensor)aMetaTileEntity;
            sensor.updateTexture(aBaseCasingIndex);
            return this.sensorHatches.add(sensor);
        }
        return false;
    }

    private static enum SpecialHatchElement implements IHatchElement<MTEHIPCompressor>
    {
        HeatSensor(MTEHIPCompressor::addSensorHatchToMachineList, new Class[]{MTEHeatSensor.class}){

            @Override
            public long count(MTEHIPCompressor gtMetaTileEntityHIPCompressor) {
                return gtMetaTileEntityHIPCompressor.sensorHatches.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTEHIPCompressor> adder;

        @SafeVarargs
        private SpecialHatchElement(IGTHatchAdder<MTEHIPCompressor> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEHIPCompressor> adder() {
            return this.adder;
        }
    }
}

