/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEPurificationUnitPlasmaHeater
extends MTEPurificationUnitBase<MTEPurificationUnitPlasmaHeater>
implements ISurvivalConstructable {
    private static final int CASING_INDEX_HEATER = MTEPurificationUnitPlasmaHeater.getTextureIndex(GregTechAPI.sBlockCasings9, 11);
    private static final int CASING_INDEX_TOWER = MTEPurificationUnitPlasmaHeater.getTextureIndex(GregTechAPI.sBlockCasings9, 5);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final int STRUCTURE_X_OFFSET = 2;
    private static final int STRUCTURE_Y_OFFSET = 14;
    private static final int STRUCTURE_Z_OFFSET = 5;
    private static final long CONSUME_INTERVAL = 20L;
    private long currentTemperature = 0L;
    private int cyclesCompleted = 0;
    private boolean ruinedCycle = false;
    private CycleState state = CycleState.Heating;
    public static final long SUCCESS_PER_CYCLE = 33L;
    public static final long MAX_PLASMA_PER_SEC = 10L;
    public static final long MAX_COOLANT_PER_SEC = 100L;
    public static final long PLASMA_TEMP_PER_LITER = 100L;
    public static final long COOLANT_TEMP_PER_LITER = -5L;
    public static final long MAX_TEMP = 12500L;
    public static final long HEATING_POINT = 10000L;
    private static final Materials plasmaMaterial = Materials.Helium;
    private static final Materials coolantMaterial = Materials.SuperCoolant;
    private MTEHatchInput plasmaInputHatch;
    private MTEHatchInput coolantInputHatch;
    private static final String[][] structure = new String[][]{{"            DDDDDDD    ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "             DDDDD     ", "             DDDDD     ", "             DDKDD     "}, {"          DD       DD  ", "            DDDDDDD    ", "             DDDDD     ", "                       ", "                       ", "                       ", "                       ", "                       ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "           DD     DD   ", "           DD     DD   ", "           DDDDDDDDD   "}, {"         D           D ", "          DDD     DDD  ", "            DDDDDDD    ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "          D         D  ", "          D         D  ", "          DDDDDDDDDDD  "}, {"         D           D ", "          D        DD  ", "           DD      D   ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "          D         D  ", "          D         D  ", "          D         D  ", "          D         D  ", "         D           D ", "         D           D ", "         DDDDDDDDDDDDD "}, {"        D             D", "         DD         DD ", "          DD        D  ", "           D       D   ", "           D       D   ", "           D       D   ", "           D       D   ", "           D       D   ", "          D         D  ", "          D         D  ", "          D         D  ", "          D         D  ", "         D           D ", "         D           D ", "         DDDDDDDDDDDDD "}, {"        D             D", "         D           D ", "         DD          D ", "          D         D  ", "          D         D  ", "GBBBG     D         D  ", "G   G     D         D  ", "G   G     D         D  ", "G   G    D           D ", "G   G    D           D ", "G   G    D           D ", "G   G    D           D ", "G   G   D             D", "G   G   D             D", "GB~BG   DDDDDDDDDDDDDDD"}, {"        D             D", "         D           D ", "         DD          D ", "          D         D  ", " BBB      D         D  ", "BBBBB     D         D  ", " EEE      D         D  ", " EEE      D         D  ", " EEE     D           D ", " EEE     D           D ", " EEE     D           D ", " EEE     D           D ", " EEE    D             D", " EEEBBBBD             D", "BAAAB   DDDDDDDDDDDDDDD"}, {"        D             D", "         D           D ", "         DD          D ", "          D         D  ", " BBB      D         D  ", "BBBBB     D         D  ", " EFE      D         D  ", " EFE      D         D  ", " EFE     D           D ", " EFE     D           D ", " EFE     D           D ", " EFE     D           D ", " EFEBBBBD             D", " EFE    D             D", "PAAABBBBDDDDDDDDDDDDDDD"}, {"        D             D", "         D           D ", "         DD          D ", "          D         D  ", " BBB      D         D  ", "BBBBB     D         D  ", " EEE      D         D  ", " EEE      D         D  ", " EEE     D           D ", " EEE     D           D ", " EEE     D           D ", " EEE     D           D ", " EEE    D             D", " EEEBBBBD             D", "BAAAB   DDDDDDDDDDDDDDD"}, {"        D             D", "         D           D ", "         DD          D ", "          D         D  ", "          D         D  ", "GBBBG     D         D  ", "G   G     D         D  ", "G   G     D         D  ", "G   G    D           D ", "G   G    D           D ", "G   G    D           D ", "G   G    D           D ", "G   G   D             D", "G   G   D             D", "GBBBG   DDDDDDDDDDDDDDD"}, {"        D             D", "         D           D ", "          D         D  ", "           D       DD  ", "           D       DD  ", "           D       DD  ", "           D       DD  ", "           D       DD  ", "          D          D ", "          D          D ", "          D          D ", "          D          D ", "         D           D ", "         D           D ", "         DDDDDDDDDDDDD "}, {"         D           DD", "          D         D  ", "           D       D   ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "          D         D  ", "          D         D  ", "          D         D  ", "          D         D  ", "         D           D ", "         D           D ", "         DDDDDDDDDDDDD "}, {"         D           D ", "          DD       DD  ", "            D     D    ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "           DD     DD   ", "          D         D  ", "          D         D  ", "          DDDDDDDDDDD  "}, {"          DD       DD  ", "            DDDDDDD    ", "             DDDDD     ", "                       ", "                       ", "                       ", "                       ", "                       ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     ", "           DD     DD   ", "           DD     DD   ", "           DDDDDDDDD   "}, {"            DDDDDDD    ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "                       ", "             DDDDD     ", "             DDDDD     ", "             DDDDD     "}};
    private int casingCount = 0;
    private static final int MIN_CASING = 50;
    private static final IStructureDefinition<MTEPurificationUnitPlasmaHeater> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)15)).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(t.getAllowedHatches()).dot(1).casingIndex(CASING_INDEX_HEATER).build()), StructureUtility.onElementPass(t -> ++t.casingCount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)11))})).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)5)).addElement('E', StructureUtility.ofBlockAnyMeta((Block)GregTechAPI.sBlockTintedGlass, (int)0)).addElement('F', (IStructureElement)StructureUtility.lazy(t -> {
        if (Mods.Chisel.isModLoaded()) {
            Block neonite = GameRegistry.findBlock((String)Mods.Chisel.ID, (String)"neonite");
            return StructureUtility.ofBlockAnyMeta((Block)neonite, (int)7);
        }
        return StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150350_a);
    })).addElement('G', GTStructureUtility.ofFrame(Materials.Tetranaquadahdiindiumhexaplatiumosminid)).addElement('K', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeast(HatchElement.InputHatch).dot(2).adder(MTEPurificationUnitPlasmaHeater::addCoolantHatchToMachineList).cacheHint(() -> "Input Hatch (Coolant)").casingIndex(CASING_INDEX_TOWER).buildAndChain(StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)5)))).addElement('P', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeast(HatchElement.InputHatch).dot(3).adder(MTEPurificationUnitPlasmaHeater::addPlasmaHatchToMachineList).cacheHint(() -> "Input Hatch (Plasma)").casingIndex(CASING_INDEX_HEATER).buildAndChain(StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)11)))).build();

    private List<IHatchElement<? super MTEPurificationUnitPlasmaHeater>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.OutputHatch);
    }

    public MTEPurificationUnitPlasmaHeater(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPurificationUnitPlasmaHeater(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationUnitPlasmaHeater(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_HEATER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_HEATER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_HEATER)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 14, 5);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 14, 5, elementBudget, env, true);
    }

    @Override
    public IStructureDefinition<MTEPurificationUnitPlasmaHeater> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.purificationPlasmaHeatingRecipes;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Unit").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Water Tier: " + EnumChatFormatting.WHITE + GTUtility.formatNumbers(this.getWaterTier()) + EnumChatFormatting.RESET).addInfo("Controller block for the Extreme Temperature Fluctuation Purification Unit.").addInfo("Must be linked to a Purification Plant using a data stick to work.").addSeparator().addInfo("Complete heating cycles by first heating the water to " + EnumChatFormatting.RED + 10000L + "K" + EnumChatFormatting.GRAY + ",").addInfo("and then cooling it back down to " + EnumChatFormatting.RED + "0K" + EnumChatFormatting.GRAY + ".").addInfo("Initial temperature is reset to " + EnumChatFormatting.RED + "0K" + EnumChatFormatting.GRAY + " on recipe start.").addInfo("Each completed heating cycle boosts success chance by " + EnumChatFormatting.RED + 33L + "%.").addInfo("If the temperature ever reaches " + EnumChatFormatting.RED + 12500L + "K" + EnumChatFormatting.GRAY + " the recipe will fail and output steam.").addSeparator().addInfo("Consumes up to " + EnumChatFormatting.RED + 10L + "L/s " + EnumChatFormatting.WHITE + plasmaMaterial.getPlasma(1L).getLocalizedName() + EnumChatFormatting.GRAY + " and up to " + EnumChatFormatting.RED + 100L + "L/s " + EnumChatFormatting.WHITE + coolantMaterial.getFluid(1L).getLocalizedName()).addInfo(EnumChatFormatting.RED + "Raises " + EnumChatFormatting.GRAY + "the temperature by " + EnumChatFormatting.RED + 100L + "K" + EnumChatFormatting.GRAY + " per liter of plasma consumed.").addInfo(EnumChatFormatting.RED + "Lowers " + EnumChatFormatting.GRAY + "the temperature by " + EnumChatFormatting.RED + 5L + "K" + EnumChatFormatting.GRAY + " per liter of coolant consumed.").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Step five of water purification is to evaporate complex organic polymers and extremophile organisms").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "that might be resistant to simple acids, clarifying agents, and filters. Using an ultra high").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "pressure chamber in combination with extreme temperature fluctuations allows the water to remain").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "supercritical while evaporating any remaining contaminants, ready for filtration.").addInfo(GTValues.AuthorNotAPenguin).beginStructureBlock(23, 15, 15, false).addCasingInfoExactlyColored("Reinforced Sterile Water Plant Casing", EnumChatFormatting.GRAY, 1091, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Heat-Resistant Trinium Plated Casing", EnumChatFormatting.GRAY, 54, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Any Tinted Industrial Glass", EnumChatFormatting.GRAY, 64, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Superconductor Base ZPM Frame Box", EnumChatFormatting.GRAY, 40, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Any Neonite", EnumChatFormatting.GRAY, 8, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Superconducting Coil Block", EnumChatFormatting.GRAY, 8, EnumChatFormatting.GOLD, false).addController("Front center").addOtherStructurePart("Input Hatch (Water)", EnumChatFormatting.GOLD + "1+", 1).addOtherStructurePart("Output Hatch", EnumChatFormatting.GOLD + "1", 1).addOtherStructurePart("Input Hatch (Coolant)", EnumChatFormatting.GOLD + "1", 2).addOtherStructurePart("Input Hatch (Plasma)", EnumChatFormatting.GOLD + "1", 3).addStructureInfo("Use the StructureLib Hologram Projector to build the structure.").toolTipFinisher("GregTech");
        return tt;
    }

    @Override
    public void startCycle(int cycleTime, int progressTime) {
        super.startCycle(cycleTime, progressTime);
        this.cyclesCompleted = 0;
        this.currentTemperature = 0L;
        this.ruinedCycle = false;
        this.state = CycleState.Heating;
    }

    private long drainFluidLimited(MTEHatchInput inputHatch, FluidStack fluid, long maxAmount) {
        FluidStack hatchStack = inputHatch.getDrainableStack();
        if (hatchStack == null) {
            return 0L;
        }
        if (hatchStack.isFluidEqual(fluid)) {
            long amountToDrain = Math.min(maxAmount, (long)hatchStack.amount);
            if (amountToDrain > 0L) {
                inputHatch.drain((int)amountToDrain, true);
            }
            return amountToDrain;
        }
        return 0L;
    }

    @Override
    public void addRecipeOutputs() {
        super.addRecipeOutputs();
        if (this.ruinedCycle) {
            FluidStack insertedWater = this.currentRecipe.mFluidInputs[0];
            long steamAmount = (long)insertedWater.amount * 60L;
            this.addOutput(GTModHandler.getSteam(steamAmount));
        }
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
        if (this.mMaxProgresstime > 0 && aTick % 20L == 0L) {
            long plasmaDrained = this.drainFluidLimited(this.plasmaInputHatch, plasmaMaterial.getPlasma(1L), 10L);
            long coolantDrained = this.drainFluidLimited(this.coolantInputHatch, coolantMaterial.getFluid(1L), 100L);
            long tempChance = plasmaDrained * 100L + coolantDrained * -5L;
            this.currentTemperature = Math.max(0L, this.currentTemperature + tempChance);
            if (this.currentTemperature > 12500L) {
                this.ruinedCycle = true;
            }
            switch (this.state) {
                case Heating: {
                    if (this.currentTemperature < 10000L) break;
                    this.state = CycleState.Cooling;
                    break;
                }
                case Cooling: {
                    if (this.currentTemperature != 0L) break;
                    this.state = CycleState.Heating;
                    ++this.cyclesCompleted;
                }
            }
        }
    }

    public boolean addCoolantHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = null;
            this.coolantInputHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addPlasmaHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((MTEHatchInput)aMetaTileEntity).mRecipeMap = null;
            this.plasmaInputHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    @Override
    public float calculateFinalSuccessChance() {
        if (this.ruinedCycle) {
            return 0.0f;
        }
        return (float)((long)this.cyclesCompleted * 33L) + this.currentRecipeChance;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> infoData = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        infoData.add("Current temperature: " + EnumChatFormatting.YELLOW + this.currentTemperature + "K");
        infoData.add("Heating cycles completed this run: " + EnumChatFormatting.YELLOW + this.cyclesCompleted);
        return infoData.toArray(new String[0]);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74772_a("mCurrentTemperature", this.currentTemperature);
        aNBT.func_74768_a("mCyclesCompleted", this.cyclesCompleted);
        aNBT.func_74757_a("mRuinedCycle", this.ruinedCycle);
        aNBT.func_74778_a("mCycleState", this.state.toString());
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.currentTemperature = aNBT.func_74763_f("mCurrentTemperature");
        this.cyclesCompleted = aNBT.func_74762_e("mCyclesCompleted");
        this.ruinedCycle = aNBT.func_74767_n("mRuinedCycle");
        this.state = CycleState.valueOf(aNBT.func_74779_i("mCycleState"));
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getWaterTier() {
        return 5;
    }

    @Override
    public long getBasePowerUsage() {
        return TierEU.RECIPE_UV;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingCount = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 14, 5)) {
            return false;
        }
        if (this.casingCount < 50) {
            return false;
        }
        if (this.plasmaInputHatch == null || this.coolantInputHatch == null) {
            return false;
        }
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    @Override
    protected ResourceLocation getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_PURIFICATION_PLASMA_LOOP.resourceLocation;
    }

    private static enum CycleState {
        Heating,
        Cooling;

    }
}

