/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.load;

import buildcraft.api.tools.IToolWrench;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.items.GTGenericItem;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.common.tools.ToolScoop;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class GTItemIterator
implements Runnable {
    @Override
    public void run() {
        GTLog.out.println("GTMod: Scanning for certain kinds of compatible Machineblocks.");
        ItemStack tStack2 = GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Bronze, 1L);
        ItemStack tStack = GTModHandler.getRecipeOutput(tStack2, tStack2, tStack2, tStack2, null, tStack2, tStack2, tStack2, tStack2);
        if (null != tStack) {
            GTValues.RA.stdBuilder().itemInputs(tStack).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Bronze, 8L)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
            GTModHandler.addSmeltingRecipe(tStack, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Bronze, 8L));
        }
        if (null != (tStack = GTModHandler.getRecipeOutput(tStack2 = GTOreDictUnificator.get(OrePrefixes.plate, Materials.Bronze, 1L), tStack2, tStack2, tStack2, null, tStack2, tStack2, tStack2, tStack2))) {
            GTOreDictUnificator.registerOre((Object)OreDictNames.craftingRawMachineTier00, tStack);
            GTValues.RA.stdBuilder().itemInputs(tStack).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Bronze, 8L)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
            GTModHandler.addSmeltingRecipe(tStack, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Bronze, 8L));
        }
        ItemStack tStack3 = new ItemStack(Blocks.field_150359_w, 1, 0);
        tStack2 = GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Iron, 1L);
        tStack = GTModHandler.getRecipeOutput(tStack2, tStack3, tStack2, tStack3, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Gold, 1L), tStack3, tStack2, tStack3, tStack2);
        if (null != tStack) {
            GTValues.RA.stdBuilder().itemInputs(tStack).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Iron, 4L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Gold, 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        }
        if (null != (tStack = GTModHandler.getRecipeOutput(tStack2 = GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 1L), tStack3 = new ItemStack(Blocks.field_150359_w, 1, 0), tStack2, tStack3, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Gold, 1L), tStack3, tStack2, tStack3, tStack2))) {
            GTValues.RA.stdBuilder().itemInputs(tStack).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Steel, 4L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Gold, 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        }
        GTLog.out.println("GTMod: Registering various Tools to be usable on GregTech Machines");
        GregTechAPI.registerScrewdriver(GTModHandler.getRecipeOutput(null, new ItemStack(Items.field_151042_j, 1), null, new ItemStack(Items.field_151055_y, 1)));
        GregTechAPI.registerScrewdriver(GTModHandler.getRecipeOutput(new ItemStack(Items.field_151042_j, 1), null, null, null, new ItemStack(Items.field_151055_y, 1)));
        GTLog.out.println("GTMod: Adding Food Recipes to the Automatic Canning Machine. (also during the following Item Iteration)");
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151078_bh, 2, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(1L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Spoiled.get(1L, new Object[0])).duration(200).eut(1).addTo(RecipeMaps.cannerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151070_bp, 2, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(1L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Spoiled.get(1L, new Object[0])).duration(100).eut(1).addTo(RecipeMaps.cannerRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Food_Poisonous_Potato.get(2L, new Object[0]), ItemList.IC2_Food_Can_Empty.get(1L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Spoiled.get(1L, new Object[0])).duration(100).eut(1).addTo(RecipeMaps.cannerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151105_aU, 1, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(12L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Filled.get(12L, new Object[0])).duration(600).eut(1).addTo(RecipeMaps.cannerRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151009_A, 1, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(6L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Filled.get(6L, new Object[0]), new ItemStack(Items.field_151054_z, 1)).duration(300).eut(1).addTo(RecipeMaps.cannerRecipes);
        GTLog.out.println("GTMod: Scanning ItemList.");
        try {
            for (Object o : Item.field_150901_e) {
                int tFoodValue;
                Block tBlock;
                Item tItem;
                String tName;
                Object tObject = o;
                if (!(tObject instanceof Item) || tObject instanceof GTGenericItem || (tName = (tItem = (Item)tObject).func_77658_a()) == null) continue;
                if (tItem instanceof IToolCrowbar && (tItem.func_77645_m() || GTModHandler.isElectricItem(new ItemStack(tItem, 1, 0))) && GregTechAPI.registerCrowbar(new ItemStack(tItem, 1, Short.MAX_VALUE))) {
                    GTLog.out.println("GTMod: Registered valid RC Crowbar: " + tName);
                }
                if (tItem instanceof IToolWrench && (tItem.func_77645_m() || GTModHandler.isElectricItem(new ItemStack(tItem, 1, 0))) && GregTechAPI.registerWrench(new ItemStack(tItem, 1, Short.MAX_VALUE))) {
                    GTLog.out.println("GTMod: Registered valid BC Wrench: " + tName);
                }
                if ((tBlock = GTUtility.getBlockFromStack(new ItemStack(tItem, 1, 0))) != null) {
                    if (tName.endsWith("beehives")) {
                        tBlock.setHarvestLevel("scoop", 0);
                        ToolScoop.sBeeHiveMaterial = tBlock.func_149688_o();
                    }
                    if (OrePrefixes.stone.mDefaultStackSize < tItem.getItemStackLimit(new ItemStack(tItem, 1, 0)) && (tBlock.isReplaceableOreGen(GTValues.DW, 0, 0, 0, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(GTValues.DW, 0, 0, 0, Blocks.field_150424_aL) || tBlock.isReplaceableOreGen(GTValues.DW, 0, 0, 0, Blocks.field_150377_bs))) {
                        tItem.func_77625_d((int)OrePrefixes.stone.mDefaultStackSize);
                    }
                }
                if (tItem instanceof ItemFood && tItem != ItemList.IC2_Food_Can_Filled.getItem() && tItem != ItemList.IC2_Food_Can_Spoiled.getItem() && (tFoodValue = ((ItemFood)tItem).func_150905_g(new ItemStack(tItem, 1, 0))) > 0) {
                    GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                    recipeBuilder.itemInputs(new ItemStack(tItem, 1, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(tFoodValue, new Object[0]));
                    if (GTUtility.getContainerItem(new ItemStack(tItem, 1, 0), true) == null) {
                        recipeBuilder.itemOutputs(ItemList.IC2_Food_Can_Filled.get(tFoodValue, new Object[0]));
                    } else {
                        recipeBuilder.itemOutputs(ItemList.IC2_Food_Can_Filled.get(tFoodValue, new Object[0]), GTUtility.getContainerItem(new ItemStack(tItem, 1, 0), true));
                    }
                    recipeBuilder.duration(tFoodValue * 5 * 20).eut(1).addTo(RecipeMaps.cannerRecipes);
                }
                if (tItem instanceof IFluidContainerItem) {
                    GTOreDictUnificator.addToBlacklist(new ItemStack(tItem, 1, Short.MAX_VALUE));
                }
                switch (tName) {
                    case "item.fieryBlood": 
                    case "item.fieryTears": {
                        GTValues.RA.stdBuilder().itemInputs(new ItemStack(tItem, 1, 0)).metadata(GTRecipeConstants.FUEL_VALUE, 2048).metadata(GTRecipeConstants.FUEL_TYPE, 5).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "tile.TFRoots": {
                        GTValues.RA.stdBuilder().itemInputs(new ItemStack(tItem, 1, 0)).itemOutputs(new ItemStack(Items.field_151055_y, 2), new ItemStack(Items.field_151055_y, 1)).outputChances(10000, 3000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                        GTValues.RA.stdBuilder().itemInputs(new ItemStack(tItem, 1, 1)).itemOutputs(new ItemStack(Items.field_151055_y, 4)).metadata(GTRecipeConstants.FUEL_VALUE, 32).metadata(GTRecipeConstants.FUEL_TYPE, 5).addTo(GTRecipeConstants.Fuel);
                        break;
                    }
                    case "item.tconstruct.manual": {
                        GTOreDictUnificator.registerOre("bookTinkersManual", new ItemStack(tItem, 1, Short.MAX_VALUE));
                        break;
                    }
                    case "item.blueprintItem": {
                        GTOreDictUnificator.registerOre("paperBlueprint", new ItemStack(tItem, 1, Short.MAX_VALUE));
                        break;
                    }
                    case "item.ItemThaumonomicon": {
                        GTOreDictUnificator.registerOre("bookThaumonomicon", new ItemStack(tItem, 1, Short.MAX_VALUE));
                        break;
                    }
                    case "tile.bop.redRocks": {
                        GTOreDictUnificator.registerOre(OrePrefixes.stone, Materials.Redrock, new ItemStack(tItem, 1, 0));
                        GTOreDictUnificator.registerOre(OrePrefixes.stone, Materials.Redrock, new ItemStack(tItem, 1, 1));
                        GTOreDictUnificator.registerOre(OrePrefixes.stone, Materials.Redrock, new ItemStack(tItem, 1, 2));
                        break;
                    }
                    case "tile.blockCosmeticSolid": {
                        GTOreDictUnificator.registerOre(OrePrefixes.stone, Materials.Obsidian, new ItemStack(tItem, 1, 0));
                        GTOreDictUnificator.registerOre(OrePrefixes.stone, Materials.Obsidian, new ItemStack(tItem, 1, 1));
                        GTOreDictUnificator.registerOre(OrePrefixes.block, Materials.Thaumium, new ItemStack(tItem, 1, 4));
                        break;
                    }
                    case "tile.enderchest": {
                        GTOreDictUnificator.registerOre((Object)OreDictNames.enderChest, new ItemStack(tItem, 1, Short.MAX_VALUE));
                        break;
                    }
                    case "tile.autoWorkbenchBlock": {
                        GTOreDictUnificator.registerOre((Object)OreDictNames.craftingWorkBench, new ItemStack(tItem, 1, 0));
                        break;
                    }
                    case "tile.pumpBlock": {
                        GTOreDictUnificator.registerOre((Object)OreDictNames.craftingPump, new ItemStack(tItem, 1, 0));
                        break;
                    }
                    case "tile.tankBlock": {
                        GTOreDictUnificator.registerOre((Object)OreDictNames.craftingTank, new ItemStack(tItem, 1, 0));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

