/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTRecipeRegistrator;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingDust
implements IOreRecipeRegistrator {
    public ProcessingDust() {
        OrePrefixes.dust.add(this);
        OrePrefixes.dustPure.add(this);
        OrePrefixes.dustImpure.add(this);
        OrePrefixes.dustRefined.add(this);
        OrePrefixes.dustSmall.add(this);
        OrePrefixes.dustTiny.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aPrefix) {
            case dust: {
                ItemStack tDustStack;
                if (aMaterial.mFuelPower > 0) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
                }
                if (GTUtility.getFluidForFilledItem(GTOreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L), true) == null && GTOreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(aStack, ItemList.Cell_Empty.get(1L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L)).duration(100).eut(1).addTo(RecipeMaps.cannerRecipes);
                }
                if (!aMaterial.mBlastFurnaceRequired) {
                    GTRecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                    if (aMaterial.mSmeltInto.mArcSmeltInto != aMaterial) {
                        GTRecipeRegistrator.registerReverseArcSmelting(GTUtility.copyAmount(1, aStack), aMaterial, aPrefix.mMaterialAmount, null, null, null);
                    }
                }
                if (null != (tDustStack = GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, 1L)) && !aMaterial.contains(SubTag.NO_SMELTING)) {
                    if (aMaterial.mBlastFurnaceRequired) {
                        GTModHandler.removeFurnaceSmelting(aStack);
                        if (aMaterial.mAutoGenerateBlastFurnaceRecipes) {
                            GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                            recipeBuilder.itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1));
                            if (aMaterial.mBlastFurnaceTemp > 1750) {
                                recipeBuilder.itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingotHot, (Object)aMaterial.mSmeltInto, tDustStack, 1L));
                            } else {
                                recipeBuilder.itemOutputs(GTUtility.copyAmount(1, tDustStack));
                            }
                            recipeBuilder.duration(Math.max(aMaterial.getMass() / 40L, 1L) * (long)aMaterial.mBlastFurnaceTemp * 1L).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, Integer.valueOf(aMaterial.mBlastFurnaceTemp)).addTo(RecipeMaps.blastFurnaceRecipes);
                        }
                    } else {
                        GTModHandler.addSmeltingRecipe(aStack, tDustStack);
                    }
                } else if (!aMaterial.contains(SubTag.NO_WORKING)) {
                    if (!OrePrefixes.block.isIgnored(aMaterial) && null == GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L) && GTOreDictUnificator.get(OrePrefixes.block, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.block, aMaterial, 1L)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
                    }
                    if ((OrePrefixes.block.isIgnored(aMaterial) || null == GTOreDictUnificator.get(OrePrefixes.block, aMaterial, 1L)) && aMaterial != Materials.GraniteRed && aMaterial != Materials.GraniteBlack && aMaterial != Materials.Basalt && aMaterial != Materials.Marble && aMaterial != Materials.Glass && aMaterial != Materials.Obsidian && aMaterial != Materials.Glowstone && aMaterial != Materials.Paper && aMaterial != MaterialsUEVplus.TranscendentMetal && aMaterial != Materials.Clay && aMaterial != Materials.Wood && GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
                    }
                }
                if (aMaterial.mMaterialList.size() > 0 && (aMaterial.mExtraData & 3) != 0) {
                    long tItemAmount = 0L;
                    long tCapsuleCount = 0L;
                    long tDensityMultiplier = aMaterial.getDensity() > 3628800L ? aMaterial.getDensity() / 3628800L : 1L;
                    ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
                    for (MaterialStack tMat : aMaterial.mMaterialList) {
                        if (tMat.mAmount <= 0L) continue;
                        if (tMat.mMaterial == Materials.Air) {
                            tDustStack = ItemList.Cell_Air.get(tMat.mAmount / 2L, new Object[0]);
                        } else {
                            tDustStack = GTOreDictUnificator.get(OrePrefixes.dust, tMat.mMaterial, tMat.mAmount);
                            if (tDustStack == null) {
                                tDustStack = GTOreDictUnificator.get(OrePrefixes.cell, tMat.mMaterial, tMat.mAmount);
                            }
                        }
                        if (tItemAmount + tMat.mAmount * 3628800L > (long)aStack.func_77976_d() * aMaterial.getDensity()) continue;
                        tItemAmount += tMat.mAmount * 3628800L;
                        if (tDustStack == null) continue;
                        tDustStack.field_77994_a = (int)((long)tDustStack.field_77994_a * tDensityMultiplier);
                        while (tDustStack.field_77994_a > 64 && tList.size() < 6 && tCapsuleCount + (long)GTModHandler.getCapsuleCellContainerCount(tDustStack) * 64L <= 64L) {
                            tCapsuleCount += (long)GTModHandler.getCapsuleCellContainerCount(tDustStack) * 64L;
                            tList.add(GTUtility.copyAmount(64, tDustStack));
                            tDustStack.field_77994_a -= 64;
                        }
                        if (tDustStack.field_77994_a <= 0 || tList.size() >= 6 || tCapsuleCount + (long)GTModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(tDustStack) > 64L) continue;
                        tCapsuleCount += (long)GTModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(tDustStack);
                        tList.add(tDustStack);
                    }
                    tItemAmount = (long)(tItemAmount * tDensityMultiplier % aMaterial.getDensity() > 0L ? 1 : 0) + tItemAmount * tDensityMultiplier / aMaterial.getDensity();
                    if (tList.size() > 0) {
                        ItemStack[] outputsArray;
                        FluidStack tFluid = null;
                        int tList_sS = tList.size();
                        for (int i = 0; i < tList_sS; ++i) {
                            if (ItemList.Cell_Air.isStackEqual(tList.get(i)) || (tFluid = GTUtility.getFluidForFilledItem((ItemStack)tList.get(i), true)) == null) continue;
                            tFluid.amount *= ((ItemStack)tList.get((int)i)).field_77994_a;
                            tCapsuleCount -= (long)GTModHandler.getCapsuleCellContainerCountMultipliedWithStackSize((ItemStack)tList.get(i));
                            tList.remove(i);
                            break;
                        }
                        if ((aMaterial.mExtraData & 1) != 0 && (tList.size() > 0 || tFluid != null)) {
                            GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                            if (tCapsuleCount > 0L) {
                                recipeBuilder.itemInputs(GTUtility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                            } else {
                                recipeBuilder.itemInputs(GTUtility.copyAmount(tItemAmount, aStack));
                            }
                            if (tList.size() > 0) {
                                outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                                recipeBuilder.itemOutputs(outputsArray);
                            }
                            if (tFluid != null) {
                                recipeBuilder.fluidOutputs(tFluid);
                            }
                            recipeBuilder.duration(Math.max(1L, Math.abs(aMaterial.getProtons() * 2L * tItemAmount))).eut(Math.min(4, tList.size()) * 30).addTo(RecipeMaps.electrolyzerRecipes);
                        }
                        if ((aMaterial.mExtraData & 2) != 0 && (tList.size() > 0 || tFluid != null)) {
                            GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
                            if (tCapsuleCount > 0L) {
                                recipeBuilder.itemInputs(GTUtility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                            } else {
                                recipeBuilder.itemInputs(GTUtility.copyAmount(tItemAmount, aStack));
                            }
                            if (tList.size() > 0) {
                                outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                                recipeBuilder.itemOutputs(outputsArray);
                            }
                            if (tFluid != null) {
                                recipeBuilder.fluidOutputs(tFluid);
                            }
                            recipeBuilder.duration(Math.max(1L, Math.abs(aMaterial.getMass() * 4L * tItemAmount))).eut(Math.min(4, tList.size()) * 5).addTo(RecipeMaps.centrifugeRecipes);
                        }
                    }
                }
                if (aMaterial.contains(SubTag.CRYSTALLISABLE) && GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(7000).fluidInputs(Materials.Water.getFluid(200L)).duration(2000).eut(24).addTo(RecipeMaps.autoclaveRecipes);
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(9000).fluidInputs(GTModHandler.getDistilledWater(100L)).duration(1500).eut(24).addTo(RecipeMaps.autoclaveRecipes);
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(10000).fluidInputs(Materials.Void.getMolten(36L)).duration(1200).eut(24).addTo(RecipeMaps.autoclaveRecipes);
                }
                switch (aMaterial.mName) {
                    case "NULL": 
                    case "Mercury": 
                    case "Coal": {
                        break;
                    }
                    case "Glass": {
                        GTModHandler.addSmeltingRecipe(GTUtility.copyAmount(1, aStack), new ItemStack(Blocks.field_150359_w));
                        break;
                    }
                    case "NetherQuartz": 
                    case "Quartz": 
                    case "CertusQuartz": {
                        GTModHandler.removeFurnaceSmelting(aStack);
                        break;
                    }
                    case "MeatRaw": {
                        GTModHandler.addSmeltingRecipe(GTUtility.copyAmount(1, aStack), GTOreDictUnificator.get(OrePrefixes.dust, Materials.MeatCooked, 1L));
                        break;
                    }
                    case "Oilsands": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).fluidOutputs(Materials.OilHeavy.getFluid(1000L)).duration(660).eut(8).addTo(RecipeMaps.centrifugeRecipes);
                        break;
                    }
                    case "HydratedCoal": {
                        GTModHandler.addSmeltingRecipe(GTUtility.copyAmount(1, aStack), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Coal, 1L));
                        break;
                    }
                    case "Diamond": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, aStack)).itemOutputs(ItemList.IC2_Industrial_Diamond.get(3L, new Object[0]), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 16L)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 32).addTo(RecipeMaps.implosionRecipes);
                        break;
                    }
                    case "Opal": 
                    case "Olivine": 
                    case "Emerald": 
                    case "Ruby": 
                    case "Sapphire": 
                    case "GreenSapphire": 
                    case "Topaz": 
                    case "BlueTopaz": 
                    case "Tanzanite": 
                    case "Amethyst": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 12L)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 24).addTo(RecipeMaps.implosionRecipes);
                        break;
                    }
                    case "FoolsRuby": 
                    case "GarnetRed": 
                    case "GarnetYellow": 
                    case "Jasper": 
                    case "Amber": 
                    case "Monazite": 
                    case "Forcicium": 
                    case "Forcillium": 
                    case "Force": {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 3L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 8L)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 16).addTo(RecipeMaps.implosionRecipes);
                    }
                }
                break;
            }
            case dustPure: 
            case dustImpure: 
            case dustRefined: {
                ItemStack tImpureStack;
                Materials tByProduct = GTUtility.selectItemInList(aPrefix == OrePrefixes.dustRefined ? 2 : (aPrefix == OrePrefixes.dustPure ? 1 : 0), aMaterial, aMaterial.mOreByProducts);
                if (aPrefix == OrePrefixes.dustPure) {
                    if (aMaterial.contains(SubTag.ELECTROMAGNETIC_SEPERATION_GOLD)) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Gold, 1L), GTOreDictUnificator.get(OrePrefixes.nugget, Materials.Gold, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
                    }
                    if (aMaterial.contains(SubTag.ELECTROMAGNETIC_SEPERATION_IRON)) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Iron, 1L), GTOreDictUnificator.get(OrePrefixes.nugget, Materials.Iron, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
                    }
                    if (aMaterial.contains(SubTag.ELECTROMAGNETIC_SEPERATION_NEODYMIUM)) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Neodymium, 1L), GTOreDictUnificator.get(OrePrefixes.nugget, Materials.Neodymium, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
                    }
                }
                if (aMaterial.contains(SubTag.CRYSTALLISABLE) && GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(9000).fluidInputs(Materials.Water.getFluid(200L)).duration(2000).eut(24).addTo(RecipeMaps.autoclaveRecipes);
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(9500).fluidInputs(GTModHandler.getDistilledWater(100L)).duration(1500).eut(24).addTo(RecipeMaps.autoclaveRecipes);
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).outputChances(10000).fluidInputs(Materials.Void.getMolten(36L)).duration(1200).eut(24).addTo(RecipeMaps.autoclaveRecipes);
                }
                if ((tImpureStack = GTOreDictUnificator.get(OrePrefixes.dustTiny, (Object)tByProduct, GTOreDictUnificator.get(OrePrefixes.nugget, tByProduct, 1L), 1L)) == null) {
                    tImpureStack = GTOreDictUnificator.get(OrePrefixes.dustSmall, tByProduct, 1L);
                    if (tImpureStack == null) {
                        tImpureStack = GTOreDictUnificator.get(OrePrefixes.dust, (Object)tByProduct, GTOreDictUnificator.get(OrePrefixes.gem, tByProduct, 1L), 1L);
                        if (tImpureStack == null) {
                            tImpureStack = GTOreDictUnificator.get(OrePrefixes.cell, tByProduct, 1L);
                            if (tImpureStack == null) {
                                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(Math.max(1L, aMaterial.getMass())).eut(5).addTo(RecipeMaps.centrifugeRecipes);
                                break;
                            }
                            FluidStack tFluid = GTUtility.getFluidForFilledItem(tImpureStack, true);
                            if (tFluid == null) {
                                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack), ItemList.Cell_Empty.get(1L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 9L), tImpureStack).duration(Math.max(1L, aMaterial.getMass() * 72L)).eut(5).addTo(RecipeMaps.centrifugeRecipes);
                                break;
                            }
                            tFluid.amount /= 10;
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).fluidOutputs(tFluid).duration(Math.max(1L, aMaterial.getMass() * 8L)).eut(5).addTo(RecipeMaps.centrifugeRecipes);
                            break;
                        }
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 9L), tImpureStack).duration(Math.max(1L, aMaterial.getMass() * 72L)).eut(5).addTo(RecipeMaps.centrifugeRecipes);
                        break;
                    }
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 2L), tImpureStack).duration(Math.max(1L, aMaterial.getMass() * 16L)).eut(5).addTo(RecipeMaps.centrifugeRecipes);
                    break;
                }
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dust, (Object)tByProduct, GTOreDictUnificator.get(OrePrefixes.nugget, tByProduct, 1L), 1L)).outputChances(10000, 1111).duration(Math.max(1L, aMaterial.getMass() * 8L)).eut(5).addTo(RecipeMaps.centrifugeRecipes);
                break;
            }
            case dustSmall: {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, aStack), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(20).eut(4).addTo(RecipeMaps.packagerRecipes);
                if (aMaterial.mBlastFurnaceRequired) break;
                GTRecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                if (aMaterial.mSmeltInto.mArcSmeltInto == aMaterial) break;
                GTRecipeRegistrator.registerReverseArcSmelting(GTUtility.copyAmount(1, aStack), aMaterial, aPrefix.mMaterialAmount, null, null, null);
                break;
            }
            case dustTiny: {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack), ItemList.Schematic_Dust.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(20).eut(4).addTo(RecipeMaps.packagerRecipes);
                if (!aMaterial.mBlastFurnaceRequired) {
                    GTRecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                    if (aMaterial.mSmeltInto.mArcSmeltInto != aMaterial) {
                        GTRecipeRegistrator.registerReverseArcSmelting(GTUtility.copyAmount(1, aStack), aMaterial, aPrefix.mMaterialAmount, null, null, null);
                    }
                }
                if (aMaterial.contains(SubTag.NO_SMELTING) || !aMaterial.mBlastFurnaceRequired) break;
                GTModHandler.removeFurnaceSmelting(aStack);
                break;
            }
        }
    }
}

