/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTRecipeRegistrator;
import gregtech.api.util.GTUtility;
import gregtech.common.GTProxy;
import net.minecraft.item.ItemStack;

public class ProcessingIngot
implements IOreRecipeRegistrator {
    public ProcessingIngot() {
        OrePrefixes.ingot.add(this);
        OrePrefixes.ingotDouble.add(this);
        OrePrefixes.ingotTriple.add(this);
        OrePrefixes.ingotQuadruple.add(this);
        OrePrefixes.ingotQuintuple.add(this);
        OrePrefixes.ingotHot.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        boolean aNoSmashing = aMaterial.contains(SubTag.NO_SMASHING);
        boolean aStretchy = aMaterial.contains(SubTag.STRETCHY);
        boolean aNoSmelting = aMaterial.contains(SubTag.NO_SMELTING);
        long aMaterialMass = aMaterial.getMass();
        boolean aSpecialRecipeReq = aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_SMASHING);
        switch (aPrefix) {
            case ingot: {
                ItemStack tStack;
                if (aMaterial.mFuelPower > 0) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
                }
                if (aMaterial.mStandardMoltenFluid != null && aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
                    GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ingot.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(144L)).duration(32).eut(GTUtility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.fluidSolidifierRecipes);
                }
                GTRecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                GTRecipeRegistrator.registerReverseMacerating(aStack, aMaterial, aPrefix.mMaterialAmount, null, null, null, false);
                if (aMaterial.mSmeltInto.mArcSmeltInto != aMaterial) {
                    GTRecipeRegistrator.registerReverseArcSmelting(GTUtility.copyAmount(1, aStack), aMaterial, aPrefix.mMaterialAmount, null, null, null);
                }
                if ((tStack = GTOreDictUnificator.get(OrePrefixes.dust, aMaterial.mMacerateInto, 1L)) != null && (aMaterial.mBlastFurnaceRequired || aNoSmelting)) {
                    GTModHandler.removeFurnaceSmelting(tStack);
                }
                if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_WORKING) && !aMaterial.contains(SubTag.SMELTING_TO_GEM) && aMaterial.contains(SubTag.MORTAR_GRINDABLE)) {
                    GTModHandler.addShapelessCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GTProxy.tBits, new Object[]{ToolDictNames.craftingToolMortar, OrePrefixes.ingot.get(aMaterial)});
                }
                if (!aNoSmashing && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV && GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L)).duration(Math.max(aMaterialMass, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.hammerRecipes);
                }
                if (aNoSmashing && !aStretchy) break;
                if (GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 24)).addTo(RecipeMaps.benderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, aStack), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 4L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(5, aStack), GTUtility.getIntegratedCircuit(5)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 5L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack), GTUtility.getIntegratedCircuit(9)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L)).duration(Math.max(aMaterialMass * 9L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.foil, aMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(10)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.foil, aMaterial, 4L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 24)).addTo(RecipeMaps.benderRecipes);
                break;
            }
            case ingotDouble: {
                if (aNoSmashing && !aStretchy) break;
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV || !aSpecialRecipeReq) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.ingotDouble, aMaterial, 1L), GTProxy.tBits, new Object[]{"I", "I", "h", Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case ingotTriple: {
                if (aNoSmashing && !aStretchy) break;
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV || !aSpecialRecipeReq) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.ingotTriple, aMaterial, 1L), GTProxy.tBits, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.ingotDouble.get(aMaterial), Character.valueOf('B'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case ingotQuadruple: {
                if (aNoSmashing && !aStretchy) break;
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV || !aSpecialRecipeReq) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.ingotQuadruple, aMaterial, 1L), GTProxy.tBits, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.ingotTriple.get(aMaterial), Character.valueOf('B'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case ingotQuintuple: {
                if (aNoSmashing && !aStretchy) break;
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV || !aSpecialRecipeReq) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.ingotQuintuple, aMaterial, 1L), GTProxy.tBits, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.ingotQuadruple.get(aMaterial), Character.valueOf('B'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case ingotHot: {
                if (!aMaterial.mAutoGenerateVacuumFreezerRecipes || GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L)).duration((int)Math.max(aMaterialMass * 3L, 1L) * 1).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.vacuumFreezerRecipes);
                break;
            }
        }
    }
}

