/*
 * Decompiled with CFR 0.152.
 */
package gregtech.shadow.com.github.technus.avrClone.compiler.js;

import gregtech.shadow.com.github.technus.avrClone.compiler.js.CompilerBindings;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;

public class CompilerContext
implements ScriptContext {
    private Writer writer;
    private Writer errorWriter;
    private Reader reader;
    private CompilerBindings bindings;
    private Bindings global;
    private static List<Integer> scopes = new ArrayList<Integer>(2);

    public CompilerContext(CompilerBindings compilerBindings, Bindings globalScope) {
        this.bindings = compilerBindings;
        this.global = globalScope;
        this.reader = new InputStreamReader(System.in);
        this.writer = new PrintWriter(System.out, true);
        this.errorWriter = new PrintWriter(System.err, true);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        if (scope == 200) {
            this.global = bindings;
        } else if (scope == 100 && bindings instanceof CompilerBindings) {
            this.bindings = (CompilerBindings)bindings;
        } else {
            throw new IllegalArgumentException("Requires " + CompilerBindings.class.getCanonicalName());
        }
    }

    @Override
    public Bindings getBindings(int scope) {
        switch (scope) {
            case 200: {
                return this.global;
            }
            case 100: {
                return this.bindings;
            }
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        if (!this.checkName(name)) {
            return;
        }
        switch (scope) {
            case 200: {
                this.global.put(name, value);
                return;
            }
            case 100: {
                this.bindings.put(name, value);
                return;
            }
        }
    }

    @Override
    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 200: {
                return this.global.get(name);
            }
            case 100: {
                return this.bindings.get(name);
            }
        }
        return null;
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        switch (scope) {
            case 200: {
                return this.global.remove(name);
            }
            case 100: {
                return this.bindings.remove(name);
            }
        }
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.bindings.get(name);
        return value != null ? value : this.global.get(name);
    }

    @Override
    public int getAttributesScope(String name) {
        if (this.bindings.containsKey(name)) {
            return 100;
        }
        if (this.global.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    @Deprecated
    public List<Integer> getScopes() {
        return scopes;
    }

    private boolean checkName(String name) {
        return name != null && !name.isEmpty() && name.matches("([a-zA-Z][0-9a-zA-Z_]*)");
    }

    static {
        scopes.add(100);
        scopes.add(200);
        scopes = Collections.unmodifiableList(scopes);
    }
}

