/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.FishPondFakeRecipe;
import gregtech.api.util.SemiFluidFuelHandler;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.common.CommonProxy;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.handler.BookHandler;
import gtPlusPlus.core.handler.PacketHandler;
import gtPlusPlus.core.handler.Recipes.RegistrationHandler;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.data.LocaleUtils;
import gtPlusPlus.plugin.manager.CoreManager;
import gtPlusPlus.xmod.gregtech.common.MetaGTProxy;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtTools;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBlastSmelterGTNH;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenMultisUsingFluidInsteadOfCells;
import gtPlusPlus.xmod.thaumcraft.commands.CommandDumpAspects;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;

@Mod(modid="miscutils", name="GT++", version="5.09.50.05", guiFactory="gtPlusPlus.core.gui.config.GTPPGuiFactory", dependencies="required-after:Forge; after:TConstruct; after:dreamcraft; after:IC2; required-after:gregtech; after:Forestry; after:MagicBees; after:CoFHCore; after:Railcraft; after:CompactWindmills; after:ForbiddenMagic; after:ExtraUtilities; after:Thaumcraft; after:EnderIO; after:tectech; after:OpenBlocks; after:IC2NuclearControl; after:TGregworks; after:StevesCarts; required-after:gtnhlib@[0.0.10,);")
public class GTplusplus
implements ActionListener {
    public static INIT_PHASE CURRENT_LOAD_PHASE;
    @Mod.Instance(value="miscutils")
    public static GTplusplus instance;
    @SidedProxy(clientSide="gtPlusPlus.core.proxy.ClientProxy", serverSide="gtPlusPlus.core.common.CommonProxy")
    public static CommonProxy proxy;
    private static final HashMap<String, Item> sMissingItemMappings;
    private static final HashMap<String, Block> sMissingBlockMappings;

    @SideOnly(value=Side.CLIENT)
    public static void loadTextures() {
        Logger.INFO("Loading some textures on the client.");
        Logger.WARNING("Processing texture: " + TexturesGtTools.ANGLE_GRINDER.getTextureFile().func_110623_a());
        Logger.WARNING("Processing texture: " + TexturesGtTools.ELECTRIC_SNIPS.getTextureFile().func_110623_a());
        Logger.WARNING("Processing texture: " + TexturesGtBlock.Casing_Machine_Dimensional.getTextureFile().func_110623_a());
    }

    public GTplusplus() {
        INIT_PHASE.SUPER.setPhaseActive(true);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        INIT_PHASE.PRE_INIT.setPhaseActive(true);
        CoreManager.veryEarlyInit();
        PacketHandler.init();
        GTplusplus.setupMaterialBlacklist();
        GTPPCore.DEVENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        proxy.preInit(event);
        Logger.INFO("Setting up our own GTProxy.");
        MetaGTProxy.preInit();
        CoreManager.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        INIT_PHASE.INIT.setPhaseActive(true);
        proxy.init(event);
        proxy.registerNetworkStuff();
        MetaGTProxy.init();
        CoreManager.init();
        if (Configuration.debug.dumpItemAndBlockData) {
            LocaleUtils.generateFakeLocaleFile();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        INIT_PHASE.POST_INIT.setPhaseActive(true);
        proxy.postInit(event);
        BookHandler.runLater();
        MetaGTProxy.postInit();
        CoreManager.postInit();
        Logger.INFO("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        Logger.INFO("| Recipes succesfully Loaded: " + RegistrationHandler.recipesSuccess + " | Failed: " + RegistrationHandler.recipesFailed + " |");
        Logger.INFO("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        Logger.INFO("Finally, we are finished. Have some cripsy bacon as a reward.");
        if (GTPPCore.DEVENV) {
            int i;
            for (i = 750; i < 1000; ++i) {
                if (GregTechAPI.METATILEENTITIES[i] != null) continue;
                Logger.INFO("MetaID " + i + " is free.");
            }
            for (i = 30000; i < 32000; ++i) {
                if (GregTechAPI.METATILEENTITIES[i] != null) continue;
                Logger.INFO("MetaID " + i + " is free.");
            }
        }
    }

    @Mod.EventHandler
    public synchronized void serverStarting(FMLServerStartingEvent event) {
        INIT_PHASE.SERVER_START.setPhaseActive(true);
        if (Mods.Thaumcraft.isModLoaded()) {
            event.registerServerCommand((ICommand)new CommandDumpAspects());
        }
        CoreManager.serverStart();
        INIT_PHASE.STARTED.setPhaseActive(true);
    }

    @Mod.EventHandler
    public synchronized void serverStopping(FMLServerStoppingEvent event) {
        CoreManager.serverStop();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        proxy.onLoadComplete(event);
        this.generateGregtechRecipeMaps();
    }

    protected void generateGregtechRecipeMaps() {
        int[] mInvalidCount = new int[]{0, 0, 0, 0, 0, 0, 0};
        RecipeGenBlastSmelterGTNH.generateGTNHBlastSmelterRecipesFromEBFList();
        FishPondFakeRecipe.generateFishPondRecipes();
        SemiFluidFuelHandler.generateFuels();
        mInvalidCount[0] = RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(RecipeMaps.centrifugeRecipes, GTPPRecipeMaps.centrifugeNonCellRecipes);
        mInvalidCount[1] = RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(RecipeMaps.electrolyzerRecipes, GTPPRecipeMaps.electrolyzerNonCellRecipes);
        mInvalidCount[2] = RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(RecipeMaps.vacuumFreezerRecipes, GTPPRecipeMaps.advancedFreezerRecipes);
        mInvalidCount[3] = RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(RecipeMaps.mixerRecipes, GTPPRecipeMaps.mixerNonCellRecipes);
        mInvalidCount[4] = RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPPRecipeMaps.chemicalDehydratorRecipes, GTPPRecipeMaps.chemicalDehydratorNonCellRecipes);
        mInvalidCount[5] = RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPPRecipeMaps.coldTrapRecipes, GTPPRecipeMaps.nuclearSaltProcessingPlantRecipes);
        mInvalidCount[6] = RecipeGenMultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPPRecipeMaps.reactorProcessingUnitRecipes, GTPPRecipeMaps.nuclearSaltProcessingPlantRecipes);
    }

    private static void setupMaterialBlacklist() {
        Material.invalidMaterials.add(Materials._NULL);
        Material.invalidMaterials.add(Materials.Clay);
        Material.invalidMaterials.add(Materials.Phosphorus);
        Material.invalidMaterials.add(Materials.Steel);
        Material.invalidMaterials.add(Materials.Bronze);
        Material.invalidMaterials.add(Materials.Hydrogen);
        Material.invalidMaterials.add(Materials.InfusedAir);
        Material.invalidMaterials.add(Materials.InfusedEarth);
        Material.invalidMaterials.add(Materials.InfusedFire);
        Material.invalidMaterials.add(Materials.InfusedWater);
        Material.invalidMaterials.add(Materials.SoulSand);
        Material.invalidMaterials.add(Materials.EnderPearl);
        Material.invalidMaterials.add(Materials.EnderEye);
        Material.invalidMaterials.add(Materials.Redstone);
        Material.invalidMaterials.add(Materials.Glowstone);
        Material.invalidMaterials.add(Materials.Soularium);
        Material.invalidMaterials.add(Materials.PhasedIron);
    }

    private static void processMissingMappings() {
        sMissingItemMappings.put("miscutils:Ammonium", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellAmmonium"));
        sMissingItemMappings.put("miscutils:Hydroxide", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellHydroxide"));
        sMissingItemMappings.put("miscutils:BerylliumHydroxide", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellmiscutils:BerylliumHydroxide"));
        sMissingItemMappings.put("miscutils:Bromine", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellBromine"));
        sMissingItemMappings.put("miscutils:Krypton", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellKrypton"));
        sMissingItemMappings.put("miscutils:itemCellZirconiumTetrafluoride", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"ZirconiumTetrafluoride"));
        sMissingItemMappings.put("miscutils:Li2BeF4", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellLithiumTetrafluoroberyllate"));
        sMissingBlockMappings.put("miscutils:oreCryolite", GameRegistry.findBlock((String)Mods.GTPlusPlus.ID, (String)"oreCryoliteF"));
        sMissingItemMappings.put("miscutils:itemDustTinyCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustTinyCryoliteF"));
        sMissingItemMappings.put("miscutils:itemDustSmallCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustSmallCryoliteF"));
        sMissingItemMappings.put("miscutils:itemDustCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustCryoliteF"));
        sMissingItemMappings.put("miscutils:dustPureCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"dustPureCryoliteF"));
        sMissingItemMappings.put("miscutils:dustImpureCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"dustImpureCryoliteF"));
        sMissingItemMappings.put("miscutils:crushedCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedCryoliteF"));
        sMissingItemMappings.put("miscutils:crushedPurifiedCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedPurifiedCryoliteF"));
        sMissingItemMappings.put("miscutils:crushedCentrifugedCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedCentrifugedCryoliteF"));
        sMissingItemMappings.put("miscutils:oreCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"oreCryoliteF"));
        sMissingBlockMappings.put("miscutils:oreFluorite", GameRegistry.findBlock((String)Mods.GTPlusPlus.ID, (String)"oreFluoriteF"));
        sMissingItemMappings.put("miscutils:itemDustTinyFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustTinyFluoriteF"));
        sMissingItemMappings.put("miscutils:itemDustSmallFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustSmallFluoriteF"));
        sMissingItemMappings.put("miscutils:itemDustFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustFluoriteF"));
        sMissingItemMappings.put("miscutils:dustPureFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"dustPureFluoriteF"));
        sMissingItemMappings.put("miscutils:dustImpureFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"dustImpureFluoriteF"));
        sMissingItemMappings.put("miscutils:crushedFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedFluoriteF"));
        sMissingItemMappings.put("miscutils:crushedPurifiedFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedPurifiedFluoriteF"));
        sMissingItemMappings.put("miscutils:crushedCentrifugedFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedCentrifugedFluoriteF"));
        sMissingItemMappings.put("miscutils:oreFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"oreFluoriteF"));
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        GTplusplus.processMissingMappings();
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            Item aReplacement;
            if (mapping.name.startsWith("Australia:")) {
                mapping.ignore();
                continue;
            }
            if (mapping.type == GameRegistry.Type.ITEM) {
                aReplacement = sMissingItemMappings.get(mapping.name);
                if (aReplacement == null) continue;
                GTplusplus.remap(aReplacement, mapping);
                continue;
            }
            if (mapping.type != GameRegistry.Type.BLOCK || (aReplacement = sMissingBlockMappings.get(mapping.name)) == null) continue;
            GTplusplus.remap((Block)aReplacement, mapping);
        }
    }

    private static void remap(Item item, FMLMissingMappingsEvent.MissingMapping mapping) {
        mapping.remap(item);
        Logger.INFO("Remapping item " + mapping.name + " to " + Mods.GTPlusPlus.ID + ":" + item.func_77658_a());
    }

    private static void remap(Block block, FMLMissingMappingsEvent.MissingMapping mapping) {
        mapping.remap(block);
        Logger.INFO("Remapping block " + mapping.name + " to " + Mods.GTPlusPlus.ID + ":" + block.func_149739_a());
    }

    static {
        try {
            ConfigurationManager.registerConfig(Configuration.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        CURRENT_LOAD_PHASE = INIT_PHASE.SUPER;
        sMissingItemMappings = new HashMap();
        sMissingBlockMappings = new HashMap();
    }

    public static enum INIT_PHASE {
        SUPER(null),
        PRE_INIT(SUPER),
        INIT(PRE_INIT),
        POST_INIT(INIT),
        SERVER_START(POST_INIT),
        STARTED(SERVER_START);

        private boolean mIsPhaseActive = false;
        private final INIT_PHASE mPrev;

        private INIT_PHASE(INIT_PHASE aPreviousPhase) {
            this.mPrev = aPreviousPhase;
        }

        public final synchronized boolean isPhaseActive() {
            return this.mIsPhaseActive;
        }

        public final synchronized void setPhaseActive(boolean aIsPhaseActive) {
            if (this.mPrev != null && this.mPrev.isPhaseActive()) {
                this.mPrev.setPhaseActive(false);
            }
            this.mIsPhaseActive = aIsPhaseActive;
            if (CURRENT_LOAD_PHASE != this) {
                CURRENT_LOAD_PHASE = this;
            }
        }
    }
}

