/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import gregtech.api.util.GTLanguageManager;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles"), @Optional.Interface(iface="baubles.api.BaubleType", modid="Baubles")})
public class BaseBauble
extends Item
implements IBauble {
    private BaubleType mThisBauble;
    private List<String> damageNegations = new ArrayList<String>();
    Multimap<String, AttributeModifier> attributes = HashMultimap.create();

    public BaseBauble(BaubleType type) {
        this.mThisBauble = type;
        this.func_77625_d(1);
        this.func_77637_a(AddToCreativeTab.tabMisc);
    }

    public List<String> getDamageNegations() {
        return this.damageNegations;
    }

    public String func_77653_i(ItemStack tItem) {
        String key = "gtplusplus." + this.func_77658_a() + ".name";
        if (key.equals(GTLanguageManager.getTranslation(key))) {
            return super.func_77653_i(tItem).replaceAll(".name", "");
        }
        return GTLanguageManager.getTranslation(key);
    }

    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return arg1 instanceof EntityPlayer;
    }

    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return arg1 instanceof EntityPlayer;
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return this.mThisBauble;
    }

    public void onEquipped(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.onEquippedOrLoadedIntoWorld(entity);
            BaseBauble.setPlayerHashcode(stack, entity.hashCode());
        }
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (BaseBauble.getPlayerHashcode(stack) != player.hashCode()) {
            this.onEquippedOrLoadedIntoWorld(player);
            BaseBauble.setPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onEquippedOrLoadedIntoWorld(EntityLivingBase player) {
        this.attributes.clear();
        player.func_110140_aT().func_111147_b(this.attributes);
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        player.func_110140_aT().func_111148_a(this.attributes);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public static int getPlayerHashcode(ItemStack stack) {
        return NBTUtils.getInteger(stack, "mPlayerHashcode");
    }

    public static void setPlayerHashcode(ItemStack stack, int hash) {
        NBTUtils.setInteger(stack, "mPlayerHashcode", hash);
    }
}

