/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import cpw.mods.fml.common.Optional;
import forestry.core.items.ItemForestryBonemeal;
import forestry.core.items.ItemRegistryCore;
import forestry.plugins.PluginCore;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.ItemPackage;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.circuit.GTPPIntegratedCircuitItem;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.plugin.agrichem.BioRecipes;
import gtPlusPlus.plugin.agrichem.item.algae.ItemAgrichemBase;
import gtPlusPlus.plugin.agrichem.item.algae.ItemAlgaeBase;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class AgriculturalChem
extends ItemPackage {
    private static boolean aBOP;
    private static boolean aTiCon;
    private static ArrayList<FluidStack> mBloodFluids;
    public static Fluid PoopJuice;
    public static Fluid ManureSlurry;
    public static Fluid FertileManureSlurry;
    public static Fluid CustomBlood;
    public static Fluid RedMud;
    public static Item dustManureByproducts;
    public static Item dustOrganicFertilizer;
    public static Item dustDirt;
    public static Item mAlgae;
    public static Item mBioCircuit;
    public static Item mAgrichemItem1;
    public static ItemStack mAlgaeBiosmass;
    public static ItemStack mGreenAlgaeBiosmass;
    public static ItemStack mBrownAlgaeBiosmass;
    public static ItemStack mGoldenBrownAlgaeBiosmass;
    public static ItemStack mRedAlgaeBiosmass;
    public static ItemStack mCelluloseFiber;
    public static ItemStack mGoldenBrownCelluloseFiber;
    public static ItemStack mRedCelluloseFiber;
    public static ItemStack mCompost;
    public static ItemStack mWoodPellet;
    public static ItemStack mWoodBrick;
    public static ItemStack mCellulosePulp;
    public static ItemStack mRawBioResin;
    public static ItemStack mCatalystCarrier;
    public static ItemStack mGreenCatalyst;
    public static ItemStack mAlginicAcid;
    public static ItemStack mAlumina;
    public static ItemStack mAluminiumPellet;
    public static ItemStack mSodiumAluminate;
    public static ItemStack mSodiumHydroxide;
    public static ItemStack mSodiumCarbonate;
    public static ItemStack mLithiumChloride;
    public static ItemStack mPelletMold;
    public static ItemStack mCleanAluminiumMix;
    public static ItemStack mPinecone;
    public static ItemStack mCrushedPine;
    private static final ArrayList<ItemStack> mMeats;
    private static final ArrayList<ItemStack> mFish;
    private static final ArrayList<ItemStack> mFruits;
    private static final ArrayList<ItemStack> mVege;
    private static final ArrayList<ItemStack> mNuts;
    private static final ArrayList<ItemStack> mSeeds;
    private static final ArrayList<ItemStack> mPeat;
    private static final ArrayList<ItemStack> mBones;
    private static final ArrayList<ItemStack> mBoneMeal;
    private static final ArrayList<ItemStack> mList_Master_Meats;
    private static final ArrayList<ItemStack> mList_Master_FruitVege;
    private static final ArrayList<ItemStack> mList_Master_Seeds;
    private static final ArrayList<ItemStack> mList_Master_Bones;
    public static ItemStack aFertForestry;
    public static ItemStack aFertIC2;

    @Override
    public void items() {
        List NaOHTiny;
        dustManureByproducts = ItemUtils.generateSpecialUseDusts("ManureByproducts", "Manure Byproduct", "(N2H4O3)N2P2Ca3CuC8", Utils.rgbtoHexValue(110, 75, 25))[0];
        dustOrganicFertilizer = ItemUtils.generateSpecialUseDusts("OrganicFertilizer", "Organic Fertilizer", "Ca5(PO4)3(OH)", Utils.rgbtoHexValue(240, 240, 240))[0];
        dustDirt = ItemUtils.generateSpecialUseDusts("Dirt", "Dried Earth", Utils.rgbtoHexValue(65, 50, 15))[0];
        mAlgae = new ItemAlgaeBase();
        mAgrichemItem1 = new ItemAgrichemBase();
        mBioCircuit = new GTPPIntegratedCircuitItem("BioRecipeSelector", "bioscience/BioCircuit");
        GregtechItemList.Circuit_BioRecipeSelector.set(mBioCircuit);
        mAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 0, 1);
        mGreenAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 1, 1);
        mBrownAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 2, 1);
        mGoldenBrownAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 3, 1);
        mRedAlgaeBiosmass = ItemUtils.simpleMetaStack(mAgrichemItem1, 4, 1);
        mCelluloseFiber = ItemUtils.simpleMetaStack(mAgrichemItem1, 5, 1);
        mGoldenBrownCelluloseFiber = ItemUtils.simpleMetaStack(mAgrichemItem1, 6, 1);
        mRedCelluloseFiber = ItemUtils.simpleMetaStack(mAgrichemItem1, 7, 1);
        mCompost = ItemUtils.simpleMetaStack(mAgrichemItem1, 8, 1);
        mWoodPellet = ItemUtils.simpleMetaStack(mAgrichemItem1, 9, 1);
        mWoodBrick = ItemUtils.simpleMetaStack(mAgrichemItem1, 10, 1);
        mCellulosePulp = ItemUtils.simpleMetaStack(mAgrichemItem1, 11, 1);
        mRawBioResin = ItemUtils.simpleMetaStack(mAgrichemItem1, 12, 1);
        mCatalystCarrier = ItemUtils.simpleMetaStack(mAgrichemItem1, 13, 1);
        mGreenCatalyst = ItemUtils.simpleMetaStack(mAgrichemItem1, 14, 1);
        mAlginicAcid = ItemUtils.simpleMetaStack(mAgrichemItem1, 15, 1);
        mAlumina = ItemUtils.simpleMetaStack(mAgrichemItem1, 16, 1);
        mAluminiumPellet = ItemUtils.simpleMetaStack(mAgrichemItem1, 17, 1);
        mSodiumAluminate = ItemUtils.simpleMetaStack(mAgrichemItem1, 18, 1);
        if (OreDictionary.doesOreNameExist((String)"dustSodiumHydroxide_GT5U") || OreDictionary.doesOreNameExist((String)"dustSodiumHydroxide")) {
            List aTest = OreDictionary.getOres((String)"dustSodiumHydroxide", (boolean)false);
            ItemStack aTestStack = aTest.isEmpty() ? ((aTest = OreDictionary.getOres((String)"dustSodiumHydroxide_GT5U", (boolean)false)).isEmpty() ? ItemUtils.simpleMetaStack(mAgrichemItem1, 19, 1) : (ItemStack)aTest.get(0)) : (ItemStack)aTest.get(0);
            mSodiumHydroxide = aTestStack;
        } else {
            mSodiumHydroxide = ItemUtils.simpleMetaStack(mAgrichemItem1, 19, 1);
        }
        mSodiumCarbonate = ItemUtils.simpleMetaStack(mAgrichemItem1, 20, 1);
        mLithiumChloride = ItemUtils.simpleMetaStack(mAgrichemItem1, 21, 1);
        mPelletMold = ItemUtils.simpleMetaStack(mAgrichemItem1, 22, 1);
        mCleanAluminiumMix = ItemUtils.simpleMetaStack(mAgrichemItem1, 23, 1);
        mPinecone = ItemUtils.simpleMetaStack(mAgrichemItem1, 24, 1);
        mCrushedPine = ItemUtils.simpleMetaStack(mAgrichemItem1, 25, 1);
        ItemUtils.addItemToOreDictionary(mGreenAlgaeBiosmass, "biomassGreenAlgae");
        ItemUtils.addItemToOreDictionary(mBrownAlgaeBiosmass, "biomassBrownAlgae");
        ItemUtils.addItemToOreDictionary(mGoldenBrownAlgaeBiosmass, "biomassGoldenBrownAlgae");
        ItemUtils.addItemToOreDictionary(mRedAlgaeBiosmass, "biomassRedAlgae");
        ItemUtils.addItemToOreDictionary(mCelluloseFiber, "fiberCellulose");
        ItemUtils.addItemToOreDictionary(mGoldenBrownCelluloseFiber, "fiberCellulose");
        ItemUtils.addItemToOreDictionary(mGoldenBrownCelluloseFiber, "fiberGoldenBrownCellulose");
        ItemUtils.addItemToOreDictionary(mRedCelluloseFiber, "fiberCellulose");
        ItemUtils.addItemToOreDictionary(mRedCelluloseFiber, "fiberRedCellulose");
        ItemUtils.addItemToOreDictionary(mWoodPellet, "pelletWood");
        ItemUtils.addItemToOreDictionary(mWoodBrick, "brickWood");
        ItemUtils.addItemToOreDictionary(mCellulosePulp, "pulpCellulose");
        ItemUtils.addItemToOreDictionary(mCatalystCarrier, "catalystEmpty");
        ItemUtils.addItemToOreDictionary(mGreenCatalyst, "catalystAluminiumSilver");
        ItemUtils.addItemToOreDictionary(mAlginicAcid, "dustAlginicAcid");
        ItemUtils.addItemToOreDictionary(mAlumina, "dustAlumina");
        ItemUtils.addItemToOreDictionary(mAluminiumPellet, "pelletAluminium");
        ItemUtils.addItemToOreDictionary(mSodiumAluminate, "dustSodiumAluminate");
        ItemUtils.addItemToOreDictionary(mSodiumHydroxide, "dustSodiumHydroxide");
        ItemUtils.addItemToOreDictionary(mSodiumCarbonate, "dustSodiumCarbonate");
        ItemUtils.addItemToOreDictionary(mLithiumChloride, "dustLithiumChloride");
        ItemUtils.addItemToOreDictionary(mPinecone, "pinecone");
        ItemUtils.addItemToOreDictionary(mCrushedPine, "crushedPineMaterial");
        List NaOHSmall = OreDictionary.getOres((String)"dustSmallSodiumHydroxide_GT5U", (boolean)false);
        if (!NaOHSmall.isEmpty()) {
            ItemUtils.addItemToOreDictionary((ItemStack)NaOHSmall.get(0), "dustSmallSodiumHydroxide");
        }
        if (!(NaOHTiny = OreDictionary.getOres((String)"dustTinySodiumHydroxide_GT5U", (boolean)false)).isEmpty()) {
            ItemUtils.addItemToOreDictionary((ItemStack)NaOHTiny.get(0), "dustTinySodiumHydroxide");
        }
    }

    @Override
    public void blocks() {
    }

    @Override
    public void fluids() {
        PoopJuice = FluidUtils.generateFluidNonMolten("raw.waste", "Raw Animal Waste", 207, new short[]{100, 70, 30, 100}, null, null, 0, true);
        ManureSlurry = FluidUtils.generateFluidNonMolten("manure.slurry", "Manure Slurry", 214, new short[]{75, 45, 15, 100}, null, null, 0, true);
        FertileManureSlurry = FluidUtils.generateFluidNonMolten("fertile.manure.slurry", "Fertile Manure Slurry", 220, new short[]{65, 50, 15, 100}, null, null, 0, true);
        RedMud = FluidUtils.generateFluidNoPrefix("mud.red.slurry", "Red Mud Slurry", 207, new short[]{180, 35, 25, 100}, true);
    }

    public AgriculturalChem() {
        FluidStack aBlood;
        aBOP = Mods.BiomesOPlenty.isModLoaded();
        aTiCon = Mods.TinkerConstruct.isModLoaded();
        Logger.INFO("Adding Agrochemical content");
        if (aBOP && (aBlood = FluidUtils.getFluidStack("hell_blood", 100)) != null) {
            Logger.INFO("Found Biome's o Plenty, enabled Blood support.");
            CustomBlood = aBlood.getFluid();
            mBloodFluids.add(aBlood);
        }
        if (aTiCon && (aBlood = FluidUtils.getFluidStack("blood", 100)) != null) {
            Logger.INFO("Found Tinker's Construct, enabled Blood support.");
            CustomBlood = aBlood.getFluid();
            mBloodFluids.add(FluidUtils.getFluidStack("blood", 100));
        }
        if (mBloodFluids.isEmpty() || CustomBlood == null) {
            Logger.INFO("Did not find any existing Blood fluids. Trying to wildcard search the fluid registry, then generate our own if that fails.");
            FluidStack aTempBlood = FluidUtils.getWildcardFluidStack("blood", 100);
            CustomBlood = aTempBlood != null ? aTempBlood.getFluid() : ((aTempBlood = FluidUtils.getWildcardFluidStack("hell_blood", 100)) == null ? FluidUtils.generateFluidNoPrefix("blood", "Blood", 207, new short[]{175, 25, 25, 100}, true) : aTempBlood.getFluid());
            Logger.INFO("Using " + CustomBlood.getName());
            mBloodFluids.add(FluidUtils.getFluidStack(CustomBlood, 100));
        }
    }

    private static void processAllOreDict() {
        boolean foundDupe;
        AgriculturalChem.processOreDict("listAllmeatraw", mMeats);
        AgriculturalChem.processOreDict("listAllfishraw", mFish);
        AgriculturalChem.processOreDict("listAllfruit", mFruits);
        AgriculturalChem.processOreDict("listAllVeggie", mVege);
        AgriculturalChem.processOreDict("listAllnut", mNuts);
        AgriculturalChem.processOreDict("listAllSeed", mSeeds);
        AgriculturalChem.processOreDict("brickPeat", mPeat);
        AgriculturalChem.processOreDict("bone", mBones);
        AgriculturalChem.processOreDict("dustBone", mBoneMeal);
        if (!mMeats.isEmpty()) {
            mList_Master_Meats.addAll(mMeats);
        }
        if (!mFish.isEmpty()) {
            for (ItemStack g : mFish) {
                foundDupe = false;
                for (ItemStack old : mList_Master_Meats) {
                    if (!GTUtility.areStacksEqual(g, old)) continue;
                    foundDupe = true;
                    break;
                }
                if (foundDupe) continue;
                mList_Master_Meats.add(g);
            }
        }
        if (!mFruits.isEmpty()) {
            mList_Master_FruitVege.addAll(mFruits);
        }
        if (!mVege.isEmpty()) {
            mList_Master_FruitVege.addAll(mVege);
        }
        if (!mNuts.isEmpty()) {
            mList_Master_FruitVege.addAll(mNuts);
        }
        if (!mSeeds.isEmpty()) {
            mList_Master_Seeds.addAll(mSeeds);
        }
        if (!mBoneMeal.isEmpty()) {
            mList_Master_Bones.addAll(mBoneMeal);
        }
        if (!mBones.isEmpty()) {
            for (ItemStack g : mBones) {
                foundDupe = false;
                for (ItemStack old : mList_Master_Bones) {
                    if (!GTUtility.areStacksEqual(g, old)) continue;
                    foundDupe = true;
                    break;
                }
                if (foundDupe) continue;
                mList_Master_Bones.add(g);
            }
        }
    }

    private static void processOreDict(String aOreName, ArrayList<ItemStack> aMap) {
        ArrayList aTemp = OreDictionary.getOres((String)aOreName);
        if (!aTemp.isEmpty()) {
            aMap.addAll(aTemp);
        }
    }

    private static void addBasicSlurryRecipes() {
        ItemStack aManureByprod1 = ItemUtils.getItemStackOfAmountFromOreDict("dustTinyManureByproducts", 1);
        ItemStack aManureByprod2 = ItemUtils.getItemStackOfAmountFromOreDict("dustSmallManureByproducts", 1);
        ItemStack aDirtDust = ItemUtils.getSimpleStack(dustDirt, 1);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(10)).itemOutputs(aDirtDust, aDirtDust, aManureByprod1, aManureByprod1, aManureByprod1, aManureByprod1).outputChances(2000, 2000, 500, 500, 250, 250).fluidInputs(FluidUtils.getFluidStack(PoopJuice, 1000)).fluidOutputs(FluidUtils.getFluidStack(ManureSlurry, 250)).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(20)).itemOutputs(aDirtDust, aDirtDust, aManureByprod1, aManureByprod1, aManureByprod2, aManureByprod2).outputChances(4000, 3000, 1250, 1250, 675, 675).fluidInputs(FluidUtils.getFluidStack(PoopJuice, 1000)).fluidOutputs(FluidUtils.getFluidStack(ManureSlurry, 50)).duration(400).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.centrifugeRecipes);
    }

    private static void addAdvancedSlurryRecipes() {
        ItemStack aCircuit = GTUtility.getIntegratedCircuit(10);
        ItemStack aEmptyCells = Materials.Empty.getCells(2);
        ItemStack aInputCells = ItemUtils.getItemStackOfAmountFromOreDict("cellRawAnimalWaste", 2);
        FluidStack aOutput = FluidUtils.getFluidStack(FertileManureSlurry, 1000);
        for (FluidStack aBloodStack : mBloodFluids) {
            for (ItemStack aBoneStack : mList_Master_Bones) {
                ItemStack aBone = ItemUtils.getSimpleStack(aBoneStack, 2);
                for (ItemStack aMeatStack : mList_Master_Meats) {
                    ItemStack aMeat = ItemUtils.getSimpleStack(aMeatStack, 5);
                    GTValues.RA.stdBuilder().itemInputs(aCircuit, aBone, aMeat, aInputCells).itemOutputs(aEmptyCells).fluidInputs(aBloodStack).fluidOutputs(aOutput).duration(160).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.mixerRecipes);
                }
            }
        }
    }

    private static void addBasicOrganiseFertRecipes() {
        FluidStack aInputFluid = FluidUtils.getFluidStack(ManureSlurry, 1000);
        ItemStack aOutputDust = ItemUtils.getSimpleStack(dustOrganicFertilizer, 3);
        for (ItemStack aPeatStack : mPeat) {
            ItemStack aMeat;
            ItemStack aPeat = ItemUtils.getSimpleStack(aPeatStack, 3);
            for (ItemStack aMeatStack : mList_Master_Meats) {
                aMeat = ItemUtils.getSimpleStack(aMeatStack, 5);
                GTValues.RA.stdBuilder().itemInputs(aPeat, aMeat).itemOutputs(aOutputDust).fluidInputs(aInputFluid).duration(400).eut(TierEU.RECIPE_MV).addTo(GTRecipeConstants.UniversalChemical);
            }
            aPeat = ItemUtils.getSimpleStack(aPeatStack, 2);
            for (ItemStack aMeatStack : mList_Master_FruitVege) {
                aMeat = ItemUtils.getSimpleStack(aMeatStack, 9);
                GTValues.RA.stdBuilder().itemInputs(aPeat, aMeat).itemOutputs(aOutputDust).fluidInputs(aInputFluid).duration(200).eut(TierEU.RECIPE_MV).addTo(GTRecipeConstants.UniversalChemical);
            }
        }
    }

    private static void addAdvancedOrganiseFertRecipes() {
        FluidStack aInputFluid = FluidUtils.getFluidStack(FertileManureSlurry, 1000);
        ItemStack aOutputDust = ItemUtils.getSimpleStack(dustOrganicFertilizer, 7);
        for (ItemStack aPeatStack : mPeat) {
            ItemStack aMeat;
            ItemStack aPeat = ItemUtils.getSimpleStack(aPeatStack, 5);
            for (ItemStack aMeatStack : mList_Master_Meats) {
                aMeat = ItemUtils.getSimpleStack(aMeatStack, 7);
                GTValues.RA.stdBuilder().itemInputs(aPeat, aMeat).itemOutputs(aOutputDust).fluidInputs(aInputFluid).duration(200).eut(140).addTo(GTRecipeConstants.UniversalChemical);
            }
            aPeat = ItemUtils.getSimpleStack(aPeatStack, 3);
            for (ItemStack aMeatStack : mList_Master_FruitVege) {
                aMeat = ItemUtils.getSimpleStack(aMeatStack, 12);
                GTValues.RA.stdBuilder().itemInputs(aPeat, aMeat).itemOutputs(aOutputDust).fluidInputs(aInputFluid).duration(100).eut(140).addTo(GTRecipeConstants.UniversalChemical);
            }
        }
    }

    private static void addMiscRecipes() {
        ItemStack aDustOrganicFert = ItemUtils.getSimpleStack(dustOrganicFertilizer, 1);
        ItemStack aManureByprod = ItemUtils.getSimpleStack(dustManureByproducts, 1);
        if (Mods.Forestry.isModLoaded()) {
            AgriculturalChem.addMiscForestryRecipes();
        }
        aFertIC2 = ItemUtils.getItemStackFromFQRN("IC2:itemFertilizer", 1);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(12), ItemUtils.getSimpleStack(aDustOrganicFert, 4)).itemOutputs(ItemUtils.getItemStackFromFQRN("IC2:itemFertilizer", 3), aManureByprod, aManureByprod).outputChances(10000, 2000, 2000).eut(240).duration(400).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(dustDirt, 9)).itemOutputs(ItemUtils.getSimpleStack(Blocks.field_150346_d)).duration(40).eut(8).addTo(RecipeMaps.compressorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(aManureByprod, 4), GTUtility.getIntegratedCircuit(20)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Phosphorus, 2L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Calcium, 2L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Copper, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Carbon, 1L), ItemUtils.getSimpleStack(dustDirt, 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAmmoniumNitrate", 1)).outputChances(2500, 2500, 750, 1000, 5000, 250).fluidInputs(Materials.SulfuricAcid.getFluid(250L)).fluidOutputs(FluidUtils.getFluidStack("sulfuricapatite", 50)).duration(400).eut(TierEU.RECIPE_MV / 2L).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().fluidInputs(FluidUtils.getFluidStack(PoopJuice, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 12).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().fluidInputs(FluidUtils.getFluidStack(ManureSlurry, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 24).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().fluidInputs(FluidUtils.getFluidStack(FertileManureSlurry, 1000)).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 32).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().itemInputs(CI.getNumberedBioCircuit(10)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Iron, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Copper, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Tin, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Sulfur, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Nickel, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Lead, 1L)).outputChances(3000, 3000, 2000, 2000, 1000, 1000).fluidInputs(FluidUtils.getFluidStack(RedMud, 1000)).fluidOutputs(Materials.Water.getFluid(500L)).duration(600).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.centrifugeRecipes);
    }

    @Optional.Method(modid="Forestry")
    private static void addMiscForestryRecipes() {
        ItemStack aDustOrganicFert = ItemUtils.getSimpleStack(dustOrganicFertilizer, 1);
        ItemStack aManureByprod = ItemUtils.getSimpleStack(dustManureByproducts, 1);
        ItemRegistryCore aItemRegInstance = PluginCore.items;
        if (aItemRegInstance != null) {
            ItemForestryBonemeal fertilizerCompound = aItemRegInstance.fertilizerCompound;
            aFertForestry = ItemUtils.getSimpleStack((Item)fertilizerCompound);
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(11), ItemUtils.getSimpleStack(aDustOrganicFert, 4)).itemOutputs(ItemUtils.getSimpleStack((Item)fertilizerCompound, 3), aManureByprod, aManureByprod).outputChances(10000, 2000, 2000).eut(240).duration(400).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        }
    }

    @Override
    public String errorMessage() {
        return "Failed to generate recipes for AgroChem.";
    }

    @Override
    public boolean generateRecipes() {
        if (mBloodFluids.isEmpty()) {
            Logger.INFO("Could not find, nor create Blood fluid. Unable to add recipes.");
            return false;
        }
        AgriculturalChem.processAllOreDict();
        AgriculturalChem.addBasicSlurryRecipes();
        AgriculturalChem.addAdvancedSlurryRecipes();
        AgriculturalChem.addBasicOrganiseFertRecipes();
        AgriculturalChem.addAdvancedOrganiseFertRecipes();
        AgriculturalChem.addMiscRecipes();
        BioRecipes.init();
        return true;
    }

    static {
        mBloodFluids = new ArrayList();
        mMeats = new ArrayList();
        mFish = new ArrayList();
        mFruits = new ArrayList();
        mVege = new ArrayList();
        mNuts = new ArrayList();
        mSeeds = new ArrayList();
        mPeat = new ArrayList();
        mBones = new ArrayList();
        mBoneMeal = new ArrayList();
        mList_Master_Meats = new ArrayList();
        mList_Master_FruitVege = new ArrayList();
        mList_Master_Seeds = new ArrayList();
        mList_Master_Bones = new ArrayList();
    }
}

