/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.minecraft.ItemPackage;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.item.chemistry.CoalTar;
import gtPlusPlus.core.item.chemistry.RocketFuels;
import gtPlusPlus.core.item.chemistry.general.ItemGenericChemBase;
import gtPlusPlus.core.item.circuit.GTPPIntegratedCircuitItem;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.MaterialsElements;
import gtPlusPlus.core.material.MaterialsOther;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.plugin.agrichem.block.AgrichemFluids;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class GenericChem
extends ItemPackage {
    public static final Material TEFLON = new Material("Teflon", MaterialState.SOLID, TextureSet.SET_SHINY, new short[]{75, 45, 75}, 330, 640, -1L, -1L, false, null, 0, new MaterialStack(MaterialsOther.PTFE, 75.0), new MaterialStack(MaterialsOther.PLASTIC, 15.0), new MaterialStack(MaterialsElements.getInstance().CARBON, 5.0), new MaterialStack(MaterialsElements.getInstance().SODIUM, 5.0));
    public static Fluid Benzene;
    public static Fluid NitroBenzene;
    public static Fluid Aniline;
    public static Fluid Polyurethane;
    public static Fluid Phenol;
    public static Fluid Cyclohexane;
    public static Fluid Cyclohexanone;
    public static Fluid Cadaverine;
    public static Fluid Putrescine;
    public static Fluid BoricAcid;
    public static Fluid HydrochloricAcid;
    public static Fluid Ethylanthraquinone2;
    public static Fluid Ethylanthrahydroquinone2;
    public static Fluid Hydrogen_Peroxide;
    public static Fluid Lithium_Peroxide;
    public static Fluid Carbon_Disulfide;
    public static ItemGenericChemBase mGenericChemItem1;
    public static Item mAdvancedCircuit;
    private ItemStack mCatalystCarrier;
    public static ItemStack mRedCatalyst;
    public static ItemStack mYellowCatalyst;
    public static ItemStack mBlueCatalyst;
    public static ItemStack mOrangeCatalyst;
    public static ItemStack mPurpleCatalyst;
    public static ItemStack mBrownCatalyst;
    public static ItemStack mPinkCatalyst;
    public static ItemStack mFormaldehydeCatalyst;
    public static ItemStack mSolidAcidCatalyst;
    public static ItemStack mInfiniteMutationCatalyst;
    public static ItemStack mPlatinumGroupCatalyst;
    public static ItemStack mPlasticPolymerCatalyst;
    public static ItemStack mRubberPolymerCatalyst;
    public static ItemStack mAdhesionPromoterCatalyst;
    public static ItemStack mTitaTungstenIndiumCatalyst;
    public static ItemStack mRadioactivityCatalyst;
    public static ItemStack mRareEarthGroupCatalyst;
    public static ItemStack mLimpidWaterCatalyst;
    public static ItemStack mSimpleNaquadahCatalyst;
    public static ItemStack mAdvancedNaquadahCatalyst;
    public static ItemStack mRawIntelligenceCatalyst;
    public static ItemStack mParticleAccelerationCatalyst;
    public static ItemStack mUltimatePlasticCatalyst;
    public static ItemStack mBiologicalIntelligenceCatalyst;
    public static ItemStack mFlawlessWaterCatalyst;
    public static ItemStack TemporalHarmonyCatalyst;
    public static ItemStack mSynchrotronCapableCatalyst;
    public static ItemStack mAlgagenicGrowthPromoterCatalyst;
    public static ItemStack mMillingBallAlumina;
    public static ItemStack mMillingBallSoapstone;
    public static ItemStack mSodiumEthoxide;
    public static ItemStack mSodiumEthylXanthate;
    public static ItemStack mPotassiumEthylXanthate;
    public static ItemStack mPotassiumHydroxide;

    @Override
    public void items() {
        MaterialGenerator.generate(TEFLON, false);
        mGenericChemItem1 = new ItemGenericChemBase();
        mAdvancedCircuit = new GTPPIntegratedCircuitItem("T3RecipeSelector", "science/general/AdvancedCircuit");
        GregtechItemList.Circuit_T3RecipeSelector.set(mAdvancedCircuit);
        this.registerItemStacks();
        this.registerOreDict();
        GregtechItemList.Milling_Ball_Alumina.set(mMillingBallAlumina);
        GregtechItemList.Milling_Ball_Soapstone.set(mMillingBallSoapstone);
    }

    public void registerItemStacks() {
        this.mCatalystCarrier = ItemUtils.simpleMetaStack(AgriculturalChem.mAgrichemItem1, 13, 1);
        mRedCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 0, 1);
        mYellowCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 1, 1);
        mBlueCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 2, 1);
        mOrangeCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 3, 1);
        mPurpleCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 4, 1);
        mBrownCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 5, 1);
        mPinkCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 6, 1);
        mMillingBallAlumina = ItemUtils.simpleMetaStack(mGenericChemItem1, 7, 1);
        mMillingBallSoapstone = ItemUtils.simpleMetaStack(mGenericChemItem1, 8, 1);
        mSodiumEthoxide = ItemUtils.simpleMetaStack(mGenericChemItem1, 9, 1);
        mSodiumEthylXanthate = ItemUtils.simpleMetaStack(mGenericChemItem1, 10, 1);
        mPotassiumEthylXanthate = ItemUtils.simpleMetaStack(mGenericChemItem1, 11, 1);
        mPotassiumHydroxide = ItemUtils.simpleMetaStack(mGenericChemItem1, 12, 1);
        mFormaldehydeCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 13, 1);
        mSolidAcidCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 14, 1);
        mInfiniteMutationCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 15, 1);
        mPlatinumGroupCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 16, 1);
        mPlasticPolymerCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 17, 1);
        mRubberPolymerCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 18, 1);
        mAdhesionPromoterCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 19, 1);
        mTitaTungstenIndiumCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 20, 1);
        mRadioactivityCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 21, 1);
        mRareEarthGroupCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 22, 1);
        mSimpleNaquadahCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 23, 1);
        mAdvancedNaquadahCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 24, 1);
        mRawIntelligenceCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 25, 1);
        mUltimatePlasticCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 26, 1);
        mBiologicalIntelligenceCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 27, 1);
        TemporalHarmonyCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 28, 1);
        mLimpidWaterCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 29, 1);
        mFlawlessWaterCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 30, 1);
        mParticleAccelerationCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 31, 1);
        mSynchrotronCapableCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 32, 1);
        mAlgagenicGrowthPromoterCatalyst = ItemUtils.simpleMetaStack(mGenericChemItem1, 33, 1);
    }

    public void registerOreDict() {
        ItemUtils.addItemToOreDictionary(mRedCatalyst, "catalystIronCopper");
        ItemUtils.addItemToOreDictionary(mYellowCatalyst, "catalystTungstenNickel");
        ItemUtils.addItemToOreDictionary(mBlueCatalyst, "catalystCobaltTitanium");
        ItemUtils.addItemToOreDictionary(mOrangeCatalyst, "catalystVanadiumPalladium");
        ItemUtils.addItemToOreDictionary(mPurpleCatalyst, "catalystIridiumRuthenium");
        ItemUtils.addItemToOreDictionary(mBrownCatalyst, "catalystNickelAluminium");
        ItemUtils.addItemToOreDictionary(mPinkCatalyst, "catalystPlatinumRhodium");
        ItemUtils.addItemToOreDictionary(mMillingBallAlumina, "millingballAlumina");
        ItemUtils.addItemToOreDictionary(mMillingBallSoapstone, "millingballSoapstone");
        ItemUtils.addItemToOreDictionary(mSodiumEthoxide, "dustSodiumEthoxide");
        ItemUtils.addItemToOreDictionary(mSodiumEthylXanthate, "dustSodiumEthylXanthate");
        ItemUtils.addItemToOreDictionary(mPotassiumEthylXanthate, "dustPotassiumEthylXanthate");
        ItemUtils.addItemToOreDictionary(mPotassiumHydroxide, "dustPotassiumHydroxide");
        ItemUtils.addItemToOreDictionary(mFormaldehydeCatalyst, "catalystFormaldehyde");
        ItemUtils.addItemToOreDictionary(mSolidAcidCatalyst, "catalystSolidAcid");
        ItemUtils.addItemToOreDictionary(mInfiniteMutationCatalyst, "catalystInfiniteMutation");
        ItemUtils.addItemToOreDictionary(mPlatinumGroupCatalyst, "catalystPlatinumGroup");
        ItemUtils.addItemToOreDictionary(mPlasticPolymerCatalyst, "catalystPlasticPolymer");
        ItemUtils.addItemToOreDictionary(mRubberPolymerCatalyst, "catalystRubberPolymer");
        ItemUtils.addItemToOreDictionary(mAdhesionPromoterCatalyst, "catalystAdhesionPromoter");
        ItemUtils.addItemToOreDictionary(mTitaTungstenIndiumCatalyst, "catalystTitaTungstenIndium");
        ItemUtils.addItemToOreDictionary(mRadioactivityCatalyst, "catalystRadioactivity");
        ItemUtils.addItemToOreDictionary(mRareEarthGroupCatalyst, "catalystRareEarthGroup");
        ItemUtils.addItemToOreDictionary(mSimpleNaquadahCatalyst, "catalystSimpleNaquadah");
        ItemUtils.addItemToOreDictionary(mAdvancedNaquadahCatalyst, "catalystAdvancedNaquadah");
        ItemUtils.addItemToOreDictionary(mRawIntelligenceCatalyst, "catalystRawIntelligence");
        ItemUtils.addItemToOreDictionary(mUltimatePlasticCatalyst, "catalystUltimatePlastic");
        ItemUtils.addItemToOreDictionary(mBiologicalIntelligenceCatalyst, "catalystBiologicalIntelligence");
        ItemUtils.addItemToOreDictionary(TemporalHarmonyCatalyst, "catalystTemporalHarmony");
        ItemUtils.addItemToOreDictionary(mLimpidWaterCatalyst, "catalystLimpidWater");
        ItemUtils.addItemToOreDictionary(mFlawlessWaterCatalyst, "catalystFlawlessWater");
        ItemUtils.addItemToOreDictionary(mParticleAccelerationCatalyst, "catalystParticleAcceleration");
        ItemUtils.addItemToOreDictionary(mSynchrotronCapableCatalyst, "catalystSynchrotronCapable");
        ItemUtils.addItemToOreDictionary(mAlgagenicGrowthPromoterCatalyst, "catalystAlgagenicGrowthPromoter");
    }

    @Override
    public void blocks() {
    }

    @Override
    public void fluids() {
        Benzene = !FluidRegistry.isFluidRegistered((String)"benzene") ? FluidUtils.generateFluidNoPrefix("benzene", "Benzene", 278, new short[]{100, 70, 30, 100}, true) : FluidRegistry.getFluid((String)"benzene");
        NitroBenzene = FluidUtils.generateFluidNoPrefix("nitrobenzene", "Nitrobenzene", 278, new short[]{70, 50, 40, 100}, true);
        Aniline = FluidUtils.generateFluidNoPrefix("aniline", "Aniline", 266, new short[]{100, 100, 30, 100}, true);
        BoricAcid = FluidUtils.generateFluidNoPrefix("boricacid", "Boric Acid", 278, new short[]{90, 30, 120, 100}, true);
        Polyurethane = FluidUtils.generateFluidNoPrefix("polyurethane", "Polyurethane", 350, new short[]{100, 70, 100, 100}, true);
        Phenol = !FluidRegistry.isFluidRegistered((String)"phenol") ? FluidUtils.generateFluidNoPrefix("phenol", "Phenol", 313, new short[]{100, 70, 30, 100}, true) : FluidRegistry.getFluid((String)"phenol");
        HydrochloricAcid = FluidRegistry.isFluidRegistered((String)"hydrochloricacid_gt5u") ? FluidRegistry.getFluid((String)"hydrochloricacid_gt5u") : FluidUtils.generateFluidNoPrefix("hydrochloricacid", "Hydrochloric Acid", 285, new short[]{183, 200, 196, 100}, true);
        Cyclohexane = FluidUtils.generateFluidNoPrefix("cyclohexane", "Cyclohexane", 207, new short[]{100, 70, 30, 100}, true);
        Cyclohexanone = FluidUtils.generateFluidNoPrefix("cyclohexanone", "Cyclohexanone", 207, new short[]{100, 70, 30, 100}, true);
        Cadaverine = FluidUtils.generateFluidNoPrefix("cadaverine", "Cadaverine", 207, new short[]{100, 70, 30, 100}, true);
        Putrescine = FluidUtils.generateFluidNoPrefix("putrescine", "Putrescine", 207, new short[]{100, 70, 30, 100}, true);
        Ethylanthraquinone2 = FluidUtils.generateFluidNonMolten("2Ethylanthraquinone", "2-Ethylanthraquinone", 415, new short[]{227, 255, 159, 100}, null, null);
        Ethylanthrahydroquinone2 = FluidUtils.generateFluidNonMolten("2Ethylanthrahydroquinone", "2-Ethylanthrahydroquinone", 415, new short[]{207, 225, 129, 100}, null, null);
        Hydrogen_Peroxide = FluidUtils.generateFluidNonMolten("HydrogenPeroxide", "Hydrogen Peroxide", 150, new short[]{210, 255, 255, 100}, null, null);
        Lithium_Peroxide = FluidUtils.generateFluidNonMolten("LithiumPeroxide", "Lithium Peroxide", 446, new short[]{135, 135, 135, 100}, null, null);
        Carbon_Disulfide = FluidUtils.generateFluidNoPrefix("CarbonDisulfide", "Carbon Disulfide", 350, new short[]{175, 175, 175, 100});
    }

    @Override
    public String errorMessage() {
        return "Failed to generate recipes for GenericChem.";
    }

    @Override
    public boolean generateRecipes() {
        GenericChem.recipeAdvancedChip();
        this.recipeCatalystRed();
        this.recipeCatalystYellow();
        this.recipeCatalystBlue();
        this.recipeCatalystOrange();
        this.recipeCatalystPurple();
        this.recipeCatalystBrown();
        this.recipeCatalystPink();
        this.recipeCatalystFormaldehyde();
        this.recipeCatalystSolidAcid();
        this.recipeCatalystInfiniteMutation();
        this.recipeGrindingBallAlumina();
        this.recipeGrindingBallSoapstone();
        this.recipeNitroBenzene();
        this.recipeAniline();
        this.recipeCadaverineAndPutrescine();
        this.recipeCyclohexane();
        this.recipeCyclohexanone();
        this.recipe2Ethylanthraquinone();
        this.recipe2Ethylanthrahydroquinone();
        this.recipeHydrogenPeroxide();
        this.recipeLithiumHydroperoxide();
        this.recipeLithiumPeroxide();
        this.recipeSodiumEthoxide();
        this.recipeCarbonDisulfide();
        this.recipeEthylXanthates();
        this.recipePotassiumHydroxide();
        this.recipeMutatedLivingSolder();
        GenericChem.registerFuels();
        return true;
    }

    private void recipeSodiumEthoxide() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(16), MaterialsElements.getInstance().SODIUM.getDust(1)).itemOutputs(ItemUtils.getSimpleStack(mSodiumEthoxide, 9)).fluidInputs(Materials.Ethanol.getFluid(1000L)).fluidOutputs(MaterialsElements.getInstance().HYDROGEN.getFluidStack(1000)).duration(400).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipePotassiumHydroxide() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(18), Materials.Potash.getDust(3), ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumHydroxide", 5)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumCarbonate", 5), ItemUtils.getSimpleStack(mPotassiumHydroxide, 6)).fluidInputs(Materials.CarbonDioxide.getGas(1000L)).duration(600).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeEthylXanthates() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(17), ItemUtils.getSimpleStack(mPotassiumHydroxide, 3)).itemOutputs(ItemUtils.getSimpleStack(mPotassiumEthylXanthate, 12)).fluidInputs(Materials.Ethanol.getFluid(1000L), FluidUtils.getFluidStack(Carbon_Disulfide, 1000)).fluidOutputs(FluidUtils.getWater(1000)).duration(1200).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 4).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(17), ItemUtils.getSimpleStack(mSodiumEthoxide, 9)).itemOutputs(ItemUtils.getSimpleStack(mSodiumEthylXanthate, 12)).fluidInputs(FluidUtils.getFluidStack(Carbon_Disulfide, 1000)).duration(1200).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 4).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeCarbonDisulfide() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 8), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Sulfur, 16L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.DarkAsh, 1L)).fluidOutputs(FluidUtils.getFluidStack(Carbon_Disulfide, 4000)).duration(12000).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.COIL_HEAT, 1500).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(20), ItemUtils.getSimpleStack(mBrownCatalyst, 0), ItemUtils.getItemStackOfAmountFromOreDict("dustSulfur", 4)).fluidInputs(FluidUtils.getFluidStack(CoalTar.Coal_Gas, 1000)).fluidOutputs(FluidUtils.getFluidStack(Carbon_Disulfide, 2000)).duration(6000).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeMutatedLivingSolder() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(mInfiniteMutationCatalyst, 0), ItemList.Circuit_Chip_Biocell.get(64L, new Object[0]), ItemList.Gravistar.get(8L, new Object[0]), Materials.InfinityCatalyst.getDust(2)).fluidInputs(FluidUtils.getFluidStack("plasma.tin", 18000), FluidUtils.getFluidStack("plasma.bismuth", 18000), FluidUtils.getFluidStack("cryotheum", 4000)).fluidOutputs(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(40320)).duration(16000).eut(3842160).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 7).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static void registerFuels() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellNitrobenzene", 1)).metadata(GTRecipeConstants.FUEL_VALUE, 1600).metadata(GTRecipeConstants.FUEL_TYPE, 1).duration(0).eut(0).addTo(GTRecipeConstants.Fuel);
    }

    private void recipeGrindingBallAlumina() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(AgriculturalChem.mAlumina, 64), GTUtility.getIntegratedCircuit(10)).itemOutputs(ItemUtils.getSimpleStack(mMillingBallAlumina, 8)).fluidInputs(FluidUtils.getFluidStack(Aniline, 4000)).duration(3600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeGrindingBallSoapstone() {
        GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Soapstone, 32L), GTUtility.getIntegratedCircuit(10)).itemOutputs(ItemUtils.getSimpleStack(mMillingBallSoapstone, 8)).fluidInputs(FluidUtils.getFluidStack(AgrichemFluids.mLiquidResin, 2500)).duration(2400).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCyclohexane() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierTwoChip(), ItemUtils.getSimpleStack(mBrownCatalyst, 0)).fluidInputs(FluidUtils.getFluidStack(Benzene, 1000), FluidUtils.getFluidStack("hydrogen", 6000)).fluidOutputs(FluidUtils.getFluidStack(Cyclohexane, 1000)).duration(2400).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeCyclohexanone() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierTwoChip(), ItemUtils.getSimpleStack(mBlueCatalyst, 0)).fluidInputs(FluidUtils.getFluidStack(Cyclohexane, 1000), FluidUtils.getFluidStack("air", 4000)).fluidOutputs(FluidUtils.getFluidStack(Cyclohexanone, 1000)).duration(2400).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierTwoChip()).fluidInputs(FluidUtils.getFluidStack(Cyclohexane, 1000), FluidUtils.getFluidStack("oxygen", 2000)).fluidOutputs(FluidUtils.getFluidStack(Cyclohexanone, 1000)).duration(2400).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeCatalystRed() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierOneChip(), CI.getEmptyCatalyst(10), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Iron, 2L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Copper, 2L)).itemOutputs(ItemUtils.getSimpleStack(mRedCatalyst, 10)).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystYellow() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierThreeChip(), CI.getEmptyCatalyst(10), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Tungsten, 4L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Nickel, 4L)).itemOutputs(ItemUtils.getSimpleStack(mYellowCatalyst, 10)).duration(1200).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystBlue() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierTwoChip(), CI.getEmptyCatalyst(10), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Cobalt, 3L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Titanium, 3L)).itemOutputs(ItemUtils.getSimpleStack(mBlueCatalyst, 10)).duration(800).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystOrange() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierTwoChip(), CI.getEmptyCatalyst(10), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Vanadium, 5L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Palladium, 5L)).itemOutputs(ItemUtils.getSimpleStack(mOrangeCatalyst, 10)).duration(800).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystPurple() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierFourChip(), CI.getEmptyCatalyst(10), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Iridium, 6L), MaterialsElements.getInstance().RUTHENIUM.getDust(6)).itemOutputs(ItemUtils.getSimpleStack(mPurpleCatalyst, 10)).duration(2400).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystBrown() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierOneChip(), CI.getEmptyCatalyst(10), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Nickel, 4L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Aluminium, 4L)).itemOutputs(ItemUtils.getSimpleStack(mBrownCatalyst, 10)).duration(300).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystPink() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierThreeChip(), CI.getEmptyCatalyst(10), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Platinum, 4L), MaterialsElements.getInstance().RHODIUM.getDust(4)).itemOutputs(ItemUtils.getSimpleStack(mPinkCatalyst, 10)).duration(600).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystFormaldehyde() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierThreeChip(), CI.getEmptyCatalyst(4), ItemUtils.getSimpleStack(RocketFuels.Formaldehyde_Catalyst_Dust, 8)).itemOutputs(ItemUtils.getSimpleStack(mFormaldehydeCatalyst, 4)).duration(600).eut(TierEU.RECIPE_HV / 2L).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystSolidAcid() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierThreeChip(), CI.getEmptyCatalyst(5), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Lapis, 2L)).itemOutputs(ItemUtils.getSimpleStack(mSolidAcidCatalyst, 5)).fluidInputs(MaterialMisc.SOLID_ACID_MIXTURE.getFluidStack(1000)).duration(600).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCatalystInfiniteMutation() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierThreeChip(), CI.getEmptyCatalyst(5), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Infinity, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Naquadria, 10L)).itemOutputs(ItemUtils.getSimpleStack(mInfiniteMutationCatalyst, 5)).duration(100).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.assemblerRecipes);
    }

    private void recipeCadaverineAndPutrescine() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierOneChip(), ItemUtils.getSimpleStack(Items.field_151078_bh, 64)).fluidInputs(FluidUtils.getHotWater(2000)).fluidOutputs(FluidUtils.getFluidStack(Cadaverine, 250), FluidUtils.getFluidStack(Putrescine, 250)).duration(2400).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierTwoChip(), ItemUtils.getSimpleStack(Items.field_151078_bh, 128), ItemUtils.simpleMetaStack(AgriculturalChem.mAgrichemItem1, 8, 32)).fluidInputs(FluidUtils.getHotWater(3000)).fluidOutputs(FluidUtils.getFluidStack(Cadaverine, 750), FluidUtils.getFluidStack(Putrescine, 750)).duration(2400).eut(240).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeAniline() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierThreeChip(), ItemUtils.getSimpleStack(mBlueCatalyst, 0)).fluidInputs(FluidUtils.getFluidStack(NitroBenzene, 1000), FluidUtils.getFluidStack("hydrogen", 6000)).fluidOutputs(FluidUtils.getFluidStack(Aniline, 1000)).duration(600).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 3).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeNitroBenzene() {
        GTValues.RA.stdBuilder().itemInputs(GenericChem.getTierThreeChip()).fluidInputs(FluidUtils.getFluidStack(Benzene, 5000), FluidUtils.getFluidStack("sulfuricacid", 1000), FluidUtils.getFluidStack("nitricacid", 5000), FluidUtils.getDistilledWater(10000)).fluidOutputs(FluidUtils.getFluidStack(NitroBenzene, 5000)).duration(600).eut(TierEU.RECIPE_HV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 4).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipe2Ethylanthraquinone() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4), ItemUtils.getItemStackOfAmountFromOreDict("dustPhthalicAnhydride", 15)).fluidInputs(FluidUtils.getFluidStack(CoalTar.Ethylbenzene, 1000)).fluidOutputs(FluidUtils.getFluidStack(Ethylanthraquinone2, 1000)).duration(300).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipe2Ethylanthrahydroquinone() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4), ItemUtils.getSimpleStack(mOrangeCatalyst, 0)).fluidInputs(FluidUtils.getFluidStack(Ethylanthraquinone2, 1000), FluidUtils.getFluidStack("hydrogen", 2000)).fluidOutputs(FluidUtils.getFluidStack(Ethylanthrahydroquinone2, 1000)).duration(800).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 2).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeLithiumPeroxide() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroperoxide", 8)).fluidOutputs(FluidUtils.getFluidStack("fluid.hydrogenperoxide", 1000)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumPeroxide", 4)).duration(2000).eut(TierEU.RECIPE_MV).noOptimize().addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    private void recipeLithiumHydroperoxide() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4), ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroxide", 3)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroperoxide", 4)).fluidInputs(FluidUtils.getFluidStack("fluid.hydrogenperoxide", 1000)).duration(600).eut(240).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private void recipeHydrogenPeroxide() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4)).fluidInputs(FluidUtils.getFluidStack("air", 20000), FluidUtils.getFluidStack(Ethylanthrahydroquinone2, 5000), FluidUtils.getFluidStack("fluid.anthracene", 50)).fluidOutputs(FluidUtils.getFluidStack(Ethylanthraquinone2, 5000), FluidUtils.getFluidStack("fluid.hydrogenperoxide", 5000)).duration(600).eut(240).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(4)).fluidInputs(Materials.Oxygen.getGas(10000L), FluidUtils.getFluidStack(Ethylanthrahydroquinone2, 5000), FluidUtils.getFluidStack("fluid.anthracene", 50)).fluidOutputs(FluidUtils.getFluidStack(Ethylanthraquinone2, 5000), FluidUtils.getFluidStack("fluid.hydrogenperoxide", 5000)).duration(100).eut(240).metadata(GTRecipeConstants.CHEMPLANT_CASING_TIER, 1).addTo(GTPPRecipeMaps.chemicalPlantRecipes);
    }

    private static ItemStack getTierOneChip() {
        return CI.getNumberedAdvancedCircuit(4);
    }

    private static ItemStack getTierTwoChip() {
        return CI.getNumberedAdvancedCircuit(8);
    }

    private static ItemStack getTierThreeChip() {
        return CI.getNumberedAdvancedCircuit(12);
    }

    private static ItemStack getTierFourChip() {
        return CI.getNumberedAdvancedCircuit(16);
    }

    private static void recipeAdvancedChip() {
        GTModHandler.addShapelessCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 0L, new Object[0]), 0L, new Object[]{OrePrefixes.circuit.get(Materials.HV)});
        long bits = 0L;
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 1L, new Object[0]), 0L, new Object[]{"d  ", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 2L, new Object[0]), 0L, new Object[]{" d ", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 3L, new Object[0]), 0L, new Object[]{"  d", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 4L, new Object[0]), 0L, new Object[]{"   ", " Pd", "   ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 5L, new Object[0]), 0L, new Object[]{"   ", " P ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 6L, new Object[0]), 0L, new Object[]{"   ", " P ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 7L, new Object[0]), 0L, new Object[]{"   ", " P ", "d  ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 8L, new Object[0]), 0L, new Object[]{"   ", "dP ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 9L, new Object[0]), 0L, new Object[]{"P d", "   ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 10L, new Object[0]), 0L, new Object[]{"P  ", "  d", "   ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 11L, new Object[0]), 0L, new Object[]{"P  ", "   ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 12L, new Object[0]), 0L, new Object[]{"P  ", "   ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 13L, new Object[0]), 0L, new Object[]{"  P", "   ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 14L, new Object[0]), 0L, new Object[]{"  P", "   ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 15L, new Object[0]), 0L, new Object[]{"  P", "   ", "d  ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 16L, new Object[0]), 0L, new Object[]{"  P", "d  ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 17L, new Object[0]), 0L, new Object[]{"   ", "   ", "d P", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 18L, new Object[0]), 0L, new Object[]{"   ", "d  ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 19L, new Object[0]), 0L, new Object[]{"d  ", "   ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 20L, new Object[0]), 0L, new Object[]{" d ", "   ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 21L, new Object[0]), 0L, new Object[]{"d  ", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 22L, new Object[0]), 0L, new Object[]{" d ", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 23L, new Object[0]), 0L, new Object[]{"  d", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
        GTModHandler.addCraftingRecipe(GregtechItemList.Circuit_T3RecipeSelector.getWithDamage(1L, 24L, new Object[0]), 0L, new Object[]{"   ", "  d", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_T3RecipeSelector.getWildcard(1L, new Object[0])});
    }
}

