/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry.general;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemGenericChemBase
extends Item {
    protected final IIcon[] base;
    private final int aMetaSize = 34;

    public ItemGenericChemBase() {
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(64);
        this.func_77656_e(0);
        this.base = new IIcon[34];
        this.func_77655_b("BasicGenericChemItem");
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public int getItemStackLimit(ItemStack stack) {
        if (ItemUtils.isMillingBall(stack)) {
            return 16;
        }
        return super.getItemStackLimit(stack);
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean func_77629_n_() {
        return super.func_77629_n_();
    }

    public void func_77663_a(ItemStack p_77663_1_, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(p_77663_1_, p_77663_2_, p_77663_3_, p_77663_4_, p_77663_5_);
    }

    public String func_77653_i(ItemStack aStack) {
        return super.func_77653_i(aStack);
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.common;
    }

    public boolean func_77623_v() {
        return false;
    }

    public void func_150895_a(Item aItem, CreativeTabs p_150895_2_, List aList) {
        for (int i = 0; i < 34; ++i) {
            aList.add(ItemUtils.simpleMetaStack(aItem, i, 1));
        }
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public void func_94581_a(IIconRegister u) {
        for (int i = 0; i < this.aMetaSize; ++i) {
            String aPath = Mods.GTPlusPlus.ID + ":science/general/MetaItem1/" + i;
            this.base[i] = u.func_94245_a(aPath);
        }
    }

    public IIcon func_77618_c(int damage, int pass) {
        return this.base[damage];
    }

    public IIcon func_77617_a(int damage) {
        return this.base[damage];
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.base[stack.func_77960_j()];
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.base[stack.func_77960_j()];
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }

    public double getDurabilityForDisplay(ItemStack aStack) {
        if (ItemUtils.isMillingBall(aStack)) {
            if (aStack.func_77978_p() == null || aStack.func_77978_p().func_82582_d()) {
                ItemGenericChemBase.createMillingBallNBT(aStack);
            }
            double currentDamage = ItemGenericChemBase.getMillingBallDamage(aStack);
            return currentDamage / (double)ItemGenericChemBase.getMaxBallDurability(aStack);
        }
        if (ItemUtils.isCatalyst(aStack)) {
            if (aStack.func_77978_p() == null || aStack.func_77978_p().func_82582_d()) {
                ItemGenericChemBase.createCatalystNBT(aStack);
            }
            double currentDamage = ItemGenericChemBase.getCatalystDamage(aStack);
            return currentDamage / (double)ItemGenericChemBase.getCatalystMaxDamage(aStack);
        }
        return 1.0;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer player, List list, boolean bool) {
        boolean aHasSpecialTooltips = false;
        int aMaxDamage = 0;
        int aDamageSegment = 0;
        int aDam = 0;
        EnumChatFormatting durability = EnumChatFormatting.GRAY;
        if (ItemUtils.isMillingBall(aStack)) {
            list.add(EnumChatFormatting.GRAY + "Tumble Tumble Tumble");
            aMaxDamage = ItemGenericChemBase.getMillingBallMaxDamage(aStack);
            aDamageSegment = aMaxDamage / 5;
            aDam = aMaxDamage - ItemGenericChemBase.getMillingBallDamage(aStack);
            aHasSpecialTooltips = true;
        }
        if (ItemUtils.isCatalyst(aStack)) {
            list.add(EnumChatFormatting.GRAY + "Active Reaction Agent");
            aMaxDamage = ItemGenericChemBase.getCatalystMaxDamage(aStack);
            aDamageSegment = aMaxDamage / 5;
            aDam = aMaxDamage - ItemGenericChemBase.getCatalystDamage(aStack);
            aHasSpecialTooltips = true;
        }
        if (aHasSpecialTooltips) {
            if (aDam > aDamageSegment * 3) {
                durability = EnumChatFormatting.GREEN;
            } else if (aDam > aDamageSegment * 2) {
                durability = EnumChatFormatting.YELLOW;
            } else if (aDam > aDamageSegment) {
                durability = EnumChatFormatting.GOLD;
            } else if (aDam >= 0) {
                durability = EnumChatFormatting.RED;
            }
            list.add(durability + "" + aDam + EnumChatFormatting.GRAY + " / " + aMaxDamage);
        }
        super.func_77624_a(aStack, player, list, bool);
    }

    public boolean showDurabilityBar(ItemStack aStack) {
        int aDam;
        return ItemUtils.isMillingBall(aStack) ? (aDam = ItemGenericChemBase.getMillingBallDamage(aStack)) > 0 : ItemUtils.isCatalyst(aStack) && (aDam = ItemGenericChemBase.getCatalystDamage(aStack)) > 0;
    }

    public static boolean createMillingBallNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a("Damage", 0L);
        tagNBT.func_74772_a("MaxDamage", (long)ItemGenericChemBase.getMaxBallDurability(rStack));
        tagMain.func_74782_a("MillingBall", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static int getMillingBallDamage(ItemStack aStack) {
        if (aStack.func_77978_p() == null || aStack.func_77978_p().func_82582_d()) {
            ItemGenericChemBase.createMillingBallNBT(aStack);
        }
        NBTTagCompound aNBT = aStack.func_77978_p();
        return aNBT.func_74775_l("MillingBall").func_74762_e("Damage");
    }

    public static int getMillingBallMaxDamage(ItemStack aStack) {
        if (aStack.func_77978_p() == null || aStack.func_77978_p().func_82582_d()) {
            ItemGenericChemBase.createMillingBallNBT(aStack);
        }
        NBTTagCompound aNBT = aStack.func_77978_p();
        return aNBT.func_74775_l("MillingBall").func_74762_e("MaxDamage");
    }

    public static void setMillingBallDamage(ItemStack aStack, int aAmount) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        aNBT = aNBT.func_74775_l("MillingBall");
        aNBT.func_74768_a("Damage", aAmount);
    }

    public static int getMaxBallDurability(ItemStack aStack) {
        if (GTUtility.areStacksEqual(aStack, GenericChem.mMillingBallAlumina, true)) {
            return 100;
        }
        if (GTUtility.areStacksEqual(aStack, GenericChem.mMillingBallSoapstone, true)) {
            return 50;
        }
        return 0;
    }

    public static boolean createCatalystNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a("Damage", 0L);
        tagNBT.func_74772_a("MaxDamage", (long)ItemGenericChemBase.getMaxCatalystDurability(rStack));
        tagMain.func_74782_a("catalyst", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static int getCatalystDamage(ItemStack aStack) {
        if (aStack.func_77978_p() == null || aStack.func_77978_p().func_82582_d()) {
            ItemGenericChemBase.createCatalystNBT(aStack);
        }
        NBTTagCompound aNBT = aStack.func_77978_p();
        return aNBT.func_74775_l("catalyst").func_74762_e("Damage");
    }

    public static int getCatalystMaxDamage(ItemStack aStack) {
        if (aStack.func_77978_p() == null || aStack.func_77978_p().func_82582_d()) {
            ItemGenericChemBase.createCatalystNBT(aStack);
        }
        NBTTagCompound aNBT = aStack.func_77978_p();
        return aNBT.func_74775_l("catalyst").func_74762_e("MaxDamage");
    }

    public static void setCatalystDamage(ItemStack aStack, int aAmount) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        aNBT = aNBT.func_74775_l("catalyst");
        aNBT.func_74768_a("Damage", aAmount);
    }

    public static int getMaxCatalystDurability(ItemStack aStack) {
        return 50;
    }
}

