/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.math;

import gregtech.api.enums.GTValues;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.Utils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;

public class MathUtils {
    static final Random rand = GTPPCore.RANDOM;
    private static final NumberFormat sNumberFormat = NumberFormat.getInstance();

    public static int randInt(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static long randLong(long min, long max) {
        return MathUtils.nextLong(rand, max - min + 1L) + min;
    }

    private static long nextLong(Random rng, long n) {
        long val;
        long bits;
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public static double randDouble(double min, double max) {
        return MathUtils.nextDouble(rand, max - min + 1.0) + min;
    }

    private static double nextDouble(Random rng, double n) {
        double val;
        double bits;
        while ((bits = (double)(rng.nextLong() << 1 >>> 1)) - (val = bits % n) + (n - 1.0) < 0.0) {
        }
        return val;
    }

    public static float randFloat(float min, float max) {
        return MathUtils.nextFloat(rand, max - min + 1.0f) + min;
    }

    private static float nextFloat(Random rng, float n) {
        float val;
        float bits;
        while ((bits = (float)(rng.nextLong() << 1 >>> 1)) - (val = bits % n) + (n - 1.0f) < 0.0f) {
        }
        return val;
    }

    public static double findPercentage(double current, double max) {
        return (double)Math.round(current / max * 100.0 * 100.0) / 100.0;
    }

    public static float findPercentage(float current, float max) {
        return (float)((double)Math.round((double)(current / max * 100.0f) * 100.0) / 100.0);
    }

    public static int findPercentageOfInt(long input, float percentage) {
        return (int)((float)input * (percentage / 100.0f));
    }

    public static double decimalRounding(double d) {
        return (double)Math.round(d * 2.0) / 2.0;
    }

    public static double decimalRoundingToWholes(double d) {
        return 5L * Math.round(d / 5.0);
    }

    public static int roundToClosestInt(double d) {
        return (int)((double)Math.round(d * 2.0) / 2.0);
    }

    public static long roundToClosestLong(double d) {
        return (long)((double)Math.round(d * 2.0) / 2.0);
    }

    public static boolean isNumberEven(long x) {
        return x % 2L == 0L;
    }

    public static float celsiusToKelvin(int i) {
        double f = (float)i + 273.15f;
        return (int)MathUtils.decimalRoundingToWholes(f);
    }

    public static int generateSingularRandomHexValue() {
        int randomInt = MathUtils.randInt(1, 5);
        Map<Integer, String> colours = Utils.hexColourGeneratorRandom(5);
        String temp = colours.get(randomInt) != null && colours.size() > 0 ? colours.get(randomInt) : "0F0F0F";
        Logger.WARNING("Operating with " + temp);
        temp = Utils.appenedHexNotationToString(String.valueOf(temp));
        return Integer.decode(temp);
    }

    public static long[] simplifyNumbersToSmallestForm(long[] inputArray) {
        long GCD = MathUtils.gcd(inputArray);
        long[] outputArray = new long[inputArray.length];
        for (int i = 0; i < inputArray.length; ++i) {
            outputArray[i] = GCD != 0L ? inputArray[i] / GCD : inputArray[i];
        }
        if (outputArray.length > 0) {
            return outputArray;
        }
        return new long[0];
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    private static long gcd(long[] input) {
        long result = input[0];
        for (int i = 1; i < input.length; ++i) {
            result = MathUtils.gcd(result, input[i]);
        }
        return result;
    }

    public static int getRgbAsHex(short[] RGBA) {
        int returnValue = Utils.rgbtoHexValue(RGBA[0], RGBA[1], RGBA[2]);
        return returnValue == 0 ? 0 : returnValue;
    }

    public static byte safeByte(long number) {
        return number > 127L ? (byte)127 : (byte)number;
    }

    public static short safeShort(long number) {
        return number > 32767L ? (short)Short.MAX_VALUE : (short)number;
    }

    public static int safeInt(long number, int margin) {
        return number > (long)(Integer.MAX_VALUE - margin) ? Integer.MAX_VALUE - margin : (int)number;
    }

    public static int safeInt(long number) {
        return number > GTValues.V[GTValues.V.length - 1] ? MathUtils.safeInt(GTValues.V[GTValues.V.length - 1], 1) : (number < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)number);
    }

    public static int getRandomFromArray(int[] mValues) {
        int[] mLargeChanceArray = new int[(mValues.length - 1) * 1000];
        for (int g = 0; g < mLargeChanceArray.length; ++g) {
            int mValueSelection = MathUtils.randInt(0, mValues.length - 1);
            mLargeChanceArray[g] = mValues[mValueSelection];
        }
        return mLargeChanceArray[MathUtils.randInt(0, mLargeChanceArray.length - 1)];
    }

    public static byte getByteAverage(ArrayList<Byte> aDataSet) {
        byte[] aNewSet = new byte[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            byte b;
            aNewSet[u] = b = MathUtils.getSafeByte(aDataSet.get(u));
        }
        return MathUtils.getByteAverage(aNewSet);
    }

    public static short getShortAverage(ArrayList<Short> aDataSet) {
        short[] aNewSet = new short[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            short b;
            aNewSet[u] = b = MathUtils.getSafeShort(aDataSet.get(u));
        }
        return MathUtils.getShortAverage(aNewSet);
    }

    public static int getIntAverage(ArrayList<Integer> aDataSet) {
        int[] aNewSet = new int[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            int b;
            aNewSet[u] = b = MathUtils.getSafeInt(aDataSet.get(u));
        }
        return MathUtils.getIntAverage(aNewSet);
    }

    public static long getLongAverage(ArrayList<Long> aDataSet) {
        long[] aNewSet = new long[aDataSet.size()];
        for (int u = 0; u < aDataSet.size(); ++u) {
            long b;
            aNewSet[u] = b = MathUtils.getSafeLong(aDataSet.get(u));
        }
        return MathUtils.getLongAverage(aNewSet);
    }

    public static byte getByteAverage(byte[] aDataSet) {
        if (aDataSet.length == 0) {
            return 0;
        }
        int divisor = aDataSet.length;
        int total = 0;
        for (byte i : aDataSet) {
            total = (byte)(total + i);
        }
        byte result = MathUtils.safeByte(total / divisor);
        return result;
    }

    public static short getShortAverage(short[] aDataSet) {
        if (aDataSet.length == 0) {
            return 0;
        }
        int divisor = aDataSet.length;
        Logger.WARNING("Calculating Average Short. Divisor: " + divisor);
        int total = 0;
        for (short i : aDataSet) {
            Logger.WARNING("Adding " + i);
            total = (short)(total + i);
        }
        short result = MathUtils.safeShort(total / divisor);
        Logger.WARNING("Average: " + result);
        return result;
    }

    public static int getIntAverage(int[] aDataSet) {
        if (aDataSet.length == 0) {
            return 0;
        }
        int divisor = aDataSet.length;
        int total = 0;
        for (int i : aDataSet) {
            total += i;
        }
        int result = MathUtils.safeInt(total / divisor);
        return result;
    }

    public static long getLongAverage(long[] aDataSet) {
        if (aDataSet.length == 0) {
            return 0L;
        }
        int divisor = aDataSet.length;
        long total = 0L;
        for (long i : aDataSet) {
            total += i;
        }
        return total / (long)divisor;
    }

    public static int howManyPlaces(int aValueForGen) {
        if (aValueForGen < 0) {
            aValueForGen = MathUtils.makeNegative(aValueForGen);
        }
        String a = String.valueOf(aValueForGen);
        return a.length();
    }

    public static int makeNegative(int aPositive) {
        if (aPositive > 0) {
            return -aPositive;
        }
        if (aPositive < 0) {
            return aPositive;
        }
        return 0;
    }

    public static <V> V safeCast(Object aNumberType) {
        long a1 = Long.parseLong(aNumberType.toString());
        double a2 = Double.parseDouble(aNumberType.toString());
        if (aNumberType.getClass() == Byte.TYPE || aNumberType instanceof Byte) {
            if (a1 >= -128L && a1 <= 127L) {
                String s = String.valueOf(a1);
                Byte s1 = Byte.valueOf(s);
                return (V)s1;
            }
        } else if (aNumberType.getClass() == Short.TYPE || aNumberType instanceof Short) {
            if (a1 >= -32768L && a1 <= 32767L) {
                String s = String.valueOf(a1);
                Short s1 = Short.valueOf(s);
                return (V)s1;
            }
        } else if (aNumberType.getClass() == Integer.TYPE || aNumberType instanceof Integer) {
            if (a1 >= Integer.MIN_VALUE && a1 <= Integer.MAX_VALUE) {
                String s = String.valueOf(a1);
                Integer s1 = Integer.valueOf(s);
                return (V)s1;
            }
        } else if (aNumberType.getClass() == Long.TYPE || aNumberType instanceof Long) {
            if (a1 >= Long.MIN_VALUE && a1 <= Long.MAX_VALUE) {
                String s = String.valueOf(a1);
                Long s1 = Long.valueOf(s);
                return (V)s1;
            }
        } else if (aNumberType.getClass() == Float.TYPE || aNumberType instanceof Float) {
            if (a2 >= (double)1.4E-45f && a2 <= 3.4028234663852886E38) {
                String s = String.valueOf(a1);
                Float s1 = Float.valueOf(s);
                return (V)s1;
            }
        } else if ((aNumberType.getClass() == Double.TYPE || aNumberType instanceof Double) && a2 >= Double.MIN_VALUE && a2 <= Double.MAX_VALUE) {
            String s = String.valueOf(a1);
            Double s1 = Double.valueOf(s);
            return (V)s1;
        }
        Integer o = 0;
        return (V)o;
    }

    public static byte getSafeByte(Byte b) {
        Byte a = (Byte)MathUtils.safeCast(b);
        return a;
    }

    public static short getSafeShort(Short b) {
        Short a = (Short)MathUtils.safeCast(b);
        return a;
    }

    public static int getSafeInt(Integer b) {
        Integer a = (Integer)MathUtils.safeCast(b);
        return a;
    }

    public static long getSafeLong(Long b) {
        Long a = (Long)MathUtils.safeCast(b);
        return a;
    }

    public static int safeCast_LongToInt(long o) {
        if (o > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int i = (int)o;
        return i;
    }

    public static int balance(int aInput, int aMin, int aMax) {
        return Math.max(Math.min(aInput, aMax), aMin);
    }

    public static Number min(Number a, Number b) {
        return a.longValue() <= b.longValue() ? (Number)a : (Number)b;
    }

    public static Number max(Number a, Number b) {
        return a.longValue() >= b.longValue() ? (Number)a : (Number)b;
    }

    public static String formatNumbers(long aNumber) {
        return sNumberFormat.format(aNumber);
    }

    public static String formatNumbers(double aNumber) {
        return sNumberFormat.format(aNumber);
    }

    static {
        sNumberFormat.setMaximumFractionDigits(2);
    }
}

