/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GasSpargingRecipe;
import gregtech.api.util.GasSpargingRecipeMap;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.nei.NEIGTPPConfig;
import java.awt.Rectangle;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LFTRSpargingNEIHandler
extends TemplateRecipeHandler {
    public static final String mNEIName = "LFTR Gas Sparging";
    private SoftReference<List<GasSpargingRecipeNEI>> mCachedRecipes = null;

    public LFTRSpargingNEIHandler() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
        if (!NEIGTPPConfig.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)GTValues.GT, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("gregtechplusplus@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public String getRecipeName() {
        return mNEIName;
    }

    public String getGuiTexture() {
        return GasSpargingRecipeMap.mNEIGUIPath;
    }

    public String getOverlayIdentifier() {
        return "gtpp.recipe.lftr.sparging";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)68);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 14, 22, 16), this.getOverlayIdentifier(), new Object[0]));
    }

    public List<GasSpargingRecipeNEI> getCache() {
        List<GasSpargingRecipeNEI> cache;
        if (this.mCachedRecipes == null || (cache = this.mCachedRecipes.get()) == null) {
            cache = GasSpargingRecipeMap.mRecipes.stream().sorted().map(temp -> this.createCachedRecipe((GasSpargingRecipe)temp)).collect(Collectors.toList());
            this.mCachedRecipes = new SoftReference<List<GasSpargingRecipeNEI>>(cache);
        }
        return cache;
    }

    public GasSpargingRecipeNEI createCachedRecipe(GasSpargingRecipe aRecipe) {
        return new GasSpargingRecipeNEI(aRecipe);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.arecipes.addAll(this.getCache());
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        FluidStack tFluidStack;
        FluidStack tFluid;
        ItemData tPrefixMaterial = GTOreDictUnificator.getAssociation(aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GTOreDictUnificator.get(true, aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GTOreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if ((tFluid = GTUtility.getFluidForFilledItem(aResult, true)) != null) {
            tFluidStack = tFluid;
            tResults.add(GTUtility.getFluidDisplayStack(tFluid, false));
        } else {
            tFluidStack = GTUtility.getFluidFromDisplayStack(aResult);
        }
        if (tFluidStack != null) {
            tResults.addAll(GTUtility.getContainersFromFluid(tFluidStack));
        }
        for (GasSpargingRecipeNEI recipe : this.getCache()) {
            if (!tResults.stream().anyMatch(stack -> recipe.contains(recipe.mOutputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack aInput) {
        FluidStack tFluidStack;
        FluidStack tFluid;
        ItemData tPrefixMaterial = GTOreDictUnificator.getAssociation(aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GTOreDictUnificator.get(false, aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GTOreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if ((tFluid = GTUtility.getFluidForFilledItem(aInput, true)) != null) {
            tFluidStack = tFluid;
            tInputs.add(GTUtility.getFluidDisplayStack(tFluid, false));
        } else {
            tFluidStack = GTUtility.getFluidFromDisplayStack(aInput);
        }
        if (tFluidStack != null) {
            tInputs.addAll(GTUtility.getContainersFromFluid(tFluidStack));
        }
        for (GasSpargingRecipeNEI recipe : this.getCache()) {
            if (!tInputs.stream().anyMatch(stack -> recipe.contains(recipe.mInputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    protected static void drawText(int aX, int aY, String aString, int aColor) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(aString, aX, aY, aColor);
    }

    public void drawExtras(int aRecipeIndex) {
        long tEUt = ((GasSpargingRecipeNEI)this.arecipes.get((int)aRecipeIndex)).mRecipe.mEUt;
        long tDuration = ((GasSpargingRecipeNEI)this.arecipes.get((int)aRecipeIndex)).mRecipe.mDuration;
        LFTRSpargingNEIHandler.drawText(10, 73, "Total: " + MathUtils.formatNumbers(tDuration * tEUt) + " EU", -16777216);
        LFTRSpargingNEIHandler.drawText(10, 83, "Usage: " + MathUtils.formatNumbers(tEUt) + " EU/t", -16777216);
        LFTRSpargingNEIHandler.drawText(10, 93, "Time: " + (tDuration < 20L ? "< 1" : MathUtils.formatNumbers(0.05 * (double)tDuration)) + " secs", -16777216);
        LFTRSpargingNEIHandler.drawText(10, 103, "Gas not used to sparge is", -16777216);
        LFTRSpargingNEIHandler.drawText(10, 113, "returned alongside outputs.", -16777216);
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof GasSpargingRecipeNEI) {
            GasSpargingRecipeNEI tRecipe = (GasSpargingRecipeNEI)tObject;
            ItemStack aSpargeInput = tRecipe.mOutputs.get((int)0).item;
            ItemStack aSpentFuel = tRecipe.mOutputs.get((int)1).item;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!gregtech.api.enums.ItemList.Display_Fluid.isStackEqual(tStack.item, true, true) || GTUtility.areStacksEqual(aStack, aSpentFuel, true)) break;
                if (GTUtility.areStacksEqual(aStack, aSpargeInput, true)) {
                    currenttip.add("The amount returned is the remainder after all other outputs.");
                }
                currenttip.add("Maximum Output: " + ((FixedPositionedStack)tStack).mChance / 100 + "." + (((FixedPositionedStack)tStack).mChance % 100 < 10 ? "0" + ((FixedPositionedStack)tStack).mChance % 100 : Integer.valueOf(((FixedPositionedStack)tStack).mChance % 100)) + "L");
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (!GTUtility.areStacksEqual(aStack, tStack.item)) continue;
                if (gregtech.api.enums.ItemList.Display_Fluid.isStackEqual(tStack.item, true, true) || tStack.item.field_77994_a != 0 || !ItemUtils.isControlCircuit(aStack)) break;
                currenttip.add("Does not get consumed in the process");
                break;
            }
        }
        return currenttip;
    }

    public class GasSpargingRecipeNEI
    extends TemplateRecipeHandler.CachedRecipe
    implements Comparable<TemplateRecipeHandler.CachedRecipe> {
        public final GasSpargingRecipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public GasSpargingRecipeNEI(GasSpargingRecipe tRecipe) {
            super((TemplateRecipeHandler)LFTRSpargingNEIHandler.this);
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            this.mRecipe = tRecipe;
            int tStartIndex = 0;
            if (tRecipe.mFluidInputs.length > 0) {
                if (tRecipe.mFluidInputs[0] != null && tRecipe.mFluidInputs[0].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[0], true), 30, 5));
                }
                if (tRecipe.mFluidInputs.length > 1 && tRecipe.mFluidInputs[1] != null && tRecipe.mFluidInputs[1].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[1], true), 12, 5));
                }
                if (tRecipe.mFluidInputs.length > 2 && tRecipe.mFluidInputs[2] != null && tRecipe.mFluidInputs[2].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[2], true), 48, 5));
                }
                if (tRecipe.mFluidInputs.length > 3 && tRecipe.mFluidInputs[3] != null && tRecipe.mFluidInputs[3].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[3], true), 12, 23));
                }
                if (tRecipe.mFluidInputs.length > 4 && tRecipe.mFluidInputs[4] != null && tRecipe.mFluidInputs[4].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[4], true), 30, 23));
                }
                if (tRecipe.mFluidInputs.length > 5 && tRecipe.mFluidInputs[5] != null && tRecipe.mFluidInputs[5].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[5], true), 48, 23));
                }
                if (tRecipe.mFluidInputs.length > 6 && tRecipe.mFluidInputs[6] != null && tRecipe.mFluidInputs[6].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[6], true), 12, 41));
                }
                if (tRecipe.mFluidInputs.length > 7 && tRecipe.mFluidInputs[7] != null && tRecipe.mFluidInputs[7].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[7], true), 30, 41));
                }
                if (tRecipe.mFluidInputs.length > 8 && tRecipe.mFluidInputs[8] != null && tRecipe.mFluidInputs[8].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidInputs[8], true), 48, 41));
                }
            }
            tStartIndex = 0;
            if (tRecipe.mFluidOutputs.length > 0) {
                if (tRecipe.mFluidOutputs[0] != null && tRecipe.mFluidOutputs[0].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[0], false), 120, 5, tRecipe.getMaxOutput(tStartIndex++)));
                }
                if (tRecipe.mFluidOutputs.length > 1 && tRecipe.mFluidOutputs[1] != null && tRecipe.mFluidOutputs[1].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[1], true), 102, 5, tRecipe.getMaxOutput(tStartIndex++)));
                }
                if (tRecipe.mFluidOutputs.length > 2 && tRecipe.mFluidOutputs[2] != null && tRecipe.mFluidOutputs[2].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[2], false), 138, 5, tRecipe.getMaxOutput(tStartIndex++)));
                }
                if (tRecipe.mFluidOutputs.length > 3 && tRecipe.mFluidOutputs[3] != null && tRecipe.mFluidOutputs[3].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[3], false), 102, 23, tRecipe.getMaxOutput(tStartIndex++)));
                }
                if (tRecipe.mFluidOutputs.length > 4 && tRecipe.mFluidOutputs[4] != null && tRecipe.mFluidOutputs[4].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[4], false), 120, 23, tRecipe.getMaxOutput(tStartIndex++)));
                }
                if (tRecipe.mFluidOutputs.length > 5 && tRecipe.mFluidOutputs[5] != null && tRecipe.mFluidOutputs[5].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[5], false), 138, 23, tRecipe.getMaxOutput(tStartIndex++)));
                }
                if (tRecipe.mFluidOutputs.length > 6 && tRecipe.mFluidOutputs[6] != null && tRecipe.mFluidOutputs[6].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[6], false), 102, 41, tRecipe.getMaxOutput(tStartIndex++)));
                }
                if (tRecipe.mFluidOutputs.length > 7 && tRecipe.mFluidOutputs[7] != null && tRecipe.mFluidOutputs[7].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[7], false), 120, 41, tRecipe.getMaxOutput(tStartIndex++)));
                }
                if (tRecipe.mFluidOutputs.length > 8 && tRecipe.mFluidOutputs[8] != null && tRecipe.mFluidOutputs[8].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(tRecipe.mFluidOutputs[8], false), 138, 41, tRecipe.getMaxOutput(tStartIndex++)));
                }
            }
        }

        @Override
        public int compareTo(TemplateRecipeHandler.CachedRecipe o) {
            boolean b = GasSpargingRecipeNEI.class.isInstance(o);
            if (b) {
                GasSpargingRecipeNEI p = (GasSpargingRecipeNEI)o;
                if (p.mOutputs.size() > this.mOutputs.size()) {
                    return 1;
                }
                if (p.mOutputs.size() == this.mOutputs.size()) {
                    return 0;
                }
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            GasSpargingRecipeNEI p;
            return obj != null && GasSpargingRecipeNEI.class.isInstance(obj) && (p = (GasSpargingRecipeNEI)obj) != null && GTUtility.areStacksEqual(p.mInputs.get((int)0).item, this.mInputs.get((int)0).item, true) && p.mOutputs.size() == this.mOutputs.size();
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(LFTRSpargingNEIHandler.this.cycleticks / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public class FixedPositionedStack
    extends PositionedStack {
        public final int mChance;
        public boolean permutated;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance) {
            super(object, x, y, true);
            this.permutated = false;
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayList<ItemStack> tDisplayStacks = new ArrayList<ItemStack>();
            for (ItemStack tStack : this.items) {
                if (!GTUtility.isStackValid(tStack)) continue;
                if (tStack.func_77960_j() == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.func_77973_b());
                    if (!permutations.isEmpty()) {
                        for (ItemStack stack : permutations) {
                            tDisplayStacks.add(GTUtility.copyAmount((long)tStack.field_77994_a, new Object[]{stack}));
                        }
                        continue;
                    }
                    ItemStack base = new ItemStack(tStack.func_77973_b(), tStack.field_77994_a);
                    base.field_77990_d = tStack.field_77990_d;
                    tDisplayStacks.add(base);
                    continue;
                }
                tDisplayStacks.add(GTUtility.copy(new Object[]{tStack}));
            }
            this.items = tDisplayStacks.toArray(new ItemStack[0]);
            if (this.items.length == 0) {
                this.items = new ItemStack[]{new ItemStack((Block)Blocks.field_150480_ab)};
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }
}

