/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import gregtech.asm.GTCorePlugin;
import gtPlusPlus.core.config.ASMConfiguration;
import gtPlusPlus.preloader.PreloaderCore;
import gtPlusPlus.preloader.PreloaderLogger;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_COFH_OreDictionaryArbiter;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_IC2_GetHarvestTool;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_LWJGL_Keyboard;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_TC_ItemWispEssence;
import gtPlusPlus.preloader.asm.transformers.Preloader_ClassTransformer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Preloader_Transformer_Handler
implements IClassTransformer {
    private static final Set<String> IC2_WRENCH_PATCH_CLASS_NAMES = new HashSet<String>();
    private static final String LWJGL_KEYBOARD = "org.lwjgl.input.Keyboard";
    private static final String MINECRAFT_GAMESETTINGS = "net.minecraft.client.settings.GameSettings";
    private static final String FORGE_CHUNK_MANAGER = "net.minecraftforge.common.ForgeChunkManager";
    private static final String FORGE_ORE_DICTIONARY = "net.minecraftforge.oredict.OreDictionary";
    private static final String COFH_ORE_DICTIONARY_ARBITER = "cofh.core.util.oredict.OreDictionaryArbiter";
    private static final String THAUMCRAFT_ITEM_WISP_ESSENCE = "thaumcraft.common.items.ItemWispEssence";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ((transformedName.equals(LWJGL_KEYBOARD) || transformedName.equals(MINECRAFT_GAMESETTINGS)) && ASMConfiguration.general.enabledLwjglKeybindingFix && !GTCorePlugin.islwjgl3Present()) {
            boolean isClientSettingsClass = !transformedName.equals(LWJGL_KEYBOARD);
            PreloaderLogger.INFO("LWJGL Keybinding index out of bounds fix", "Transforming " + transformedName);
            return new ClassTransformer_LWJGL_Keyboard(basicClass, isClientSettingsClass).getWriter().toByteArray();
        }
        if (transformedName.equals(FORGE_ORE_DICTIONARY) && ASMConfiguration.debug.enableOreDictPatch) {
            PreloaderLogger.INFO("OreDictTransformer", "Transforming " + transformedName);
            ClassWriter classWriter = new ClassWriter(2);
            new ClassReader(basicClass).accept((ClassVisitor)new Preloader_ClassTransformer.OreDictionaryVisitor((ClassVisitor)classWriter), 0);
            return classWriter.toByteArray();
        }
        if (transformedName.equals(COFH_ORE_DICTIONARY_ARBITER) && (ASMConfiguration.debug.enableCofhPatch || PreloaderCore.DEV_ENVIRONMENT)) {
            PreloaderLogger.INFO("COFH", "Transforming " + transformedName);
            return new ClassTransformer_COFH_OreDictionaryArbiter(basicClass).getWriter().toByteArray();
        }
        if (IC2_WRENCH_PATCH_CLASS_NAMES.contains(transformedName)) {
            PreloaderLogger.INFO("IC2 getHarvestTool Patch", "Transforming " + transformedName);
            return new ClassTransformer_IC2_GetHarvestTool(basicClass, !PreloaderCore.DEV_ENVIRONMENT, transformedName).getWriter().toByteArray();
        }
        if (transformedName.equals(THAUMCRAFT_ITEM_WISP_ESSENCE) && ASMConfiguration.general.enableTcAspectSafety) {
            PreloaderLogger.INFO("Thaumcraft WispEssence_Patch", "Transforming " + transformedName);
            return new ClassTransformer_TC_ItemWispEssence(basicClass, !PreloaderCore.DEV_ENVIRONMENT).getWriter().toByteArray();
        }
        return basicClass;
    }

    static {
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.BlockTileEntity");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.machine.BlockMachine");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.machine.BlockMachine2");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.machine.BlockMachine3");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.kineticgenerator.block.BlockKineticGenerator");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.heatgenerator.block.BlockHeatGenerator");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.generator.block.BlockGenerator");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorAccessHatch");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorChamber");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorFluidPort");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorRedstonePort");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorVessel");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.personal.BlockPersonal.class");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.wiring.BlockChargepad.class");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.wiring.BlockElectric.class");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.wiring.BlockLuminator.class");
    }
}

