/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.keyboard;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_LWJGL_Keyboard;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import org.apache.logging.log4j.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;

public class BetterKeyboard {
    public static final int KEYBOARD_SIZE = Short.MAX_VALUE;
    private static boolean init = false;

    public static void init() {
        if (!init) {
            ByteBuffer aOldByteBuffer;
            FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)"Trying to patch out LWJGL internal arrays with larger ones.", (Object[])new Object[0]);
            Field aKeyNameSize = ReflectionUtils.getField(Keyboard.class, "keyName");
            Field aKeyMapSize = ReflectionUtils.getField(Keyboard.class, "keyMap");
            Field aKeyDownBuffer = ReflectionUtils.getField(Keyboard.class, "keyDownBuffer");
            String[] aOldKeyNameArray = (String[])ReflectionUtils.getFieldValue(aKeyNameSize);
            if (aOldKeyNameArray != null && aOldKeyNameArray.length < Short.MAX_VALUE) {
                String[] aNewKeyNameArray = new String[Short.MAX_VALUE];
                for (int i = 0; i < aOldKeyNameArray.length; ++i) {
                    aNewKeyNameArray[i] = aOldKeyNameArray[i];
                }
                try {
                    ReflectionUtils.setFinalFieldValue(Keyboard.class, aKeyNameSize.getName(), aNewKeyNameArray);
                    FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Patched Field: " + aKeyNameSize.getName()), (Object[])new Object[0]);
                }
                catch (Throwable t) {
                    FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Failed Patching Field: " + aKeyDownBuffer.getName()), (Object[])new Object[0]);
                }
            }
            Map aOldKeyMapArray = (Map)ReflectionUtils.getFieldValue(aKeyMapSize);
            if (aOldKeyNameArray != null && aOldKeyMapArray.size() < Short.MAX_VALUE) {
                HashMap aNewKeyMapArray = new HashMap(Short.MAX_VALUE);
                aNewKeyMapArray.putAll(aOldKeyMapArray);
                try {
                    ReflectionUtils.setFinalFieldValue(Keyboard.class, aKeyMapSize.getName(), aNewKeyMapArray);
                    FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Patched Field: " + aKeyMapSize.getName()), (Object[])new Object[0]);
                }
                catch (Throwable t) {
                    FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Failed Patching Field: " + aKeyDownBuffer.getName()), (Object[])new Object[0]);
                }
            }
            if ((aOldByteBuffer = (ByteBuffer)ReflectionUtils.getFieldValue(aKeyDownBuffer)) != null && aOldByteBuffer.capacity() == 256) {
                ByteBuffer aNewByteBuffer = BufferUtils.createByteBuffer((int)Short.MAX_VALUE);
                try {
                    ReflectionUtils.setFinalFieldValue(Keyboard.class, aKeyDownBuffer.getName(), aNewByteBuffer);
                    FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Patched Field: " + aKeyDownBuffer.getName()), (Object[])new Object[0]);
                }
                catch (Throwable t) {
                    FMLRelaunchLog.log((String)"[GT++ ASM] LWJGL Keybinding index out of bounds fix", (Level)Level.INFO, (String)("Failed Patching Field: " + aKeyDownBuffer.getName()), (Object[])new Object[0]);
                }
            }
            init = true;
        }
    }

    public static synchronized String getKeyName(int key) {
        return ClassTransformer_LWJGL_Keyboard.getKeyName(key);
    }

    public static String getKeyDisplayString(int aKeyValue) {
        return aKeyValue < 0 ? I18n.func_135052_a((String)"key.mouseButton", (Object[])new Object[]{aKeyValue + 101}) : BetterKeyboard.getKeyName(aKeyValue);
    }
}

