/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.MTELargerTurbineBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTEHatchTurbine
extends MTEHatch {
    public boolean mHasController = false;
    public boolean mUsingAnimation = true;
    private String mControllerLocation;
    public int mEUt = 0;

    public MTEHatchTurbine(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 16, "Turbine Rotor holder for XL Turbines", new ITexture[0]);
    }

    public MTEHatchTurbine(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    public MTEHatchTurbine(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription[0], aTextures);
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Right Click with a soldering iron to reset controller link", "Right Click with a wrench to remove turbine", "Right Click with a screwdriver for technical information", "Sneak + Right Click with a wrench to rotate", "Sneak + Right Click with a screwdriver to disable animations", GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, this.getFrontFacingTurbineTexture()};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, this.getFrontFacingTurbineTexture()};
    }

    public int getEU() {
        return this.mEUt;
    }

    public void setEU(int aEU) {
        this.mEUt = aEU;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return facing.offsetY == 0;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public boolean hasTurbine() {
        ItemStack aStack = this.mInventory[0];
        boolean aIsValid = MTELargerTurbineBase.isValidTurbine(aStack);
        return aIsValid;
    }

    public ItemStack getTurbine() {
        if (this.hasTurbine()) {
            return this.mInventory[0];
        }
        return null;
    }

    public boolean canWork() {
        return this.hasTurbine();
    }

    public boolean insertTurbine(ItemStack aTurbine) {
        if (MTELargerTurbineBase.isValidTurbine(aTurbine)) {
            this.mInventory[0] = aTurbine;
            return true;
        }
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchTurbine(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void damageTurbine(int aEUt, int damageFactorLow, float damageFactorHigh) {
        this.damageTurbine((long)aEUt, damageFactorLow, damageFactorHigh);
    }

    public void damageTurbine(long aEUt, int damageFactorLow, float damageFactorHigh) {
        if (this.hasTurbine() && MathUtils.randInt(0, 1) == 0) {
            ItemStack aTurbine = this.getTurbine();
            ((MetaGeneratedTool)aTurbine.func_77973_b()).doDamage(aTurbine, (long)this.getDamageToComponent(aTurbine) * (long)Math.min((double)((float)aEUt / (float)damageFactorLow), Math.pow(aEUt, damageFactorHigh)));
        }
    }

    private int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mHasController", this.mHasController);
        aNBT.func_74757_a("mUsingAnimation", this.mUsingAnimation);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mHasController = aNBT.func_74767_n("mHasController");
        this.mUsingAnimation = aNBT.func_74767_n("mUsingAnimation");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mHasController) {
            if (aTick % 20L == 0L) {
                if (this.isControllerActive()) {
                    this.getBaseMetaTileEntity().setActive(true);
                } else {
                    this.getBaseMetaTileEntity().setActive(false);
                }
            }
        } else if (this.mHasController || this.mControllerLocation == null || this.setController(BlockPos.generateBlockPos(this.mControllerLocation))) {
            // empty if block
        }
        if (this.mInventory[0] != null && this.mInventory[0].field_77994_a <= 0) {
            this.mInventory[0] = null;
        }
    }

    public boolean isControllerActive() {
        MTELargerTurbineBase x = this.getController();
        if (x != null) {
            return x.lEUt > 0L;
        }
        return false;
    }

    public MTELargerTurbineBase getController() {
        BlockPos p;
        if (this.mHasController && this.mControllerLocation != null && this.mControllerLocation.length() > 0 && (p = BlockPos.generateBlockPos(this.mControllerLocation)) != null) {
            IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntity(p.xPos, p.yPos, p.zPos);
            if (tTileEntity != null && tTileEntity.getMetaTileEntity() instanceof MTELargerTurbineBase) {
                return (MTELargerTurbineBase)tTileEntity.getMetaTileEntity();
            }
            if (tTileEntity == null) {
                Logger.INFO("Controller MTE is null, somehow?");
            } else {
                Logger.INFO("Controller is a different MTE to expected");
            }
        }
        return null;
    }

    public boolean canSetNewController() {
        return (this.mControllerLocation == null || this.mControllerLocation.length() <= 0) && !this.mHasController;
    }

    public boolean setController(BlockPos aPos) {
        this.clearController();
        if (this.canSetNewController()) {
            this.mControllerLocation = aPos.getUniqueIdentifier();
            this.mHasController = true;
            Logger.INFO("Successfully injected controller into this Turbine Assembly Hatch.");
        }
        return this.mHasController;
    }

    public void clearController() {
        this.mControllerLocation = null;
        this.mHasController = false;
    }

    public boolean usingAnimations() {
        return this.mUsingAnimation;
    }

    private ITexture getFrontFacingTurbineTexture() {
        if (!this.mHasController) {
            return this.getBaseMetaTileEntity().isActive() ? new GTRenderedTexture(Textures.BlockIcons.LARGETURBINE_ST_ACTIVE5) : new GTRenderedTexture(Textures.BlockIcons.LARGETURBINE_ST5);
        }
        if (this.usingAnimations() && this.isControllerActive()) {
            return this.getController().frontFaceActive;
        }
        return this.getController().frontFace;
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return false;
    }

    @Override
    public int[] func_94128_d(int ordinalSide) {
        return new int[0];
    }

    @Override
    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return false;
    }

    public void setActive(boolean b) {
        this.getBaseMetaTileEntity().setActive(b);
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GTItemStack aStack) {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!aPlayer.func_70093_af()) {
            PlayerUtils.messagePlayer(aPlayer, "Using Animations? " + this.usingAnimations());
            PlayerUtils.messagePlayer(aPlayer, "Has Controller? " + this.mHasController);
            if (this.mHasController) {
                PlayerUtils.messagePlayer(aPlayer, "Controller Location: " + BlockPos.generateBlockPos(this.mControllerLocation).getLocationString());
                PlayerUtils.messagePlayer(aPlayer, "Controller Active? " + this.isControllerActive());
            }
            PlayerUtils.messagePlayer(aPlayer, "Active? " + this.getBaseMetaTileEntity().isActive());
            PlayerUtils.messagePlayer(aPlayer, "Has Turbine inserted? " + this.hasTurbine());
            if (this.hasTurbine()) {
                Materials aMat = MetaGeneratedTool.getPrimaryMaterial(this.getTurbine());
                String aSize = MTELargerTurbineBase.getTurbineSizeString(MTELargerTurbineBase.getTurbineSize(this.getTurbine()));
                PlayerUtils.messagePlayer(aPlayer, "Using: " + aMat.mLocalizedName + " " + aSize);
            }
        } else {
            boolean bl = this.mUsingAnimation = !this.mUsingAnimation;
            if (this.mUsingAnimation) {
                PlayerUtils.messagePlayer(aPlayer, "Using Animated Turbine Texture.");
            } else {
                PlayerUtils.messagePlayer(aPlayer, "Using Static Turbine Texture.");
            }
        }
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ItemStack tCurrentItem;
        if (this.getBaseMetaTileEntity().isServerSide() && !aPlayer.func_70093_af() && (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) != null && tCurrentItem.func_77973_b() instanceof MetaGeneratedTool) {
            return this.onToolClick(tCurrentItem, aPlayer, wrenchingSide);
        }
        return super.onWrenchRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ItemStack tCurrentItem;
        if (this.getBaseMetaTileEntity().isServerSide() && (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) != null && tCurrentItem.func_77973_b() instanceof MetaGeneratedTool) {
            return this.onToolClick(tCurrentItem, aPlayer, wrenchingSide);
        }
        return false;
    }

    public boolean onToolClick(ItemStack tCurrentItem, EntityPlayer aPlayer, ForgeDirection side) {
        if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sWrenchList)) {
            boolean aHasTurbine = this.hasTurbine();
            if (aPlayer.field_71071_by.func_70447_i() >= 0 && aHasTurbine) {
                if (PlayerUtils.isCreative(aPlayer) || GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                    aPlayer.field_71071_by.func_70441_a(this.getTurbine());
                    this.mInventory[0] = null;
                    GTUtility.sendChatToPlayer(aPlayer, "Removed turbine with wrench.");
                    return true;
                }
            } else {
                GTUtility.sendChatToPlayer(aPlayer, aHasTurbine ? "Cannot remove turbine, no free inventory space." : "No turbine to remove.");
            }
        } else if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sSolderingToolList) && this.mControllerLocation != null && this.mControllerLocation.length() > 0 && this.setController(BlockPos.generateBlockPos(this.mControllerLocation)) && (PlayerUtils.isCreative(aPlayer) || GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer))) {
            String tChat = "Trying to Reset linked Controller";
            IGregTechTileEntity g = this.getBaseMetaTileEntity();
            GTUtility.sendChatToPlayer(aPlayer, tChat);
            GTUtility.sendSoundToPlayers(g.getWorld(), SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE, 1.0f, -1.0f, g.getXCoord(), (int)g.getYCoord(), g.getZCoord());
            return true;
        }
        return false;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setFilter(MTELargerTurbineBase::isValidTurbine).setAccess(false, true).setPos(79, 34));
    }
}

