/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.objects.GTMultiTexture;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.CoverBehavior;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import gtPlusPlus.xmod.gregtech.common.covers.CoverToggleVisual;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class MetaCustomCoverItem
extends Item {
    protected final IIcon[] icons;
    private final String mModID;
    private final String mTextureSetName;
    protected final IIconContainer[] mTextures;
    private final short[][] mRGB;

    public MetaCustomCoverItem(String aModId, int aTextureCount, String aTextureSetName, IIconContainer[] aTextures, short[][] aRGB) {
        this.icons = new IIcon[aTextureCount];
        this.mModID = aModId;
        this.mTextureSetName = Utils.sanitizeString(aTextureSetName);
        this.mTextures = aTextures;
        this.mRGB = aRGB;
        this.func_111206_d(Mods.GTPlusPlus.ID + ":itemPlate");
        this.func_77627_a(true);
        String unlocalizedName = "itemCustomMetaCover." + this.mModID + "." + this.mTextureSetName;
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77625_d(1);
        GameRegistry.registerItem((Item)this, (String)unlocalizedName);
        this.registerCover();
        Logger.INFO("[Covers] Generated Custom covers for " + this.mModID + " using " + aTextureCount + " textures from " + this.mTextureSetName + ".");
    }

    public boolean hide() {
        return true;
    }

    private void registerCover() {
        for (int i = 0; i < this.icons.length; ++i) {
            ItemStack thisStack = ItemUtils.simpleMetaStack(this, i, 1);
            if (i > 0 && this.hide()) {
                ItemUtils.hideItemFromNEI(thisStack);
            }
            GregTechAPI.registerCover(thisStack, (ITexture)new GTMultiTexture(new GTRenderedTexture(this.mTextures[i])), (CoverBehavior)new CoverToggleVisual());
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.icons.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + stack.func_77960_j();
    }

    public String func_77653_i(ItemStack tItem) {
        return StringUtils.capitalize((String)this.mTextureSetName) + " (" + tItem.func_77960_j() + ")";
    }

    private static boolean createNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a("Damage", 0L);
        tagNBT.func_74757_a("AllowConnections", false);
        tagMain.func_74782_a("CustomCoverMeta", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static final long getCoverDamage(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("CustomCoverMeta")) != null) {
                return aNBT.func_74763_f("Damage");
            }
        } else {
            MetaCustomCoverItem.createNBT(aStack);
        }
        return 0L;
    }

    public static final boolean setCoverDamage(ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("CustomCoverMeta")) != null) {
            aNBT.func_74772_a("Damage", aDamage);
            return true;
        }
        return false;
    }

    public static final boolean getCoverConnections(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("CustomCoverMeta")) != null) {
                return aNBT.func_74767_n("AllowConnections");
            }
        } else {
            MetaCustomCoverItem.createNBT(aStack);
        }
        return false;
    }

    public static final boolean setCoverConnections(ItemStack aStack, boolean aConnections) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("CustomCoverMeta")) != null) {
            aNBT.func_74757_a("AllowConnections", aConnections);
            return true;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            MetaCustomCoverItem.createNBT(stack);
        }
        double currentDamage = MetaCustomCoverItem.getCoverDamage(stack);
        double meta = stack.func_77960_j() == 0 ? 50.0 : 2500.0;
        double durabilitypercent = currentDamage / meta;
        return durabilitypercent;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (KeyboardUtils.isShiftKeyDown()) {
            boolean con = MetaCustomCoverItem.getCoverConnections(stack);
            if (con) {
                MetaCustomCoverItem.setCoverConnections(stack, false);
            } else {
                MetaCustomCoverItem.setCoverConnections(stack, true);
            }
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        boolean cons = MetaCustomCoverItem.getCoverConnections(stack);
        list.add(EnumChatFormatting.GRAY + "Allows Connections: " + cons);
        list.add(EnumChatFormatting.GRAY + "Shift Rmb to change state before applying");
        super.func_77624_a(stack, player, list, bool);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public Item func_77664_n() {
        return super.func_77664_n();
    }

    public boolean func_77662_d() {
        return super.func_77662_d();
    }

    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        if (this.mRGB == null) {
            return super.func_82790_a(stack, HEX_OxFFFFFF);
        }
        int aMeta = stack.func_77960_j();
        return Utils.rgbtoHexValue(this.mRGB[aMeta][0], this.mRGB[aMeta][1], this.mRGB[aMeta][2]);
    }
}

