/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.items.behaviours;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockOres;
import gregtech.common.blocks.TileEntityOres;
import gregtech.common.items.behaviors.BehaviourProspecting;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

public class Behaviour_Prospecting_Ex
extends BehaviourProspecting {
    private final int mVanillaCosts;
    private final int mEUCosts;

    public Behaviour_Prospecting_Ex(int aVanillaCosts, int aEUCosts) {
        super(aVanillaCosts, aEUCosts);
        this.mVanillaCosts = aVanillaCosts;
        this.mEUCosts = aEUCosts;
    }

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == null) {
            return false;
        }
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        ItemData tAssotiation = GTOreDictUnificator.getAssociation(new ItemStack(aBlock, 1, (int)aMeta));
        if (tAssotiation != null && tAssotiation.mPrefix.toString().startsWith("ore")) {
            GTUtility.sendChatToPlayer(aPlayer, "This is " + tAssotiation.mMaterial.mMaterial.mDefaultLocalName + " Ore.");
            GTUtility.sendSoundToPlayers(aWorld, SoundResource.RANDOM_ANVIL_USE, 1.0f, -1.0f, aX, aY, aZ);
            return true;
        }
        if (aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTechAPI.sBlockGranites) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150346_d) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150349_c)) {
            if (GTModHandler.damageOrDechargeItem(aStack, this.mVanillaCosts, this.mEUCosts, (EntityLivingBase)aPlayer)) {
                int i;
                GTUtility.sendSoundToPlayers(aWorld, SoundResource.RANDOM_ANVIL_USE, 1.0f, -1.0f, aX, aY, aZ);
                int tX = aX;
                int tY = aY;
                int tZ = aZ;
                int tMetaID = 0;
                int tQuality = (aItem instanceof MetaGeneratedTool ? ((MetaGeneratedTool)aItem).getHarvestLevel(aStack, "") : 0) * 3;
                int j = 6 + tQuality;
                for (i = 0; i < j; ++i) {
                    Block tBlock = aWorld.func_147439_a(tX -= side.offsetX, tY -= side.offsetY, tZ -= side.offsetZ);
                    if (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) {
                        GTUtility.sendChatToPlayer(aPlayer, "There is Lava behind this Block.");
                        break;
                    }
                    if (tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i || tBlock instanceof IFluidBlock) {
                        GTUtility.sendChatToPlayer(aPlayer, "There is a Liquid behind this Block.");
                        break;
                    }
                    if (tBlock == Blocks.field_150418_aU || !GTUtility.hasBlockHitBox(aWorld, tX, tY, tZ)) {
                        GTUtility.sendChatToPlayer(aPlayer, "There is an Air Pocket behind this Block.");
                        break;
                    }
                    if (tBlock == aBlock) continue;
                    if (i >= 4) break;
                    GTUtility.sendChatToPlayer(aPlayer, "Material is changing behind this Block.");
                    break;
                }
                Random tRandom = new Random(aX ^ aY ^ aZ ^ side.ordinal());
                int j2 = 9 + 2 * tQuality;
                for (i = 0; i < j2; ++i) {
                    tX = aX - 4 - tQuality + tRandom.nextInt(j2);
                    Block tBlock = aWorld.func_147439_a(tX, tY = aY - 4 - tQuality + tRandom.nextInt(j2), tZ = aZ - 4 - tQuality + tRandom.nextInt(j2));
                    if (tBlock instanceof BlockOres) {
                        Materials tMaterial;
                        TileEntity tTileEntity = aWorld.func_147438_o(tX, tY, tZ);
                        if (!(tTileEntity instanceof TileEntityOres) || (tMaterial = GregTechAPI.sGeneratedMaterials[((TileEntityOres)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL) continue;
                        GTUtility.sendChatToPlayer(aPlayer, "Found traces of " + tMaterial.mDefaultLocalName + " Ore.");
                        return true;
                    }
                    tMetaID = aWorld.func_72805_g(tX, tY, tZ);
                    tAssotiation = GTOreDictUnificator.getAssociation(new ItemStack(tBlock, 1, tMetaID));
                    if (tAssotiation == null || !tAssotiation.mPrefix.toString().startsWith("ore")) continue;
                    GTUtility.sendChatToPlayer(aPlayer, "Found traces of " + tAssotiation.mMaterial.mMaterial.mDefaultLocalName + " Ore.");
                    return true;
                }
                GTUtility.sendChatToPlayer(aPlayer, "No Ores found.");
            }
            return true;
        }
        return false;
    }
}

