/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.GTMod;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.TurbineStatCalculator;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.MTELargerTurbineBase;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MTELargeTurbineSHSteam
extends MTELargerTurbineBase {
    public boolean achievement = false;
    private boolean isUsingDenseSteam;

    public MTELargeTurbineSHSteam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeTurbineSHSteam(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeTurbineSHSteam(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 2;
    }

    @Override
    public int getCasingTextureIndex() {
        return 59;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return true;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        return 0;
    }

    @Override
    long fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        long tEU = 0L;
        int totalFlow = 0;
        int flow = 0;
        float denseFlow = 0.0f;
        float steamFlowForNextSteam = 0.0f;
        int steamInHatch = 0;
        this.realOptFlow = (float)this.getSpeedMultiplier() * (this.looseFit ? turbine.getOptimalLooseSteamFlow() : turbine.getOptimalSteamFlow());
        int remainingFlow = MathUtils.safeInt((long)(this.realOptFlow * 1.25));
        float remainingDenseFlow = 0.0f;
        boolean hasConsumedSteam = false;
        this.storedFluid = 0;
        block14: for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            String fluidName;
            switch (fluidName = aFluids.get(i).getFluid().getUnlocalizedName(aFluids.get(i))) {
                case "ic2.fluidSuperheatedSteam": {
                    if (!hasConsumedSteam) {
                        hasConsumedSteam = true;
                        this.isUsingDenseSteam = false;
                    } else if (this.isUsingDenseSteam) continue block14;
                    flow = Math.min(aFluids.get((int)i).amount, remainingFlow);
                    this.depleteInput(new FluidStack(aFluids.get(i), flow));
                    this.storedFluid += aFluids.get((int)i).amount;
                    remainingFlow -= flow;
                    totalFlow += flow;
                    if (this.achievement) continue block14;
                    try {
                        GTMod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "efficientsteam");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.achievement = true;
                    continue block14;
                }
                case "fluid.densesuperheatedsteam": {
                    if (!hasConsumedSteam) {
                        hasConsumedSteam = true;
                        this.isUsingDenseSteam = true;
                    } else if (!this.isUsingDenseSteam) continue block14;
                    steamInHatch = aFluids.get((int)i).amount;
                    remainingDenseFlow = (float)remainingFlow / 1000.0f;
                    denseFlow = Math.min((float)steamInHatch, remainingDenseFlow);
                    this.depleteInput(new FluidStack(aFluids.get(i), (int)denseFlow));
                    this.storedFluid += aFluids.get((int)i).amount;
                    remainingFlow = (int)((float)remainingFlow - denseFlow * 1000.0f);
                    totalFlow = (int)((float)totalFlow + denseFlow * 1000.0f);
                    steamFlowForNextSteam += denseFlow;
                    continue block14;
                }
                case "fluid.steam": 
                case "ic2.fluidSteam": 
                case "fluid.mfr.steam.still.name": {
                    this.depleteInput(new FluidStack(aFluids.get(i), aFluids.get((int)i).amount));
                }
            }
        }
        if (totalFlow <= 0) {
            return 0L;
        }
        tEU = totalFlow;
        if (this.isUsingDenseSteam) {
            this.addOutput(Materials.DenseSteam.getGas((long)steamFlowForNextSteam));
        } else {
            this.addOutput(GTModHandler.getSteam(totalFlow));
        }
        if ((double)totalFlow != this.realOptFlow) {
            float efficiency = 1.0f - Math.abs(((float)totalFlow - (float)this.realOptFlow) / (float)this.realOptFlow);
            tEU = (long)((float)tEU * efficiency);
            tEU = Math.max(1, MathUtils.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency()))));
        } else {
            tEU = MathUtils.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency())));
        }
        return tEU;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit && GTPPCore.RANDOM.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public String getMachineType() {
        return "Large Super-heated Steam Turbine";
    }

    @Override
    protected String getTurbineType() {
        return "Super-heated Steam";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced HP Steam Turbine Casing";
    }

    @Override
    protected ITexture getTextureFrontFace() {
        return new GTRenderedTexture(TexturesGtBlock.Overlay_Machine_Controller_Advanced);
    }

    @Override
    protected ITexture getTextureFrontFaceActive() {
        return new GTRenderedTexture(TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active);
    }
}

