/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import gregtech.api.enums.GTValues;
import gregtech.api.util.GTRecipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.WeightedCollection;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLoaderAlgaeFarm {
    private static final HashMap<Integer, ArrayList<GTRecipe>> mRecipeCache = new HashMap();
    private static final HashMap<Integer, ArrayList<GTRecipe>> mRecipeCompostCache = new HashMap();

    public static void generateRecipes() {
        int i;
        for (i = 0; i < 15; ++i) {
            RecipeLoaderAlgaeFarm.getTieredRecipeFromCache(i, false);
        }
        for (i = 0; i < 15; ++i) {
            RecipeLoaderAlgaeFarm.getTieredRecipeFromCache(i, true);
        }
    }

    public static GTRecipe getTieredRecipeFromCache(int aTier, boolean aCompost) {
        HashMap<Integer, ArrayList<GTRecipe>> aMap = aCompost ? mRecipeCompostCache : mRecipeCache;
        String aComp = aCompost ? "(Compost)" : "";
        ArrayList<GTRecipe> aTemp = aMap.get(aTier);
        if (aTemp == null || aTemp.isEmpty()) {
            aTemp = new ArrayList();
            aMap.put(aTier, aTemp);
            Logger.INFO("Tier " + aTier + aComp + " had no recipes, initialising new map.");
        }
        if (aTemp.size() < 500) {
            Logger.INFO("Tier " + aTier + aComp + " has less than 500 recipes, generating " + (500 - aTemp.size()) + ".");
            for (int i = aTemp.size(); i < 500; ++i) {
                aTemp.add(RecipeLoaderAlgaeFarm.generateBaseRecipe(aCompost, aTier));
            }
        }
        int aIndex = MathUtils.randInt(0, (aTemp.isEmpty() ? 1 : aTemp.size()) - 1);
        Logger.INFO("Using recipe with index of " + aIndex + ". " + aComp);
        return aTemp.get(aIndex);
    }

    public static int compostForTier(int aTier) {
        return aTier > 1 ? (int)Math.min(64.0, Math.pow(2.0, aTier - 1)) : 1;
    }

    private static GTRecipe generateBaseRecipe(boolean aUsingCompost, int aTier) {
        if (aTier < 0) {
            return null;
        }
        WeightedCollection<Float> aOutputTimeMulti = new WeightedCollection<Float>();
        for (int i = 100; i > 0; --i) {
            float aValue = 0.0f;
            aValue = i < 10 ? 3.0f : (i < 20 ? 2.0f : 1.0f);
            aOutputTimeMulti.put(i, Float.valueOf(aValue));
        }
        int[] aDurations = new int[]{2000, 1800, 1600, 1400, 1200, 1000, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};
        ItemStack[] aInputs = new ItemStack[]{};
        if (aUsingCompost) {
            ItemStack aCompost = ItemUtils.getSimpleStack(AgriculturalChem.mCompost, RecipeLoaderAlgaeFarm.compostForTier(aTier));
            aInputs = new ItemStack[]{aCompost};
            ++aTier;
        }
        ItemStack[] aOutputs = RecipeLoaderAlgaeFarm.getOutputsForTier(aTier);
        GTRecipe tRecipe = new GTRecipe(false, aInputs, aOutputs, null, new int[0], new FluidStack[]{GTValues.NF}, new FluidStack[]{GTValues.NF}, (int)((float)aDurations[aTier] * ((Float)aOutputTimeMulti.get()).floatValue() / 2.0f), 0, 0);
        tRecipe.mSpecialValue = tRecipe.hashCode();
        return tRecipe;
    }

    private static ItemStack[] getOutputsForTier(int aTier) {
        ArrayList<ItemStack> aOutputMap = new ArrayList<ItemStack>();
        if (aTier >= 0) {
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mAlgaeBiosmass, 2));
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mAlgaeBiosmass, 4));
            if (MathUtils.randInt(0, 10) > 9) {
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 2));
            }
        }
        if (aTier >= 1) {
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mAlgaeBiosmass, 4));
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 2));
            if (MathUtils.randInt(0, 10) > 9) {
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 4));
            }
        }
        if (aTier >= 2) {
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 2));
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 3));
            if (MathUtils.randInt(0, 10) > 9) {
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 8));
            }
        }
        if (aTier >= 3) {
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 4));
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 1));
            if (MathUtils.randInt(0, 10) > 9) {
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 4));
            }
        }
        if (aTier >= 4) {
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 2));
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 3));
            if (MathUtils.randInt(0, 10) > 9) {
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, 4));
            }
        }
        if (aTier >= 5) {
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 4));
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, 2));
            if (MathUtils.randInt(0, 10) > 9) {
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, 4));
            }
        }
        if (aTier >= 6) {
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, 4));
            aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, 2));
            if (MathUtils.randInt(0, 10) > 9) {
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, 8));
            }
        }
        for (int i2 = 0; i2 < 20; ++i2) {
            if (aTier >= 6 + i2) {
                int aMulti = i2 + 1;
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, aMulti * 4));
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, aMulti * 3));
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, aMulti * 2));
                aOutputMap.add(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, aMulti));
                continue;
            }
            i2 = 20;
        }
        ItemStack[] aOutputs = new ItemStack[aOutputMap.size()];
        for (int i = 0; i < aOutputMap.size(); ++i) {
            aOutputs[i] = (ItemStack)aOutputMap.get(i);
        }
        return aOutputs;
    }
}

