/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import advsolar.utils.MTRecipeManager;
import advsolar.utils.MTRecipeRecord;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.util.math.MathUtils;

public class RecipeLoaderMolecularTransformer {
    public static void run() {
        for (MTRecipeRecord aRecipe : MTRecipeManager.transformerRecipes) {
            int aEU = (int)TierEU.RECIPE_IV;
            Logger.INFO("=======================");
            Logger.INFO("Generating GT recipe for Molecular Transformer.");
            Logger.INFO("Input: " + aRecipe.inputStack.func_82833_r() + ", Output: " + aRecipe.outputStack.func_82833_r() + ", EU/t: " + aEU);
            float aTicks = (float)aRecipe.energyPerOperation / (float)aEU;
            Logger.INFO("Ticks: " + aTicks);
            int aTicksRoundedUp = MathUtils.roundToClosestInt(Math.ceil(aTicks));
            Logger.INFO("Ticks: " + aTicksRoundedUp);
            Logger.INFO("Total EU equal or greater? " + (aTicksRoundedUp * aEU >= aRecipe.energyPerOperation));
            GTValues.RA.stdBuilder().itemInputs(aRecipe.inputStack).itemOutputs(aRecipe.outputStack).duration(aTicksRoundedUp).eut(aEU).addTo(GTPPRecipeMaps.molecularTransformerRecipes);
            Logger.INFO("=======================");
        }
        MTRecipeManager.transformerRecipes.clear();
        if (Mods.AdvancedSolarPanel.isModLoaded() && Mods.GalaxySpace.isModLoaded()) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Glowstone, 1L)).itemOutputs(GTModHandler.getModItem(Mods.AdvancedSolarPanel.ID, "asp_crafting_items", 1L, 9)).duration(600).eut(TierEU.RECIPE_EV).addTo(GTPPRecipeMaps.molecularTransformerRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.GalaxySpace.ID, "item.GlowstoneDusts", 1L, 0)).itemOutputs(GTModHandler.getModItem(Mods.AdvancedSolarPanel.ID, "asp_crafting_items", 1L, 9)).duration(150).eut(TierEU.RECIPE_IV).addTo(GTPPRecipeMaps.molecularTransformerRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.GalaxySpace.ID, "item.GlowstoneDusts", 1L, 1)).itemOutputs(GTModHandler.getModItem(Mods.AdvancedSolarPanel.ID, "asp_crafting_items", 1L, 9)).duration(38).eut(TierEU.RECIPE_LuV).addTo(GTPPRecipeMaps.molecularTransformerRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.GalaxySpace.ID, "item.GlowstoneDusts", 1L, 2)).itemOutputs(GTModHandler.getModItem(Mods.AdvancedSolarPanel.ID, "asp_crafting_items", 1L, 9)).duration(10).eut(TierEU.RECIPE_ZPM).addTo(GTPPRecipeMaps.molecularTransformerRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.GalaxySpace.ID, "item.GlowstoneDusts", 1L, 3)).itemOutputs(GTModHandler.getModItem(Mods.AdvancedSolarPanel.ID, "asp_crafting_items", 1L, 9)).duration(3).eut(TierEU.RECIPE_UV).addTo(GTPPRecipeMaps.molecularTransformerRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.GalaxySpace.ID, "item.GlowstoneDusts", 1L, 4)).itemOutputs(GTModHandler.getModItem(Mods.AdvancedSolarPanel.ID, "asp_crafting_items", 1L, 9)).duration(1).eut(TierEU.RECIPE_UHV).addTo(GTPPRecipeMaps.molecularTransformerRecipes);
        }
    }
}

