/*
 * Decompiled with CFR 0.152.
 */
package gtneioreplugin.plugin;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.event.NEIRegisterHandlerInfosEvent;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTOreDictUnificator;
import gtneioreplugin.plugin.gregtech5.PluginGT5SmallOreStat;
import gtneioreplugin.plugin.gregtech5.PluginGT5UndergroundFluid;
import gtneioreplugin.plugin.gregtech5.PluginGT5VeinStat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class NEIPluginConfig
implements IConfigureNEI {
    public String getName() {
        return "GregTech Ore Plugin";
    }

    public String getVersion() {
        return "5.09.50.05";
    }

    public void loadConfig() {
        PluginGT5VeinStat pluginVeinStat = new PluginGT5VeinStat();
        PluginGT5SmallOreStat pluginSmallOreStat = new PluginGT5SmallOreStat();
        PluginGT5UndergroundFluid pluginGT5UndergroundFluid = new PluginGT5UndergroundFluid();
        API.registerRecipeHandler((ICraftingHandler)pluginVeinStat);
        API.registerUsageHandler((IUsageHandler)pluginVeinStat);
        API.registerRecipeHandler((ICraftingHandler)pluginSmallOreStat);
        API.registerUsageHandler((IUsageHandler)pluginSmallOreStat);
        API.registerRecipeHandler((ICraftingHandler)pluginGT5UndergroundFluid);
        API.registerUsageHandler((IUsageHandler)pluginGT5UndergroundFluid);
        List<ItemList> catalysts = Arrays.asList(ItemList.OilDrill1, ItemList.OilDrill2, ItemList.OilDrill3, ItemList.OilDrill4, ItemList.OilDrillInfinite);
        for (ItemList catalyst : catalysts) {
            API.addRecipeCatalyst((ItemStack)catalyst.get(1L, new Object[0]), (IRecipeHandler)pluginGT5UndergroundFluid);
        }
    }

    @SubscribeEvent
    public void registerHandlerInfo(NEIRegisterHandlerInfosEvent event) {
        HashMap<String, ItemStack> handlers = new HashMap<String, ItemStack>();
        handlers.put("PluginGT5VeinStat", GTOreDictUnificator.get(OrePrefixes.ore, Materials.Manyullyn, 1L));
        handlers.put("PluginGT5SmallOreStat", GTOreDictUnificator.get(OrePrefixes.ore, Materials.Platinum, 1L));
        handlers.put("PluginGT5UndergroundFluid", ItemList.Electric_Pump_UEV.get(1L, new Object[0]));
        for (Map.Entry handler : handlers.entrySet()) {
            event.registerHandlerInfo(new HandlerInfo.Builder("gtneioreplugin.plugin.gregtech5." + (String)handler.getKey(), "GT NEI Ore Plugin GT:NH Mod", "gtneioreplugin").setHeight(160).setMaxRecipesPerPage(2).setDisplayStack((ItemStack)handler.getValue()).build());
        }
    }
}

