/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity;

import bartworks.API.BorosilicateGlass;
import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.SimpleShutDownReason;
import gtnhlanth.common.beamline.BeamInformation;
import gtnhlanth.common.beamline.BeamLinePacket;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.block.BlockAntennaCasing;
import gtnhlanth.common.hatch.MTEHatchInputBeamline;
import gtnhlanth.common.hatch.MTEHatchOutputBeamline;
import gtnhlanth.common.register.LanthItemList;
import gtnhlanth.common.tileentity.recipe.beamline.BeamlineRecipeLoader;
import gtnhlanth.util.DescTextLocalization;
import gtnhlanth.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTESynchrotron
extends MTEEnhancedMultiBlockBase<MTESynchrotron>
implements ISurvivalConstructable {
    private static final IStructureDefinition<MTESynchrotron> STRUCTURE_DEFINITION;
    protected static final String STRUCTURE_PIECE_ENTRANCE = "entrance";
    protected static final String STRUCTURE_PIECE_BASE = "base";
    public static final int CONSUMED_FLUID = 32000;
    public static final int MIN_INPUT_FOCUS = 25;
    private ArrayList<MTEHatchInputBeamline> mInputBeamline = new ArrayList();
    private ArrayList<MTEHatchOutputBeamline> mOutputBeamline = new ArrayList();
    public ArrayList<BlockAntennaCasing> mAntennaCasings = new ArrayList();
    private static final int CASING_INDEX;
    private static final byte MIN_GLASS_TIER = 6;
    private int energyHatchTier;
    private int antennaeTier;
    private Byte glassTier;
    private float outputEnergy;
    private int outputRate;
    private int outputParticle;
    private float outputFocus;
    private float machineFocus;
    private int machineTemp;

    public MTESynchrotron(String aName) {
        super(aName);
    }

    public MTESynchrotron(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESynchrotron(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Particle Accelerator").addInfo("Controller block for the Synchrotron").addInfo("Torus-shaped, accelerates electrons to produce high-energy electromagnetic radiation,").addInfo("in the form of photons").addInfo("Antenna Casings can be one of two tiers, upgrade them to improve output rate and energy scaling").addInfo("Minimum input focus: 25").addInfo(DescTextLocalization.BLUEPRINT_INFO).addInfo(DescTextLocalization.BEAMLINE_SCANNER_INFO).addInfo("Use a lower temperature coolant to improve output focus").addInfo("Valid Coolants:");
        for (String fluidName : BeamlineRecipeLoader.coolantMap.keySet()) {
            tt.addInfo("- " + FluidRegistry.getFluid((String)fluidName).getLocalizedName(null));
        }
        tt.addInfo("Requires 32 kL/s of coolant").addSeparator().beginStructureBlock(36, 7, 34, true).addController("Front middle").addCasingInfoExactly(LanthItemList.SHIELDED_ACCELERATOR_CASING.func_149732_F(), 676, false).addCasingInfoExactly("Superconducting Coil Block", 90, false).addCasingInfoExactly("Niobium Cavity Casing", 64, false).addCasingInfoExactly(LanthItemList.COOLANT_DELIVERY_CASING.func_149732_F(), 28, false).addCasingInfoExactly("Borosilicate Glass Block (LuV+)", 16, false).addCasingInfoExactly("Antenna Casing (must match)", 4, true).addOtherStructurePart("Beamline Input Hatch", DescTextLocalization.addDotText(1)).addOtherStructurePart("Beamline Output Hatch", DescTextLocalization.addDotText(2)).addMaintenanceHatch(DescTextLocalization.addDotText(3)).addInputHatch(DescTextLocalization.addDotText(4)).addOutputHatch(DescTextLocalization.addDotText(5)).addEnergyHatch(DescTextLocalization.addDotText(6)).toolTipFinisher("GTNH: Lanthanides");
        return tt;
    }

    private boolean addBeamlineInputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEHatchInputBeamline) {
            return this.mInputBeamline.add((MTEHatchInputBeamline)mte);
        }
        return false;
    }

    private boolean addBeamlineOutputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEHatchOutputBeamline) {
            return this.mOutputBeamline.add((MTEHatchOutputBeamline)mte);
        }
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean active, boolean aRedstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][14], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][14], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][14]};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        elementBudget = 200;
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivialBuildPiece(STRUCTURE_PIECE_ENTRANCE, stackSize, 16, 3, 1, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 16, 3, 0, elementBudget, env, false, true);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_ENTRANCE, stackSize, hintsOnly, 16, 3, 1);
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 16, 3, 0);
    }

    @Override
    public IStructureDefinition<MTESynchrotron> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            MTEHatchEnergy hatch = (MTEHatchEnergy)aMetaTileEntity;
            if (this.mEnergyHatches.size() == 0) {
                this.energyHatchTier = hatch.mTier;
            }
            if (hatch.mTier != this.energyHatchTier) {
                return false;
            }
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mEnergyHatches.add(hatch);
        }
        return false;
    }

    private boolean addAntenna(Block block, int meta) {
        if (block == null) {
            return false;
        }
        if (!(block instanceof BlockAntennaCasing)) {
            return false;
        }
        BlockAntennaCasing antennaBlock = (BlockAntennaCasing)block;
        int antennaTier = antennaBlock.getTier();
        if (this.mAntennaCasings.size() == 0) {
            this.antennaeTier = antennaTier;
        }
        if (antennaTier != this.antennaeTier) {
            return false;
        }
        return this.mAntennaCasings.add(antennaBlock);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        float inputEnergy = 0.0f;
        float inputFocus = 0.0f;
        float inputRate = 0.0f;
        int inputParticleId = 0;
        this.machineFocus = 0.0f;
        this.machineTemp = 0;
        this.outputEnergy = 0.0f;
        this.outputFocus = 0.0f;
        this.outputRate = 0;
        this.outputParticle = 0;
        float tempFactor = 0.0f;
        float voltageFactor = 0.0f;
        ArrayList<FluidStack> fluidList = this.getStoredFluids();
        if (fluidList.size() == 0) {
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.nocoolant"));
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.getInputInformation() == null) {
            return false;
        }
        if (this.getInputInformation().getEnergy() == 0.0f) {
            return false;
        }
        if (this.getInputInformation().getFocus() < 25.0f) {
            return false;
        }
        inputParticleId = this.getInputInformation().getParticleId();
        Particle inputParticle = Particle.getParticleFromId(inputParticleId);
        if (!inputParticle.canAccelerate()) {
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.noaccel"));
            return false;
        }
        this.mMaxProgresstime = 20;
        long voltage = this.getMaxInputVoltage();
        this.mEUt = (int)(-voltage / GTValues.V[(int)this.getInputVoltageTier()] * GTValues.VP[(int)this.getInputVoltageTier()]);
        this.outputParticle = 1;
        FluidStack primaryFluid = fluidList.get(0);
        int fluidTemperature = primaryFluid.isFluidEqual(new FluidStack(FluidRegistry.getFluid((String)"ic2coolant"), 1)) ? 60 : primaryFluid.getFluid().getTemperature();
        this.machineTemp = fluidTemperature;
        this.machineFocus = MTESynchrotron.getMachineFocus(fluidTemperature);
        inputFocus = this.getInputInformation().getFocus();
        this.outputFocus = inputFocus > this.machineFocus ? (inputFocus + this.machineFocus) / 2.5f : inputFocus * (this.machineFocus / 100.0f);
        voltageFactor = MTESynchrotron.getVoltageFactor(voltage, this.antennaeTier);
        inputEnergy = this.getInputInformation().getEnergy();
        float mass = inputParticle.getMass();
        this.outputEnergy = (float)MTESynchrotron.calculateOutputParticleEnergy(voltage, inputEnergy, this.antennaeTier);
        inputRate = this.getInputInformation().getRate();
        this.outputRate = (int)(inputRate * MTESynchrotron.getOutputRatetio(voltageFactor, this.antennaeTier));
        if (this.outputRate == 0) {
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.low_input_rate"));
            return false;
        }
        if (Util.coolantFluidCheck(primaryFluid, 32000)) {
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.inscoolant"));
            return false;
        }
        primaryFluid.amount -= 32000;
        Fluid fluidOutput = BeamlineRecipeLoader.coolantMap.get(primaryFluid.getFluid().getName());
        if (Objects.isNull(fluidOutput)) {
            return false;
        }
        FluidStack fluidOutputStack = new FluidStack(fluidOutput, 32000);
        if (Objects.isNull(fluidOutputStack)) {
            return false;
        }
        this.addFluidOutputs(new FluidStack[]{fluidOutputStack});
        this.outputAfterRecipe();
        return true;
    }

    private void outputAfterRecipe() {
        if (!this.mOutputBeamline.isEmpty()) {
            BeamLinePacket packet = new BeamLinePacket(new BeamInformation(this.outputEnergy, this.outputRate, this.outputParticle, this.outputFocus));
            for (MTEHatchOutputBeamline o : this.mOutputBeamline) {
                o.q = packet;
            }
        }
    }

    @Override
    public void stopMachine() {
        this.outputFocus = 0.0f;
        this.outputEnergy = 0.0f;
        this.outputParticle = 0;
        this.outputRate = 0;
        this.machineFocus = 0.0f;
        this.machineTemp = 0;
        super.stopMachine();
    }

    @Override
    public void stopMachine(ShutDownReason reason) {
        this.outputFocus = 0.0f;
        this.outputEnergy = 0.0f;
        this.outputParticle = 0;
        this.outputRate = 0;
        this.machineFocus = 0.0f;
        this.machineTemp = 0;
        super.stopMachine(reason);
    }

    private BeamInformation getInputInformation() {
        Iterator<MTEHatchInputBeamline> iterator = this.mInputBeamline.iterator();
        if (iterator.hasNext()) {
            MTEHatchInputBeamline in = iterator.next();
            if (in.q == null) {
                return new BeamInformation(0.0f, 0, 0, 0.0f);
            }
            return (BeamInformation)((BeamLinePacket)in.q).getContent();
        }
        return null;
    }

    private static float getVoltageFactor(long mEU, int antennaTier) {
        float factor = (float)(Math.sqrt(mEU) / 1500.0);
        return factor;
    }

    private static double calculateOutputParticleEnergy(long voltage, double inputParticleEnergy, int antennaTier) {
        double energy = Math.pow(inputParticleEnergy, 1.13 * Math.pow(antennaTier, 0.4444444444444444)) / 4.0E7 * (-Math.pow(Math.pow(0.15, 2.0 / Math.pow(antennaTier, 2.5)), (double)voltage / 60768.0) + 1.0);
        return energy;
    }

    private static float getMachineFocus(int temperature) {
        return (float)Math.max(Math.min(Math.pow(1.5, -0.025 * (double)(temperature - 480)), 90.0), 10.0);
    }

    private static float getOutputRatetio(float voltageFactor, int antennaTier) {
        return (float)((double)voltageFactor / (10.0 / Math.pow(2.5, antennaTier)));
    }

    @Override
    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("Synchrotron.hint", 12);
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : this.mEnergyHatches) {
            if (!tHatch.isValid()) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        BeamInformation information = this.getInputInformation();
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %", EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.info") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + this.machineFocus + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.temperature") + ": " + EnumChatFormatting.DARK_RED + this.machineTemp + EnumChatFormatting.RESET + " K", StatCollector.func_74838_a((String)"beamline.coolusage") + ": " + EnumChatFormatting.AQUA + 32000 + EnumChatFormatting.RESET + " kL/s", EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.in_pre") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.particle") + ": " + EnumChatFormatting.GOLD + Particle.getParticleFromId(information.getParticleId()).getLocalisedName() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.energy") + ": " + EnumChatFormatting.DARK_RED + information.getEnergy() + EnumChatFormatting.RESET + " keV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + information.getFocus() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.amount") + ": " + EnumChatFormatting.LIGHT_PURPLE + information.getRate(), EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.out_pre") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.particle") + ": " + EnumChatFormatting.GOLD + Particle.getParticleFromId(this.outputParticle).getLocalisedName() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.energy") + ": " + EnumChatFormatting.DARK_RED + this.outputEnergy * 1000.0f + EnumChatFormatting.RESET + " eV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + this.outputFocus + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.amount") + ": " + EnumChatFormatting.LIGHT_PURPLE + this.outputRate};
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mInputBeamline.clear();
        this.mOutputBeamline.clear();
        this.mAntennaCasings.clear();
        this.mEnergyHatches.clear();
        this.energyHatchTier = 0;
        this.antennaeTier = 0;
        this.glassTier = 0;
        this.outputEnergy = 0.0f;
        this.outputRate = 0;
        this.outputFocus = 0.0f;
        this.outputParticle = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_ENTRANCE, 16, 3, 1)) {
            return false;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 16, 3, 0)) {
            return false;
        }
        return this.mInputBeamline.size() == 1 && this.mOutputBeamline.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() == 4 && this.glassTier >= 6;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    static {
        CASING_INDEX = GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings5, 14);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_ENTRANCE, (String[][])new String[][]{{"                                    ", "  ccc                               ", " cgggc                              ", " cgvgc                              ", " cgggc                              ", "  ccc                               "}}).addShape(STRUCTURE_PIECE_BASE, (String[][])new String[][]{{"                                    ", "  ccc                               ", " ccccc       cjjjjjc                ", " cc-cc      cjjc~cjjc               ", " ccccc       cjjjjjc                ", "  ccc                               ", "                                    "}, {"                                    ", "  ccc      ccccccccccc              ", " c---c    ccc-------ccc             ", " c---c    ccc-------ccc             ", " c---c    ccc-------ccc             ", "  ccc      ccccccccccc              ", "                                    "}, {"           ccccccccccc              ", "  ccc    cc-----------cc            ", " c---c  cc-------------cc           ", " c---c  cc-------------cc           ", " c---c  cc-------------cc           ", "  ccc    ccc---------ccc            ", "           ccccccccccc              "}, {"         ccccccccccccccc            ", "  ccc  cc---------------cc          ", " c---ccc-----------------c          ", " c---ccc-----------------cc         ", " c---ccc-----------------c          ", "  ccc  cc---------------cc          ", "         ccccccccccccccc            "}, {"  ccc   ccccccccccccccccc           ", " ckkkccc-----------------cc         ", "ck---kc-------------------cc        ", "ck---kc--------------------c        ", "ck---kc-------------------cc        ", " ckkkccc-----------------cc         ", "  ccc  cccccccccccccccccc           "}, {"  cccccccccccc     ccccccc          ", " cdddcc-------ccccc-------cc        ", "cd---d----------------------c       ", "cd---d----------------------c       ", "cd---d----------------------c       ", " cdddcc-------ccccc-------cc        ", "  cccccccccccc     ccccccc          "}, {"  ccccccccc           ccccc         ", " ckkkc-----cccc   cccc-----cc       ", "ck---k-------ccccccc--------c       ", "ck---k-------ccccccc---------c      ", "ck---k-------ccccccc--------c       ", " ckkkc-----cccc   cccc-----cc       ", "  ccccccccc           ccccc         "}, {"  cccccccc             ccccc        ", " c--------cc         cc-----cc      ", "c----------cc       cc-------c      ", "c----------cc       cc-------c      ", "c----------cc       cc-------c      ", " c--------cc         cc-----cc      ", "  cccccccc             ccccc        "}, {"  ccccccc               ccccc       ", " c-------c             c-----c      ", "c---------c           c-------c     ", "c---------c           c-------c     ", "c---------c           c-------c     ", " c-------c             c-----c      ", "  ccccccc               ccccc       "}, {"  cccccc                 ccccc      ", " c------c               c-----c     ", "c--------c             c------c     ", "c--------c             c------c     ", "c--------c             c------c     ", " c------c               c-----c     ", "  cccccc                 ccccc      "}, {"  ccccc                   cccc      ", " c-----c                 c----c     ", "c-------c               c------c    ", "c-------c               c------c    ", "c-------c               c------c    ", " c-----c                 c----c     ", "  ccccc                   cccc      "}, {"  cccc                     ccc      ", " c----cc                 cc---cc    ", "c------c                 c-----c    ", "c------c                 c-----c    ", "c------c                 c-----c    ", " c----cc                 cc---cc    ", "  cccc                     ccc      "}, {"  cccc                     cccc     ", " c---cc                   c----c    ", "c------c                 c-----c    ", "c------c                 c-----cc   ", "c------c                 c-----c    ", " c---cc                   cc---c    ", "  cccc                     cccc     "}, {"  cccc                     cccc     ", " c---cc                   c----c    ", "c-----c                   c----cc   ", "c-----c                   c----cc   ", "c-----c                   c----cc   ", " c---cc                   cc---c    ", "  cccc                     cccc     "}, {"  ccc                       ccc     ", " ckkkcc                   cckkkc    ", "ck---kc                   ck---kc   ", "ck---kc                   ck---kc   ", "ck---kc                   ck---kc   ", " ckkkcc                   cckkkc    ", "  ccc                       ccc     "}, {"  cec                       cec     ", " cnanc                     cnanc    ", "cn---nc                   cn---nc   ", "cn---nc                   cn---nc   ", "cn---nc                   cn---nc   ", " cnnnc                     cnnnc    ", "  ccc                       ccc     "}, {"  cic                       cic     ", " cndnc                     cndnc    ", "cn---nc                   cn---nc   ", "cn---nc                   cn---nc   ", "cn---nc                   cn---nc   ", " cndnc                     cndnc    ", "  coc                       coc     "}, {"  cec                       cec     ", " cnanc                     cnanc    ", "cn---nc                   cn---nc   ", "cn---nc                   cn---nc   ", "cn---nc                   cn---nc   ", " cnnnc                     cnnnc    ", "  ccc                       ccc     "}, {"  ccc                       ccc     ", " ckkkcc                   cckkkc    ", "ck---kc                   ck---kc   ", "ck---kc                   ck---kc   ", "ck---kc                   ck---kc   ", " ckkkcc                   cckkkc    ", "  ccc                       ccc     "}, {"  cccc                     cccc     ", " c----c                   c----c    ", "cc----c                   c----cc   ", "cc----c                   c----cc   ", "cc----c                   c----cc   ", " c---cc                   cc---c    ", "  cccc                     cccc     "}, {"  cccc                     cccc     ", " c----c                   c----c    ", " c-----c                 c-----c    ", "cc-----c                 c-----cc   ", " c-----c                 c-----c    ", " c---cc                   cc---c    ", "  cccc                     cccc     "}, {"   ccc                     ccc      ", " cc---cc                 cc---cc    ", " c-----c                 c-----c    ", " c-----c                 c-----c    ", " c-----c                 c-----c    ", " cc---cc                 cc---cc    ", "   ccc                     ccc      "}, {"   cccc                   cccc      ", "  c----c                 c----c     ", " c------c               c------c    ", " c------c               c------c    ", " c------c               c------c    ", "  c----c                 c----c     ", "   cccc                   cccc      "}, {"   ccccc                 ccccc      ", "  c-----c               c-----c     ", "  c------c             c------c     ", "  c------c             c------c     ", "  c------c             c------c     ", "  c-----c               c-----c     ", "   ccccc                 ccccc      "}, {"    ccccc               ccccc       ", "   c-----c             c-----c      ", "  c-------c           c-------c     ", "  c-------c           c-------c     ", "  c-------c           c-------c     ", "   c-----c             c-----c      ", "    ccccc               ccccc       "}, {"     ccccc             ccccc        ", "    c-----cc         cc-----c       ", "   c-------cc       cc-------cc     ", "   c-------cc       cc-------cc     ", "   c-------cc       cc-------cc     ", "    c-----cc         cc------c      ", "     ccccc             cccccc       "}, {"      ccccc           ccccccc       ", "    cc-----cccc   cccc-----ccc      ", "    c--------ccccccc--------cccc    ", "    c--------ccccccc--------cccc    ", "    c--------ccccccc--------cccc    ", "    cc-----cccc   cccc------cc      ", "      ccccc           cccccc        "}, {"       ccccccc     cccccccccc       ", "     cc-------ccccc--------cccc     ", "    c---------kdkdk--------ccccccccc", "    c---------kdkdk--------ccccccccc", "    c---------kdkdk--------ccccccccc", "     cc-------ccccc--------cccc     ", "       ccccccc     cccccccc         "}, {"        cccccccccccccccccccc        ", "      cc-------------------ccccccccc", "     cc---------------------------cg", "     c----------------------------cg", "     cc---------------------------cg", "       c-------------------ccccccccc", "        ccccccccccccccccccc         "}, {"         ccccccccccccccccccc        ", "       cc-----------------cccccccccc", "       c--------------------------cg", "      cc---------------------------b", "       c--------------------------cg", "        c-----------------cccccccccc", "         ccccccccccccccccc          "}, {"            ccccccccccccccc         ", "         ccc-------------ccccccccccc", "        cc------------------------cg", "        cc------------------------cg", "        cc------------------------cg", "         ccc-------------ccccccccccc", "            ccccccccccccc           "}, {"                                    ", "           cccccccccccccccccc       ", "          ccc-kdkdk------ccccccccccc", "          cc--kdkdk------ccccccccccc", "          ccc-kdkdk------ccccccccccc", "           cccccccccccccccccc       "}, {"                                    ", "                                    ", "             cccccccccccccccc       ", "            ccccccccccccccccc       ", "             cccccccccccccccc       ", "                                    ", "                                    "}}).addElement('c', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0)).addElement('k', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)15)).addElement('d', StructureUtility.ofBlock((Block)LanthItemList.COOLANT_DELIVERY_CASING, (int)0)).addElement('e', GTStructureUtility.buildHatchAdder(MTESynchrotron.class).atLeast((Map<IHatchElement<MTESynchrotron>, Number>)ImmutableMap.of((Object)HatchElement.Energy, (Object)4)).dot(6).casingIndex(CASING_INDEX).build()).addElement('n', StructureUtility.ofBlock((Block)LanthItemList.NIOBIUM_CAVITY_CASING, (int)0)).addElement('a', StructureUtility.ofBlockAdder(MTESynchrotron::addAntenna, (Block)LanthItemList.ANTENNA_CASING_T1, (int)0)).addElement('i', GTStructureUtility.buildHatchAdder(MTESynchrotron.class).atLeast((Map<IHatchElement<MTESynchrotron>, Number>)ImmutableMap.of((Object)HatchElement.InputHatch, (Object)2)).dot(4).casingIndex(CASING_INDEX).build()).addElement('o', GTStructureUtility.buildHatchAdder(MTESynchrotron.class).atLeast((Map<IHatchElement<MTESynchrotron>, Number>)ImmutableMap.of((Object)HatchElement.OutputHatch, (Object)2)).dot(5).casingIndex(CASING_INDEX).build()).addElement('v', GTStructureUtility.buildHatchAdder(MTESynchrotron.class).hatchClass(MTEHatchInputBeamline.class).casingIndex(CASING_INDEX).dot(1).adder(MTESynchrotron::addBeamlineInputHatch).build()).addElement('b', GTStructureUtility.buildHatchAdder(MTESynchrotron.class).hatchClass(MTEHatchOutputBeamline.class).casingIndex(CASING_INDEX).dot(2).adder(MTESynchrotron::addBeamlineOutputHatch).build()).addElement('g', BorosilicateGlass.ofBoroGlass((byte)0, (byte)6, (byte)127, (te, t) -> {
            te.glassTier = t;
        }, te -> te.glassTier)).addElement('j', GTStructureUtility.buildHatchAdder(MTESynchrotron.class).atLeast(HatchElement.Maintenance).dot(3).casingIndex(CASING_INDEX).buildAndChain(LanthItemList.SHIELDED_ACCELERATOR_CASING, 0)).build();
    }
}

