/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.event.RitualRunEvent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectWellOfSuffering;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.kuba6000.mobsinfo.api.utils.FastRandom;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import kubatech.api.Variables;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.api.tileentity.CustomTileEntityPacketHandler;
import kubatech.api.utils.ModUtils;
import kubatech.client.effect.EntityRenderer;
import kubatech.loaders.MobHandlerLoader;
import kubatech.network.CustomTileEntityPacket;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEExtremeEntityCrusher
extends KubaTechGTMultiBlockBase<MTEExtremeEntityCrusher>
implements CustomTileEntityPacketHandler,
ISurvivalConstructable {
    public static final double DIAMOND_SPIKES_DAMAGE = 9.0;
    public static final int MOB_SPAWN_INTERVAL = 55;
    public final Random rand = new FastRandom();
    private final WeaponCache weaponCache = new WeaponCache(this.mInventory);
    private static final String WellOfSufferingRitualName = "AW013Suffering";
    private static final Item poweredSpawnerItem = Item.func_150898_a((Block)EnderIO.blockPoweredSpawner);
    private static final int CASING_INDEX = 16;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEExtremeEntityCrusher> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "g---g", "g---g", "g---g", "fgggf"}, {"fgggf", "gsssg", "gsssg", "gsssg", "fgggf"}, {"CC~CC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}})).addElement('c', StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0))).addElement('C', GTStructureUtility.buildHatchAdder(MTEExtremeEntityCrusher.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy, HatchElement.Maintenance).casingIndex(16).dot(1).buildAndChain(StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)))).addElement('g', BorosilicateGlass.ofBoroGlass((byte)0, (t, v) -> {
        t.mGlassTier = v;
    }, t -> t.mGlassTier)).addElement('f', GTStructureUtility.ofFrame(Materials.Steel)).addElement('s', Mods.ExtraUtilities.isModLoaded() ? StructureUtility.ofBlock((Block)Block.func_149684_b((String)"ExtraUtilities:spike_base_diamond"), (int)0) : StructureUtility.isAir()).build();
    private TileEntity masterStoneRitual = null;
    private TileEntity tileAltar = null;
    private boolean isInRitualMode = false;
    private int mCasing = 0;
    private byte mGlassTier = 0;
    private boolean mAnimationEnabled = true;
    private boolean mIsProducingInfernalDrops = true;
    private boolean voidAllDamagedAndEnchantedItems = false;
    private EntityRenderer entityRenderer = null;
    private boolean renderEntity = false;
    public EECFakePlayer EECPlayer = null;
    private CustomTileEntityPacket mobPacket = null;

    public MTEExtremeEntityCrusher(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEExtremeEntityCrusher(String aName) {
        super(aName);
        if (Mods.BloodMagic.isModLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void onRemoval() {
        if (Mods.BloodMagic.isModLoaded()) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
        if (this.getBaseMetaTileEntity().isClientSide() && this.entityRenderer != null) {
            this.entityRenderer.func_70106_y();
        }
    }

    @Override
    public void onUnload() {
        if (Mods.BloodMagic.isModLoaded()) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isInRitualMode", this.isInRitualMode);
        aNBT.func_74757_a("mAnimationEnabled", this.mAnimationEnabled);
        aNBT.func_74774_a("mGlassTier", this.mGlassTier);
        aNBT.func_74757_a("mIsProducingInfernalDrops", this.mIsProducingInfernalDrops);
        aNBT.func_74757_a("voidAllDamagedAndEnchantedItems", this.voidAllDamagedAndEnchantedItems);
        if (this.weaponCache.getStackInSlot(0) != null) {
            aNBT.func_74782_a("weaponCache", (NBTBase)this.weaponCache.getStackInSlot(0).func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isInRitualMode = aNBT.func_74767_n("isInRitualMode");
        this.mAnimationEnabled = !aNBT.func_74764_b("mAnimationEnabled") || aNBT.func_74767_n("mAnimationEnabled");
        this.mGlassTier = aNBT.func_74771_c("mGlassTier");
        this.mIsProducingInfernalDrops = !aNBT.func_74764_b("mIsProducingInfernalDrops") || aNBT.func_74767_n("mIsProducingInfernalDrops");
        this.voidAllDamagedAndEnchantedItems = aNBT.func_74767_n("voidAllDamagedAndEnchantedItems");
        if (aNBT.func_74764_b("weaponCache")) {
            this.weaponCache.setStackInSlot(0, ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l("weaponCache")));
        }
    }

    @Override
    public boolean isOverclockingInfinite() {
        return true;
    }

    @Override
    protected int getOverclockTimeLimit() {
        return 20;
    }

    @Override
    public IStructureDefinition<MTEExtremeEntityCrusher> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Powered Spawner, EEC").addInfo("Controller block for the Extreme Entity Crusher").addInfo(Variables.Author).addInfo("Spawns and kills monsters for you.").addInfo("You have to insert the powered spawner in the controller.").addInfo("Base energy usage: 2,000 EU/t").addInfo("Supports perfect OC, minimum time: 20 ticks, after that multiplies the outputs.").addInfo("Recipe time is based on mob health.").addInfo("You can additionally put a weapon inside the GUI.").addInfo("It will speed up the process and apply the looting level from the weapon (maximum 4 levels).").addInfo(EnumChatFormatting.RED + "Enchanting the spikes inside the structure does nothing!").addInfo("Also produces 120 Liquid XP per operation.").addInfo("If the mob spawns infernal, it will drain 8 times more power.").addInfo("You can prevent infernal spawns by shift clicking with a screwdriver.").addInfo("Note: If the mob has forced infernal spawn, it will do it anyway.").addInfo("You can enable ritual mode with a screwdriver.").addInfo("When in ritual mode and the Well Of Suffering ritual is built directly centered on the machine,").addInfo("the mobs will start to buffer and die very slowly by the ritual.").addInfo("You can disable mob animation with a soldering iron.").addInfo(Variables.StructureHologram).addSeparator().beginStructureBlock(5, 7, 5, true).addController("Front Bottom Center").addCasingInfoMin("Solid Steel Machine Casing", 35, false).addOtherStructurePart("Tiered (HV+) Glass", "Side walls without edges or corners").addStructureInfo("The glass tier limits the Energy Hatch tier").addOtherStructurePart("Steel Frame Box", "All vertical edges without corners").addOtherStructurePart("Diamond spikes", "Inside second layer").addOutputBus("Any bottom casing", 1).addOutputHatch("Any bottom casing", 1).addEnergyHatch("Any bottom casing", 1).addMaintenanceHatch("Any bottom casing", 1).toolTipFinisher("KubaTech");
        return tt;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 6, 0, elementBudget, env, true, true);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEExtremeEntityCrusher(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(16)};
    }

    @SideOnly(value=Side.CLIENT)
    private void setupEntityRenderer(IGregTechTileEntity aBaseMetaTileEntity, int time) {
        if (this.entityRenderer == null) {
            ChunkCoordinates coords = this.getBaseMetaTileEntity().getCoords();
            int[] abc = new int[]{0, -2, 2};
            int[] xyz = new int[]{0, 0, 0};
            this.getExtendedFacing().getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + coords.field_71574_a;
            xyz[1] = xyz[1] + coords.field_71572_b;
            xyz[2] = xyz[2] + coords.field_71573_c;
            this.entityRenderer = new EntityRenderer(aBaseMetaTileEntity.getWorld(), xyz[0], xyz[1], xyz[2], time);
        } else {
            this.entityRenderer.func_70106_y();
            this.entityRenderer = new EntityRenderer(this.entityRenderer, time);
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)this.entityRenderer);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && this.renderEntity && aBaseMetaTileEntity.isActive() && aTick % 40L == 0L) {
            this.setupEntityRenderer(aBaseMetaTileEntity, 40);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void HandleCustomPacket(CustomTileEntityPacket message) {
        if (message.getDataBoolean() && Mods.MobsInfo.isModLoaded()) {
            this.renderEntity = true;
            String mobType = message.getDataString();
            MobHandlerLoader.MobEECRecipe r = MobHandlerLoader.recipeMap.get(mobType);
            if (r != null) {
                if (this.entityRenderer == null) {
                    this.setupEntityRenderer(this.getBaseMetaTileEntity(), 40);
                }
                this.entityRenderer.setEntity(r.entityCopy);
            } else {
                this.entityRenderer.setEntity(null);
            }
        } else {
            this.renderEntity = false;
            if (this.entityRenderer != null) {
                this.entityRenderer.func_70106_y();
                this.entityRenderer = null;
            }
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mMaxProgresstime > 0) {
            GTUtility.sendChatToPlayer(aPlayer, "Can't change mode when running !");
            return;
        }
        if (aPlayer.func_70093_af()) {
            if (!Mods.InfernalMobs.isModLoaded()) {
                return;
            }
            boolean bl = this.mIsProducingInfernalDrops = !this.mIsProducingInfernalDrops;
            if (!this.mIsProducingInfernalDrops) {
                GTUtility.sendChatToPlayer(aPlayer, "Mobs will now be prevented from spawning infernal");
            } else {
                GTUtility.sendChatToPlayer(aPlayer, "Mobs can spawn infernal now");
            }
        } else {
            if (!Mods.BloodMagic.isModLoaded()) {
                return;
            }
            boolean bl = this.isInRitualMode = !this.isInRitualMode;
            if (!this.isInRitualMode) {
                GTUtility.sendChatToPlayer(aPlayer, "Ritual mode disabled");
            } else {
                GTUtility.sendChatToPlayer(aPlayer, "Ritual mode enabled");
                if (this.connectToRitual()) {
                    GTUtility.sendChatToPlayer(aPlayer, "Successfully connected to the ritual");
                } else {
                    GTUtility.sendChatToPlayer(aPlayer, "Can't connect to the ritual");
                }
            }
        }
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (wrenchingSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mAnimationEnabled = !this.mAnimationEnabled;
            GTUtility.sendChatToPlayer(aPlayer, "Animations are " + (this.mAnimationEnabled ? "enabled" : "disabled"));
            return true;
        }
        return super.onSolderingToolRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRitualPerform(RitualRunEvent event) {
        RitualEffect ritualEffect;
        Rituals ritual;
        if (!this.isInRitualMode) {
            return;
        }
        if (this.masterStoneRitual == null) {
            return;
        }
        if (this.mMaxProgresstime == 0) {
            return;
        }
        if (event.mrs.equals(this.masterStoneRitual) && event.ritualKey.equals(WellOfSufferingRitualName) && (ritual = (Rituals)Rituals.ritualMap.get(WellOfSufferingRitualName)) != null && (ritualEffect = ritual.effect) instanceof RitualEffectWellOfSuffering) {
            RitualEffectWellOfSuffering effect = (RitualEffectWellOfSuffering)ritualEffect;
            event.setCanceled(true);
            String owner = event.mrs.getOwner();
            int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
            World world = event.mrs.getWorld();
            int x = event.mrs.getXCoord();
            int y = event.mrs.getYCoord();
            int z = event.mrs.getZCoord();
            if (world.func_72820_D() % 25L != 0L) {
                return;
            }
            if (this.tileAltar == null || this.tileAltar.func_145837_r()) {
                this.tileAltar = null;
                for (int i = -5; i <= 5; ++i) {
                    for (int j = -5; j <= 5; ++j) {
                        for (int k = -10; k <= 10; ++k) {
                            if (!(world.func_147438_o(x + i, y + k, z + j) instanceof IBloodAltar)) continue;
                            this.tileAltar = world.func_147438_o(x + i, y + k, z + j);
                        }
                    }
                }
            }
            if (this.tileAltar == null) {
                return;
            }
            if (currentEssence < effect.getCostPerRefresh() * 100) {
                SoulNetworkHandler.causeNauseaToPlayer((String)owner);
                return;
            }
            ((IBloodAltar)this.tileAltar).sacrificialDaggerCall(100 * RitualEffectWellOfSuffering.amount * (effect.canDrainReagent(event.mrs, ReagentRegistry.offensaReagent, 3, true) ? 2 : 1) * (effect.canDrainReagent(event.mrs, ReagentRegistry.tenebraeReagent, 5, true) ? 2 : 1), true);
            SoulNetworkHandler.syphonFromNetwork((String)owner, (int)(effect.getCostPerRefresh() * 100));
        }
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex >= 0;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        MobHandlerLoader.MobEECRecipe recipe;
        if (this.getBaseMetaTileEntity().isClientSide()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        ItemStack aStack = this.mInventory[1];
        if (aStack == null) {
            return SimpleCheckRecipeResult.ofFailure("EEC_nospawner");
        }
        if (aStack.func_77973_b() != poweredSpawnerItem) {
            return SimpleCheckRecipeResult.ofFailure("EEC_nospawner");
        }
        if (aStack.func_77978_p() == null) {
            return SimpleCheckRecipeResult.ofFailure("EEC_invalidspawner");
        }
        String mobType = aStack.func_77978_p().func_74779_i("mobType");
        if (mobType.isEmpty()) {
            return SimpleCheckRecipeResult.ofFailure("EEC_invalidspawner");
        }
        if (mobType.equals("Skeleton") && this.getBaseMetaTileEntity().getWorld().field_73011_w instanceof WorldProviderHell && this.rand.nextInt(5) > 0) {
            mobType = "witherSkeleton";
        }
        if ((recipe = MobHandlerLoader.recipeMap.get(mobType)) == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (!recipe.recipe.isPeacefulAllowed && this.getBaseMetaTileEntity().getWorld().field_73013_u == EnumDifficulty.PEACEFUL) {
            return SimpleCheckRecipeResult.ofFailure("EEC_peaceful");
        }
        if (this.isInRitualMode && this.isRitualValid()) {
            if (this.getMaxInputEu() < (long)(recipe.mEUt / 4)) {
                return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt / 4);
            }
            this.mOutputFluids = new FluidStack[]{FluidRegistry.getFluidStack((String)"xpjuice", (int)5000)};
            this.mOutputItems = recipe.generateOutputs(this.rand, this, 3.0, 0, this.mIsProducingInfernalDrops, this.voidAllDamagedAndEnchantedItems);
            this.lEUt /= 4L;
            this.mMaxProgresstime = 400;
        } else {
            ItemStack lootingHolder;
            MTEHatchInputBus inputbus;
            long l = this.getMaxInputEu();
            Objects.requireNonNull(recipe);
            if (l < 2000L) {
                Objects.requireNonNull(recipe);
                return CheckRecipeResultRegistry.insufficientPower(2000L);
            }
            if (recipe.recipe.alwaysinfernal && this.getMaxInputEu() < (long)(recipe.mEUt * 8)) {
                return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt * 8);
            }
            double attackDamage = 9.0;
            MTEHatchInputBus mTEHatchInputBus = inputbus = this.mInputBusses.size() == 0 ? null : (MTEHatchInputBus)this.mInputBusses.get(0);
            if (inputbus != null && !inputbus.isValid()) {
                inputbus = null;
            }
            ItemStack itemStack = lootingHolder = inputbus == null ? null : inputbus.func_70301_a(0);
            if (lootingHolder != null && this.weaponCache.getStackInSlot(0) == null && this.weaponCache.isItemValid(0, lootingHolder)) {
                this.weaponCache.setStackInSlot(0, lootingHolder);
                inputbus.func_70299_a(0, null);
                this.updateSlots();
            }
            if (this.weaponCache.isValid) {
                attackDamage += this.weaponCache.attackDamage;
            }
            if (this.EECPlayer == null) {
                this.EECPlayer = new EECFakePlayer(this);
            }
            this.EECPlayer.currentWeapon = this.weaponCache.getStackInSlot(0);
            this.mOutputItems = recipe.generateOutputs(this.rand, this, attackDamage, this.weaponCache.isValid ? this.weaponCache.looting : 0, this.mIsProducingInfernalDrops, this.voidAllDamagedAndEnchantedItems);
            this.EECPlayer.currentWeapon = null;
            this.mOutputFluids = new FluidStack[]{FluidRegistry.getFluidStack((String)"xpjuice", (int)120)};
            ItemStack weapon = this.weaponCache.getStackInSlot(0);
            int times = this.calculatePerfectOverclock(this.lEUt, this.mMaxProgresstime);
            if (this.weaponCache.isValid && weapon.func_77984_f()) {
                this.EECPlayer.currentWeapon = weapon;
                Item lootingHolderItem = weapon.func_77973_b();
                for (int i = 0; i < times + 1 && lootingHolderItem.func_77644_a(weapon, (EntityLivingBase)recipe.recipe.entity, (EntityLivingBase)this.EECPlayer); ++i) {
                    if (weapon.field_77994_a != 0) continue;
                    this.weaponCache.setStackInSlot(0, null);
                    break;
                }
                this.EECPlayer.currentWeapon = null;
            }
        }
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mobPacket == null) {
            this.mobPacket = new CustomTileEntityPacket((TileEntity)this.getBaseMetaTileEntity(), null);
        }
        this.mobPacket.resetHelperData();
        this.mobPacket.addData(this.mAnimationEnabled);
        if (this.mAnimationEnabled) {
            this.mobPacket.addData(mobType);
        }
        this.mobPacket.sendToAllAround(16);
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private boolean isRitualValid() {
        if (!this.isInRitualMode) {
            return false;
        }
        if (this.masterStoneRitual == null) {
            return false;
        }
        if (this.masterStoneRitual.func_145837_r() || !((TEMasterStone)this.masterStoneRitual).getCurrentRitual().equals(WellOfSufferingRitualName)) {
            this.masterStoneRitual = null;
            return false;
        }
        return true;
    }

    private boolean connectToRitual() {
        if (!Mods.BloodMagic.isModLoaded()) {
            return false;
        }
        ChunkCoordinates coords = this.getBaseMetaTileEntity().getCoords();
        int[] abc = new int[]{0, -8, 2};
        int[] xyz = new int[]{0, 0, 0};
        this.getExtendedFacing().getWorldOffset(abc, xyz);
        xyz[0] = xyz[0] + coords.field_71574_a;
        xyz[1] = xyz[1] + coords.field_71572_b;
        xyz[2] = xyz[2] + coords.field_71573_c;
        TileEntity te = this.getBaseMetaTileEntity().getTileEntity(xyz[0], xyz[1], xyz[2]);
        if (te instanceof TEMasterStone && ((TEMasterStone)te).getCurrentRitual().equals(WellOfSufferingRitualName)) {
            this.masterStoneRitual = te;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mGlassTier = 0;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 6, 0)) {
            return false;
        }
        if (this.mCasing < 35 || this.mMaintenanceHatches.size() != 1 || this.mEnergyHatches.size() == 0 || this.mInputBusses.size() != 0 && (this.mInputBusses.size() != 1 || ((MTEHatchInputBus)this.mInputBusses.get((int)0)).mTier != 0)) {
            return false;
        }
        if (this.mGlassTier < 8) {
            for (MTEHatchEnergy hatch : this.mEnergyHatches) {
                if (hatch.mTier <= this.mGlassTier) continue;
                return false;
            }
        }
        if (this.isInRitualMode) {
            this.connectToRitual();
        }
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add("Animations: " + EnumChatFormatting.YELLOW + (this.mAnimationEnabled ? "Enabled" : "Disabled"));
        info.add("Is allowed to produce infernal drops: " + EnumChatFormatting.YELLOW + (this.mIsProducingInfernalDrops ? "Yes" : "No"));
        info.add("Void all damaged and enchanted items: " + EnumChatFormatting.YELLOW + (this.voidAllDamagedAndEnchantedItems ? "Yes" : "No"));
        info.add("Is in ritual mode: " + EnumChatFormatting.YELLOW + (this.isInRitualMode ? "Yes" : "No"));
        if (this.isInRitualMode) {
            info.add("Is connected to ritual: " + (this.isRitualValid() ? EnumChatFormatting.GREEN + "Yes" : EnumChatFormatting.RED + "No"));
        } else {
            info.add("Inserted weapon: " + EnumChatFormatting.YELLOW + (this.weaponCache.isValid ? "Yes" : "No"));
            if (this.weaponCache.isValid) {
                info.add("Weapon attack damage: " + EnumChatFormatting.YELLOW + this.weaponCache.attackDamage);
                info.add("Weapon looting level: " + EnumChatFormatting.YELLOW + this.weaponCache.looting);
                info.add("Total attack damage: " + EnumChatFormatting.YELLOW + (9.0 + this.weaponCache.attackDamage));
            } else {
                info.add("Total attack damage: " + EnumChatFormatting.YELLOW + 9.0);
            }
        }
        return info.toArray(new String[0]);
    }

    @Override
    protected void addConfigurationWidgets(DynamicPositionedRow configurationElements, UIBuildContext buildContext) {
        configurationElements.setSynced(true);
        configurationElements.widget(new CycleButtonWidget().setToggle(() -> this.isInRitualMode, v -> {
            if (this.mMaxProgresstime > 0) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Can't change mode when running !");
                return;
            }
            this.isInRitualMode = v;
            if (!(buildContext.getPlayer() instanceof EntityPlayerMP)) {
                return;
            }
            if (!this.isInRitualMode) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Ritual mode disabled");
            } else {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Ritual mode enabled");
                if (this.connectToRitual()) {
                    GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Successfully connected to the ritual");
                } else {
                    GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Can't connect to the ritual");
                }
            }
        }).setTextureGetter(toggleButtonTextureGetter).setVariableBackgroundGetter(toggleButtonBackgroundGetter).setSize(16, 16).addTooltip("Ritual mode").setTooltipShowUpDelay(5));
        configurationElements.widget(new CycleButtonWidget().setToggle(() -> this.mIsProducingInfernalDrops, v -> {
            if (this.mMaxProgresstime > 0) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Can't change mode when running !");
                return;
            }
            this.mIsProducingInfernalDrops = v;
            if (!(buildContext.getPlayer() instanceof EntityPlayerMP)) {
                return;
            }
            if (!this.mIsProducingInfernalDrops) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Mobs will now be prevented from spawning infernal");
            } else {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Mobs can spawn infernal now");
            }
        }).setTextureGetter(toggleButtonTextureGetter).setVariableBackgroundGetter(toggleButtonBackgroundGetter).setSize(16, 16).addTooltip("Is allowed to spawn infernal mobs").addTooltip(new Text("Does not affect mobs that are always infernal !").color(Color.GRAY.normal)).setTooltipShowUpDelay(5));
        configurationElements.widget(new CycleButtonWidget().setToggle(() -> this.voidAllDamagedAndEnchantedItems, v -> {
            if (this.mMaxProgresstime > 0) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Can't change mode when running !");
                return;
            }
            this.voidAllDamagedAndEnchantedItems = v;
            if (!(buildContext.getPlayer() instanceof EntityPlayerMP)) {
                return;
            }
            if (!this.voidAllDamagedAndEnchantedItems) {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Void nothing");
            } else {
                GTUtility.sendChatToPlayer(buildContext.getPlayer(), "Void all damaged and enchanted items");
            }
        }).setTextureGetter(toggleButtonTextureGetter).setVariableBackgroundGetter(toggleButtonBackgroundGetter).setSize(16, 16).addTooltip("Void all damaged and enchanted items").addTooltip(new Text("Does not affect infernal drops and some special drops like Sticky Sword!").color(Color.GRAY.normal)).setTooltipShowUpDelay(5));
    }

    @Override
    public void createInventorySlots() {
        SlotWidget spawnerSlot = new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1);
        spawnerSlot.setBackground(new IDrawable[]{GTUITextures.SLOT_DARK_GRAY, UITexture.fullImage((String)"kubatech", (String)"gui/slot/gray_spawner").withFixedSize(16.0f, 16.0f).withOffset(1.0f, 1.0f)});
        spawnerSlot.setFilter(stack -> stack.func_77973_b() == poweredSpawnerItem);
        this.slotWidgets.add(spawnerSlot);
        SlotWidget weaponSlot = new SlotWidget((IItemHandlerModifiable)this.weaponCache, 0);
        weaponSlot.setBackground(new IDrawable[]{GTUITextures.SLOT_DARK_GRAY, UITexture.fullImage((String)"kubatech", (String)"gui/slot/gray_sword").withFixedSize(16.0f, 16.0f).withOffset(1.0f, 1.0f)});
        this.slotWidgets.add(weaponSlot);
    }

    private static class EECFakePlayer
    extends FakePlayer {
        MTEExtremeEntityCrusher mte;
        ItemStack currentWeapon;

        public EECFakePlayer(MTEExtremeEntityCrusher mte) {
            super((WorldServer)mte.getBaseMetaTileEntity().getWorld(), new GameProfile(UUID.nameUUIDFromBytes("[EEC Fake Player]".getBytes(StandardCharsets.UTF_8)), "[EEC Fake Player]"));
            this.mte = mte;
        }

        public void func_70669_a(ItemStack p_70669_1_) {
        }

        public Random func_70681_au() {
            return this.mte.rand;
        }

        public void func_71028_bD() {
        }

        public ItemStack func_71045_bC() {
            return this.currentWeapon;
        }

        public ItemStack func_70694_bm() {
            return this.currentWeapon;
        }
    }

    private static class WeaponCache
    extends ItemStackHandler {
        boolean isValid = false;
        int looting = 0;
        double attackDamage = 0.0;

        public WeaponCache(ItemStack[] inventory) {
            super(inventory);
        }

        protected void onContentsChanged(int slot) {
            if (slot != 0) {
                return;
            }
            if (ModUtils.isClientThreaded()) {
                return;
            }
            ItemStack stack = this.getStackInSlot(0);
            if (stack == null) {
                this.isValid = false;
                return;
            }
            this.attackDamage = stack.func_111283_C().get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).stream().mapToDouble(attr -> attr.func_111164_d() + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED)).sum();
            this.looting = Math.min(4, EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)stack));
            this.isValid = true;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return Enchantment.field_77335_o.func_92089_a(stack);
        }
    }
}

